#ifdef GL_ES
precision mediump float;
precision mediump int;
#endif

uniform sampler2D texture;
varying vec4 vertColor;
varying vec4 vertTexCoord;
uniform float iTime;
uniform vec2 iResolution;

uniform bool scan;
uniform bool colorshift;
uniform bool wiggle;
uniform bool vignet;



float rand () {
    return fract(sin(iTime)*1e4);
}

void main() {
    vec2 uv = gl_FragCoord.xy/iResolution;
    vec2 uvR = uv;
    vec2 uvB = uv;

    if(colorshift)
    {
        uvR.x = uv.x * 1.0 - rand() * 0.02 * 0.8;
        uvB.y = uv.y * 1.0 + rand() * 0.02 * 0.8;
    }

    if(uv.y < rand() && uv.y > rand() -0.1 && sin(iTime) < 0.0 && wiggle)
    {
       uv.x = (uv + 0.02 * rand()).x;
    }
 

    vec4 c;
    c.r = texture(texture, uvR).r;
    c.g = texture(texture, uv).g;
    c.b = texture(texture, uvB).b;
    c.a=1.;
 
    if(scan)
    {
        float scanline = sin( uv.y * abs(sin(iTime*0.005))*800.0 * rand())/30.0; 
        c *= 1.0 - scanline; 
    }
     
 
    if(vignet)
    {
        float vignette = length(( 0.5 , 0.5 ) - uv);
        c *= 1.0 - vignette * 0.6;
    } 




    gl_FragColor = c;
}