void cubescene2(float rot,float fadeIn)
{
  float zoom = (float) moonlander.getValue("zoom");
  float floora = PI/2;
  canvas.background(255);
  canvas.lights();
  //cube
  canvas.pushMatrix();
  canvas.translate(width / 2, height / 3,zoom);
  
  canvas.rotateX(radians(rot % 360));
  canvas.rotateZ(radians(rot % 360));
  
  canvas.noStroke();
 
  float time = (float) moonlander.getCurrentTime();
  
  int bsize = 8;
  float offset = bsize-8*sin((time-3.25));
  int res = 14;
  canvas.translate(-(offset+bsize)*res/2, -(offset+bsize)*res/2,-(offset+bsize)*res/2);
  for(int x=0;x<res;x++)
  {
    canvas.pushMatrix();
    for(int y=0;y<res;y++)
    {
      
      canvas.translate(0,(bsize+offset));
      
      canvas.pushMatrix();
      for(int z=0;z<res;z++)
      {
        canvas.translate((bsize+offset),0);
        
        float colr =  100*(x+y+z)/(res*2);
        canvas.fill(2.55*(colr)*fadeIn/100, 30, 30);
        
        canvas.box(bsize);
      }
      canvas.popMatrix();
    }
    canvas.popMatrix();
    
    canvas.translate(0,0,(bsize+offset));
    
  }
  //canvas.box(100);
  canvas.popMatrix(); 
  
  
  //floor
  canvas.pushMatrix();
  canvas.noStroke();
  canvas.fill(250, 250, 250);
  canvas.translate(width / 2, 2.5*height / 3);
  canvas.rectMode(CENTER);
  canvas.rotateX(floora);
  canvas.rect(0,0,10000,10000);
  canvas.popMatrix(); 
  
  //floorcircle
  canvas.pushMatrix();
  canvas.translate(width / 2, 2.5*height / 3-1,zoom);
  canvas.fill(30, 30, 30);
  canvas.rotateX(floora);
  canvas.ellipseMode(CENTER);
  float shadowsize = 200-160*sin((time-3.25));
  canvas.ellipse(0,0,shadowsize,shadowsize);
  canvas.popMatrix(); 
 

  

}
