import moonlander.library.*; //<>//

import ddf.minim.*;

Moonlander moonlander;
float SPHERE_DIAMETER = 5.0;


//Canvas
int CANVAS_WIDTH = 1920;
int CANVAS_HEIGHT = 1080;
int PARTICLE_COUNT = 350;
float MIN_Y = -70;
float MAX_Y = 70;
PVector[] particlePositions = new PVector[PARTICLE_COUNT * 2];
PImage backgroundImg;
JSONObject sevenSeg;
int rotCount = 0;

void settings() {
  // The P3D parameter enables accelerated 3D rendering.
  size(CANVAS_WIDTH, CANVAS_HEIGHT, P3D);
}

void setup() {
  rectMode(CENTER);
  moonlander =  Moonlander.initWithSoundtrack(this, "soundtrack.mp3", 60, 1);
  moonlander.start();
  setParticlePositions(1, 2);  
  sevenSeg = loadJSONObject("7seg.json");
}

void setParticlePositions(int img1, int img2) {
  // Load and parse the svg files
  XML file1 = loadXML("drawing" + str(img1) + ".svg");
  XML file2 = loadXML("drawing" + str(img2) + ".svg");
  
  // Reprocess them into arrays of lines so that one array has all the starting positions in order, and another one has the corresponding end positions.
  ArrayList<PVector> lineStartPoints1 = new ArrayList<PVector>();
  ArrayList<PVector> lineEndPoints1 = new ArrayList<PVector>();
  ArrayList<PVector> lineStartPoints2 = new ArrayList<PVector>();
  ArrayList<PVector> lineEndPoints2 = new ArrayList<PVector>();
  
  parsePointsFromXML(file1, lineStartPoints1, lineEndPoints1);
  parsePointsFromXML(file2, lineStartPoints2, lineEndPoints2);
  
  PVector[] positions1 = particlePositionsForSegments(lineStartPoints1, lineEndPoints1);
  PVector[] positions2 = particlePositionsForSegments(lineStartPoints2, lineEndPoints2);
  
  for (int i = 0; i < positions1.length; i++) {
    PVector pos1 = positions1[i];
    FloatList crossingX = getCrossingX(pos1.y, lineStartPoints2, lineEndPoints2);
    particlePositions[i] = new PVector(pos1.x, pos1.y, crossingX.get(0));
  }
  
  for (int i = 0; i < positions2.length; i++) {
    PVector pos2 = positions2[i];
    FloatList crossingX = getCrossingX(pos2.y, lineStartPoints1, lineEndPoints1);
    particlePositions[PARTICLE_COUNT + i] = new PVector(crossingX.get(0), pos2.y, pos2.x);
  }
}

PVector[] particlePositionsForSegments(ArrayList<PVector> lineStartPoints, ArrayList<PVector> lineEndPoints) {
  PVector[] retArr = new PVector[PARTICLE_COUNT];
  int particlePositionStepper = 0;
  
  float totalLength = 0.0;
  for (int i = 0; i < lineStartPoints.size(); i++) {
    totalLength += PVector.dist(lineStartPoints.get(i), lineEndPoints.get(i));
  }
  float stepSize = totalLength / (PARTICLE_COUNT - 1);
  float r = 0.0; // how much of the last step is left to the next segment 
  for (int i = 0; i < lineStartPoints.size(); i++) {
    float l = PVector.dist(lineEndPoints.get(i), lineStartPoints.get(i)); // length of this segment
    int k = floor((l-r) / stepSize); // step count
    for (int k_i = 0; k_i <= k; k_i++) {
      PVector direction = PVector.sub(lineEndPoints.get(i), lineStartPoints.get(i)).normalize();
      // lineStartPoints1.get(i) + r * direction + k_i * stepSize * direction
      PVector p = PVector.add(PVector.add(lineStartPoints.get(i), PVector.mult(direction, r)), PVector.mult(direction, k_i * stepSize));
      retArr[particlePositionStepper] = p;
      particlePositionStepper++;
    }
    r = r + k * stepSize + stepSize - l;
  }
  
  // If there are empty slots for some reason at the end of the array, fill them
  for (; particlePositionStepper < PARTICLE_COUNT; particlePositionStepper++) {
    retArr[particlePositionStepper] = retArr[particlePositionStepper - 1];
  }
  return retArr;
}

void parsePointsFromXML(XML file, ArrayList<PVector> lineStartPoints, ArrayList<PVector> lineEndPoints) {
  // Min and max values for this parsed svg.
  float minY = 1000000.0;
  float maxY = -1000000.0;
  float minX = 1000000.0;
  float maxX = -1000000.0;
  
  // This is to allow scaling all points easily.
  ArrayList<PVector> allPoints = new ArrayList<PVector>();
  
  XML[] paths;
  XML potentialG = file.getChild("g");
  if (potentialG == null) {
    paths = file.getChildren("path");
  }
  else {
    paths = potentialG.getChildren("path");
  }
  for (int i = 0; i < paths.length; i++) {
    XML path = paths[i];
    String pathStr = path.getString("d");
    String[] pathElements = split(pathStr, "L");
    PVector previousPoint = null;
    for (int j = 0; j < pathElements.length; j++) {
      String pathElem = pathElements[j];
      
      if (pathElem.charAt(0) == 'M') {
        pathElem = pathElem.substring(1);
      }
      
      String[] pointCoords = split(pathElem, " ");
      
      if (pointCoords.length == 2) {
        PVector newPoint = new PVector(float(pointCoords[0]), float(pointCoords[1]));
        if (previousPoint != null) {
          lineEndPoints.add(newPoint);
        }
        lineStartPoints.add(newPoint);
        allPoints.add(newPoint);
        previousPoint = newPoint;
        
        minY = min(minY, newPoint.y);
        maxY = max(maxY, newPoint.y);
        minX = min(minX, newPoint.x);
        maxX = max(maxX, newPoint.x);
      }
    }
    lineStartPoints.remove(lineStartPoints.size() - 1);
  }
  
  // Scale the points to MIN_Y and MAX_Y.
  float xOffset = (maxX + minX) / 2;
  float yScalar = (MAX_Y - MIN_Y) / (maxY - minY);
  for (PVector v : allPoints) {
    v.y = MIN_Y + (MAX_Y - MIN_Y) * (v.y - minY) / (maxY - minY);
    v.x = v.x - xOffset;
    v.x = v.x * yScalar;
  }
}

FloatList getCrossingX(float y, ArrayList<PVector> segmentStartPoints, ArrayList<PVector> segmentEndPoints) {
  float x1, x2, y1, y2;
  FloatList crossingX = new FloatList();
  for (int i = 0; i < segmentStartPoints.size(); i++) {
     // Check if line y = y intersects segmentStartPoints[i] -> segmentEndPoints[i]
     x1 = segmentStartPoints.get(i).x;
     y1 = segmentStartPoints.get(i).y;
     x2 = segmentEndPoints.get(i).x;
     y2 = segmentEndPoints.get(i).y;
     float epsilon = 0.01;
     if ((y > y1-epsilon && y < y2+epsilon) || (y < y1+epsilon && y > y2-epsilon)) {  
       float x = (y - y1) * (x2 - x1) / (y2 - y1) + x1;
       crossingX.append(x);
     }
  }
  crossingX.shuffle();
  return crossingX;
}



void draw() {
  
  moonlander.update();
  ortho();
  background(0);
    
  float rockValue = (float) moonlander.getValue("rock");
  //float tick = (float) moonlander.getValue("tick");
  ambientLight(255,255,255);
  
  // Center the view
  translate(width/2, height/2, 0);
  // Rotate the viewport
  float pingPongRock = rockValue % 2;
  if (floor((rockValue / 2) % 2) == 1) {
    pingPongRock = 2 - pingPongRock;
  }
  rotateY(pingPongRock/4 * PI);
  
  //transition the color from red(cross) to green(tick) and back
  float r = map(pingPongRock, 0, 2, 255, 0);
  float g = map(pingPongRock, 0, 2, 0, 255);  
  fill(r, g, 128);
  
  int newRotCount = floor(rockValue / 2);
  if(newRotCount > rotCount) {
    // Load the next image
    setParticlePositions(newRotCount + 1 + newRotCount % 2, newRotCount + 1 + (newRotCount - 1) % 2);
    rotCount = newRotCount;
  }
   
  if (rotCount < 16) {
    
    for (int i = 0; i < PARTICLE_COUNT * 2 - 1; i++) {
      PVector pos = particlePositions[i];
      drawSphere(pos);
    }
  }
  
  translate(-400, -200, -400);
  if(rotCount>15){
    String story[]={"leevi the storymaster", "antti the plotter", "viking the ball painter", "anna the runaway", "l a v a"};
  
    for(int i=0; i<5; i++){
      pushMatrix();
      writeSentence(story[i]);
      popMatrix();
      translate(0,100,0);  
    }
  }
   /*if(rockValue<16){
    translate(-400,200,0);
    weHaveBalls();*/
  
  /*if(rockValue>=16 && rockValue<32){
      // Draw some checkTicks
    vedranCheckTicks(r, g);
    
  }*/
  //if(rockValue>=32){
   // for (PVector pos : particlePositions) {
   //   drawSphere(pos);
   // }
 // }
}

void weHaveBalls(){
   
   
   pushMatrix();
   noFill();
   stroke(255);
   box(100,100,300);
   popMatrix();
   translate(0, 100, 0);
   noStroke();
   fill(255,255,0);
   pushMatrix();
   threeDeeLetter("w");
   popMatrix();
   translate(60,0,60);
   pushMatrix();
   threeDeeLetter("e");
   popMatrix();
   translate(120,0,120);
   pushMatrix();
   threeDeeLetter("h");
   popMatrix();
   translate(60,0,60);
   pushMatrix();
   threeDeeLetter("a");
   popMatrix();
   translate(60,0,60);
      pushMatrix();
   threeDeeLetter("v");
   popMatrix();
   translate(60,0,60);
   pushMatrix();
   threeDeeLetter("e");
   popMatrix();
   translate(120,0,120);
   pushMatrix();
   threeDeeLetter("b");
   popMatrix();
   translate(60,0,60);
   pushMatrix();
   threeDeeLetter("a");
   popMatrix();
   translate(60,0,60);
      pushMatrix();
   threeDeeLetter("l");
   popMatrix();
   translate(60,0,60);
   pushMatrix();
   threeDeeLetter("l");
   popMatrix();
   translate(60,0,60);
   pushMatrix();
   threeDeeLetter("s");
   popMatrix();
  
  

}


void vedranCheckTicks(float r, float g){
  
   pushMatrix();
   threeDeeLetter("g");
   popMatrix();
   translate(60,0,60);
   pushMatrix();
   threeDeeLetter("d");
   popMatrix();
   translate(60,0,60);
   pushMatrix();
   threeDeeLetter("p");
   popMatrix();
   translate(60,0,60);
   pushMatrix();
   threeDeeLetter("r");
   popMatrix();
   translate(60,0,60);
   
   pushMatrix();
   threeDeeLetterSideways("p");
   popMatrix();
   translate(0,60,0);
   pushMatrix();
   threeDeeLetterSideways("g");
   popMatrix();
   translate(0,60,0);
   pushMatrix();
   threeDeeLetterSideways("p");
   popMatrix();
   
   pushMatrix(); 
   drawCheckTick(false);
   popMatrix();
   translate(-200,0, -200);
   fill(g, r, 128);
   pushMatrix();
   drawCheckTick(true);
   popMatrix();
   translate(-200,0, -200);
   pushMatrix();
   fill(r, g, 128);
   drawCheckTick(true);
   popMatrix();
   fill(g, r, 128);
   translate(200,200, 200);
   pushMatrix();
   drawCheckTick(false);
   popMatrix();
   translate(-200,200, -200);
   pushMatrix();
   drawCheckTick(true);
   popMatrix();
   fill(r, g, 128);
   translate(200,0, 200);
   pushMatrix();
   drawCheckTick(false);
   popMatrix();
   translate(200,0, 200);
   pushMatrix();
   drawCheckTick(true);
   popMatrix();
}

void drawCheckTick(boolean truth){
   
  if(truth){
   drawSphere(0,0,14);
   drawSphere(12,0,14);
   drawSphere(1,1,13);
   drawSphere(11,1,13);
   drawSphere(2,2,12);
   drawSphere(10,2,12);
   drawSphere(3,3,11);
   drawSphere(9,3,11);
   drawSphere(4,4,10);
   drawSphere(8,4,10);
   drawSphere(5,5,9);     
   drawSphere(7,5,9);
   drawSphere(6,6,8);
   drawSphere(6,6,8);
   drawSphere(7,7,7);
   drawSphere(5,7,7);
   drawSphere(8,8,6);
   drawSphere(4,8,6);
   drawSphere(9,9,5);
   drawSphere(3,9,5);
   drawSphere(10,10,4);
   drawSphere(2,10,0);
   drawSphere(11,11,3);
   drawSphere(1,11,1);
   drawSphere(12,12,2);
   drawSphere(0,12,2);}
   else{
   drawSphere(14,0,0);
   drawSphere(14,0,12);
   drawSphere(13,1,1);
   drawSphere(13,1,11);
   drawSphere(12,2,2);
   drawSphere(12,2,10);
   drawSphere(11,3,3);
   drawSphere(11,3,9);
   drawSphere(10,4,4);
   drawSphere(10,4,8);
   drawSphere(9,5,5);     
   drawSphere(9,5,7);
   drawSphere(8,6,6);
   drawSphere(8,6,6);
   drawSphere(7,7,7);
   drawSphere(7,7,5);
   drawSphere(6,8,8);
   drawSphere(6,8,4);
   drawSphere(5,9,9);
   drawSphere(5,9,3);
   drawSphere(4,10,10);
   drawSphere(0,10,2);
   drawSphere(3,11,11);
   drawSphere(1,11,1);
   drawSphere(2,12,12);
   drawSphere(2,12,0);
   }
   
   
}

void drawSphere(PVector position) {
  drawSphere(position.x, position.y, position.z); 
}

void drawSphere(float sphereX, float sphereY, float sphereZ){

  pushMatrix();
  lights();
  shininess(0.70);
  float n = random(100);
  if(n<3) fill(0,0,255);
  if(n>97) fill(255,255,0);
  emissive(100 + random(50),100,0);
  specular(200 + random(55),200+random(55),128+random(100));
  noStroke();
  float sphereDiameter = SPHERE_DIAMETER; 
  
  translate(sphereX * sphereDiameter, sphereY * sphereDiameter, sphereZ * sphereDiameter);
  
  // Draw the sphere
  sphere(sphereDiameter/2);
  popMatrix();
}

JSONArray sevenSegArray(String ch){
  JSONArray c = sevenSeg.getJSONArray(ch);
  return c;
}

void threeDeeLetter(String letter){
  JSONArray m = sevenSegArray(letter);
  for(int i=0; i < 7; i++){
    for(int j=0; j<5; j++){
      String s = m.getString(i);
      if(s.charAt(j) == '1'){
        drawSphere(j,i,j);
      }
    }
  }
}


void threeDeeLetterSideways(String letter){
  JSONArray m = sevenSegArray(letter);
  for(int i=0; i < 7; i++){
    for(int j=0; j<5; j++){
      String s = m.getString(i);
      if(s.charAt(j) == '1'){
        drawSphere(i,j,0);
      }
    }
  }
}

void writeSentence(String sentence){
  for (int i=0; i<sentence.length(); i++){
    translate(SPHERE_DIAMETER * 5.2, 0, SPHERE_DIAMETER * 5.2);
    if(sentence.charAt(i)!=' '){
      pushMatrix();
      char n[]={' '};
      char x = sentence.charAt(i);
      n[0] = x;
      String s = new String(n);
      threeDeeLetter(s);
      popMatrix();
    }
  }
}
