import moonlander.library.*;

// Minim must be imported when using Moonlander with soundtrack.
import ddf.minim.*;

Moonlander moonlander;

Scene[] scenes = {
  new Scene1(),
  //new LensTest2(),
  new Scene2(),
  new Scene3(),
  new Scene4(),
};

// SHADER STUFF //

PGraphics frameBuffer1;
PGraphics frameBuffer2;

PShader rectLens;

//////////////////

// hardcoded parameters for controlling rectangular lens size
float lensMinW = 0.1;
float lensMaxW = 0.7;
float lensMinH = 0.05;
float lensMaxH = 0.2;
float lensMinZoom = 1.2;
float lensMaxZoom = 2;

void setup() {
  moonlander = Moonlander.initWithSoundtrack(this, "soundtrack-short-edit.wav", 128, 4);
  //size(1280, 720, P3D);
  fullScreen(P3D);
  noCursor();
  smooth(8);
  moonlander.start();

  rectLens = loadShader("shaders/rectLens.glsl");
  frameBuffer1 = createGraphics(width, height, P3D);
  frameBuffer2 = createGraphics(width, height, P3D);

  // Writing to the depth buffer is disabled to avoid rendering
  // artifacts due to the fact that the particles are semi-transparent
  // but not z-sorted.
  hint(DISABLE_DEPTH_MASK);

  for (int i = 0; i < scenes.length; i++) {
    scenes[i].init();
  }

}

// Monta partikkelisysteemiä on järkevämpi tehdä näin:
// https://processing.org/examples/multipleparticlesystems.html
void draw() {
  moonlander.update();
  //background(0, 0, 0, 0);
  int s = (int) constrain((float) moonlander.getValue("scene"), 0, scenes.length - 1);
  int t = (int) moonlander.getValue("time");
  translate(width/2, height/2);
  scenes[s].render();
  if(t == -1) {
    exit(); //TODO
    //println("finished.");
  }
}
