/*
 * Decompiled with CFR 0.152.
 */
package moonlander.library;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import moonlander.library.TrackKey;

public class Track {
    private String name;
    private ArrayList<TrackKey> keys;

    public Track(String string) {
        this.name = string;
        this.keys = new ArrayList();
    }

    protected List<TrackKey> getKeys() {
        return Collections.unmodifiableList(this.keys);
    }

    private int getKeyIndex(int n) {
        int n2 = Collections.binarySearch(this.keys, new TrackKey(n, 0.0f, TrackKey.KeyType.STEP));
        if (n2 >= 0 || n2 == -1) {
            return n2;
        }
        return -n2 - 2;
    }

    private int getKeyIndexExact(int n) {
        int n2 = this.getKeyIndex(n);
        if (n2 >= 0 && this.keys.get(n2).getRow() == n) {
            return n2;
        }
        return -1;
    }

    protected TrackKey getKey(int n) {
        int n2 = this.getKeyIndex(n);
        if (n2 >= 0) {
            return this.keys.get(n2);
        }
        return null;
    }

    protected void addOrUpdateKey(TrackKey trackKey) {
        int n = this.getKeyIndexExact(trackKey.getRow());
        if (n >= 0) {
            this.keys.set(n, trackKey);
        } else {
            this.keys.add(trackKey);
            Collections.sort(this.keys);
        }
    }

    protected void deleteKey(int n) {
        int n2 = this.getKeyIndexExact(n);
        if (n2 >= 0) {
            this.keys.remove(n2);
        }
    }

    public void printKeys() {
        for (TrackKey trackKey : this.keys) {
            System.out.println(trackKey);
        }
    }

    public double getValue(double d) {
        if (this.keys.size() == 0) {
            return 0.0;
        }
        int n = (int)d;
        int n2 = this.getKeyIndex(n);
        if (n2 == -1) {
            return 0.0;
        }
        if (n2 == this.keys.size() - 1) {
            return this.keys.get(n2).getValue();
        }
        return TrackKey.interpolate(this.keys.get(n2), this.keys.get(n2 + 1), d);
    }

    public String toString() {
        return String.format("Track(name=%s, keys=%d)", this.name, this.keys.size());
    }
}

