/*
 * Decompiled with CFR 0.152.
 */
import moonlander.library.Moonlander;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PImage;

public class Processing_Demobase
extends PApplet {
    int CANVAS_WIDTH = 1920;
    int CANVAS_HEIGHT = 1080;
    int speed = this.height / 55;
    int star_amount = 0;
    PImage img;
    PImage img2;
    PFont font;
    float x;
    float y;
    float hack;
    int SONG_SKIP_MILLISECONDS = 2000;
    Moonlander moonlander;
    Star[] stars;
    Spaceship spaceship;
    Fish fish;
    CollidingObject heart;

    public void settings() {
        this.size(this.CANVAS_WIDTH, this.CANVAS_HEIGHT, "processing.opengl.PGraphics2D");
    }

    public void setup() {
        this.noCursor();
        this.frameRate(60.0f);
        this.font = this.createFont("Comfortaa-Regular.ttf", 60.0f);
        this.textFont(this.font);
        this.textAlign(3);
        this.img = this.loadImage("background3.png");
        this.fish = new Fish();
        this.fish.img = this.loadImage("fish.png");
        this.heart = new CollidingObject(this.width / 2 - 65, this.height + 100, 130.0f, 130.0f);
        this.heart.img = this.loadImage("data/heart.png");
        this.y = this.height + 10;
        this.spaceship = new Spaceship();
        this.spaceship.img = this.loadImage("data/spaceship.png");
        this.spaceship.img.resize(130, 130);
        this.stars = new Star[this.width / 8];
        int i = 0;
        while (i < this.stars.length) {
            this.stars[i] = i % 5 == 0 ? new Star(3) : new Star(PApplet.parseInt((float)this.random(1.0f, 3.0f)));
            ++i;
        }
        this.moonlander = Moonlander.initWithSoundtrack((PApplet)this, (String)"./data/spacetravel.wav", (int)120, (int)8);
        this.moonlander.start();
    }

    public void drawType(float x) {
        this.fill(200);
        this.textSize(60.0f);
        this.text("Fish n Ships", x, 550.0f);
    }

    public void drawScript(float x) {
        this.fill(210);
        this.textSize(30.0f);
        this.text("In a far-far-away universe", x, 500.0f);
        this.text("At 12 pm", x, 550.0f);
        this.text("Our fish is hungry", x, 600.0f);
    }

    public void draw() {
        this.moonlander.update();
        this.background(9.0f, 56.0f, 90.0f);
        this.image(this.img, 0.0f, this.y);
        this.moonlander.getIntValue("display_gradient");
        int scene = this.moonlander.getIntValue("scene");
        int red = this.moonlander.getIntValue("red");
        int green = this.moonlander.getIntValue("green");
        int blue = this.moonlander.getIntValue("blue");
        double row = this.moonlander.getCurrentRow();
        int i = 0;
        while (i < this.stars.length) {
            this.stars[i].color_r = red;
            this.stars[i].color_g = green;
            this.stars[i].color_b = blue;
            this.stars[i].display();
            ++i;
        }
        this.image(this.spaceship.img, this.spaceship.x, this.spaceship.y);
        this.image(this.fish.img, this.fish.x, this.fish.y);
        if (row > 50.0 & row < 150.0) {
            this.textAlign(3);
            this.drawType((float)this.width * 0.5f);
        }
        if (row > 150.0 & row < 250.0) {
            this.textAlign(3);
            this.drawScript((float)this.width * 0.5f);
        }
        if (scene == 1) {
            this.spaceship.move_horizontally();
            this.fish.move_horizontally();
            this.spaceship.y += 0.3f;
            this.fish.y += 0.3f;
        } else if (scene == 4) {
            if (!this.heart.collided) {
                this.heart.x = this.spaceship.x;
                this.heart.draw_and_move();
            }
            if (this.heart.isColliding(this.spaceship)) {
                this.speed = (int)((float)this.speed + 0.5f);
                this.heart.onCollision();
                i = 0;
                while (i < this.stars.length) {
                    this.stars[i].color_r = red;
                    this.stars[i].color_g = green;
                    this.stars[i].color_b = blue;
                    this.stars[i].display();
                    ++i;
                }
                this.image(this.spaceship.img, this.spaceship.x, this.spaceship.y);
                this.image(this.fish.img, this.fish.x, this.fish.y);
            }
        } else if (scene == 2) {
            this.background(255.0f, 111.0f, 111.0f);
            this.image(this.img, 0.0f, this.y);
            i = 0;
            while (i < this.stars.length) {
                this.stars[i].color_r = red;
                this.stars[i].color_g = green;
                this.stars[i].color_b = blue;
                this.stars[i].display();
                ++i;
            }
            this.y -= 2.0f;
            this.image(this.spaceship.img, this.spaceship.x, this.spaceship.y);
            this.image(this.fish.img, this.fish.x, this.fish.y);
            this.spaceship.move_horizontally();
            this.fish.follow(this.spaceship);
            this.hack = this.y + 10.0f;
        } else if (scene == 5) {
            this.y = Processing_Demobase.lerp((float)this.y, (float)this.hack, (float)0.05f);
        } else if (scene == 6) {
            this.spaceship.move_away();
            this.fish.move_away();
        } else if (scene == 7) {
            this.textAlign(3);
            this.fill(200);
            this.textSize(60.0f);
            this.text("Happy Ending", (float)this.width * 0.5f, this.height / 2);
        } else if (scene == 8) {
            this.textAlign(3);
            this.fill(200);
            this.textSize(60.0f);
            this.text("Fish n Ships", (float)this.width * 0.5f, this.height / 2);
        } else if (scene == 9) {
            this.textAlign(3);
            this.fill(200);
            this.textSize(60.0f);
            this.text("Graffathon 2018", (float)this.width * 0.5f, this.height / 2);
        } else if (scene == 10) {
            this.textAlign(3);
            this.fill(200);
            this.textSize(60.0f);
            this.text("Titi/Yuyu/sivuosa/Jari", (float)this.width * 0.5f, this.height / 2);
        } else if (scene == 11) {
            this.exit();
        }
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"Processing_Demobase"};
        if (passedArgs != null) {
            PApplet.main((String[])Processing_Demobase.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }

    class CollidingObject {
        PImage img = new PImage();
        float x;
        float y;
        float size_x;
        float size_y;
        boolean collided;

        CollidingObject(float x, float y, float size_x, float size_y) {
            this.x = x;
            this.y = y;
            this.size_x = size_x;
            this.size_y = size_y;
            this.collided = false;
        }

        public void draw_and_move() {
            Processing_Demobase.this.image(this.img, this.x, this.y);
            this.y -= 3.0f;
        }

        public boolean isColliding(Spaceship s) {
            return this.x >= s.x && this.x <= s.x + 70.0f && this.y >= s.y && this.y <= s.y + 70.0f;
        }

        public void onCollision() {
            Processing_Demobase.this.image(this.img, -100.0f, -100.0f);
            Processing_Demobase.this.background(255.0f, 111.0f, 111.0f);
            this.collided = true;
        }
    }

    class Fish {
        PImage img = new PImage();
        float x;
        float y;
        float direction;
        float destination;

        Fish() {
            this.x = (float)(Processing_Demobase.this.CANVAS_WIDTH / 2) - 319.5f;
            this.y = -1500.0f;
            this.direction = -1.0f;
            this.destination = Processing_Demobase.this.CANVAS_WIDTH / 2 - 600;
        }

        public void move_horizontally() {
            if (this.x <= this.destination + 15.0f && this.direction == -1.0f) {
                this.direction = 1.0f;
                this.destination = Processing_Demobase.this.CANVAS_WIDTH / 2 + 600;
            } else if (this.x >= this.destination - 15.0f && this.direction == 1.0f) {
                this.direction = -1.0f;
                this.destination = Processing_Demobase.this.CANVAS_WIDTH / 2 - 600;
            }
            this.x = Processing_Demobase.lerp((float)this.x, (float)this.destination, (float)0.05f);
        }

        public void follow(Spaceship s) {
            this.direction = s.direction;
            this.destination = s.destination;
            this.x = Processing_Demobase.lerp((float)this.x, (float)this.destination, (float)0.05f);
        }

        public void move_away() {
            this.y = Processing_Demobase.lerp((float)this.y, (float)(Processing_Demobase.this.height + 500), (float)0.05f);
        }
    }

    class Spaceship {
        PImage img = new PImage();
        float x;
        float y;
        float direction;
        float destination;

        Spaceship() {
            this.x = Processing_Demobase.this.CANVAS_WIDTH / 2 - 65;
            this.y = -100.0f;
            this.direction = -1.0f;
            this.destination = Processing_Demobase.this.CANVAS_WIDTH / 2 - 400;
        }

        public void move_horizontally() {
            if (this.x <= this.destination + 15.0f && this.direction == -1.0f) {
                this.direction = 1.0f;
                this.destination = Processing_Demobase.this.CANVAS_WIDTH / 2 + 400;
            } else if (this.x >= this.destination - 15.0f && this.direction == 1.0f) {
                this.direction = -1.0f;
                this.destination = Processing_Demobase.this.CANVAS_WIDTH / 2 - 400;
            }
            this.x = Processing_Demobase.lerp((float)this.x, (float)this.destination, (float)0.05f);
        }

        public boolean is_colliding(CollidingObject co) {
            return true;
        }

        public void move_away() {
            this.y = Processing_Demobase.lerp((float)this.y, (float)(Processing_Demobase.this.height + 500), (float)0.05f);
        }
    }

    class Star {
        int layer;
        float size;
        int x;
        int y;
        int color_r;
        int color_g;
        int color_b;

        Star(int layer) {
            this.layer = layer;
            this.size = PApplet.parseInt((float)(Processing_Demobase.this.random(1.0f, 4.0f) * (float)layer));
            this.x = PApplet.parseInt((float)Processing_Demobase.this.random(5.0f, Processing_Demobase.this.width));
            this.y = PApplet.parseInt((float)Processing_Demobase.this.random(0.0f, Processing_Demobase.this.height));
            this.color_r = 255;
            this.color_g = 247;
            this.color_b = 93;
        }

        public void display() {
            Processing_Demobase.this.pushStyle();
            Processing_Demobase.this.stroke(this.color_r, this.color_g, this.color_b);
            Processing_Demobase.this.strokeWeight(this.size);
            int y = this.y - Processing_Demobase.this.speed * this.layer;
            if (y < -10) {
                y = Processing_Demobase.this.height + 10;
            }
            this.y = y;
            Processing_Demobase.this.point(this.x, y);
            Processing_Demobase.this.popStyle();
        }
    }
}

