import moonlander.library.*;

/* 
 * Code for starting a demo project
 *
 * Nothing extra except standard libraries
 * bundled with Processing 
 */

// Minim is needed for the music playback.
import ddf.minim.spi.*;
import ddf.minim.signals.*;
import ddf.minim.*;
import ddf.minim.analysis.*;
import ddf.minim.ugens.*;
import ddf.minim.effects.*;

int CANVAS_WIDTH = 1920;
int CANVAS_HEIGHT = 1080;

int speed = height / 55;
int star_amount = 0;
PImage img, img2;
PFont font;
float x;
float y;
float hack;

// You can skip backwards/forwards in your demo by using the 
// arrow keys; this controls how many milliseconds you skip
// with one keypress.
int SONG_SKIP_MILLISECONDS = 2000;

Moonlander moonlander;

Star[] stars;

Spaceship spaceship;

Fish fish;

CollidingObject heart;

void settings() {
  // Set up the drawing area size and renderer (P2D / P3D).
  size(CANVAS_WIDTH, CANVAS_HEIGHT, P2D);
}
 
void setup() {
  noCursor();
  frameRate(60);
  font = createFont("Comfortaa-Regular.ttf", 60);
  textFont(font);
  textAlign(CENTER);
  img = loadImage("background3.png");
  fish = new Fish();
  fish.img = loadImage("fish.png");
  heart = new CollidingObject(((width /  2) - 65), height + 100, 130, 130);
  heart.img = loadImage("data/heart.png");
  y = height + 10;
  spaceship = new Spaceship();
  spaceship.img = loadImage("data/spaceship.png");
  
  spaceship.img.resize(130,130);

  // Your setup code
  stars = new Star[width / 8];
  
  for(int i = 0; i < stars.length; i++) {
    if (i % 5 == 0) {
      stars[i] = new Star(3);
    } else {
      stars[i] = new Star(int(random(1, 3)));
    }
  }

  moonlander = Moonlander.initWithSoundtrack(this, "./data/spacetravel.wav", 120, 8);
  moonlander.start();
  smooth();
}

void drawType(float x) {
  fill(200);
  textSize(60);
  text("Fish n Ships", x, 550);
}

void drawScript(float x) {
  fill(210);
  textSize(30);
  text("In a far-far-away universe",x,500);
  text("At 12 pm",x,550);
  text("Our fish is hungry",x,600);
}
 

/*
 * Processing's drawing method
 */
void draw() {
  moonlander.update();
  background(9, 56, 90);
  image(img, 0, y);
  int display_gradient = moonlander.getIntValue("display_gradient");
  int scene = moonlander.getIntValue("scene");
  //int display_fish = moonlander.getIntValue("display_fish");
  //if (display_gradient == 1) {
  //if (y >= (height / 2 - 4500)) {
  //  y -= 1; 
  //  }
  //if (display_fish == 1) {
    //image(img2,spaceship.x-100, 2*height/3); 
    //}
  //if (display_fish == 2) {
    //image(img2,width/2-80, 2*height/3); 
    //}
  //}
  int red = moonlander.getIntValue("red");
  int green = moonlander.getIntValue("green");
  int blue = moonlander.getIntValue("blue");
  double row = moonlander.getCurrentRow();
  for(int i = 0; i < stars.length; i++) {
    stars[i].color_r = red;
    stars[i].color_g = green;
    stars[i].color_b = blue;
    stars[i].display();
  }
  
  image(spaceship.img, spaceship.x, spaceship.y);
  image(fish.img, fish.x, fish.y);
  
  //if (spaceship.y < ((height / 2) - 65)) {
   if (row > 50 & row < 150) {
     textAlign(CENTER);
     drawType(width*0.5);
   }
   if (row > 150 & row < 250) {
     textAlign(CENTER);
     drawScript(width*0.5);
   }
  if (scene == 1) {
    spaceship.move_horizontally();
    fish.move_horizontally();
    spaceship.y += .3;
    fish.y += .3;
  } else if (scene == 4) {
    if (!heart.collided) {
      
      heart.x = spaceship.x;
      heart.draw_and_move();
    }
    if (heart.isColliding(spaceship)) {
      speed += .5;
      heart.onCollision();
      for(int i = 0; i < stars.length; i++) {
        stars[i].color_r = red;
        stars[i].color_g = green;
        stars[i].color_b = blue;
        stars[i].display();
      }
      image(spaceship.img, spaceship.x, spaceship.y);
      image(fish.img, fish.x, fish.y);
    }
  } else if (scene == 2) {
    background(255, 111, 111);
    image(img, 0, y);
    for(int i = 0; i < stars.length; i++) {
        stars[i].color_r = red;
        stars[i].color_g = green;
        stars[i].color_b = blue;
        stars[i].display();
    }
    y -= 2;
    image(spaceship.img, spaceship.x, spaceship.y);
    image(fish.img, fish.x, fish.y);
    spaceship.move_horizontally();
    fish.follow(spaceship);
    hack = y + 10;
  } else if (scene == 5) {
    y = lerp(y, hack, 0.05);
  } else if (scene == 6) {
    spaceship.move_away();
    fish.move_away();
  } else if (scene == 7) {
    textAlign(CENTER);
    fill(200);
    textSize(60);
    text("Happy Ending", width * 0.5, height / 2);
  } else if (scene == 8) {
    textAlign(CENTER);
    fill(200);
    textSize(60);
    text("Fish n Ships", width * 0.5, height / 2);
  } else if (scene == 9) {
    textAlign(CENTER);
    fill(200);
    textSize(60);
    text("Graffathon 2018", width * 0.5, height / 2);
  } else if (scene == 10) {
    textAlign(CENTER);
    fill(200);
    textSize(60);
    text("Titi/Yuyu/sivuosa/Jari", width * 0.5, height / 2);
  } else if (scene == 11) {
    exit();
  }
}

class Star {
  int layer;
  float size;
  int x;
  int y;
  int color_r;
  int color_g;
  int color_b;
  
  Star(int layer) {
    this.layer = layer;
    this.size = (int(random(1, 4) * layer));
    this.x = int(random(5, width));
    this.y = int(random(0, height));
    this.color_r = 255;
    this.color_g = 247;
    this.color_b = 93;
  }
  
  void display() {
    pushStyle();
    
    //Setup the style
    stroke(this.color_r, this.color_g, this.color_b);
    strokeWeight(this.size);
    
    int y = this.y - (speed * this.layer);
    
    if (y < -10) y = height + 10;
    
    this.y = y;
    
    point(this.x, y);
    popStyle();
  }
}

class CollidingObject {
  PImage img;
  float x;
  float y;
  float size_x;
  float size_y;
  boolean collided;
  
  CollidingObject(float x, float y, float size_x, float size_y) {
    this.img = new PImage();
    this.x = x;
    this.y = y;
    this.size_x = size_x;
    this.size_y = size_y;
    this.collided = false;
  }
  
  void draw_and_move() {
    image(this.img, this.x, this.y);
    this.y = this.y - 3;
  }
  
  boolean isColliding(Spaceship s) {
    if ((this.x >= s.x && this.x <= (s.x + 70)) && (this.y >= s.y && this.y <= (s.y + 70))) {
      return true;
    }
    return false;
  }
  
  void onCollision() {
    image(this.img, -100, -100);
    background(255, 111, 111);
    this.collided = true;
  }
}

class Spaceship {
  PImage img;
  float x;
  float y;
  float direction;
  float destination;
  
  Spaceship() {
    this.img = new PImage();
    this.x = ((CANVAS_WIDTH / 2) - 65);
    this.y = -100;
    this.direction = -1;
    this.destination = ((CANVAS_WIDTH / 2) - 400);
  }
  
  void move_horizontally() {
    if (this.x <= (this.destination + 15) && this.direction == -1) {
      this.direction = 1;
      this.destination = ((CANVAS_WIDTH / 2) + 400);
    } else if (this.x >= (this.destination - 15) && this.direction == 1) {
      this.direction = -1;
      this.destination = ((CANVAS_WIDTH / 2) - 400);
    }
    
    this.x = lerp(this.x, this.destination, 0.05);
  }
  
  boolean is_colliding(CollidingObject co) {
    return true;
  }
  
  void move_away() {
    this.y = lerp(this.y, height + 500, 0.05);
  }
}

class Fish {
  PImage img;
  float x;
  float y;
  float direction;
  float destination;
  
  Fish() {
    this.img = new PImage();
    this.x = ((CANVAS_WIDTH / 2) - 319.5);
    this.y = -1500;
    this.direction = -1;
    this.destination = ((CANVAS_WIDTH / 2) - 600);
  }
  
  void move_horizontally() {
    if (this.x <= (this.destination + 15) && this.direction == -1) {
      this.direction = 1;
      this.destination = ((CANVAS_WIDTH / 2) + 600);
    } else if (this.x >= (this.destination - 15) && this.direction == 1) {
      this.direction = -1;
      this.destination = ((CANVAS_WIDTH / 2) - 600);
    }
    
    this.x = lerp(this.x, this.destination, 0.05);
  }
  
  void follow(Spaceship s) {
    this.direction = s.direction;
    this.destination = s.destination;
    
    this.x = lerp(this.x, this.destination, 0.05);
  }
  
  void move_away() {
    this.y = lerp(this.y, height + 500, 0.05);
  }
}
