var fboSceneNameList = ["Title", "Instructions", "Turbulence", "PlaneLanding", "FlappyPlane","Whistle","ChairWoman","PlaneEvacuation"];
var fboSceneDataList = [];
var bpm = 152.0;
var beat = 60.0/bpm;
var instructionAlpha = 255;

function initMixer(animation) {
    for (var i = 0; i < fboSceneNameList.length; i++) {
        fboSceneDataList.push(imageLoadImage(fboSceneNameList[i] + "SceneFbo.color.fbo"));
    }
}

function drawMixer(animation) {
    var scene3 = Math.floor(Sync.getSyncValue('scene3'));
    if (scene3 >= 0) {
        var image = fboSceneDataList[scene3];
        setTextureColor(image.ptr, 0xFF,0xFF,0xFF,Sync.getSyncValue('scene3_alpha') * 0xFF);
        drawTexture(image.ptr);
    }

    var scene4 = Math.floor(Sync.getSyncValue('scene4'));
    if (scene4 >= 0) {
        var image = fboSceneDataList[scene4];
        setTextureColor(image.ptr, 0xFF,0xFF,0xFF,Sync.getSyncValue('scene4_alpha') * 0xFF);
        drawTexture(image.ptr);
    }

    var scene5 = Math.floor(Sync.getSyncValue('scene5'));
    if (scene5 >= 0) {
        var image = fboSceneDataList[scene5];
        setTextureColor(image.ptr, 0xFF,0xFF,0xFF,Sync.getSyncValue('scene5_alpha') * 0xFF);
        drawTexture(image.ptr);
    }

    var scene6 = Math.floor(Sync.getSyncValue('scene6'));
    if (scene6 >= 0) {
        var image = fboSceneDataList[scene6];
        setTextureColor(image.ptr, 0xFF,0xFF,0xFF,Sync.getSyncValue('scene6_alpha') * 0xFF);
        drawTexture(image.ptr);
    }

    var scene7 = Math.floor(Sync.getSyncValue('scene7'));
    if (scene7 >= 0) {
        var image = fboSceneDataList[scene7];
        setTextureColor(image.ptr, 0xFF,0xFF,0xFF,Sync.getSyncValue('scene7_alpha') * 0xFF);
        drawTexture(image.ptr);
    }

    var scene8 = Math.floor(Sync.getSyncValue('scene8'));
    if (scene8 >= 0) {
        var image = fboSceneDataList[scene8];
        setTextureColor(image.ptr, 0xFF,0xFF,0xFF,Sync.getSyncValue('scene8_alpha') * 0xFF);
        drawTexture(image.ptr);
    }

    var scene1 = Math.floor(Sync.getSyncValue('scene1'));
    if (scene1 >= 0) {
        var image = fboSceneDataList[scene1];
        setTextureColor(image.ptr, 0xFF,0xFF,0xFF,Sync.getSyncValue('scene1_alpha') * 0xFF);
        drawTexture(image.ptr);
    }

    var scene2 = Math.floor(Sync.getSyncValue('scene2'));
    if (scene2 >= 0) {
        var image = fboSceneDataList[scene2];
        setTextureColor(image.ptr, 0xFF,0xFF,0xFF,Sync.getSyncValue('scene2_alpha') * 0xFF);
        drawTexture(image.ptr);
    }
}

var heightMapMesh = void null;
var heightMapTexture = void null;
var runwayTexture = void null;
function initHeightMap(animation) {
    heightMapMesh = new Mesh();
    if (heightMapMesh.ptr === void null) {
        loggerFatal("Could not initialize Mesh");
    }

    var precision = 24;

    heightMapTexture = imageLoadImage("heightmap.png");
    runwayTexture = imageLoadImage("runway.png");

    heightMapMesh.setMaterialTexture(heightMapTexture, 0);
    heightMapMesh.setMaterialTexture(runwayTexture, 1);

    var lineMax = 480;
    heightMapMesh.setFaceDrawType(TRIANGLES);

    var max = {"y":40.0,"x":40};
    var step = 0.2;
    var uvStep = {"y":step/max.y,"x":step/max.x};
    for(var y = 0; y < max.y; y+=step) {
        for(var x = 0; x < max.x; x+=step) {
            var z = 0;
            var u = x/max.x;
            var v = y/max.y;

            heightMapMesh.addTexCoord(u, v);
            heightMapMesh.addVertex(x, y, z);

            heightMapMesh.addTexCoord(u + uvStep.x, v + uvStep.y);
            heightMapMesh.addVertex(x + step, y + step, z);

            heightMapMesh.addTexCoord(u, v + uvStep.y);
            heightMapMesh.addVertex(x, y + step, z);

            heightMapMesh.addTexCoord(u, v);
            heightMapMesh.addVertex(x, y, z);

            heightMapMesh.addTexCoord(u + uvStep.x, v);
            heightMapMesh.addVertex(x + step, y, z);

            heightMapMesh.addTexCoord(u + uvStep.x, v + uvStep.y);
            heightMapMesh.addVertex(x + step, y + step, z);
        }
    }

    heightMapMesh.generate();

}

function deinitHeightMap(animation) {
    heightMapMesh.delete();
    //TODO: ummh... did i fix this and was there still need for manual cleanup?
    //well... i don't really five a fuck; you shouldn't either
    //texturedQuadDeinit(heightMapTexture.ptr);
    //texturedQuadDeinit(runwayTexture.ptr);
}

function drawHeightMap(animation) {
    glPushMatrix();
    perspective2dEnd();

    glTranslatef(-26,-2.1,0);// * getSceneTimeFromStart()*0.5);
    glRotatef(-90,1,0,0);

    heightMapMesh.draw();

    glPopMatrix();
}

Demo.prototype.addLight = function(start, duration, layer)
{
    this.loader.addAnimation([
    {
         "start": start, "duration": duration, "layer": layer
        ,"light":{"index":0, "action":"begin"}
        ,"lightType": Light.type.DIRECTIONAL
        ,"direction":[
             {"x":0.5, "y":-1, "z":-0.5}
        ]
        ,"specularColor":[
             {"r":255, "g":255, "b":255, "a":255}
        ]
        ,"diffuseColor":[
             {"r":255*0.6, "g":255*0.6, "b":255*0.6, "a":255}
        ]
        ,"ambientColor":[
             {"r":255*0.3, "g":255*0.3, "b":255*0.3, "a":255}
        ]
    }]);
}

Demo.prototype.addTitle = function(start, duration, layer)
{
    this.loader.setScene("Title", {"useFbo": true});

    this.addLight(start, duration, layer);

    var rotateObjs = [
         {"name":"jml_fist.dae","z":-15,"degreesX":1,"degreesZ":1}
        ,{"name":"text_safety.obj","z":-5,"degreesX":-1,"degreesZ":-1}
        ,{"name":"jml_fist.dae","z":-15,"degreesX":1,"degreesZ":1}
        ,{"name":"text_sicherheit.obj","z":-5,"degreesX":-1,"degreesZ":-1}
    ];

    for(var i = 0; i < rotateObjs.length; i++) {
        var obj = rotateObjs[i%rotateObjs.length];
        var objDuration = 3;
        var objStart = start+i*objDuration;
        this.loader.addAnimation(
        {
             "start": objStart, "duration": objDuration, "layer": layer
            ,"object": obj.name
            ,"position":[{"z":obj.z}]
            ,"angle":[
                {"degreesX":obj.degreesX*90,"degreesZ":obj.degreesZ*(90)},
                {"duration":objDuration,"degreesZ":obj.degreesZ*(360+90)}
            ]
        });
    }
}

Demo.prototype.addTurbulence = function(start, duration, layer)
{
    this.loader.setScene("Turbulence",{"useFbo": true});

    this.loader.addAnimation(
    {
         "start": start, "duration": duration + 80, "layer": layer
        ,"image": "warning_panel.png"
    });

    this.loader.addAnimation(
    {
         "start": start, "duration": duration + 80, "layer": layer
        ,"image": "no_smoking_off.png"
        ,"position":[{"y":getScreenHeight()/2.0,"x": 500}]
    });
    this.loader.addAnimation(
    {
         "start": start, "duration": duration + 80, "layer": layer
        ,"image": "fasten_seatbelts_off.png"
        ,"position":[{"y":getScreenHeight()/2.0,"x": 1350}]
        //,"color":[{"a":0},{"duration":0.5,"a":255}]
    });

    this.loader.addAnimation(
    {
         "start": start, "duration": duration, "layer": layer
        ,"image": "no_smoking.png"
        ,"position":[{"y":getScreenHeight()/2.0,"x": 500}]
        ,"color":[{"a":0},{"duration":0.5,"a":"{return (1+Math.sin(getSceneTimeFromStart()*20))/2*255*Sync.getSyncValue('turbulence')}"}]
    });

    this.loader.addAnimation(
    {
         "start": start, "duration": duration, "layer": layer
        ,"image": "fasten_seatbelts.png"
        ,"position":[{"y":getScreenHeight()/2.0,"x": 1350}]
        ,"color":[{"a":0},{"duration":0.5,"a":"{return 255*Sync.getSyncValue('turbulence');}"}]
    });
}

Demo.prototype.addWhistle = function(start, duration, layer)
{
    this.loader.setScene("Whistle",{"useFbo": true});

    this.loader.addAnimation(
    {
         "start": start, "duration": duration, "layer": layer
        ,"image": "_embedded/defaultWhite.png"
        ,"shader":{
             "name":"spiral.fs"
         }
    });

    this.loader.addAnimation(
    {
         "start": start, "duration": duration, "layer": layer
        ,"image": "whistle_man_pants.png"
        ,"color":[{"a":0},{"duration":1.0,"a":instructionAlpha}]
        ,"position":[{"y":210,"x": 740}]
    });

    this.loader.addAnimation(
    {
         "start": start, "duration": duration, "layer": layer
        ,"image": "whistle_bg.png"
        ,"color":[{"a":0},{"duration":1.0,"a":instructionAlpha}]
    });

    this.loader.addAnimation(
    {
         "start": start, "duration": duration, "layer": layer
        ,"image": "whistle_fem_hand_1.png"
        ,"color":[{"a":0},{"duration":1.0,"a":instructionAlpha}]
        ,"position":[
            {
              "y": "{return 308 - (45*((1+Math.sin(getSceneTimeFromStart()*17))/2.0)*Sync.getSyncValue('s6Hand'));}"
             ,"x": "{return 950 - (45*((1+Math.sin(getSceneTimeFromStart()*17))/2.0)*Sync.getSyncValue('s6Hand'));}"
            }
        ]
    });

    this.loader.addAnimation(
    {
         "start": start, "duration": duration, "layer": layer
        ,"image": "whistle_bgfg.png"
        ,"color":[{"a":0},{"duration":1.0,"a":instructionAlpha}]
    });
    this.loader.addAnimation(
    {
         "start": start, "duration": duration, "layer": layer
        ,"image": "whistle_head.png"
        ,"color":[{"a":"{return instructionAlpha*Sync.getSyncValue('s6Mouth');}"}]
        //,"color":[{"r":255,"g":255,"b":255,"a":100}]
        ,"position":[{"y":837,"x": 651}]
    });

    this.loader.addAnimation(
    {
         "start": start, "duration": 6, "layer": layer
        ,"image": "arrow.png"
        ,"angle":[{"degreesZ":-135}]
        ,"scale":[{"uniform2d":"{return 1.5+Math.sin(getSceneTimeFromStart()*7)*0.5;}"}]
        ,"color":[{"a":"{return (1+Math.sin(getSceneTimeFromStart()*7))/2.0*155+100;}"}]
        ,"position":[{"y":getScreenHeight()*0.57,"x":getScreenWidth()*0.39}]
    });

    this.loader.addAnimation(
    {
         "start": start, "duration": 9, "layer": layer
        ,"image": "arrow.png"
        ,"angle":[{"degreesZ":45}]
        ,"scale":[{"uniform2d":"{return 1.5+Math.sin(getSceneTimeFromStart()*7)*0.5;}"}]
        ,"color":[{"a":"{return (1+Math.sin(getSceneTimeFromStart()*7))/2.0*155+100;}"}]
        ,"position":[{"y":getScreenHeight()*0.31,"x":getScreenWidth()*0.43}]
    });
}


Demo.prototype.addInstructions = function(start, duration, layer)
{
    this.loader.setScene("Instructions",{"useFbo": true});

    var images = ["lifevest_1.png","lifevest_2.png","lifevest_3.png","lifevest_4.png"];
    for (var i = 0; i < images.length; i++) {
        var wantedDuration = 3;
        var singleDuration = wantedDuration / images.length;
        var fade = 0.25;
        this.loader.addAnimation(
        {
             "start": start + i*singleDuration, "duration": singleDuration+fade, "layer": layer
            ,"image": images[i]
            ,"color":[
                 {"a":0}
                ,{"duration":fade,"a":instructionAlpha}
                ,{"duration":singleDuration-fade}
                ,{"duration":fade,"a":0}
            ]
        });
    }
}

Demo.prototype.addChairWoman = function(start, duration, layer)
{
    this.loader.setScene("ChairWoman",{"useFbo": true});

    this.loader.addAnimation(
    {
         "start": start, "duration": duration, "layer": layer
        ,"image": "_embedded/defaultWhite.png"
        ,"shader":{
             "name":"spiral.fs"
         }
    });

    this.loader.addAnimation(
    {
         "start": start, "duration": duration/2.0, "layer": layer
        ,"image": "chair_woman_torso.png"
        ,"position":[{"x":"{return getScreenWidth()/2.0+20+Math.sin(getSceneTimeFromStart()*17)*30;}","y":getScreenHeight()/2.0+170}]
        ,"angle":[{"degreesZ":"{return Math.sin(getSceneTimeFromStart()*17)*10;}"}]
        ,"scale":[{"uniform2d":2}]
        ,"color":[{"a":instructionAlpha}]
    });

    this.loader.addAnimation(
    {
         "start": start, "duration": duration/2.0, "layer": layer
        ,"image": "chair_woman.png"
        ,"position":[{"x":getScreenWidth()/2.0,"y":getScreenHeight()/2.0}]
        ,"scale":[{"uniform2d":2}]
        ,"color":[{"a":instructionAlpha}]
    });

    this.loader.addAnimation(
    {
         "start": start, "duration": 4, "layer": layer
        ,"image": "arrow.png"
        //,"angle":[{"degreesZ":-135}]
        ,"scale":[{"uniform2d":"{return 1.5+Math.sin(getSceneTimeFromStart()*7)*0.5;}"}]
        ,"color":[{"a":"{return (1+Math.sin(getSceneTimeFromStart()*7))/2.0*155+100;}"}]
        ,"position":[{"y":getScreenHeight()*0.82,"x":getScreenWidth()*0.47}]
    });

    this.loader.addAnimation(
    {
         "start": start+duration/2.0, "duration": duration/2.0, "layer": layer
        ,"image": "buckle_left.png"
        ,"position":[{
            "x":"{return getScreenWidth()/2.0*0.7+Math.sin(getSceneTimeFromStart()*14)*170;}",
            "y":"{return getScreenHeight()/2.0+Math.cos(getSceneTimeFromStart()*14)*70;}"
        }]
        ,"scale":[{"uniform2d":2}]
        ,"color":[{"a":instructionAlpha}]
    });

    this.loader.addAnimation(
    {
         "start": start+duration/2.0, "duration": duration/2.0, "layer": layer
        ,"image": "buckle_right.png"
        ,"position":[{
            "x":"{return getScreenWidth()/2.0*1.4+Math.sin(getSceneTimeFromStart()*17)*180;}",
            "y":"{return getScreenHeight()/2.0+Math.sin(getSceneTimeFromStart()*12)*40;}"
        }]
        ,"scale":[{"uniform2d":2}]
        ,"color":[{"a":instructionAlpha}]
    });

    this.loader.addAnimation(
    {
         "start": start+duration/2.0, "duration": 4, "layer": layer
        ,"image": "arrow.png"
        //,"angle":[{"degreesZ":-135}]
        ,"scale":[{"uniform2d":"{return 1.5+Math.sin(getSceneTimeFromStart()*7)*0.5;}"}]
        ,"color":[{"a":"{return (1+Math.sin(getSceneTimeFromStart()*7))/2.0*155+100;}"}]
        ,"position":[{"y":getScreenHeight()*0.75,"x":getScreenWidth()*0.3}]
    });

    this.loader.addAnimation(
    {
         "start": start+duration/2.0, "duration": 4, "layer": layer
        ,"image": "arrow.png"
        ,"angle":[{"degreesZ":-180}]
        ,"scale":[{"uniform2d":"{return 1.5+Math.sin(getSceneTimeFromStart()*7)*0.5;}"}]
        ,"color":[{"a":"{return (1+Math.sin(getSceneTimeFromStart()*7))/2.0*155+100;}"}]
        ,"position":[{"y":getScreenHeight()*0.75,"x":getScreenWidth()*0.7}]
    });

    var greetings = [
        "Instanssi orgs",
        "Alumni",
        "Dekadence",
        "De-palvelut",
        "Faemiyah ",
        "Ivory Labs",
        "Kahvikello",
        "Leipaeae",
        "Paraguay",
        "The Old Dude",
        "Äärikeskusta",
        "Wide Load"
    ];

    var greetPos = [
         {"x":0.22,"y":0.95}
        ,{"x":0.80,"y":0.95}
        ,{"x":0.22,"y":0.10}
        ,{"x":0.80,"y":0.10}
    ];
    var greetStarts = [0,beat*8,beat*16,beat*24];
    for (var i = 0; i < greetings.length; i++) {
        var pos = greetPos[i%greetPos.length];
        this.loader.addAnimation([
        {
             "start": start+greetStarts[Math.floor(i/4)], "duration": beat*10
            ,"layer": layer
            ,"text":{"name":"DroidSerif-Regular.ttf","string":greetings[i]}
            ,"position":[{"x":getScreenWidth()*pos.x,"y":getScreenHeight()*pos.y}]
            ,"scale":[{"uniform2d":3.0}]
            ,"color":[{"a":0},{"duration":beat,"a":0xFF},{"duration":beat*7},{"duration":beat*3,"a":0}]
            ,"shader":{
                 "name":"noise.fs"
             }
        }]);
    }
}

Demo.prototype.addPlaneLanding = function(start, duration, layer)
{
    this.loader.setScene("PlaneLanding",
            {
                "useFbo": true
            }
    );

    this.loader.addAnimation(
    {
         "start": start, "duration": duration, "layer": layer
        ,"image": "_embedded/defaultWhite.png"
        ,"shader":{
             "name":"background.fs"
         }
    });
    this.loader.addAnimation(
    {
         "start": start, "duration": duration, "layer": layer
        ,"image": "clouds_01.png"
        ,"scale":[{"uniform2d":2}]
        ,"color": [{"a":150}]
        ,"shader":{
             "name":"cloudscroll.fs"
            ,"variable":[
                 {"name":"direction","value":[1,-1]}
                 ,{"name":"speed","value":[0.55,0.35]}
            ]
         }
    });

    this.addLight(start, duration, layer);

    this.loader.addAnimation(
    {
         "start": start, "duration": duration, "layer": layer
        ,"object": "tupolev/tupolev.obj"
        ,"scale":[{"uniform3d":0.2}]
        ,"position":[{"z":-8,
             "x":"{return Math.random()*0.12;}"
            ,"y":"{return Math.random()*0.15;}"
        }]
        ,"angle":[{
             "degreesY":"{return 90+Math.cos(getSceneTimeFromStart())*5;}"
            ,"degreesX":"{return Math.sin(getSceneTimeFromStart())*18;}"
            ,"degreesZ":"{return Math.sin(getSceneTimeFromStart())*25;}"
        }]
    });

    this.loader.addAnimation(
    {
         "start": start, "duration": duration, "layer": layer
        ,"image": "clouds_01.png"
        ,"scale":[{"uniform2d":4}]
        ,"color": [{"a":150}]
        ,"shader":{
             "name":"cloudscroll.fs"
            ,"variable":[
                 {"name":"direction","value":[1,-1]}
                 ,{"name":"speed","value":[0.55,0.35]}
            ]
         }
    });
}


Demo.prototype.addFlappyPlane = function(start, duration, layer)
{
    this.loader.setScene("FlappyPlane",{"useFbo": true}
    );

    this.loader.addAnimation(
    {
         "start": start, "duration": duration, "layer": layer
        ,"image": "_embedded/defaultWhite.png"
        ,"shader":{
             "name":"background.fs"
         }
    });
    this.loader.addAnimation(
    {
         "start": start, "duration": duration, "layer": layer
        ,"image": "clouds_01.png"
        ,"scale":[{"uniform2d":1}]
        ,"color": [{"a":200}]
        ,"shader":{
             "name":"cloudscroll.fs"
            ,"variable":[
                 {"name":"direction","value":[1,-1]}
                 ,{"name":"speed","value":[0.005,0]}
            ]
         }
    });
    this.loader.addAnimation(
    {
         "start": start, "duration": duration, "layer": layer
        ,"image": "skyline.png"
        ,"position":[{"y":400,"x":1500},{"duration":duration,"x":1200}]
    });

    this.addLight(start, duration, layer);

    var uniqueBuildings = 8;
    var buildings = {"size":uniqueBuildings*3};
    var structures = [];
    for(var i = 0; i < buildings.size; i++) {
        var y = Math.random()*0.4-0.2;
        var x = Math.random()*0.3;
        structures.push({"y":y,"x":x,"posx":Math.random()*2/-1,"posz":-Math.random()*0.5});
    }
    buildings["structures"] = structures;

    var jmax = buildings.size;
    for (var j = 1; j <= jmax; j++) {
        var i = Math.floor(j%uniqueBuildings+1);
        this.loader.addAnimation(
        {
             "start": start, "duration": duration, "layer": layer
            ,"object": "buildings/0"+i+"/building0"+i+".obj"
            ,"scale":[{"x":0.5+buildings.structures[i-1].x,"y":0.3+buildings.structures[i-1].y}]
            ,"position":[{"max":jmax, "iterator":j, "z":-8+buildings.structures[i-1].posz, "y":-4.8, "x":"{return -8+"+buildings.structures[i-1].posx+"+animation.iterator*3-getSceneTimeFromStart()%animation.max;}"}]
            ,"angle":[{"degreesX":8}]
        });
    }

    this.loader.addAnimation(
    {
         "start": start, "duration": duration, "layer": layer
        ,"object": "tupolev/tupolev.obj"
        ,"scale":[{"uniform3d":0.1}]
        ,"position":[{"z":-8, "y":"{return 2+0.2*Math.sin(getSceneTimeFromStart()*Math.cos(getSceneTimeFromStart()*0.35))+0.03*Math.sin(getSceneTimeFromStart()*10.3);}"}]
        ,"angle":[{
             "degreesY":"{return 90+Math.cos(getSceneTimeFromStart())*15;}"
            ,"degreesX":"{return Math.sin(getSceneTimeFromStart())*30;}"
            ,"degreesZ":"{return Math.sin(getSceneTimeFromStart())*25;}"
        }]
    });
}

var FIXMETESTING = false;

Demo.prototype.addPlaneEvacuation = function(start, duration, layer)
{
    this.loader.setScene("PlaneEvacuation",
            {
                "useFbo": !FIXMETESTING //FIXME LOL
            }
    );

    this.loader.addAnimation(
    {
         "start": start, "duration": duration, "layer": layer
        ,"camera": "Runway"
        ,"position":[
             {"x":2.0,"y":3.0,"z":-3.5}
        ]
        ,"target":[
            {"x":1.5,"y":2,"z":-4.5}
        ]
    });

    this.addLight(start, duration, layer);

    this.loader.addAnimation({
         "start": start, "duration": duration
        ,"layer": layer
        ,"initFunction": "{initHeightMap(animation);}"
        ,"deinitFunction": "{deinitHeightMap(animation);}"
        ,"runFunction": "{drawHeightMap(animation);}"
        ,"shader":{
             "name":["heightmap.vs","heightmap.fs"]
            ,"variable":[
                 {"name":"terrain","type":"int","value":[0]}
            ]
        }
    });

    this.loader.addAnimation(
    {
         "start": start, "duration": duration, "layer": layer
        ,"object": "tupolev/tupolev.obj"
        ,"scale":[{"uniform3d":0.15}]
        ,"position":[{"x":-1.7,"y":-1,"z":-8}]
        ,"angle":[{
             "degreesY":-168
        }]
    });

    this.loader.addAnimation([
    {
         "start": start, "duration": duration, "layer": layer
        ,"light":{"index":0, "action":"end"}
    }]);


    this.loader.addAnimation(
    {
         "start": start, "duration": duration, "layer": layer
        ,"perspective":"3d"
        ,"image": "arrow.png"
        ,"position":[{"x":-1,"y":-1,"z":-5.4}]
        ,"angle":[{"degreesX":90}]
        ,"scale":[{"uniform3d":"{return 0.3+Math.sin(getSceneTimeFromStart()*7)*0.05;}"}]
        ,"color":[{"a":"{return (1+Math.sin(getSceneTimeFromStart()*7))/2.0*100+155;}"}]
    });
    this.loader.addAnimation(
    {
         "start": start, "duration": duration, "layer": layer
        ,"perspective":"3d"
        ,"image": "arrow.png"
        ,"position":[{"x":-2.9,"y":-1,"z":-5.5}]
        ,"angle":[{"degreesX":90,"degreesZ":180}]
        ,"scale":[{"uniform3d":"{return 0.5+Math.sin(getSceneTimeFromStart()*7)*0.1;}"}]
        ,"color":[{"a":"{return (1+Math.sin(getSceneTimeFromStart()*7))/2.0*100+155;}"}]
    });
    this.loader.addAnimation(
    {
         "start": start, "duration": duration, "layer": layer
        ,"perspective":"3d"
        ,"image": "arrow.png"
        ,"position":[{"x":-0.7,"y":-1,"z":-6.8}]
        ,"angle":[{"degreesX":90}]
        ,"scale":[{"uniform3d":"{return 0.3+Math.sin(getSceneTimeFromStart()*7)*0.05;}"}]
        ,"color":[{"a":"{return (1+Math.sin(getSceneTimeFromStart()*7))/2.0*100+155;}"}]
    });
    this.loader.addAnimation(
    {
         "start": start, "duration": duration, "layer": layer
        ,"perspective":"3d"
        ,"image": "arrow.png"
        ,"position":[{"x":-2.5,"y":-1,"z":-7.0}]
        ,"angle":[{"degreesX":90,"degreesZ":180}]
        ,"scale":[{"uniform3d":"{return 0.3+Math.sin(getSceneTimeFromStart()*7)*0.05;}"}]
        ,"color":[{"a":"{return (1+Math.sin(getSceneTimeFromStart()*7))/2.0*100+155;}"}]
    });

    for(var i = 0; i < 60; i++) {
        var deltaStart = beat*12+(i*(beat/3.0));
        this.loader.addAnimation(
        {
             "start": start+deltaStart, "duration": duration-deltaStart, "layer": layer
            ,"perspective":"3d"
            ,"image": "arrow.png"
            ,"position":[{"x":Math.random()*5-4,"y":Math.random()*3-1.5,"z":-4.0-Math.random()*4}]
            ,"angle":[{"degreesY":Math.random()*20,"degreesX":Math.random()*20+90,"degreesZ":Math.random()*360}]
            ,"scale":[{"uniform3d":"{return 0.3+Math.sin(getSceneTimeFromStart()*7)*0.05;}"}]
            ,"color":[{"a":0},{"duration":beat,"a":0xFF}]
        });        
    }

    this.addLight(start, duration, layer);

    //OK, so somehow the camera is fucked and needs non-default settings
    //so that it'd look as expected...
    //i'd expect *ACTUAL* defaults should be: position-z:2.0, target-z:0.0
    this.loader.addAnimation(
    {
         "start": start, "duration": duration, "layer": layer
        ,"camera": "Default"
        ,"position":[
             {"x":0.0,"y":0.0,"z":0.0}
        ]
        ,"target":[
            {"x":0.0,"y":0.0,"z":-1.0}
        ]
    });

}


Demo.prototype.init = function()
{
    /*
    // This was the pizza ordering mechanism for
    // absent urs - KIITOS 17.2.2018 17.30 - 17.40
    // Shrimp (ok... replaced with Pepperoni), Kebab meat, Minced meat, BBQ sauce
    for(var i = 0; i < 4; i++) {
        print(Math.floor(Math.random()*20));
    }
    */

    var start = 0;
    var duration = 182;
    var layer = 1; 

    if (dmxLightManager === void null) {
        // in case menu did not exist
        dmxLightManager = new DmxLightManager();
        dmxLightManager.sock.setHost(dmxLightManagerSettings.host);
        dmxLightManager.sock.setPort(parseInt(dmxLightManagerSettings.port));
        dmxLightManager.init(parseInt(dmxLightManagerSettings.count));
    }

    Sync.addSync(
    [
         { "name":"scene1", "type":"rocket" }
        ,{ "name":"scene1_alpha", "type":"rocket" }
        ,{ "name":"scene1_start", "type":"rocket" }
        ,{ "name":"scene2", "type":"rocket" }
        ,{ "name":"scene2_alpha", "type":"rocket" }
        ,{ "name":"scene2_start", "type":"rocket" }
        ,{ "name":"scene3", "type":"rocket" }
        ,{ "name":"scene3_alpha", "type":"rocket" }
        ,{ "name":"scene3_start", "type":"rocket" }
        ,{ "name":"scene4", "type":"rocket" }
        ,{ "name":"scene4_alpha", "type":"rocket" }
        ,{ "name":"scene4_start", "type":"rocket" }
        ,{ "name":"scene5", "type":"rocket" }
        ,{ "name":"scene5_alpha", "type":"rocket" }
        ,{ "name":"scene5_start", "type":"rocket" }
        ,{ "name":"scene6", "type":"rocket" }
        ,{ "name":"scene6_alpha", "type":"rocket" }
        ,{ "name":"scene6_start", "type":"rocket" }
        ,{ "name":"scene7", "type":"rocket" }
        ,{ "name":"scene7_alpha", "type":"rocket" }
        ,{ "name":"scene7_start", "type":"rocket" }
        ,{ "name":"scene8", "type":"rocket" }
        ,{ "name":"scene8_alpha", "type":"rocket" }
        ,{ "name":"scene8_start", "type":"rocket" }
        ,{ "name":"extraBrightness", "type":"rocket" }
        ,{ "name":"turbulence", "type":"rocket" }
        ,{ "name":"mixShift", "type":"rocket" }
        ,{ "name":"dmxR", "type":"rocket" }
        ,{ "name":"dmxG", "type":"rocket" }
        ,{ "name":"dmxB", "type":"rocket" }
        ,{ "name":"dmxMul", "type":"rocket" }
        ,{ "name":"dmxAdd", "type":"rocket" }
        ,{ "name":"dmxStart", "type":"rocket" }
        ,{ "name":"dmxEnd", "type":"rocket" }
        ,{ "name":"s6Hand", "type":"rocket" }
        ,{ "name":"s6Mouth", "type":"rocket" }
    ]);


    if (FIXMETESTING) {
        this.addPlaneEvacuation(start, 20, layer);
        return; // FIXME LOL
    }

    this.loader.addSceneToTimeline([
        {
            "scene": "Title"
            ,"start": "{return Sync.getSyncValue('scene1_start'); }"
        },
        {
             "scene": "Instructions"
            ,"start": "{return Sync.getSyncValue('scene2_start'); }"
        },
        {
            "scene": "Turbulence"
            ,"start": "{return Sync.getSyncValue('scene3_start'); }"
        },
        {
             "scene": "PlaneLanding"
            ,"start": "{return Sync.getSyncValue('scene4_start'); }"
        },
        {
             "scene": "FlappyPlane"
            ,"start": "{return Sync.getSyncValue('scene5_start'); }"
        },
        {
            "scene": "Whistle"
            ,"start": "{return Sync.getSyncValue('scene6_start'); }"
        },
        {
            "scene": "ChairWoman"
            ,"start": "{return Sync.getSyncValue('scene7_start'); }"
        },
        {
            "scene": "PlaneEvacuation"
            ,"start": "{return Sync.getSyncValue('scene8_start'); }"
        },
        {
            "layer": 100,
            "scene": "Front",
            "start": 0,
            "duration": 1000
        }
    ]);

    this.addTitle(start, 10, layer);
    this.addInstructions(start, 20, layer);
    this.addTurbulence(start, 20, layer);
    this.addPlaneLanding(start, 20, layer);
    this.addFlappyPlane(start, 20, layer);
    this.addWhistle(start, 20, layer);
    this.addChairWoman(start, 20, layer);
    this.addPlaneEvacuation(start, 20, layer);

    this.loader.setScene("Front", {"useFbo": false});
    //return;
    this.loader.addAnimation({
         "start": start, "duration": duration, "layer": layer
        ,"initFunction": "{initMixer(animation);}"
        ,"runFunction": "{drawMixer(animation);}"
    });

    var postprocs = true;
    if (postprocs) {
        this.loader.addAnimation(
        {
             "start": start, "duration": duration, "layer": layer
            ,"image": "vignette.png"
        });
        this.distortion(0,200,0,50000,50002);
        this.brightnessContrast(0,200,50001,50004,50007,0.5,3.5);
    }

    this.loader.addAnimation(
    {
         "start": start, "duration": duration, "layer": layer
        ,"image": "jumadidas.png"
        ,"color":[{"a":0},{"duration":0.5,"a":255},{"duration":1.25},{"duration":0.5,"a":0}]
    });
}

Demo.prototype.distortion = function(startTime, duration, startLayer, endLayer, layer)
{
    this.loader.addAnimation ([
    {
    "start": startTime, "duration": duration
    ,"layer": startLayer
    ,"fbo":{"name":"fbodist","action":"begin"}
    },
    {
    "start": startTime, "duration": duration
    ,"layer": endLayer,"fbo":{"name":"fbodist","action":"unbind"}
    }
    ]);
    this.loader.addAnimation ([
    {
         "start": startTime, "duration": duration
        ,"image": "fbodist.color.fbo"
        ,"layer": layer
        ,"shader":{"name":"distortion.fs",
            "variable":[
                 {"name":"timeMultiplier","value":[20.9]}
                ,{"name":"pixelSize","value":["{return 0.005-Math.random()*0.004;}",0.005]}
                ,{"name":"noiseWaveSpeed","value":[10]}
                ,{"name":"noiseWaveSize","value":[8]}
                ,{"name":"noiseLuminance","value":[1]}
                ,{"name":"noiseAlpha","value":[0.2]}
                ,{"name":"colorComponentDistortionX","value":["{return -0.05*Math.random();}",0.00,0.00,0.00]}
                ,{"name":"colorComponentDistortionY","value":["{return -0.05*Math.random();}",0.00,0.00,0.00]}
                /*,{"name":"noiseWaveSpeed","value":[10]}
                ,{"name":"noiseWaveSize","value":[1]}
                ,{"name":"noiseLuminance","value":[0]}
                ,{"name":"noiseAlpha","value":[0.0]}
                ,{"name":"colorComponentDistortionX","value":[0.01,0.01,0.01,0.01]}
                ,{"name":"colorComponentDistortionY","value":[0.01,0.01,0.01,0.01]}*/
            ]
            }
        }]);
}


function brightnessContrastSync(animation) {
    setTextureSizeToScreenSize(fboBcImage.ptr);
    var timeNow = getSceneTimeFromStart();
    var start = beat * 16;

    if (dmxLightManager.isInitialized() && timeNow > animation.start+start) {
        var beatSync = 1.0-((timeNow+start)%animation.beat)/animation.beat;
        var mul = Sync.getSyncValue('dmxMul');
        var add = Sync.getSyncValue('dmxAdd');
        var r = Utils.clampRange((beatSync * (0xFF * Sync.getSyncValue('dmxR'))) * mul + add, 0.0, 255.0);
        var g = Utils.clampRange((beatSync * (0xFF * Sync.getSyncValue('dmxG'))) * mul + add, 0.0, 255.0);
        var b = Utils.clampRange((beatSync * (0xFF * Sync.getSyncValue('dmxB'))) * mul + add, 0.0, 255.0);
        var start = 0;
        var end = dmxLightManager.lightCount;
        var count = (end-start)/2.0;

        if (timeNow < 27.0) {
            if (timeNow % (beat*2) >= beat) {
                start += count;
            } else {
                end -= count;
            }
        } else if (timeNow > 61.0) {
            start = Math.floor((timeNow*(beat*8))%dmxLightManager.lightCount);
            end = start+4;
            /*g = 0x20;
            if (timeNow % (beat*2) >= beat) {
                b = 0x20;
            } else {
                r = 0x20;
            }*/
        }

        dmxLightManager.setColor(r, g, b, start, end);
        dmxLightManager.sendData();
    }
}

function brightnessContrastSyncDeinit(animation) {
    if (dmxLightManager.isInitialized()) {
        dmxLightManager.setColor(0x00,0x00,0x00);
        dmxLightManager.sendData();
        dmxLightManager.deinit();
        dmxLightManager = void null; //reload will fuck up without this
    }
}

Demo.prototype.brightnessContrast = function (startTime, duration, startLayer, endLayer, layer, brightness, contrast)
{
    var contrast = 8;
    var brightness = 0.3;
    this.loader.addAnimation ([
    {
    "start": startTime, "duration": duration
    ,"layer": startLayer
    ,"fbo":{"name":"fbobc","action":"begin"}
    },
    {
    "start": startTime, "duration": duration
    ,"layer": endLayer,"fbo":{"name":"fbobc","action":"unbind"}
    }
    ]);
    this.loader.addAnimation ([
        {
             "start": startTime, "duration":duration
            ,"layer": layer, "image": ["fbobc.color.fbo"]
         ,"initFunction":"{fboBcImage = imageLoadImage('fbobc.color.fbo'); setTextureSizeToScreenSize(fboBcImage.ptr); }"
         ,"runFunction":"{brightnessContrastSync(animation);}"
         ,"deinitFunction":"{brightnessContrastSyncDeinit(animation);}"
         ,"brightness": brightness
         ,"contrast": contrast
         ,"beat": beat
            ,"shader":{
                "name":"brightnesscontrast.fs",
                "variable":[
                      {"name":"brightness","value":["{return animation.brightness-(getSceneTimeFromStart()%animation.beat)}"]}
                     ,{"name":"contrast","value":[contrast]}
                ]
            }
        }
    ]);
}