#version 330 core

in vec2 texCoord;
in vec4 vertexFragColor;
out vec4 fragColor;
uniform sampler2D texture0;
uniform vec4 color = vec4(1,1,1,1);


uniform vec4 colorStart = vec4(0x30/255.0,0x8b/255.0,0xda/255.0,1);
uniform vec4 colorEnd = vec4(0x80/255.0,0xdb/255.0,0xff/255.0,1);
uniform float ySplice = 0.01;
uniform bool enableVertexColor = true;

float circle(in vec2 p, in float r){
    vec2 dist = p-vec2(0.5);
    dist.x *= 16.0/11.0;
    return 1.-smoothstep(r-(r*0.01),
                         r+(r*0.01),
                         dot(dist,dist));
}

void main() {
    fragColor = mix(colorStart, colorEnd, texCoord.y-mod(texCoord.y,ySplice));

    /*if (textureSize(texture0, 0).x > 0) {
        fragColor *= texture(texture0, texCoord);
    }

    //if (enableVertexColor) {
        fragColor *= vertexFragColor;
    //}*/

    fragColor *= color;
    //fragColor = vec4(1,0,0,1);
}
