/* eslint-disable require-jsdoc*/
/* eslint-disable no-undef*/
(function libraryWrapper(window) {
  function defineLibrary() {
    const ColorFiltersLib = {};
    const ConnectionType = FilterLib.ConnectionType;

//  Color filters
    ColorFiltersLib.MaxColorFilter = class MaxColorFilter extends FilterLib.Filter {
      constructor() {
        super('MaxColor', 0, 1, ConnectionType.Color, 0, 0, 1);
        this.mFragSourceFile = undefined;
        this.mVertSourceFile = undefined;
        this.mIsTriggerFilter = true;
        this.setColors();
      }
      triggerFilter(trigger) {
        if (trigger) this.calculate();
      }

      calculate() {
        let r = this.mColorLists[0][(0 * 4) + 0];
        let g = this.mColorLists[0][(0 * 4) + 1];
        let b = this.mColorLists[0][(0 * 4) + 2];

        for (let i = 0; i < this.mColorLists[0].length / 4; i++) {
          if (r < this.mColorLists[0][(i * 4) + 0]) r = this.mColorLists[0][(i * 4) + 0];
          if (g < this.mColorLists[0][(i * 4) + 1]) g = this.mColorLists[0][(i * 4) + 1];
          if (b < this.mColorLists[0][(i * 4) + 2]) b = this.mColorLists[0][(i * 4) + 2];
        }

        this.mColorOutput[0] = r;
        this.mColorOutput[1] = g;
        this.mColorOutput[2] = b;
        this.mColorOutput[3] = 1.0;
      }
    };

    ColorFiltersLib.MinColorFilter = class MinColorFilter extends FilterLib.Filter {
      constructor() {
        super('MinColor', 0, 1, ConnectionType.Color, 0, 0, 1);
        this.mFragSourceFile = undefined;
        this.mVertSourceFile = undefined;
        this.mIsTriggerFilter = true;
        this.setColors();
      }
      triggerFilter(trigger) {
        if (trigger) this.calculate();
      }

      calculate() {
        let r = this.mColorLists[0][(0 * 4) + 0];
        let g = this.mColorLists[0][(0 * 4) + 1];
        let b = this.mColorLists[0][(0 * 4) + 2];

        for (let i = 0; i < this.mColorLists[0].length / 4; i++) {
          if (r > this.mColorLists[0][(i * 4) + 0]) r = this.mColorLists[0][(i * 4) + 0];
          if (g > this.mColorLists[0][(i * 4) + 1]) g = this.mColorLists[0][(i * 4) + 1];
          if (b > this.mColorLists[0][(i * 4) + 2]) b = this.mColorLists[0][(i * 4) + 2];
        }

        this.mColorOutput[0] = r;
        this.mColorOutput[1] = g;
        this.mColorOutput[2] = b;
        this.mColorOutput[3] = 1.0;
      }
    };

    ColorFiltersLib.RandomColorFilter = class RandomColorFilter extends FilterLib.Filter {
      constructor() {
        super('RandomColor', 0, 1, ConnectionType.Color);
        this.mFragSourceFile = undefined;
        this.mVertSourceFile = undefined;
        this.mIsTriggerFilter = true;
        this.setColors();
      }
      triggerFilter(trigger) {
        if (trigger) {
          this.mColorOutput = [];
          this.mColorOutput.push(Math.random());
          this.mColorOutput.push(Math.random());
          this.mColorOutput.push(Math.random());
          this.mColorOutput.push(1.0);
        }
      }
    };

    ColorFiltersLib.WhiteColorFilter = class WhiteColorFilter extends FilterLib.Filter {
      constructor() {
        super('WhiteColor', 0, 1, ConnectionType.Color);
        this.mFragSourceFile = undefined;
        this.mVertSourceFile = undefined;
        this.mColorOutput = [];
        this.mColorOutput.push(1.0);
        this.mColorOutput.push(1.0);
        this.mColorOutput.push(1.0);
        this.mColorOutput.push(1.0);
      }

    };
    return ColorFiltersLib;
  }
  if (typeof (ColorFiltersLib) === 'undefined') window.ColorFiltersLib = defineLibrary(); // eslint-disable-line no-param-reassign, no-undef
  else console.log('Library already defined.'); // eslint-disable-line no-console
}(window)); // eslint-disable-line no-undef
