/* eslint-disable require-jsdoc*/
(function libraryWrapper(window) {
  function defineLibrary() {
    const FilterComponent = FilterComponentLib.FilterComponent; // eslint-disable-line no-undef
    const DesignLib = {};
    let canvas;
    let context;
    let filters = [];
    let mFromOutput = null;
    let mMouseX = 0;
    let mMouseY = 0;
    let mName = 'CustomFilter';
    let offsetx = 0;
    let offsety = 0;
    let movableFilter = null;
    let previous = null;
    let previousX = null;
    let previousY = null;
    let previousComponent = null;
    let overlaysection = null;
    let overlayname = null;
    let nameField = null;
    let multipassfilterlist = null;

    function storageAvailable(type) {
      try {
        const storage = window[type];
        const x = '__storage_test__';
        storage.setItem(x, x);
        storage.removeItem(x);
        return true;
      } catch (e) {
        return false;
      }
    }

    DesignLib.resize = function resize() {
    };

    DesignLib.draw = function draw() {
      context.clearRect(0, 0, canvas.width, canvas.height);
      context.fillStyle = 'Black';
      context.fillRect(0, 0, canvas.width, canvas.height);

      context.fillStyle = 'DarkGray';
      context.fillRect(canvas.width - (0.20 * canvas.height),
                canvas.height * 0.80,
                canvas.height * 0.20,
                canvas.height * 0.20);
      context.fillStyle = 'Black';
      context.fillRect(canvas.width - (0.18 * canvas.height),
                canvas.height * 0.82,
                canvas.height * 0.16,
                canvas.height * 0.16);

      const l = filters.length;
      for (let i = 0; i < l; i++) {
        filters[i].draw(context, canvas);
        filters[i].drawTexts(context, canvas);
      }

      for (let i = 0; i < l; i++) {
        filters[i].drawCables(context, canvas);
      }

      for (let i = 0; i < l; i++) {
        filters[i].drawConnections(context, canvas);
      }
      context.strokeStyle = 'DarkGray';
      context.lineWidth = 3.0;
      if (mFromOutput !== null) {
        context.strokeStyle = mFromOutput.getCableColor(false);
        context.lineWidth = mFromOutput.getOutputCableWidth();
        context.beginPath();
        context.moveTo(mFromOutput.getOutputX() * canvas.width,
                  mFromOutput.getOutputY() * canvas.height);
        context.lineTo(
                    mMouseX * canvas.width,
                    mMouseY * canvas.height);
        context.stroke();
      }
    };

    DesignLib.touchDown = function touchDown(event) {
      const x = (event.touches[0].clientX - canvas.offsetLeft) / DesignLib.getWidth();
      const y = (event.touches[0].clientY - canvas.offsetTop) / DesignLib.getHeight();
      for (let j = 0; j < filters.length; j++) {
        const filter = filters[j];
        for (let i = 0; i < filter.getInputCount(); i++) {
          if (filter.containsInput(x, y, i)) {
                        // mFromInput = filter
            mFromOutput = filter.getInput(i);
            if (mFromOutput != null) {
              mFromOutput.unplugOutput(filter, i);
              filter.unplugInput(mFromOutput, i);
              mMouseX = x;
              mMouseY = y;
              DesignLib.draw();
            }
            return true;
          }
        }

        if (filter.containsOutput(x, y)) {
          mFromOutput = filter;
          mMouseX = x;
          mMouseY = y;
          DesignLib.draw();
          return true;
        }

        mFromOutput = null;
        if (filter.contains(x, y)) {
          offsetx = x - filter.getX();
          offsety = y - filter.getY();
          movableFilter = filter;


          const current = (new Date()).getTime();
          if (current - previous < 500 && Math.abs(previousX - x) < 0.05
                      && Math.abs(previousY - y) < 0.05 && previousComponent === filter) {
            // console.log('open filter setttings');
            DesignLib.openFilterSettings(filter.getFilter());
            movableFilter = null;
            return true;
          }

          previous = (new Date()).getTime();

          previousX = x;
          previousY = y;
          previousComponent = filter;
        }
      }
      return true;
    };

    DesignLib.touchUp = function touchUp() {
    // DesignLib.mouseUp = function mouseUp(e) {
      const rawX = (mMouseX * DesignLib.getWidth());
      const rawY = (mMouseY * DesignLib.getHeight());
      console.log(`raw ${rawX} ${rawY}`);
      const x = rawX / DesignLib.getWidth();
      const y = rawY / DesignLib.getHeight();
      console.log(`xy ${x} ${y}`);

      if (movableFilter !== null) {
        if (rawX > DesignLib.getWidth() - (0.2 * DesignLib.getHeight())
          && rawY > DesignLib.getHeight() * 0.8) {
          movableFilter.unplugAll();
          let index = -1;

          for (let i = 0; i < filters.length; i++) {
            if (filters[i] === movableFilter) {
              index = i;
            }
          }
          if (index !== -1) filters.splice(index, 1);
        }

        movableFilter = null;
      }


      if (mFromOutput != null) {
        console.log(`trying connect ${x} ${y}`);
        for (let j = 0; j < filters.length; j++) {
          const filter = filters[j];
          for (let i = 0; i < filter.getInputCount(); i++) {
            if (filter.containsInput(x, y, i)) {
              mFromOutput.plugOutput(filter, i);
              filter.plugInput(mFromOutput, i);
                  // showPlugStatePopup(state);

              mFromOutput = null;
              return true;
            }
          }
          if (filter.contains(x, y)) {
            const i = (((y - (filter.getY() - filter.getHeight() / 2.0))
                / filter.getHeight()) * filter.getInputCount());
            mFromOutput.plugOutput(filter, i);
            filter.plugInput(mFromOutput, i);
                // showPlugStatePopup(state);
            mFromOutput = null;
            return true;
          }
        }
        mFromOutput = null;
      }
      DesignLib.draw();
      return true;
    };

    DesignLib.touchMove = function touchMove(event) {
      const x = (event.touches[0].clientX - canvas.offsetLeft) / DesignLib.getWidth();
      const y = (event.touches[0].clientY - canvas.offsetTop) / DesignLib.getHeight();
      if (movableFilter != null) {
        movableFilter.move(x - offsetx, y - offsety);
      }

      if (mFromOutput != null) {
        mMouseX = x;
        mMouseY = y;
      }
      DesignLib.draw();
      return true;
    };

    DesignLib.mouseDown = function mouseDown(event) {
      const e = {};
      e.touches = [];
      e.touches.push({
        clientX: event.pageX,
        clientY: event.pageY
      });
      DesignLib.touchDown(e);
    };

    DesignLib.mouseMove = function mouseMove(event) {
      const e = {};
      e.touches = [];
      e.touches.push({
        clientX: event.pageX,
        clientY: event.pageY
      });
      DesignLib.touchMove(e);
    };

    DesignLib.mouseUp = function mouseUp(event) {
      mMouseX = (event.pageX - canvas.offsetLeft) / DesignLib.getWidth();
      mMouseY = (event.pageY - canvas.offsetTop) / DesignLib.getHeight();
      DesignLib.touchUp();
    };

    DesignLib.setName = function setName(name) {
      mName = name;
      nameField.value = name;
    };

    DesignLib.start = function start() {
      canvas = document.getElementById('design'); // eslint-disable-line no-undef
      const filterList = document.getElementById('filters'); // eslint-disable-line no-undef
      const addButton = document.getElementById('addButton'); // eslint-disable-line no-undef
      const saveButton = document.getElementById('saveButton'); // eslint-disable-line no-undef
      const deleteButton = document.getElementById('deleteButton'); // eslint-disable-line no-undef
      const exportButton = document.getElementById('exportButton'); // eslint-disable-line no-undef
      multipassfilterlist = document.getElementById('multipassfilters'); // eslint-disable-line no-undef
      nameField = document.getElementById('filtername'); // eslint-disable-line no-undef
      overlaysection = document.getElementById('overlaysection'); // eslint-disable-line no-undef
      overlayname = document.getElementById('overlayname'); // eslint-disable-line no-undef

      nameField.onchange = function nameFieldChanged() {
        DesignLib.setName(nameField.value);
      };

      for (let i = 0; i < FiltersMapLib.filterList.length; i++) { // eslint-disable-line no-undef
        const filter = new FiltersMapLib.filterList[i]();// eslint-disable-line no-undef
        const option = document.createElement('option');// eslint-disable-line no-undef
        option.text = filter.getName();
        option.value = filter.getName();
        filterList.appendChild(option);
      }

      const oldfun = FilterLib.currentMultiPassFilterChanged;
      FilterLib.currentMultiPassFilterChanged = function filterchanged() {
        DesignLib.multiPassFilterChanged();
        if (oldfun) oldfun();
      };

      multipassfilterlist.onchange = function filterSelected() {
        const fname = multipassfilters.value;
        if (storageAvailable('localStorage')) {
          if (localStorage[fname] && localStorage[fname] !== '') { // eslint-disable-line no-undef
            const jsonta = localStorage[fname]; // eslint-disable-line no-undef
            // DesignLib.createFilter(jsonta);
            FilterLib.loadMultiPassFilter(jsonta);
          }
        }
      };

      DesignLib.updateFilterList();

      addButton.onclick = function addButton() {
        DesignLib.addFilter(new FilterComponent(
          new FiltersMapLib.filterMap[filterList.value](), // eslint-disable-line no-undef
          0.5, 0.5));
      };

      deleteButton.onclick = function deleteButton() {
        if (storageAvailable('localStorage')) {
          try {
            localStorage.setItem(mName, undefined); // eslint-disable-line no-undef
            let tempFilterList = [];
            if (localStorage.filterlist && localStorage.filterlist !== '') {
              const filterListJSON = localStorage.filterlist;  // eslint-disable-line no-undef
              tempFilterList = JSON.parse(filterListJSON);
            }
            for (let i = 0; i < tempFilterList.length; i++) {
              if (tempFilterList[i] === mName) {
                tempFilterList.splice(i, 1);
              }
            }
            const jsonFilterList = JSON.stringify(tempFilterList);
            localStorage.setItem('filterlist', jsonFilterList);
          } catch (e) {
            console.log(e); // eslint-disable-line no-console
          }
        }
        DesignLib.updateFilterList();
      };

      exportButton.onclick = DesignLib.exportFilters;

      saveButton.onclick = DesignLib.saveFilter;
/*
      loadButton.onclick = function loadButton() {
        if (storageAvailable('localStorage')) {
          if (localStorage.filter && localStorage.filter !== '') { // eslint-disable-line no-undef
            const jsonta = localStorage.filter; // eslint-disable-line no-undef
            DesignLib.createFilter(jsonta);
          }
        }
      };
      */

      context = canvas.getContext('2d');
      DesignLib.draw();
      DesignLib.newFilter('TEST');
      canvas.addEventListener('mousedown', DesignLib.mouseDown, false);
      canvas.addEventListener('mouseup', DesignLib.mouseUp, false);
      canvas.addEventListener('mousemove', DesignLib.mouseMove, false);
      canvas.ondragover = function allowdrop(ev) {
        ev.preventDefault();
        console.log('ondragover');
      };
      canvas.ondrop = function ondrop(ev) {
        ev.preventDefault();
        console.log('ondrop');
        const record = ev.dataTransfer.getData('record');
        if (record !== '') {
          console.log(`record ${record}`);
          const filter = new VideoFiltersLib.VideoFilter();
          filter.setVideoIndex(record);
          DesignLib.addFilter(new FilterComponent(filter, (1.0 / 20.0), 0.75));
        }
        const dt = ev.dataTransfer;
        if (dt.items) {
            // Use DataTransferItemList interface to access the file(s)
          for (let i = 0; i < dt.items.length; i++) {
            if (dt.items[i].kind === 'file') {
              const f = dt.items[i].getAsFile();
              console.log(`... file[${i}].name = ${f.name}`);
              if (f.name.endsWith('.jpg') || f.name.endsWith('.jpeg') || f.name.endsWith('.png')) {
                PassKameraLib.addImageFileElement(f);
              } else {
                PassKameraLib.addVideoFileElement(f);
              }
            }
          }
        } else {
            // Use DataTransfer interface to access the file(s)
          for (let i = 0; i < dt.files.length; i++) {
            console.log(`... file[${i}].name = ${dt.files[i].name}`);
            PassKameraLib.addVideoFileElement(dt.files[i]);
          }
        }
      };

      canvas.dragend = function dragend(ev) {
        ev.preventDefault();
        const dt = ev.dataTransfer;
        if (dt.items) {
          // Use DataTransferItemList interface to remove the drag data
          for (let i = 0; i < dt.items.length; i++) {
            dt.items.remove(i);
          }
        } else {
          // Use DataTransfer interface to remove the drag data
          ev.dataTransfer.clearData();
        }
      };
/*
      document.body.addEventListener('touchstart', (e) => { // eslint-disable-line no-undef
        if (e.target === canvas) {
          e.preventDefault();
        }
      }, false);
      document.body.addEventListener('touchend', (e) => { // eslint-disable-line no-undef
        if (e.target === canvas) {
          e.preventDefault();
        }
      }, false);
      document.body.addEventListener('touchmove', (e) => { // eslint-disable-line no-undef
        if (e.target === canvas) {
          e.preventDefault();
        }
      }, false);
      document.body.addEventListener('touchcancel', (e) => { // eslint-disable-line no-undef
        if (e.target === canvas) {
          e.preventDefault();
        }
      }, false);
      */

      canvas.addEventListener('touchstart', DesignLib.touchDown, false);
      canvas.addEventListener('touchend', DesignLib.touchUp, false);
      canvas.addEventListener('touchcancel', DesignLib.touchUp, false);
      canvas.addEventListener('touchmove', DesignLib.touchMove, false);
    };

    DesignLib.updateFilterList = function updateFilterList() {
      const oldfun = multipassfilterlist.onchange;
      multipassfilterlist.onchange = function empty() {

      };
      if (storageAvailable('localStorage')) {
        if (localStorage.filterlist && localStorage.filterList !== '') {
          const filterListJSON = localStorage.filterlist;
          const tempFilterList = JSON.parse(filterListJSON);
          while (multipassfilterlist.firstChild) {
            multipassfilterlist.removeChild(multipassfilterlist.firstChild);
          }
          for (let i = 0; i < tempFilterList.length; i++) {
            const filterName = tempFilterList[i];
            const option = document.createElement('option');// eslint-disable-line no-undef
            option.text = filterName;
            option.value = filterName;
            multipassfilterlist.appendChild(option);
          }
        } else {
          const filters = FiltersDBLib.filters;
          const filterslist = JSON.parse(filters);
          const tempfilterslist = [];
          for (let i = 0; i < filterslist.length; i++) {
            tempfilterslist.push(filterslist[i].name);
            localStorage[filterslist[i].name] = JSON.stringify(filterslist[i]);
          }
          const filtersliststring = JSON.stringify(tempfilterslist);
          localStorage.filterlist = filtersliststring;
          DesignLib.updateFilterList();
        }
      }
      multipassfilterlist.onchange = oldfun;
    };

    DesignLib.saveFilter = function saveButton() {
      const jsonta = DesignLib.getJSON();
      console.log(jsonta);
      if (storageAvailable('localStorage')) {
        try {
          localStorage.setItem(mName, jsonta); // eslint-disable-line no-undef
          let tempFilterList = [];
          if (localStorage.filterlist && localStorage.filterList !== '') {
            const filterListJSON = localStorage.filterlist;  // eslint-disable-line no-undef
            tempFilterList = JSON.parse(filterListJSON);
          }
          for (let i = 0; i < tempFilterList.length; i++) {
            if (tempFilterList[i] === mName) {
              multipassfilterlist.onchange();
              return;
            }
          }
          tempFilterList.push(mName);

          const jsonFilterList = JSON.stringify(tempFilterList);
          localStorage.setItem('filterlist', jsonFilterList);
        } catch (e) {
          console.log(e); // eslint-disable-line no-console
        }
      }
      DesignLib.updateFilterList();
    };

    DesignLib.exportFilters = function exportFilters() {
      const jsonta = DesignLib.getJSON();
      console.log(jsonta);
      if (storageAvailable('localStorage')) {
        let text = '';
        try {
          // localStorage.setItem(mName, jsonta); // eslint-disable-line no-undef
          let tempFilterList = [];
          if (localStorage.filterlist && localStorage.filterList !== '') {
            const filterListJSON = localStorage.filterlist;  // eslint-disable-line no-undef
            tempFilterList = JSON.parse(filterListJSON);
          }

          console.log('[\n');
          text += '[\n';
          for (let i = 0; i < tempFilterList.length; i++) {
            const filtername = tempFilterList[i];
            const filter = localStorage[filtername];
            console.log(filter);
            text += filter;
            if (i < tempFilterList.length - 1) {
              console.log('\n,\n');
              text += '\n,\n';
            }
          }
          text += ']\n';
          console.log[']\n'];
        } catch (e) {
          console.log(e); // eslint-disable-line no-console
        }
        const blob = new Blob([text], { type: 'text/plain;charset=utf-8' });
        const url = window.URL.createObjectURL(blob);
        const a = document.createElement('a');
        a.style.display = 'none';
        a.href = url;
        const filename = 'filters.json';
        a.download = filename;
        document.body.appendChild(a);
        a.click();
        setTimeout(() => {
          document.body.removeChild(a);
          window.URL.revokeObjectURL(url);
        }, 100);
      }
    };

    DesignLib.getWidth = function getWidth() {
      return canvas.width;
    };

    DesignLib.getHeight = function getHeight() {
      return canvas.height;
    };

    DesignLib.newFilter = function newfilter(name) {
      DesignLib.setName(name);
      DesignLib.addFilter(new FilterComponent(new VideoFiltersLib.CameraFilter(), (1.0 / 20.0), 0.5));
      DesignLib.addFilter(new FilterComponent(new VideoFiltersLib.DisplayFilter(), 1.0 - (1.0 / 20), 0.5));
    };

    DesignLib.addFilter = function addFilter(fc) {
      fc.setView(DesignLib);
      filters.push(fc);
      DesignLib.draw();
          // invalidate();
    };

    DesignLib.multiPassFilterChanged = function multiPassFilterChanged() {
      const filter = FilterLib.currentMultiPassFilter;
      DesignLib.setName(filter.getName());
      const filterstoadd = [];
      const pos = filter.getPositions();
      const subfilters = filter.getFilters();
      const connectivityMap = filter.getConnectivityMap();
      for (let i = 0; i < filter.getFilters().length; i++) {
        filterstoadd.push(new FilterComponent(subfilters[i], pos[i * 2], pos[i * 2 + 1]));
      }
      for (let i = 0; i < filter.getFilters().length; i++) {
        for (let j = 0; j < connectivityMap[i].length; j++) {
          if (connectivityMap[i][j] >= 0 && ((connectivityMap[i][j] < i) ||
                        (filterstoadd[connectivityMap[i][j]].getFilter().getName() === 'Buffer'))) {
            filterstoadd[connectivityMap[i][j]].plugOutput(filterstoadd[i], j);
            filterstoadd[i].plugInput(filterstoadd[connectivityMap[i][j]], j);
          }
        }
      }
      filters = [];
      for (let i = 0; i < filter.getFilters().length; i++) {
        DesignLib.addFilter(filterstoadd[i]);
      }
    };

    function addFiltersRecursively(filt, current) {
      if (filt.findIndex(currentValue => currentValue === current) === -1) {
        filt.push(current);
      } else {
        return true;
      }

      for (let i = 0; i < current.getInputCount(); i++) {
        const next = current.getInput(i);

        if (current.getInputType(i) === FilterLib.ConnectionType.Scalar &&
                        current.getInput(i) == null) {
                    // do nothing scalar input is default;
        } else if (current.getInputType(i) === FilterLib.ConnectionType.Texture3D &&
                        current.getInput(i) == null) {
                    // do nothing texture3d input is default;
        } else if (next == null) {
          return false;
        } else if (!addFiltersRecursively(filt, next)) { return false; }
      }
      for (let i = 0; i < current.getInputCount(); i++) {
        const next = current.getInput(i);

        if (current.getInputType(i) === FilterLib.ConnectionType.Scalar &&
                    current.getInput(i) == null) {
                // do nothing scalar input is default;
        } else if (current.getInputType(i) === FilterLib.ConnectionType.Texture3D &&
                    current.getInput(i) == null) {

        } else if (next === null) {
          return false;
        } else if (next.getFilter().getName() === 'Buffer') {
                // do not move filter in front
        } else if (filt.findIndex(currentValue => currentValue === next) !== -1) {
          const ni = filt.findIndex(currentValue => currentValue === next);
          const ci = filt.findIndex(currentValue => currentValue === current);
          if (ni < ci) {
            filt.splice(ci, 1);
            filt.splice(ni, 0, current);
          }
        }
      }

      return true;
    }


    function sortFilters() {
      const filt = [];
      let displayindex = -1;
      for (let i = 0; i < filters.length; i++) {
        const fc = filters[i];
        if (fc.getFilter().getName() === 'Display' || fc.getFilter().getName() === 'VRDisplay') {
          if (displayindex === -1) {
            displayindex = i;
          } else {
            return false;
          }
        }
      }
      if (displayindex === -1) {
        return false;
      }
      const start = filters[displayindex];
      const ok = addFiltersRecursively(filt, start);
      if (!ok) {
        return false;
      }
      filt.reverse();

      for (let i = 0; i < filt.length; i++) {
        const f = filt[i];
        f.setIndex(i);
      }
      filters = filt;
      return true;
    }

    function isValid() {
        // sortFilters();
      return true;
    }

    function getVersion() {
      return 0;
    }

    function getSubVersion() {
      return 0;
    }

    DesignLib.openFilterSettings = function openFilterSettings(filter) {
      console.log('show pop up');
      overlayname.innerHTML = filter.getName();
      while (overlaysection.firstChild) {
        overlaysection.removeChild(overlaysection.firstChild);
      }
      if (filter.getName() === 'Number') {
        const input = document.createElement('input');
        input.type = 'number';
        input.min = 0;
        input.max = 1000;
        input.step = 0.005;
        input.value = filter.getScalar(0);
        input.onchange = function onchangeValue() {
          filter.setScalar(0, input.value);
        };
        overlaysection.appendChild(input);
      } else {
        for (let i = 0; i < filter.getScalarInputCount(); i++) {
          const input = document.createElement('input');
          const index = i;
          input.type = 'range';
          input.min = 0.0;
          input.max = 1.0;
          input.step = 0.001;
          input.value = filter.getScalar(index);
          console.log(`value ${filter.getScalar(i)}`);
          input.onchange = function onchangeValue() {
            filter.setScalar(index, input.value);
          };
          overlaysection.appendChild(input);
        }
      }
      if (filter.isCameraFilter()) {
        const input = document.createElement('input');
        input.type = 'number';
        input.min = 0;
        input.max = 5;
        input.value = filter.getCameraIndex();
        input.onchange = function onchangeValue() {
          filter.setCameraIndex(input.value);
        };

        overlaysection.appendChild(input);
      }

      if (filter.isVideoSourceFilter()) {
        const input = document.createElement('input');
        input.type = 'number';
        input.min = 0;
        input.max = 5;
        input.value = filter.getVideoIndex();
        input.onchange = function onchangeValue() {
          filter.setVideoIndex(input.value);
          // DesignLib.saveFilter();
          // filterlist.onchange();
        };
        overlaysection.appendChild(input);
      }
      overlayon();
    };

    DesignLib.dropVideo = function dropVideo(ev) {
      console.log('Drop');
      ev.preventDefault();
        // If dropped items aren't files, reject them
      const dt = ev.dataTransfer;
      if (dt.items) {
          // Use DataTransferItemList interface to access the file(s)
        for (var i = 0; i < dt.items.length; i++) {
          if (dt.items[i].kind == 'file') {
            const f = dt.items[i].getAsFile();
            console.log(`... file[${i}].name = ${f.name}`);
            PassKameraLib.addVideoFileElement(f);
          }
        }
      } else {
          // Use DataTransfer interface to access the file(s)
        for (var i = 0; i < dt.files.length; i++) {
          console.log(`... file[${i}].name = ${dt.files[i].name}`);
          PassKameraLib.addVideoFileElement(dt.files[i]);
        }
      }
    };

    DesignLib.dragoverVideo = function dragoverVideo(ev) {
      console.log('dragOver');
        // Prevent default select and drag behavior
      ev.preventDefault();
    };

    DesignLib.dragendVideo = function dragendVideo(ev) {
      console.log('dragEnd');
      // Remove all of the drag data
      const dt = ev.dataTransfer;
      if (dt.items) {
        // Use DataTransferItemList interface to remove the drag data
        for (let i = 0; i < dt.items.length; i++) {
          dt.items.remove(i);
        }
      } else {
        // Use DataTransfer interface to remove the drag data
        ev.dataTransfer.clearData();
      }
    };

    DesignLib.getJSON = function getJSON() {
      let builder = '';
      if (!sortFilters()) {
        return null;
      }

      builder = builder.concat('{ "name":').concat('"').concat(mName).concat('", "version":')
        .concat(getVersion())
        .concat(' , "subversion":')
        .concat(getSubVersion())
        .concat(' ,')
        .concat('"subfilters":[\n');
      for (let i = 0; i < filters.length; i++) {
        builder = builder.concat('{');
        const f = filters[i];
        builder = builder.concat('"name":')
            .concat('"').concat(
            f.getFilter().getName()).concat('", ')
            .concat('"inputs":[');
        for (let j = 0; j < f.getInputCount(); j++) {
          if (f.getInput(j) == null) {
            builder = builder.concat('-1');
          } else {
            builder = builder.concat(f.getInput(j).getIndex());
          }
          if (j !== f.getInputCount() - 1) {
            builder = builder.concat(',');
          }
        }
        if (f.getInputCount() === 0) {
          builder = builder.concat('-1');
        }
        builder = builder.concat('] ');
        builder = builder.concat(', ')
            .concat('"x":').concat(f.getX()).concat(', ');
        builder = builder.concat('"y":').concat(f.getY()).concat(' ');
        if (f.getFilter().getScalarInputCount() > 0) {
          builder = builder.concat(', "scalars":').concat('[');
          for (let j = 0; j < f.getFilter().getScalarInputCount(); j++) {
            if (f.getInput(j + f.getFilter().getConnectivityOffset(FilterLib.ConnectionType.Scalar)) === null) {
              builder = builder.concat(f.getFilter().mScalars[j]);
            } else {
              builder = builder.concat(0.5);
            }
            if (f.getFilter().getScalarInputCount() - 1 !== j) {
              builder = builder.concat(',');
            }
          }
          builder = builder.concat('] ');
        }
        if (f.getFilter().isCameraFilter()) {
          builder = builder.concat(', "cameraIndex":');
          builder = builder.concat(f.getFilter().getCameraIndex());
        }
        if (f.getFilter().isVideoSourceFilter()) {
          builder = builder.concat(', "videoIndex":');
          builder = builder.concat(f.getFilter().getVideoIndex());
        }
        builder = builder.concat('} ');
        if (i !== filters.length - 1) {
          builder = builder.concat(',\n');
        }
      }
      builder = builder.concat('\n]}');
      return builder;
    };
    return DesignLib;
  }
  if (typeof (DesignLib) === 'undefined') window.DesignLib = defineLibrary(); // eslint-disable-line no-param-reassign, no-undef
  else console.log('Library already defined.'); // eslint-disable-line no-console
}(window)); // eslint-disable-line no-undef
