/* eslint-disable require-jsdoc*/
(function libraryWrapper(window) {
  function defineLibrary() {
    const FilterLib = {};

    const ConnectionType = {
      Video: 1,
      Scalar: 2,
      Texture2D: 3,
      Texture3D: 4,
      Color: 5,
      ColorArray: 6,
      Boolean: 7,
      Integer: 8,
      String: 9,
      ScalarArray: 10


    };

    FilterLib.ConnectionType = ConnectionType;

    FilterLib.Filter = class Filter {

      constructor(name, inputCount, outputCount, outputType,
        scalarInputs, texture3dInputs, colorListInputs, colorInputs,
        texture2dinputs) {
        this.mName = name;
        this.mInputCount = inputCount === undefined ? 0 : inputCount;
        this.mOutputCount = outputCount === undefined ? 0 : outputCount;
        this.mOutputType = outputType;
        this.mColorlistOutput = [1, 1, 1, 1];

        this.mColorOutput = [1, 1, 1, 1];
        this.mScalarCount = scalarInputs === undefined ? 0 : scalarInputs;
        if (scalarInputs > 0) {
          this.mScalars = [];
          for (let i = 0; i < this.mScalarCount; i++) { this.mScalars.push(0.5); }
        } else {
          this.mScalars = [];
          this.mScalars.push(0.0);
        }
        this.mTexture3dCount = texture3dInputs === undefined ? 0 : texture3dInputs;
        if (texture3dInputs > 0) {
          this.mTexture3d = [];
          for (let i = 0; i < this.mTexture3dCount; i++) { this.mTexture3d.push(-1); }
        } else {
          this.mTexture3d = [];
          this.mTexture3d.push(-1);
        }
        this.mColorListCount = colorListInputs === undefined ? 0 : colorListInputs;
        if (colorListInputs > 0) {
          this.mColorLists = [];
          for (let i = 0; i < this.mColorListCount; i++) {
            this.mColorLists.push([]);
            this.mColorLists[i].push(1.0);
            this.mColorLists[i].push(1.0);
            this.mColorLists[i].push(1.0);
            this.mColorLists[i].push(1.0);
          }
        } else {
          this.mColorLists = [];
          this.mColorLists.push(null);
        }
        this.mColorCount = colorInputs === undefined ? 0 : colorInputs;
        if (colorListInputs > 0) {
          this.mColors = [];
          for (let i = 0; i < this.mColorCount; i++) {
            this.mColors.push([]);
            this.mColors[i].push(1.0);
            this.mColors[i].push(1.0);
            this.mColors[i].push(1.0);
            this.mColors[i].push(1.0);
          }
        } else {
          this.mColors = [];
          this.mColors.push(null);
        }
        this.mTexture2dCount = texture2dinputs === undefined ? 0 : texture2dinputs;
        if (this.texture2dinputs > 0) {
          this.mTexture2d = [];
          for (let i = 0; i < this.mTexture2dCount; i++) {
            this.mTexture2d.push(-1);
          }
        } else {
          this.mTexture2d = [];
          this.mTexture2d.push(-1);
        }

        this.mIsMicrophoneFilter = false;
        this.mIsOnOffFilter = false;
        this.mIsColorCountFilter = false;
        this.mIsColorsFilter = false;
        this.mIsTriggerFilter = false;
        this.mIsRangesFilter = false;
        this.mIsTimeFilter = false;
        this.mIsSizeFilter = false;
        this.mIsStartFilter = false;
        this.mIsOrientationFilter = false;
        this.mIsCalculateFilter = false;
        this.mIsSpecialRenderer = false;
        this.mIsFaceCaptureFilter = false;
        this.mIsCameraFilter = false;
        this.mIsVideoSourceFilter = false;
        this.mIsSetUniformsFilter = false;
      }

      doNothing() { // eslint-disable-line
        return null;
      }

      isMicrophoneFilter() {
        return this.mIsMicrophoneFilter;
      }

      getOutputType() {
        return this.mOutputType;
      }

      getName() {
        return this.mName;
      }

      getFragSourceFile() {
        return this.mFragSourceFile;
      }

      getVertSourceFile() {
        return this.mVertSourceFile;
      }

      getFragSourceFile2() {
        return this.mFragSourceFile;
      }

      getVertSourceFile2() {
        return this.mVertSourceFile;
      }

      getInputCount() {
        return this.mInputCount;
      }

      getOutputCount() {
        return this.mOutputCount;
      }

      isOnOffFilter() {
        return this.mIsOnOffFilter;
      }

      isColorCountFilter() {
        return this.mIsColorCountFilter;
      }


      isColorsFilter() {
        return this.mIsColorsFilter;
      }

      setColors(i, colors) {
        this.doNothing(colors, i);
      }

      isTriggerFilter() {
        return this.mIsTriggerFilter;
      }

      triggerFilter(trigger) {
        this.doNothing(trigger);
      }

      isRangesFilter() {
        return this.mIsRangesFilter;
      }

      isTimeFilter() {
        return this.mIsTimeFilter;
      }

      getScalarInputCount() {
        return this.mScalarCount;
      }

      setScalar(i, scalar) {
        this.mScalars[i] = scalar;
      }

      getScalar(i) {
        return this.mScalars[i];
      }

      getScalarOutput() {
        return this.mScalarOutput;
      }

      getColorListInputCount() {
        return this.mColorListCount;
      }

      setColorList(i, colorList) {
        this.mColorLists[i] = colorList;
      }

      getColorList(i) {
        return this.mColorLists[i];
      }

      getColorListOutput() {
        return this.mColorlistOutput;
      }

      isSizeFilter() {
        return this.mIsSizeFilter;
      }

      setSize(width, height) {
        this.mWidth = width;
        this.mHeight = height;
      }

      getColorInputCount() {
        return this.mColorCount;
      }

      setColor(i, colorList) {
        this.mColors[i] = colorList;
      }

      getColor(i) {
        return this.mColors[i];
      }

      getColorOutput() {
        return this.mColorOutput;
      }

      updateTexture(renderer) {
        this.doNothing(renderer);
      }

      isStartFilter() {
        return this.mIsStartFilter;
      }

      startFilter(renderer) {
        this.doNothing(renderer);
      }

      isOrientationFilter() {
        return this.mIsOrientationFilter;
      }

      setOrientation(orientation) {
        this.mOrientation = orientation;
      }

      isTexture3dFilter() {
        return this.mTexture3dCount;
      }

      setTexture3d(i, texture3d) {
        this.mTexture3d[i] = texture3d;
      }

      getTexture3d(i) {
        return this.mTexture3d[i];
      }

      getTexture3dInputCount() {
        return this.mTexture3dCount;
      }

      getTexture3dOutput() {
        return this.mTexture3dOutput;
      }

      isTexture2dFilter() {
        return this.mTexture2dCount;
      }

      setTexture2d(i, texture3d) {
        this.mTexture2d[i] = texture3d;
      }

      getTexture2d(i) {
        return this.mTexture2d[i];
      }

      getTexture2dInputCount() {
        return this.mTexture2dCount;
      }

      getTexture2dOutput() {
        return this.mTexture2dOutput;
      }

      setTime(time) {
        this.mTime = time;
      }


      isCalculateFilter() {
        return this.mIsCalculateFilter;
      }

      calculate() {
        this.doNothing();
      }

      setOutputTexture(tex) {
        this.mTex = tex;
      }

      getOutputTexture() {
        return this.mTex;
      }

      isSpecialRenderer() {
        return this.mIsSpecialRenderer;
      }

      isFaceCaptureFilter() {
        return this.mIsFaceCaptureFilter;
      }

      isCameraFilter() {
        return this.mIsCameraFilter;
      }

      isVideoSourceFilter() {
        return this.mIsVideoSourceFilter;
      }

      getCaptureCallback() {
        return this.doNothing();
      }

      render(renderer) {
        this.doNothing(renderer);
      }

      setExtraTextures(renderer) {
        this.doNothing(renderer);
      }

      isSetUniformsFilter() {
        return this.mIsSetUniformsFilter;
      }

      setUniforms() {
        this.doNothing();
      }

      getConnectivityOffset(type) {
        switch (type) {
          case ConnectionType.Video:
            return 0;
          case ConnectionType.Scalar:
            return this.getInputCount();
          case ConnectionType.Texture3D:
            return this.getInputCount() + this.getScalarInputCount();
          case ConnectionType.ColorArray:
            return this.getInputCount() + this.getScalarInputCount() +
            this.getTexture3dInputCount();
          case ConnectionType.Color:
            return this.getInputCount()
            + this.getScalarInputCount()
            + this.getTexture3dInputCount()
            + this.getColorListInputCount();
          case ConnectionType.Texture2D:
            return this.getInputCount()
            + this.getScalarInputCount()
            + this.getTexture3dInputCount()
            + this.getColorListInputCount()
            + this.getTexture2dInputCount();
          default:
            return 0;
        }
      }

      getTotalInputCount() {
        return this.getInputCount()
          + this.getScalarInputCount()
          + this.getTexture3dInputCount()
          + this.getColorListInputCount()
          + this.getColorInputCount()
          + this.getTexture2dInputCount();
      }
      };


    class MultiPassFilter extends FilterLib.Filter {

      constructor(name, JSONfilters) {
        super(name, 1, 1);
        this.mFilters = [];
        this.mConnectivityMap = [];
        this.positions = [];
        this.mFilterJSON = '';

        this.mVersion = 0;
        this.mSubVersion = 0;
        this.mFilterJSON = JSONfilters;
        this.parseFilter(JSONfilters);
      }

      getFilterJSON() {
        return this.mFilterJSON;
      }

      static createMultiPassFilter(JSONfilters) {
        return new MultiPassFilter('MultiPass', JSONfilters);
      }

      getFilters() {
        return this.mFilters;
      }

      getConnectivityMap() {
        return this.mConnectivityMap;
      }

      getPositions() {
        return this.positions;
      }

      getVersion() {
        return this.mVersion;
      }

      getSubVersion() {
        return this.mSubVersion;
      }

      parseFilter(filter) {
        // try {
        console.log(filter); // eslint-disable-line no-console
        const fil = JSON.parse(filter);
        this.mName = fil.name;
        if (fil.version !== undefined) {
          this.mVersion = fil.version;
          this.mSubVersion = fil.subversion;
        }
        const f = fil.subfilters;
        this.mFilters = [];
        this.mConnectivityMap = [];
        this.positions = [];
        for (let i = 0; i < f.length; i++) {
          const fi = f[i];
          const name = fi.name;
          this.mFilters.push(MultiPassFilter.CreateFilter(name));
          const inputs = fi.inputs;
          const inputcount = Math.max(1, this.mFilters[i].getTotalInputCount());
          this.mConnectivityMap.push([]);
          for (let j = 0; j < inputcount; j++) {
            this.mConnectivityMap[i].push(-1);
          }
          if (inputs.length > 0) {
            for (let j = 0; j < inputs.length; j++) {
              this.mConnectivityMap[i][j] = inputs[j];
            }
          }

          const x = fi.x;
          const y = fi.y;

          if (fi.scalars !== undefined) {
            const scalars = fi.scalars;
            for (let j = 0; j < scalars.length; j++) {
              this.mFilters[i].setScalar(j, scalars[j]);
            }
          }
          if (fi.scalar !== undefined) {
            const scalar = fi.scalar;
            this.mFilters[i].setScalar(0, scalar);
          }
          if (this.mFilters[i].isCameraFilter()) {
            const cameraIndex = 0;
            this.mFilters[i].setCameraIndex(cameraIndex);
            if (fi.cameraIndex) {
              const cameraIndex2 = fi.cameraIndex;
              this.mFilters[i].setCameraIndex(cameraIndex2);
            }
          }
          if (this.mFilters[i].isVideoSourceFilter()) {
            const videoIndex = 0;
            this.mFilters[i].setVideoIndex(videoIndex);
            if (fi.videoIndex) {
              const videoIndex2 = fi.videoIndex;
              this.mFilters[i].setVideoIndex(videoIndex2);
            }
          }
          this.positions[i * 2] = x;
          this.positions[(i * 2) + 1] = y;
        }
      }

      static CreateFilter(name) {
        return new FiltersMapLib.filterMap[name](); // eslint-disable-line no-undef
      }
    }

    FilterLib.MultiPassFilter = MultiPassFilter;

    FilterLib.currentMultiPassFilter = null;

    FilterLib.currentMultiPassFilterChanged = null;

    FilterLib.loadMultiPassFilter = function loadMultiPassFilter(filterJSON) {
      const filter = FilterLib.MultiPassFilter.createMultiPassFilter(filterJSON);
      FilterLib.currentMultiPassFilter = filter;
      FilterLib.currentMultiPassFilterChanged();
    };

    return FilterLib;
  }
  if (typeof (FilterLib) === 'undefined') window.FilterLib = defineLibrary(); // eslint-disable-line no-param-reassign, no-undef
  else console.log('Library already defined.'); // eslint-disable-line no-console
}(window)); // eslint-disable-line no-undef
