
/* eslint no-loop-func: "error"*/
/* eslint-env es6*/
/* eslint-disable require-jsdoc*/
(function libraryWrapper(window) {
  function defineLibrary() {
    const PassKameraLib = {};
    let canvas = null;
    // const timeoutId = null;
    // let context;
    const deviceIds = [];
    // const currentIndex = 0;
    let videos = [];
    const vconsts = [];
    let gl;
    let vrDisplay;
    let btn;
    let normalSceneFrame;
    let vrSceneFrame;
    let vrOn = false;
    /*
    let program;
    let texture0;
    let texture1;
    */
    // let mMultiPassFilter = null;
    let mFilters = [];
    let mConnectivityMap = [];
    let mFrameBuffers = [];
    let mTextures = [];
    let mVideoSources = [];
    let mVideoTextureUnits = [];
    let usedTextures;
    let mPrograms = [];
    let vbuffer = null;
    let ibuffer = null;
    let tbuffer = null;
    let width = 800;
    let height = 600;
    let texturecounter = 0;

    let TextureUnits = [];

    let mOn = 1;

    let takeshotwhenready = false;

    // let poll;

    const mediaSource = new MediaSource();
    mediaSource.addEventListener('sourceopen', handleSourceOpen, false);
    let mediaRecorder;
    let recordedBlobs;
    let sourceBuffer;
    let stream;
    let recordButton;
    let downloadButton;
    let playButton;
    let xcounter = 0;
    const recordedVideos = [];

    let currentTime = 0;
    let startTime = 0;

    let mGlobalTrigger = true;

    let localVideo;
    let localCanvas;

    function errorMsg(msg, error) {
      if (typeof error !== 'undefined') {
        console.error(error);   // eslint-disable-line no-console
      }
    }

    function updateTexture(gl, video, texture) {
      const v = video;
      const level = 0;
      const internalFormat = gl.RGBA;
      const srcFormat = gl.RGBA;
      const srcType = gl.UNSIGNED_BYTE;
      gl.bindTexture(gl.TEXTURE_2D, texture);
      gl.texImage2D(gl.TEXTURE_2D, level, internalFormat,
        srcFormat, srcType, v);
      gl.bindTexture(gl.TEXTURE_2D, null);
    }

    function handleError(error) {
      if (error.name === 'ConstraintNotSatisfiedError') {
        // errorMsg(`The resolution ${constraints.video.width.exact}x${
        // constraints.video.width.exact} px is not supported by your device.`);
        errorMsg('The resolution is not suppported');
      } else if (error.name === 'PermissionDeniedError') {
        errorMsg('Permissions have not been granted to use your camera and ' +
      'microphone, you need to allow the page access to your devices in ' +
      'order for the demo to work.');
      }
      errorMsg(`getUserMedia error: ${error.name}`, error);
    }

    function openDevice(stream) {
      const s = stream;
      const videoTracks = stream.getVideoTracks();
      console.log('Got stream with constraints:', vconsts[xcounter]); // eslint-disable-line no-console
      console.log(`Using video device: ${videoTracks[0].label}`); // eslint-disable-line no-console
      s.oninactive = function streamactivate() {
        console.log('Stream inactive'); // eslint-disable-line no-console
      };
      // window.streams.push(stream); // make variable available to browser console
      console.log(`here s ${xcounter}`); // eslint-disable-line no-console
      videos[xcounter].srcObject = stream;
      videos[xcounter].play();
      videos[xcounter].onload = function () {
          //
      };
      xcounter += 1;
      if (xcounter < vconsts.length) {
        PassKameraLib.chainOpen();
      }
    }
    PassKameraLib.screenshot = function screenshot() {
      takeshotwhenready = true;
    };
    PassKameraLib.chainOpen = function chainOpen() {
      // for(let i =0; i < vconsts.length; i++)
      console.log(`CHAIN open ${xcounter}`);
      navigator.mediaDevices.getUserMedia(vconsts[xcounter]) // eslint-disable-line no-undef
    .then(openDevice).catch(handleError);
    };

    function gotDevices(deviceInfos) {
      for (let i = 0; i !== deviceInfos.length; ++i) {
        const deviceInfo = deviceInfos[i];
        // const option = document.createElement('option');
        const id = deviceInfo.deviceId;
        if (deviceInfo.kind === 'audioinput') {
          // var text = deviceInfo.label ||
          // `microphone ${audioInputSelect.length + 1}`;
          // audioInputSelect.appendChild(option);
        } else if (deviceInfo.kind === 'audiooutput') {
          // var text = deviceInfo.label || `speaker ${
          // audioOutputSelect.length + 1}`;
          // audioOutputSelect.appendChild(option);
        } else if (deviceInfo.kind === 'videoinput') {
          const text = deviceInfo.label;
          deviceIds.push(deviceInfo.deviceId);
          // videoSelect.appendChild(option);
          console.log(`Camera ${text} id ${id}`); // eslint-disable-line no-console
        } else {
          console.log('Some other kind of source/device: ', deviceInfo); // eslint-disable-line no-console
        }
      }

      videos = [];
      for (let i = 0; i < deviceIds.length; i++) {
        const x = i;
        vconsts.push({ audio: null, video: { deviceId: deviceIds[x] } });
        const v = document.createElement('video'); // eslint-disable-line no-undef
        v.setAttribute('width', width);
        v.setAttribute('height', height);
        videos.push(v);
      }
      xcounter = 0;
      PassKameraLib.chainOpen();
    }

    function getNextTextureUnit() {
      const nu = texturecounter;
      const tu = TextureUnits[texturecounter];
      texturecounter += 1;
      console.log(`texturecounter is ${texturecounter}`);
      return ({ unit: tu, number: nu });
    }

    PassKameraLib.resize = function resize() {

      // const size = Math.min(window.innerHeight, window.innerWidth);
      // canvas.height = size;
      // canvas.width = size;
      // PassKameraLib.drawPulse();
    };

    function initGL(canvas) {
      gl = canvas.getContext('webgl2') || canvas.getContext('webgl') || canvas.getContext('experimental-webgl');
      TextureUnits = [
        gl.TEXTURE0,
        gl.TEXTURE1,
        gl.TEXTURE2,
        gl.TEXTURE3,
        gl.TEXTURE4,
        gl.TEXTURE5,
        gl.TEXTURE6,
        gl.TEXTURE7,
        gl.TEXTURE8,
        gl.TEXTURE9,
        gl.TEXTURE10,
        gl.TEXTURE11,
        gl.TEXTURE12,
        gl.TEXTURE13,
        gl.TEXTURE14,
        gl.TEXTURE15,
        gl.TEXTURE16,
        gl.TEXTURE17,
        gl.TEXTURE18,
        gl.TEXTURE19,
        gl.TEXTURE20,
        gl.TEXTURE21
      ];
      gl.viewport(0, 0, width, height);
    }

    function initCameraSources() {
      mVideoSources = [];
      mVideoTextureUnits = [];
      console.log('initCameraSources');
      for (let i = 0; i < deviceIds.length; i++) {
        console.log(`creating shit ${i}`);
        const videotexture = gl.createTexture();
        const videotextureunit = getNextTextureUnit();
        gl.bindTexture(gl.TEXTURE_2D, videotexture);
        const index = i;
        gl.texImage2D(gl.TEXTURE_2D, 0, gl.RGBA, gl.RGBA, gl.UNSIGNED_BYTE, videos[index]);
        gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_S, gl.CLAMP_TO_EDGE);
        gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_T, gl.CLAMP_TO_EDGE);
        gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MIN_FILTER, gl.LINEAR);
      // gl.generateMipmap(gl.TEXTURE_2D);
        gl.bindTexture(gl.TEXTURE_2D, null);
        mVideoSources.push(videotexture);
        mVideoTextureUnits.push(videotextureunit);
      }
    }

    function initVideoSources() {
      // mVideoSources = [];
      // mVideoTextureUnits = [];
      console.log('initVideoSources');
      for (let i = 0; i < videos.length; i++) {
        console.log(`creating somethin ${i}`);
        const videotexture = gl.createTexture();
        const videotextureunit = getNextTextureUnit();
        gl.bindTexture(gl.TEXTURE_2D, videotexture);
        const index = i;
        gl.texImage2D(gl.TEXTURE_2D, 0, gl.RGBA, gl.RGBA, gl.UNSIGNED_BYTE, videos[index]);
        gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_S, gl.CLAMP_TO_EDGE);
        gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_T, gl.CLAMP_TO_EDGE);
        gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MIN_FILTER, gl.LINEAR);
      // gl.generateMipmap(gl.TEXTURE_2D);
        gl.bindTexture(gl.TEXTURE_2D, null);
        mVideoSources.push(videotexture);
        mVideoTextureUnits.push(videotextureunit);
      }
    }

    function createFramebuffer(texture) {
      const framebuffer = gl.createFramebuffer();
      gl.bindFramebuffer(gl.FRAMEBUFFER, framebuffer);
      framebuffer.width = width;
      framebuffer.height = height;
      gl.bindTexture(gl.TEXTURE_2D, texture);
      gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_S, gl.CLAMP_TO_EDGE);
      gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_T, gl.CLAMP_TO_EDGE);
      gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MIN_FILTER, gl.LINEAR);
      gl.texImage2D(gl.TEXTURE_2D, 0, gl.RGBA, framebuffer.width,
        framebuffer.height, 0, gl.RGBA, gl.UNSIGNED_BYTE, null);
      const renderbuffer = gl.createRenderbuffer();
      gl.bindRenderbuffer(gl.RENDERBUFFER, renderbuffer);
      gl.renderbufferStorage(gl.RENDERBUFFER, gl.DEPTH_COMPONENT16,
          framebuffer.width, framebuffer.height);
      gl.framebufferTexture2D(gl.FRAMEBUFFER, gl.COLOR_ATTACHMENT0,
        gl.TEXTURE_2D, texture, 0);
      gl.framebufferRenderbuffer(gl.FRAMEBUFFER, gl.DEPTH_ATTACHMENT,
        gl.RENDERBUFFER, renderbuffer);
      gl.bindTexture(gl.TEXTURE_2D, null);
      gl.bindRenderbuffer(gl.RENDERBUFFER, null);
      gl.bindFramebuffer(gl.FRAMEBUFFER, null);
      mTextures.push(texture);
      mFrameBuffers.push(framebuffer);
    }

    function getNextRecycledTextureUnit(i) {
      // Log.e(TAG,"filter "+mFilters[i].getName()+" "+mFilterCount);

      console.log(`filter ${mFilters[i].getName()}`);
            // find free texture?
      let needsnewfilter = true;

      if (!(mFilters[i].getName() === 'Buffer') && !(mFilters[i].getName() === 'Display')
        && !(mFilters[i].getName() === 'VRDisplay') && !(mFilters[i].getName() === 'Camera')
        && !(mFilters[i].getName() === 'Sampler')) {
        // let videoindex = 0;
        for (let j = 0; j < i - 1; j++) {
          if (!(mFilters[j].getName() === 'Buffer')
                        && !(mFilters[j].getName() === 'Camera')
                      && !(mFilters[j].getName() === 'Video')
                      && !(mFilters[i].getName() === 'Sampler')
                    && mFilters[j].getOutputType() === FilterLib.ConnectionType.Video) {
            let foundfreefilter = true;


            for (let k = i + 1; k < mFilters.length; k++) {
              for (let n = 0; n < usedTextures[j].length; n++) {
                for (let m = 0; m < mFilters[usedTextures[j][n]].getInputCount(); m++) {
                  if (mConnectivityMap[usedTextures[j][n]][m] > j) {
                    console.log(`Sorry x ${mFilters[usedTextures[j][n]].getName()} is using texture`);
                    foundfreefilter = false;
                    break;
                  }
                }
              }

              for (let n = 0; n < mFilters[k].getInputCount(); n++) {
                if (mConnectivityMap[k][n] === j) {
                  console.log(`Sorry ${mFilters[k].getName()} is using filter`);
                  foundfreefilter = false;
                  break;
                }
              }
            }

            if (foundfreefilter) {
              let isinput = false;
              for (let n = 0; n < mFilters[i].getInputCount(); n++) {
                if (mFilters[mConnectivityMap[i][n]].getOutputTexture() ===
                                    mFilters[j].getOutputTexture()) {
                  console.log(`Sorry ${mFilters[i].getName()} is input filter for me`);
                  isinput = true;
                  break;
                }
              }

              if (!isinput && (mFilters[j].getOutputType() === FilterLib.ConnectionType.Video)) {
                console.log(`Found free filter at ${mFilters[j].getName()}`);
                usedTextures[j].push(i);
                // xxxx
                mTextures.push(mTextures[j]);
                mFrameBuffers.push(mFrameBuffers[j]);
                mFilters[i].setOutputTexture(mFilters[j].getOutputTexture());
                            // mFilters[i].getOutputTexture().uniformName += mFilters[i].getName();
                needsnewfilter = false;
                return;
              }
            }
            // videoindex += 1;
          }
        }
      }
      if (needsnewfilter && (mFilters[i].getOutputType() === FilterLib.ConnectionType.Video)) {
        const texture = gl.createTexture();
        const textureunit = getNextTextureUnit();
        createFramebuffer(texture);
        mFilters[i].setOutputTexture(textureunit);
      }
    }

    function startFilters(gl) {
      for (let i = 0; i < mFilters.length; i++) {
        const filter = mFilters[i];
        if (filter.isSizeFilter()) filter.setSize(width, height);
        if (filter.isStartFilter()) filter.startFilter(gl, mPrograms[i]);
      }
    }

    function initTextureFramebuffers() {
      mFrameBuffers = [];
      usedTextures = [];
      for (let i = 0; i < mFilters.length; i++) {
        usedTextures.push([]);
      }
      for (let i = 0; i < mFilters.length; i++) {
        // const filter = mFilters[i];


        // const texture = gl.createTexture();
        // const texture =
        if (mFilters[i].getOutputType() === FilterLib.ConnectionType.Video) {
          getNextRecycledTextureUnit(i);
        } else {
          mTextures.push(null);
          mFrameBuffers.push(null);
        }
        // const textureunit = getNextTextureUnit();
        // filter.setOutputTexture(textureunit);
      }
    }

    function initShaders() {
      mPrograms = [];
      for (let i = 0; i < mFilters.length; i++) {
        const filter = mFilters[i];
        if (filter.getOutputType() === FilterLib.ConnectionType.Video) {
          const program = ShaderLib.makeProgram(gl, filter.getVertSourceFile(),
          filter.getFragSourceFile());

          // camera texture
          if (mFilters[i].isCameraFilter()) {
            program.uTexture0 = gl.getUniformLocation(program, 'uTexture0');
          } else if (mFilters[i].isVideoSourceFilter()) {
            program.uTexture0 = gl.getUniformLocation(program, 'uTexture0');
          }
          for (let j = 0; j < filter.getInputCount(); j++) {
            program[`uTexture${j}`] = gl.getUniformLocation(program, `uTexture${j}`);
          }
          program.uOn = gl.getUniformLocation(program, 'uOn');
          program.position = gl.getAttribLocation(program, 'position');
          program.texCoordinate = gl.getAttribLocation(program, 'texCoordinate');
          if (filter.isSizeFilter()) {
            program.uSize = gl.getUniformLocation(program, 'uSize');
          }
          for (let j = 0; j < filter.getScalarInputCount(); j++) {
            program[`uSetScalar${j}`] = gl.getUniformLocation(program, `uSetScalar${j}`);
          }
          for (let j = 0; j < filter.getColorListInputCount(); j++) {
            program[`iColors${j}`] = gl.getUniformLocation(program, `iColors${j}`);
            program[`vColors${j}`] = gl.getUniformLocation(program, `vColors${j}`);
          }
          for (let j = 0; j < filter.getColorInputCount(); j++) {
            program[`vColor${j}`] = gl.getUniformLocation(program, `vColor${j}`);
          }
          if (filter.isTimeFilter()) {
            program.uTime = gl.getUniformLocation(program, 'uTime');
          }

          mPrograms.push(program);
        } else {
          mPrograms.push(null);
        }
      }
    }

    function initBuffers() {
      vbuffer = gl.createBuffer();

      gl.bindBuffer(gl.ARRAY_BUFFER, vbuffer);
      gl.bufferData(gl.ARRAY_BUFFER, new Float32Array([-1, -1, 1, -1, -1, 1, 1, 1
      ]), gl.STATIC_DRAW);

      tbuffer = gl.createBuffer();
      gl.bindBuffer(gl.ARRAY_BUFFER, tbuffer);
      gl.bufferData(gl.ARRAY_BUFFER, new Float32Array([0, 0, 1, 0, 0, 1, 1, 1
      ]), gl.STATIC_DRAW);

      ibuffer = gl.createBuffer();
      gl.bindBuffer(gl.ELEMENT_ARRAY_BUFFER, ibuffer);
      gl.bufferData(gl.ELEMENT_ARRAY_BUFFER, new Uint16Array([0, 1, 2, 1, 2, 3
      ]), gl.STATIC_DRAW);
    }

    function initTextures() {
      // no textures
    }
/*
    function triggerFilters() {
      for (let i = 0; i < mFilters.length; i++) {
        const filter = mFilters[i];
        if (filter.isTriggerFilter()) {
          filter.triggerFilter(true);
          filter.triggerFilter(false);
        }
      }
    }
*/
    function tick() {
      // gl.activeTexture(mVideoTextureUnits[0]);
      currentTime = ((new Date()).getTime() - startTime) / 1000.0;
      for (let i = 0; i < videos.length; i++) {
        const index = i;
        updateTexture(gl, videos[index], mVideoSources[index]);
      }
      for (let i = 0; i < mFilters.length; i++) {
        const filter = mFilters[i];
        if (filter.isTimeFilter()) {
          filter.setTime(currentTime);
        }

        // if (filter.getOutputType() === FilterLib.ConnectionType.Scalar) {
        for (let j = 0; j < filter.getScalarInputCount(); j++) {
          const index = mConnectivityMap[i][filter.getConnectivityOffset(FilterLib.ConnectionType.Scalar) + j];
          if (index === -1) {
          } else {
            filter.setScalar(j, mFilters[index].getScalarOutput());
          }
        }
        for (let j = 0; j < filter.getColorInputCount(); j++) {
          const index = mConnectivityMap[i][filter.getConnectivityOffset(FilterLib.ConnectionType.Color) + j];
          if (index === -1) {
          } else {
            filter.setColor(j, mFilters[index].getColorOutput());
          }
        }

        for (let j = 0; j < filter.getColorListInputCount(); j++) {
          const index = mConnectivityMap[i][filter.getConnectivityOffset(FilterLib.ConnectionType.ColorArry) + j];
          if (index === -1) {
          } else {
            filter.setColorList(j, mFilters[index].getColorListOutput());
          }
        }

        if (filter.isCalculateFilter()) {
          filter.calculate();
        }
        // }

        if (filter.getOutputType() === FilterLib.ConnectionType.Video &&
            (!((mFilters[i].getName() === 'Sampler') && !mGlobalTrigger))) {
          if (filter.getName() !== 'Display' && filter.getName() !== 'VRDisplay') {
          // console.log(`framebuffer${mFrameBuffers[i]}`);
            gl.viewport(0, 0, width, height);
            gl.bindFramebuffer(gl.FRAMEBUFFER, mFrameBuffers[i]);
          } else {
          // console.log(`framebuffer${null}`);
            gl.viewport(0, 0, canvas.width, canvas.height);
            gl.bindFramebuffer(gl.FRAMEBUFFER, null);
          }
          gl.useProgram(mPrograms[i]);
      // Set clear color to black, fully opaque
          gl.clearColor(0.8, 0.8, 0.8, 1.0);
      // Enable depth testing
          gl.enable(gl.DEPTH_TEST);
      // Near things obscure far things
          gl.depthFunc(gl.LEQUAL);
      // Clear the color as well as the depth buffer.
          gl.clear(gl.COLOR_BUFFER_BIT | gl.DEPTH_BUFFER_BIT); // eslint-disable-line no-bitwise

          if (filter.isCameraFilter()) {
          // console.log('i is 0');
            const index = Math.min(videos.length - 1, filter.getCameraIndex());
            const videoTextureUnit = mVideoTextureUnits[index];
            const unit = videoTextureUnit.unit;
            const number = videoTextureUnit.number;
            gl.activeTexture(unit);
            gl.bindTexture(gl.TEXTURE_2D, mVideoSources[index]);
            const texa = 'uTexture0';
            const t = mPrograms[i][texa];
          // console.log(`index is ${index} unit ${unit} nmumber ${number}`);
            gl.uniform1i(t, number);
          } else if (filter.isVideoSourceFilter()) {
            const index = Math.min(videos.length - 1, filter.getVideoIndex());
            const videoTextureUnit = mVideoTextureUnits[index];
            const unit = videoTextureUnit.unit;
            const number = videoTextureUnit.number;
            gl.activeTexture(unit);
            gl.bindTexture(gl.TEXTURE_2D, mVideoSources[index]);
            const texa = 'uTexture0';
            const t = mPrograms[i][texa];
          // console.log(`index is ${index} unit ${unit} nmumber ${number}`);
            gl.uniform1i(t, number);
          } else {
            for (let j = 0; j < filter.getInputCount(); j++) {
              const index = mConnectivityMap[i][j];
            // xxxx
              const texture = mFilters[index].getOutputTexture();
              const textureUnit = texture.unit;
              const textureNumber = texture.number;
              gl.activeTexture(textureUnit);
              const tex = mTextures[index];
              gl.bindTexture(gl.TEXTURE_2D, tex);
              const texa = `uTexture${j}`;
              gl.uniform1i(mPrograms[i][texa], textureNumber);
            }
          }
          if (filter.isOnOffFilter) {
            gl.uniform1i(mPrograms[i].uOn, mOn);
          }
          if (filter.isSizeFilter() && mPrograms[i].uSize !== undefined) {
            gl.uniform2fv(mPrograms[i].uSize, [width, height]);
          }

          if (filter.isTimeFilter()) {
            gl.uniform1f(mPrograms[i].uTime, currentTime);
          }

          for (let j = 0; j < filter.getScalarInputCount(); j++) {
            const index = mConnectivityMap[i][filter.getConnectivityOffset(FilterLib.ConnectionType.Scalar) + j];
            if (index === -1) {
              gl.uniform1f(mPrograms[i][`uSetScalar${j}`], filter.mScalars[j]);
            } else {
              gl.uniform1f(mPrograms[i][`uSetScalar${j}`], mFilters[index].getScalarOutput());
            }
          }

          for (let j = 0; j < filter.getColorListInputCount(); j++) {
            const index = mConnectivityMap[i][
              filter.getConnectivityOffset(FilterLib.ConnectionType.ColorArray) + j];
            if (index >= 0) {
              const colorCount = mFilters[index].getColorListOutput().length / 4;
              gl.uniform1i(mPrograms[i][`iColors${j}`], colorCount);
              gl.uniform4fv(mPrograms[i][`vColors${j}`], mFilters[index].getColorListOutput());
            }
          }

          for (let j = 0; j < filter.getColorInputCount(); j++) {
            const index = mConnectivityMap[i][
              filter.getConnectivityOffset(FilterLib.ConnectionType.Color) + j];
            if (index >= 0) {
              const colorCount = mFilters[index].getColorOutput().length / 4;
              gl.uniform4fv(mPrograms[i][`vColor${j}`], mFilters[index].getColorOutput());
            }
          }

          if (filter.isCalculateFilter()) {
            filter.calculate();
          }

          if (filter.isSetUniformsFilter()) {
            filter.setUniforms(gl.mPrograms[i]);
          }

          gl.bindBuffer(gl.ARRAY_BUFFER, vbuffer);
          gl.enableVertexAttribArray(mPrograms[i].position);
          gl.vertexAttribPointer(mPrograms[i].position, 2, gl.FLOAT, false, 0, 0);

          gl.bindBuffer(gl.ARRAY_BUFFER, tbuffer);
          gl.enableVertexAttribArray(mPrograms[i].texCoordinate);
          gl.vertexAttribPointer(mPrograms[i].texCoordinate, 2, gl.FLOAT, false, 0, 0);

          gl.bindBuffer(gl.ELEMENT_ARRAY_BUFFER, ibuffer);
          gl.drawElements(gl.TRIANGLES, 6, gl.UNSIGNED_SHORT, 0);
        }
        if (mGlobalTrigger) {
          if (filter.isSizeFilter()) {
            filter.setSize(width, height);
          }
          if (filter.isTriggerFilter()) {
            filter.triggerFilter(true, gl);
            filter.triggerFilter(false, gl);
          }
        }
        if (filter.isSpecialRenderer()) {
          filter.render(gl);
        }
      }

/*
      if (mGlobalTrigger) {
        const w = localVideo.width;
        const h = localVideo.height;

        //console.log(`xxx localvideo ${w} ${h}`);

        // canvas.width = w;
        // canvas.height = h;
        //const ctx = localVideo.getContext('2d');
        //ctx.drawImage(canvas, 0, 0, w, h);
      }
      */
      if (mGlobalTrigger) { mGlobalTrigger = false; } // else mGlobalTrigger = true;
      // tickTimeout = setTimeout(tick, 30);
    }

    function handleSourceOpen(event) {
      console.log('MediaSource opened');
      sourceBuffer = mediaSource.addSourceBuffer('video/webm; codecs="vp8"');
      console.log('Source buffer: ', sourceBuffer);
    }

    function handleDataAvailable(event) {
      if (event.data && event.data.size > 0) {
        recordedBlobs.push(event.data);
      }
    }

    function handleStop(event) {
      console.log('Recorder stopped: ', event);
      recordedVideos.push(recordedBlobs);
      addVideoElement(recordedBlobs);
    }

    function toggleRecording() {
      if (recordButton.textContent === 'record') {
        startRecording();
      } else {
        stopRecording();
        recordButton.textContent = 'record';
        playButton.disabled = false;
        downloadButton.disabled = false;
      }
    }

// The nested try blocks will be simplified when Chrome 47 moves to Stable
    function startRecording() {
      let options = { mimeType: 'video/webm' };
      recordedBlobs = [];
      try {
        mediaRecorder = new MediaRecorder(stream, options);
      } catch (e0) {
        console.log('Unable to create MediaRecorder with options Object: ', e0);
        try {
          options = { mimeType: 'video/webm,codecs=vp9' };
          mediaRecorder = new MediaRecorder(stream, options);
        } catch (e1) {
          console.log('Unable to create MediaRecorder with options Object: ', e1);
          try {
            options = 'video/vp8'; // Chrome 47
            mediaRecorder = new MediaRecorder(stream, options);
          } catch (e2) {
            alert('MediaRecorder is not supported by this browser.\n\n' +
            'Try Firefox 29 or later, or Chrome 47 or later, with Enable experimental Web Platform features enabled from chrome://flags.');
            console.error('Exception while creating MediaRecorder:', e2);
            return;
          }
        }
      }
      console.log('Created MediaRecorder', mediaRecorder, 'with options', options);
      recordButton.textContent = 'Stop Recording';
      playButton.disabled = true;
      downloadButton.disabled = true;
      mediaRecorder.onstop = handleStop;
      mediaRecorder.ondataavailable = handleDataAvailable;
      mediaRecorder.start(100); // collect 100ms of data
      console.log('MediaRecorder started', mediaRecorder);
    }

    function stopRecording() {
      mediaRecorder.stop();
      console.log('Recorded Blobs: ', recordedBlobs);

      // video.controls = true;
    }

    function play() {
      const superBuffer = new Blob(recordedBlobs, { type: 'video/webm' });
      // video.src = window.URL.createObjectURL(superBuffer);
    }

    function download() {
      const blob = new Blob(recordedBlobs, { type: 'video/webm' });
      const url = window.URL.createObjectURL(blob);
      const a = document.createElement('a');
      a.style.display = 'none';
      a.href = url;
      const filename = document.getElementById('filename');
      a.download = filename.value;
      document.body.appendChild(a);
      a.click();
      setTimeout(() => {
        document.body.removeChild(a);
        window.URL.revokeObjectURL(url);
      }, 100);
    }

    function createVideoElement(record) {
      const videoBuffer = new Blob(record, { type: 'video/webm' });
      console.log('initcreateVideoElement');

      const videotexture = gl.createTexture();
      const videotextureunit = getNextTextureUnit();
      gl.bindTexture(gl.TEXTURE_2D, videotexture);
      const index = videos.length;
      const video = document.createElement('video');
      video.src = window.URL.createObjectURL(videoBuffer);
      video.onload = function videoonload() {
        console.log('HELLO');
      };
      video.loop = 'loop';
      video.play();
      videos.push(video);

      gl.texImage2D(gl.TEXTURE_2D, 0, gl.RGBA, gl.RGBA, gl.UNSIGNED_BYTE, video);
      gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_S, gl.CLAMP_TO_EDGE);
      gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_T, gl.CLAMP_TO_EDGE);
      gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MIN_FILTER, gl.LINEAR);
      gl.bindTexture(gl.TEXTURE_2D, null);
      mVideoSources.push(videotexture);
      mVideoTextureUnits.push(videotextureunit);
      console.log('video element on load');
      return index;
    }

    function createVideoFromFile(file) {
      // const videoBuffer = new Blob(record, { type: 'video/webm' });
      console.log('creatvideofromFile');

      const videotexture = gl.createTexture();
      const videotextureunit = getNextTextureUnit();
      gl.bindTexture(gl.TEXTURE_2D, videotexture);
      const index = videos.length;
      const video = document.createElement('video');
      video.src = window.URL.createObjectURL(file);
      video.onload = function videoonload() {

      };
      video.loop = 'loop';
      video.play();
      videos.push(video);
      // document.getElementById('videoelements').appendChild(video);

      gl.texImage2D(gl.TEXTURE_2D, 0, gl.RGBA, gl.RGBA, gl.UNSIGNED_BYTE, video);
      gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_S, gl.CLAMP_TO_EDGE);
      gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_T, gl.CLAMP_TO_EDGE);
      gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MIN_FILTER, gl.LINEAR);
      gl.bindTexture(gl.TEXTURE_2D, null);
      mVideoSources.push(videotexture);
      mVideoTextureUnits.push(videotextureunit);
      console.log('video element on load');
      return index;
    }

    function createImageFromFile(file) {
      // const videoBuffer = new Blob(record, { type: 'video/webm' });
      console.log('createImagefromFile');

      const videotexture = gl.createTexture();
      const videotextureunit = getNextTextureUnit();
      gl.bindTexture(gl.TEXTURE_2D, videotexture);
      const index = videos.length;
      const v = document.createElement('img');
      const video = document.createElement('img');
      const c = document.createElement('canvas');
      c.width = width;
      c.height = height;
      const context = c.getContext('2d');

      v.onload = function vonload() {
        console.log(`video width ${v.width} ${v}`);
        const ratio = v.width / v.height;
        const cratio = c.width / c.height;
        const w = (ratio > cratio) ? c.width : (ratio * c.height);
        const h = (ratio > cratio) ? ((v.height / v.width) * c.width) : c.height;
        const ox = (c.width - w) / 2.0;
        const oy = (c.height - h) / 2.0;
        context.fillStyle = 'white';
        context.fillRect(0, 0, width, height);
        context.drawImage(v, 0, 0, v.width, v.height, ox, oy, w, h);

        video.src = c.toDataURL();
      };
      v.src = window.URL.createObjectURL(file);

      videos.push(video);
      // document.getElementById('videoelements').appendChild(video);

      gl.texImage2D(gl.TEXTURE_2D, 0, gl.RGBA, gl.RGBA, gl.UNSIGNED_BYTE, video);
      gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_S, gl.CLAMP_TO_EDGE);
      gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_T, gl.CLAMP_TO_EDGE);
      gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MIN_FILTER, gl.LINEAR);
      gl.bindTexture(gl.TEXTURE_2D, null);
      mVideoSources.push(videotexture);
      mVideoTextureUnits.push(videotextureunit);
      console.log('video element on load');
      return index;
    }

    PassKameraLib.createPreviewImage = function createPreviewImage(recordindex, callbackfun) {
      const c = document.createElement('canvas');
      c.width = 64;
      c.height = 48;
      const ctx = c.getContext('2d');
      const v = videos[recordindex];
      v.onseeked = function (e) {
        console.log(`video width ${v.width} ${v}`);
        ctx.drawImage(v, 0, 0, 640, 480, 0, 0, c.width, c.height);
        const url = c.toDataURL();
        callbackfun(url);
      };
      v.currentTime = 1;
      // return url;
    };

    PassKameraLib.createPreviewImageFromImg = function createPreviewImage(recordindex, callbackfun) {
      const c = document.createElement('canvas');
      c.width = 64;
      c.height = 48;
      const ctx = c.getContext('2d');
      const v = videos[recordindex];
      // v.onload = function (e) {
      console.log(`video width ${v.width} ${v}`);
      v.onload = function vonload() {
        const ratio = v.width / v.height;
        const cratio = c.width / c.height;
        const w = (ratio > cratio) ? c.width : (ratio * c.height);
        const h = (ratio > cratio) ? ((v.width / v.height) * c.width) : c.width;
        ctx.drawImage(v, 0, 0, v.width, v.height, 0, 0, w, h);
        const url = v.src;


        callbackfun(v.src);
      };
      // };
      // return url;
    };

    function globalTrigger() {
      mGlobalTrigger = true;
    }

    PassKameraLib.addVideoFileElement = function addVideoFileElement(file) {
      const recordindex = createVideoFromFile(file);
      const videoelements = document.getElementById('videoelements');
      const img = document.createElement('img');
      const fun = function callback(url) {
        img.src = url;
      };
      PassKameraLib.createPreviewImage(recordindex, fun);
      // img.src = imageData;
      img.draggable = 'true';
      img.ondragstart = function dragstart(event) {
        console.log('dragstart');
        event.dataTransfer.setData('record', recordindex);
      };
      videoelements.appendChild(img);
    };

    PassKameraLib.addImageFileElement = function addImageFileElement(file) {
      const recordindex = createImageFromFile(file);
      const videoelements = document.getElementById('videoelements');
      const img = document.createElement('img');
      const fun = function callback(url) {
        img.src = url;
      };
      PassKameraLib.createPreviewImageFromImg(recordindex, fun);
      // img.src = imageData;
      img.draggable = 'true';
      img.width = 64;
      img.height = 48;
      img.ondragstart = function dragstart(event) {
        console.log('dragstart');
        event.dataTransfer.setData('record', recordindex);
      };
      videoelements.appendChild(img);
    };

    function addVideoElement(record) {
      const recordindex = createVideoElement(record);
      const videoelements = document.getElementById('videoelements');
      const img = document.createElement('img');
      const fun = function callback(url) {
        img.src = url;
      };
      PassKameraLib.createPreviewImage(recordindex, fun);

      img.draggable = 'true';
      img.ondragstart = function dragstart(event) {
        console.log('dragstart');
        event.dataTransfer.setData('record', recordindex);
      };
      videoelements.appendChild(img);
    }

    function drawVRSceneFrame() {
      tick();
      vrSceneFrame = vrDisplay.requestAnimationFrame(drawVRSceneFrame);
      vrDisplay.submitFrame();
    }

    PassKameraLib.takeScreenshot = function takeScreenshot() {
      const url = canvas.toDataURL();
      const a = document.createElement('a');
      a.style.display = 'none';
      a.href = url;
      a.download = 'screenshot.png';
      document.body.appendChild(a);
      a.click();
      setTimeout(() => {
        document.body.removeChild(a);
        window.URL.revokeObjectURL(url);
      }, 100);
    };

    function drawNormalSceneFrame() {
      tick();
      if (takeshotwhenready) {
        PassKameraLib.takeScreenshot();
        takeshotwhenready = false;
      }
      normalSceneFrame = window // eslint-disable-line no-undef
        .requestAnimationFrame(drawNormalSceneFrame);
    }

    function initVR(canvas, runner, drawVRScene, gl) {
      const can = canvas;
      if (navigator.getVRDisplays && navigator.getGamepads) { // eslint-disable-line no-undef
        console.log('WebVR 1.1 supported'); // eslint-disable-line no-console
  // Then get the displays attached to the computer
        navigator.getVRDisplays().then((displays) => { // eslint-disable-line no-undef
    // If a display is available, use it to present the scene
          if (displays.length > 0) {
            vrDisplay = displays[0];
            console.log('Display found'); // eslint-disable-line no-console
      // Starting the presentation when the button is clicked:
      // It can only be called in response to a user gesture
            btn.addEventListener('click', () => {
              if (btn.textContent === 'Start VR display') {
                vrDisplay.requestPresent([{ source: canvas }]).then(() => {
                  console.log('Presenting to WebVR display'); // eslint-disable-line no-console
            // Set the canvas size to the size of the vrDisplay viewport
                  const leftEye = vrDisplay.getEyeParameters('left');
                  const rightEye = vrDisplay.getEyeParameters('right');
                  can.width = Math.max(leftEye.renderWidth, rightEye.renderWidth) * 2;
                  can.height = Math.max(leftEye.renderHeight, rightEye.renderHeight);
            // stop the normal presentation, and start the vr presentation
                  window.cancelAnimationFrame(normalSceneFrame);
                  vrOn = true;
                  drawVRSceneFrame();
                  btn.textContent = 'Exit VR display';
                });
              } else {
                vrDisplay.exitPresent();
                console.log('Stopped presenting to WebVR display'); // eslint-disable-line no-console
                btn.textContent = 'Start VR display';
          // Stop the VR presentation, and start the normal presentation
                vrDisplay.cancelAnimationFrame(vrSceneFrame);
                vrOn = false;
                canvas.width = 1280;
                canvas.height = 768;
                gl.viewport(0, 0, canvas.width, canvas.height);
                drawNormalSceneFrame();
              }
            });
          }
        });
      } else {
        console.log('WebVR API not supported by this browser.'); // eslint-disable-line no-console
      }
    }

/*
    poll = function poll() {
      const w = localVideo.width;
      const h = localVideo.height;

      console.log(`localvideo ${w} ${h}`);
      // const canvas = document.createElement('canvas');
      // canvas.width = w;
      // canvas.height = h;
      // const ctx = canvas.getContext('2d');
      // ctx.drawImage(localVideo, 0, 0, w, h);
      console.log(`cascade ${cascade}`);
      const comp = ccv.detect_objects({ canvas: ccv.grayscale(localVideo),
        cascade,
        interval: 5,
        min_neighbors: 1 });

      localCanvas.width = localVideo.width;
      localCanvas.height = localVideo.height;

      const ctx2 = localCanvas.getContext('2d');
      ctx2.lineWidth = 2;
      ctx2.lineJoin = 'round';
      ctx2.clearRect(0, 0, localCanvas.width, localCanvas.height);
      ctx2.drawImage(localVideo, 0, 0, localCanvas.width, localCanvas.height);
      let x_offset = 0,
        y_offset = 0,
        x_scale = 1,
        y_scale = 1;
      if (localVideo.width * localVideo.height > localVideo.width * localVideo.height) {
        x_offset = (localVideo.width - localVideo.height *
                localVideo.width / localVideo.height) / 2;
      } else {
        y_offset = (localVideo.height - localVideo.width *
                localVideo.height / localVideo.width) / 2;
      }
      x_scale = (localVideo.width - x_offset * 2) / localVideo.width;
      y_scale = (localVideo.height - y_offset * 2) / localVideo.height;

      for (let i = 0; i < comp.length; i++) {
        console.log(comp[i]);
        comp[i].x = comp[i].x * x_scale + x_offset;
        comp[i].y = comp[i].y * y_scale + y_offset;
        comp[i].width = comp[i].width * x_scale;
        comp[i].height = comp[i].height * y_scale;

        let opacity = 0.1;
        if (comp[i].confidence > 0) {
          opacity += comp[i].confidence / 10;
          if (opacity > 1.0) opacity = 1.0;
        }

    // ctx2.strokeStyle = "rgba(255,0,0," + opacity * 255 + ")";
        ctx2.lineWidth = opacity * 10;
        ctx2.strokeStyle = 'rgb(255,0,0)';
        // ctx2.strokeRect(comp[i].x, comp[i].y, comp[i].width, comp[i].height);
        ctx2.beginPath();
        ctx2.ellipse(comp[i].x + comp[i].width / 2, comp[i].y + comp[i].height / 2, comp[i].width / 2, comp[i].height / 2, 0, 0, Math.PI * 2);
        ctx2.stroke();
      }
      setTimeout(poll, 1000);
    };
    */

    PassKameraLib.start = function start() {
      const bOnOff = document.getElementById('onoff');
      recordButton = document.getElementById('recordButton');
      playButton = document.getElementById('playButton');
      downloadButton = document.getElementById('downloadButton');
      const triggerButton = document.getElementById('triggerButton');
      const multipassfilterlist = document.getElementById('multipassfilters'); // eslint-disable-line no-undef
      btn = document.getElementById('stop-start'); // eslint-disable-line no-undef

      localVideo = document.getElementById('localVideo');
      localCanvas = document.getElementById('localCanvas');

      startTime = (new Date()).getTime();

      recordButton.onclick = toggleRecording;
      playButton.onclick = play;
      downloadButton.onclick = download;

      triggerButton.onclick = globalTrigger;

      const oldfun = FilterLib.currentMultiPassFilterChanged;
      FilterLib.currentMultiPassFilterChanged = function filterchanged() {
        PassKameraLib.multiPassFilterChanged();
        if (oldfun) oldfun();
      };
      /*
      const oldfun = multipassfilterlist.onchange;

      multipassfilterlist.onchange = function multipassfilterlistchanged() {
        oldfun();
        console.log('changed');
        const fname = multipassfilters.value;
        if (storageAvailable('localStorage')) {
          if (localStorage[fname] && localStorage[fname] !== '') { // eslint-disable-line no-undef
            const jsonta = localStorage[fname]; // eslint-disable-line no-undef
            PassKameraLib.update(jsonta);
          }
        }
      };*/


      bOnOff.onclick = function onoffclick() {
        if (mOn === 1) {
          mOn = 0;
        } else {
          mOn = 1;
        }
      };
      canvas = document.getElementById('canvas'); // eslint-disable-line no-undef
      // video = document.getElementById('video'); // eslint-disable-line no-undef
      width = canvas.width;
      height = canvas.height;

      // setTimeout(poll, 3000);
      navigator.mediaDevices // eslint-disable-line no-undef
        .enumerateDevices().then(gotDevices).then(() => {
          // mMultiPassFilter = FiltersLib.MultiPassFilter.createMultiPassFilter('{ "name":"NEGAITITII", "version":0 , "subversion":0 ,"subfilters":[ {"name":"Camera", "inputs":[-1] , "x":0.05, "y":0.5 } ,{"name":"Negative", "inputs":[0] , "x":0.5, "y":0.5 } ,{"name":"Display", "inputs":[1] , "x":0.95, "y":0.5 } ]}');
          // mMultiPassFilter = FiltersLib.MultiPassFilter.createMultiPassFilter('{ "name":"negativeadder", "version":0 , "subversion":0 ,"subfilters":[{"name":"Camera", "inputs":[-1] , "x":0.05, "y":0.5 } ,{"name":"Negative", "inputs":[0] , "x":0.29874999999999996, "y":0.7733333333333334 } ,{"name":"Add", "inputs":[0,1] , "x":0.5549999999999999, "y":0.4116666666666667 } ,{"name":"Display", "inputs":[2] , "x":0.95, "y":0.5 } ]}');
          // mFilters = mMultiPassFilter.getFilters();
          // mConnectivityMap = mMultiPassFilter.getConnectivityMap();
          initGL(canvas);
          initVR(canvas, drawNormalSceneFrame, drawVRSceneFrame, gl);
          stream = canvas.captureStream(); // frames per second
          console.log('Started stream capture from canvas element: ', stream);

          // initVideoSources();
            /*
          initTextureFramebuffers();
          initShaders();
          initBuffers();
          initTextures();
          tick();
          */
        }).catch(handleError);
    };

    // PassKameraLib.update = function update(jsonta) {
    PassKameraLib.multiPassFilterChanged = function multiPassFilterChanged() {
      const mMultiPassFilter = FilterLib.currentMultiPassFilter;
      if (!vrOn) {
        window.cancelAnimationFrame(normalSceneFrame);
      } else {
        vrDisplay.cancelAnimationFrame(vrSceneFrame);
      }
      // clearTimeout(tickTimeout);
      mFilters = mMultiPassFilter.getFilters();
      mConnectivityMap = mMultiPassFilter.getConnectivityMap();
      // initGL(canvas);
      texturecounter = 0;
      mTextures = [];
      // getNextTextureUnit();
      initCameraSources();
      initVideoSources();
      initTextureFramebuffers();
      initShaders();
      initBuffers();
      initTextures();
      startFilters(gl);
      mGlobalTrigger = true;
      // initFilters();
      // tick();
      if (!vrOn) {
        drawNormalSceneFrame();
      } else {
        drawVRSceneFrame();
      }
    };

    return PassKameraLib;
  }
  if (typeof (PassKameraLib) === 'undefined') window.PassKameraLib = defineLibrary(); // eslint-disable-line no-param-reassign, no-undef
  else console.log('Library already defined.'); // eslint-disable-line no-console
}(window)); // eslint-disable-line no-undef
