/* eslint-disable require-jsdoc*/
/* eslint-disable no-undef*/
(function libraryWrapper(window) {
  function defineLibrary() {
    const VideoFiltersLib = {};
    const ConnectionType = FilterLib.ConnectionType;

    VideoFiltersLib.CameraFilter = class CameraFilter extends FilterLib.Filter {
      constructor() {
        super('Camera', 0, 1, ConnectionType.Video);
        this.mFragSourceFile = 'mpcamerafrag';
        this.mVertSourceFile = 'mpcameravert';
        this.cameraIndex = 0;
        this.mIsCameraFilter = true;
      }

      getCameraIndex() {
        return this.cameraIndex;
      }

      setCameraIndex(index) {
        this.cameraIndex = index;
      }
    };

    VideoFiltersLib.VideoFilter = class VideoFilter extends FilterLib.Filter {
      constructor() {
        super('Video', 0, 1, ConnectionType.Video);
        this.mFragSourceFile = 'mpvideofrag';
        this.mVertSourceFile = 'mpvideovert';
        this.videoIndex = 0;
        this.mIsVideoSourceFilter = true;
      }

      getVideoIndex() {
        return this.cameraIndex;
      }

      setVideoIndex(index) {
        this.cameraIndex = index;
      }
    };

    VideoFiltersLib.DisplayFilter = class DisplayFilter extends FilterLib.Filter {
      constructor() {
        super('Display', 1, 0, ConnectionType.Video);
        this.mFragSourceFile = 'mpemptyfrag';
        this.mVertSourceFile = 'mpemptyvert';
      }
    };

    VideoFiltersLib.VRDisplayFilter = class VRDisplayFilter extends FilterLib.Filter {
      constructor() {
        super('VRDisplay', 2, 0, ConnectionType.Video);
        this.mFragSourceFile = 'mpvrdisplayfrag';
        this.mVertSourceFile = 'mpvrdisplayvert';
      }
    };

    VideoFiltersLib.BufferFilter = class BufferFilter extends FilterLib.Filter {
      constructor() {
        super('Buffer', 1, 1, ConnectionType.Video);
        this.mFragSourceFile = 'mpemptyfrag';
        this.mVertSourceFile = 'mpemptyvert';
      }
    };

// This needs some thinking how to work this better
    VideoFiltersLib.SamplerFilter = class SamplerFilter extends FilterLib.Filter {
      constructor() {
        super('Sampler', 1, 1, ConnectionType.Video);
        this.mFragSourceFile = 'mpemptyfrag';
        this.mVertSourceFile = 'mpemptyvert';
        this.mIsTriggerFilter = true;
      }
      triggerFilter(trigger) {
        if (trigger === true) { console.log('triggered sampler', trigger); }
      }
    };

    VideoFiltersLib.BlurFilter = class BlurFilter extends FilterLib.Filter {
      constructor() {
        super('Blur', 1, 1, ConnectionType.Video);
        this.mFragSourceFile = 'mpblurfrag';
        this.mVertSourceFile = 'mpemptyvert';
        this.mIsOnOffFilter = true;
        this.mIsSizeFilter = true;
      }
    };

    VideoFiltersLib.GaussianBlurFilter = class GaussianBlurFilter extends FilterLib.Filter {
      constructor() {
        super('GaussianBlur', 1, 1, ConnectionType.Video);
        this.mFragSourceFile = 'mpgblurfrag';
        this.mVertSourceFile = 'mpemptyvert';
        this.mIsOnOffFilter = true;
        this.mIsSizeFilter = true;
      }
    };

    VideoFiltersLib.MedianFilter = class MedianFilter extends FilterLib.Filter {
      constructor() {
        super('Median', 1, 1, ConnectionType.Video);
        this.mFragSourceFile = 'mpmedianfrag';
        this.mVertSourceFile = 'mpemptyvert';
        this.mIsOnOffFilter = true;
        this.mIsSizeFilter = true;
      }
    };

    VideoFiltersLib.SharpenFilter = class SharpenFilter extends FilterLib.Filter {
      constructor() {
        super('Sharpen', 1, 1, ConnectionType.Video);
        this.mFragSourceFile = 'mpsharpenfrag';
        this.mVertSourceFile = 'mpemptyvert';
        this.mIsOnOffFilter = true;
        this.mIsSizeFilter = true;
      }
    };

    VideoFiltersLib.UnsharpenFilter = class UnsharpenFilter extends FilterLib.Filter {
      constructor() {
        super('Unsharpen', 1, 1, ConnectionType.Video);
        this.mFragSourceFile = 'mpunsharpenfrag';
        this.mVertSourceFile = 'mpemptyvert';
        this.mIsOnOffFilter = true;
        this.mIsSizeFilter = true;
      }
    };

    VideoFiltersLib.ShutterFilter = class ShutterFilter extends FilterLib.Filter {
      constructor() {
        super('Shutter', 1, 1, ConnectionType.Video, 1);
        this.mFragSourceFile = 'mpshutterfrag';
        this.mVertSourceFile = 'mpemptyvert';
        this.mIsOnOffFilter = true;
        this.mIsSizeFilter = true;
      }
    };

    VideoFiltersLib.EdgeDetectFilter = class EdgeDetectFilter extends FilterLib.Filter {
      constructor() {
        super('EdgeDetect', 1, 1, ConnectionType.Video, 1);
        this.mFragSourceFile = 'mpedgedetectfrag';
        this.mVertSourceFile = 'mpemptyvert';
        this.mIsOnOffFilter = true;
        this.mIsSizeFilter = true;
      }
    };

    VideoFiltersLib.BlackFilter = class BlackFilter extends FilterLib.Filter {
      constructor() {
        super('Black', 0, 1, ConnectionType.Video);
        this.mFragSourceFile = 'mpblackfrag';
        this.mVertSourceFile = 'mpemptyvert';
        this.mIsOnOffFilter = true;
      }
    };

    VideoFiltersLib.MirrorFilter = class MirrorFilter extends FilterLib.Filter {
      constructor() {
        super('Mirror', 1, 1, ConnectionType.Video);
        this.mFragSourceFile = 'mpmirrorfrag';
        this.mVertSourceFile = 'mpemptyvert';
        this.mIsOnOffFilter = true;
      }
    };

    VideoFiltersLib.OvalFilter = class OvalFilter extends FilterLib.Filter {
      constructor() {
        super('Oval', 1, 1, ConnectionType.Video, 1);
        this.mFragSourceFile = 'mpovalfrag';
        this.mVertSourceFile = 'mpemptyvert';
        this.mIsOnOffFilter = true;
      }
    };

    VideoFiltersLib.RadialFilter = class RadialFilter extends FilterLib.Filter {
      constructor() {
        super('Radial', 1, 1, ConnectionType.Video, 1);
        this.mFragSourceFile = 'mpradialfrag';
        this.mVertSourceFile = 'mpemptyvert';
        this.mIsOnOffFilter = true;
        this.mIsSizeFilter = true;
      }
    };

    VideoFiltersLib.RepeaterFilter = class RepeaterFilter extends FilterLib.Filter {
      constructor() {
        super('Repeater', 1, 1, ConnectionType.Video, 1);
        this.mFragSourceFile = 'mprepeaterfrag';
        this.mVertSourceFile = 'mpemptyvert';
        this.mIsOnOffFilter = true;
      }
    };

    VideoFiltersLib.RepeaterXFilter = class RepeaterXFilter extends FilterLib.Filter {
      constructor() {
        super('RepeaterX', 1, 1, ConnectionType.Video, 1);
        this.mFragSourceFile = 'mprepeaterxfrag';
        this.mVertSourceFile = 'mpemptyvert';
        this.mIsOnOffFilter = true;
      }
    };

    VideoFiltersLib.RepeaterYFilter = class RepeaterYFilter extends FilterLib.Filter {
      constructor() {
        super('RepeaterY', 1, 1, ConnectionType.Video, 1);
        this.mFragSourceFile = 'mprepeateryfrag';
        this.mVertSourceFile = 'mpemptyvert';
        this.mIsOnOffFilter = true;
      }
    };

    VideoFiltersLib.RotateFilter = class RotateFilter extends FilterLib.Filter {
      constructor() {
        super('Rotate', 1, 1, ConnectionType.Video, 1);
        this.mFragSourceFile = 'mprotatefrag';
        this.mVertSourceFile = 'mpemptyvert';
        this.mIsOnOffFilter = true;
        this.mIsSizeFilter = true;
      }
    };

    VideoFiltersLib.ScaleFilter = class ScaleFilter extends FilterLib.Filter {
      constructor() {
        super('Scale', 1, 1, ConnectionType.Video, 1);
        this.mFragSourceFile = 'mpscalefrag';
        this.mVertSourceFile = 'mpemptyvert';
        this.mIsOnOffFilter = true;
      }
    };

    VideoFiltersLib.WhiteFilter = class WhiteFilter extends FilterLib.Filter {
      constructor() {
        super('White', 0, 1, ConnectionType.Video);
        this.mFragSourceFile = 'mpwhitefrag';
        this.mVertSourceFile = 'mpemptyvert';
      }
    };

    VideoFiltersLib.GrayFilter = class GrayFilter extends FilterLib.Filter {
      constructor() {
        super('Gray', 0, 1, ConnectionType.Video, 1);
        this.mFragSourceFile = 'mpgrayfrag';
        this.mVertSourceFile = 'mpemptyvert';
        this.mIsOnOffFilter = true;
      }
    };

    VideoFiltersLib.LensFilter = class LensFilter extends FilterLib.Filter {
      constructor() {
        super('Lens', 0, 1, ConnectionType.Video, 1);
        this.mFragSourceFile = 'mplensfrag';
        this.mVertSourceFile = 'mpemptyvert';
        this.mIsOnOffFilter = true;
        this.mIsSizeFilter = true;
      }
    };

    VideoFiltersLib.LowerScaleFilter = class LowerScaleFilter extends FilterLib.Filter {
      constructor() {
        super('LowerScale', 1, 1, ConnectionType.Video, 1);
        this.mFragSourceFile = 'mplowerfrag';
        this.mVertSourceFile = 'mpemptyvert';
        this.mIsOnOffFilter = true;
      }
    };

    VideoFiltersLib.UpperScaleFilter = class UpperScaleFilter extends FilterLib.Filter {
      constructor() {
        super('UpperScale', 1, 1, ConnectionType.Video, 1);
        this.mFragSourceFile = 'mpupperfrag';
        this.mVertSourceFile = 'mpemptyvert';
        this.mIsOnOffFilter = true;
      }
    };

    VideoFiltersLib.DrawEdgesFilter = class DrawEdgesFilter extends FilterLib.Filter {
      constructor() {
        super('DrawEdges', 1, 1, ConnectionType.Video, 1);
        this.mFragSourceFile = 'mpdrawedgesfrag';
        this.mVertSourceFile = 'mpemptyvert';
        this.mIsOnOffFilter = true;
        this.mIsSizeFilter = true;
      }
    };

    VideoFiltersLib.Rule30Filter = class Rule30Filter extends FilterLib.Filter {
      constructor() {
        super('Rule30', 1, 1, ConnectionType.Video, 1);
        this.mFragSourceFile = 'mprule30frag';
        this.mVertSourceFile = 'mpemptyvert';
        this.mIsOnOffFilter = true;
        this.mIsSizeFilter = true;
      }
    };

    VideoFiltersLib.LifeFilter = class LifeFilter extends FilterLib.Filter {
      constructor() {
        super('Life', 1, 1, ConnectionType.Video, 1);
        this.mFragSourceFile = 'mplifefrag';
        this.mVertSourceFile = 'mpemptyvert';
        this.mIsOnOffFilter = true;
        this.mIsSizeFilter = true;
      }
    };

    VideoFiltersLib.NegativeFilter = class NegativeFilter extends FilterLib.Filter {
      constructor() {
        super('Negative', 1, 1, ConnectionType.Video);
        this.mFragSourceFile = 'mpnegativefrag';
        this.mVertSourceFile = 'mpemptyvert';
        this.mIsOnOffFilter = true;
      }
    };

    VideoFiltersLib.BWFilter = class BWFilter extends FilterLib.Filter {
      constructor() {
        super('BW', 1, 1, ConnectionType.Video, 1);
        this.mFragSourceFile = 'mpbwfrag';
        this.mVertSourceFile = 'mpemptyvert';
        this.mIsOnOffFilter = true;
      }
    };

    VideoFiltersLib.AddFilter = class AddFilter extends FilterLib.Filter {
      constructor() {
        super('Add', 2, 1, ConnectionType.Video);
        this.mFragSourceFile = 'mpaddfrag';
        this.mVertSourceFile = 'mpemptyvert';
        this.mIsOnOffFilter = true;
      }
    };

    VideoFiltersLib.DivideFilter = class DivideFilter extends FilterLib.Filter {
      constructor() {
        super('Divide', 2, 1, ConnectionType.Video);
        this.mFragSourceFile = 'mpdividefrag';
        this.mVertSourceFile = 'mpemptyvert';
        this.mIsOnOffFilter = true;
      }
    };

    VideoFiltersLib.MultiplyFilter = class MultiplyFilter extends FilterLib.Filter {
      constructor() {
        super('Multiply', 2, 1, ConnectionType.Video);
        this.mFragSourceFile = 'mpmultiplyfrag';
        this.mVertSourceFile = 'mpemptyvert';
        this.mIsOnOffFilter = true;
      }
    };

    VideoFiltersLib.SubtractFilter = class SubtractFilter extends FilterLib.Filter {
      constructor() {
        super('Subtract', 2, 1, ConnectionType.Video);
        this.mFragSourceFile = 'mpsubtractfrag';
        this.mVertSourceFile = 'mpemptyvert';
        this.mIsOnOffFilter = true;
      }
    };

    VideoFiltersLib.AndFilter = class AndFilter extends FilterLib.Filter {
      constructor() {
        super('And', 2, 1, ConnectionType.Video);
        this.mFragSourceFile = 'mpandfrag';
        this.mVertSourceFile = 'mpemptyvert';
        this.mIsOnOffFilter = true;
      }
    };

    VideoFiltersLib.OrFilter = class OrFilter extends FilterLib.Filter {
      constructor() {
        super('Or', 2, 1, ConnectionType.Video);
        this.mFragSourceFile = 'mporfrag';
        this.mVertSourceFile = 'mpemptyvert';
        this.mIsOnOffFilter = true;
      }
    };

    VideoFiltersLib.XorFilter = class XorFilter extends FilterLib.Filter {
      constructor() {
        super('Xor', 2, 1, ConnectionType.Video);
        this.mFragSourceFile = 'mpxorfrag';
        this.mVertSourceFile = 'mpemptyvert';
        this.mIsOnOffFilter = true;
      }
    };

    VideoFiltersLib.MixFilter = class MixFilter extends FilterLib.Filter {
      constructor() {
        super('Mix', 2, 1, ConnectionType.Video, 1);
        this.mFragSourceFile = 'mpmixfrag';
        this.mVertSourceFile = 'mpemptyvert';
        this.mIsOnOffFilter = true;
      }
    };

    VideoFiltersLib.MaxFilter = class MaxFilter extends FilterLib.Filter {
      constructor() {
        super('Max', 2, 1, ConnectionType.Video);
        this.mFragSourceFile = 'mpmaxfrag';
        this.mVertSourceFile = 'mpemptyvert';
        this.mIsOnOffFilter = true;
      }
    };

    VideoFiltersLib.MinFilter = class MinFilter extends FilterLib.Filter {
      constructor() {
        super('Min', 2, 1, ConnectionType.Video);
        this.mFragSourceFile = 'mpminfrag';
        this.mVertSourceFile = 'mpemptyvert';
        this.mIsOnOffFilter = true;
      }
    };

    VideoFiltersLib.QuadFilter = class QuadFilter extends FilterLib.Filter {
      constructor() {
        super('Quad', 4, 1, ConnectionType.Video);
        this.mFragSourceFile = 'mpquadfrag';
        this.mVertSourceFile = 'mpemptyvert';
        this.mIsOnOffFilter = true;
      }
    };

    VideoFiltersLib.SliderFilter = class SliderFilter extends FilterLib.Filter {
      constructor() {
        super('Slider', 2, 1, ConnectionType.Video, 1);
        this.mFragSourceFile = 'mpsliderfrag';
        this.mVertSourceFile = 'mpemptyvert';
        this.mIsOnOffFilter = true;
      }
    };

    VideoFiltersLib.VerticalSliderFilter = class VerticalSliderFilter extends FilterLib.Filter {
      constructor() {
        super('VerticalSlider', 2, 1, ConnectionType.Video, 1);
        this.mFragSourceFile = 'mpverticalsliderfrag';
        this.mVertSourceFile = 'mpemptyvert';
        this.mIsOnOffFilter = true;
      }
    };

    VideoFiltersLib.CombineFilter = class CombineFilter extends FilterLib.Filter {
      constructor() {
        super('Combine', 2, 1, ConnectionType.Video);
        this.mFragSourceFile = 'mpcombinefrag';
        this.mVertSourceFile = 'mpemptyvert';
        this.mIsOnOffFilter = true;
      }
    };

    VideoFiltersLib.CombineWhiteFilter = class CombineWhiteFilter extends FilterLib.Filter {
      constructor() {
        super('CombineWhite', 2, 1, ConnectionType.Video);
        this.mFragSourceFile = 'mpcombinewhitefrag';
        this.mVertSourceFile = 'mpemptyvert';
        this.mIsOnOffFilter = true;
      }
    };

    VideoFiltersLib.SelectFilter = class SelectFilter extends FilterLib.Filter {
      constructor() {
        super('Select', 3, 1, ConnectionType.Video);
        this.mFragSourceFile = 'mpselectfrag';
        this.mVertSourceFile = 'mpemptyvert';
        this.mIsOnOffFilter = true;
      }
    };

    VideoFiltersLib.DarkFilter = class DarkFilter extends FilterLib.Filter {
      constructor() {
        super('Dark', 1, 1, ConnectionType.Video, 1);
        this.mFragSourceFile = 'mpdarkfrag';
        this.mVertSourceFile = 'mpemptyvert';
        this.mIsOnOffFilter = true;
      }
    };

    VideoFiltersLib.DilateFilter = class DilateFilter extends FilterLib.Filter {
      constructor() {
        super('Dilate', 1, 1, ConnectionType.Video);
        this.mFragSourceFile = 'mpdilatefrag';
        this.mVertSourceFile = 'mpemptyvert';
        this.mIsOnOffFilter = true;
        this.mIsSizeFilter = true;
      }
    };

    VideoFiltersLib.DisplacementFilter = class DisplacementFilter extends FilterLib.Filter {
      constructor() {
        super('Displacement', 2, 1, ConnectionType.Video, 1);
        this.mFragSourceFile = 'mpdisplacementfrag';
        this.mVertSourceFile = 'mpemptyvert';
        this.mIsOnOffFilter = true;
        this.mIsSizeFilter = true;
      }
    };

    VideoFiltersLib.DynamicRandomNoiseFilter = class DynamicRandomNoiseFilter extends FilterLib.Filter {
      constructor() {
        super('DRN', 0, 1, ConnectionType.Video, 1);
        this.mFragSourceFile = 'mpdrnfrag';
        this.mVertSourceFile = 'mpemptyvert';
        this.mIsOnOffFilter = true;
        this.mIsTimeFilter = true;
      }
    };

    VideoFiltersLib.StaticRandomNoiseFilter = class StaticRandomNoiseFilter extends FilterLib.Filter {
      constructor() {
        super('SRN', 0, 1, ConnectionType.Video, 1);
        this.mFragSourceFile = 'mpsrnfrag';
        this.mVertSourceFile = 'mpemptyvert';
        this.mIsOnOffFilter = true;
        this.mIsTimeFilter = true;
      }
    };

    VideoFiltersLib.TurbulentRandomNoiseFilter = class TurbulentRandomNoiseFilter
      extends FilterLib.Filter {
        constructor() {
          super('TRN', 0, 1, ConnectionType.Video, 1);
          this.mFragSourceFile = 'mptrnfrag';
          this.mVertSourceFile = 'mpemptyvert';
          this.mIsOnOffFilter = true;
          this.mIsTimeFilter = true;
          this.mIsSizeFilter = true;
        }
    };

    VideoFiltersLib.ColorListFilter = class ColorListFilter
      extends FilterLib.Filter {
        constructor() {
          super('ColorList', 1, 1, ConnectionType.Video, 0, 0, 1);
          this.mFragSourceFile = 'mpcolorlistfrag';
          this.mVertSourceFile = 'mpemptyvert';
          this.mIsOnOffFilter = true;
          this.mIsSizeFilter = true;
        }
    };

    VideoFiltersLib.ColorCageFilter = class ColorCageFilter
      extends FilterLib.Filter {
        constructor() {
          super('ColorCage', 1, 1, ConnectionType.Video, 0, 0, 0, 2);
          this.mFragSourceFile = 'mpcolorcagefrag';
          this.mVertSourceFile = 'mpemptyvert';
          this.mIsOnOffFilter = true;
          this.mIsSizeFilter = true;
        }
    };

    VideoFiltersLib.ColorMapFilter = class ColorMapFilter
      extends FilterLib.Filter {
        constructor() {
          super('ColorMap', 1, 1, ConnectionType.Video, 0, 0, 2);
          this.mFragSourceFile = 'mpcolormapfrag';
          this.mVertSourceFile = 'mpemptyvert';
          this.mIsOnOffFilter = true;
        }
    };

    VideoFiltersLib.MapColorFilter = class MapColorFilter
      extends FilterLib.Filter {
        constructor() {
          super('MapColor', 1, 1, ConnectionType.Video, 1, 0, 0, 2);
          this.mFragSourceFile = 'mpmapcolorfrag';
          this.mVertSourceFile = 'mpemptyvert';
          this.mIsOnOffFilter = true;
        }
    };

    VideoFiltersLib.ExpandColorsFilter = class ExpandColorsFilter
      extends FilterLib.Filter {
        constructor() {
          super('ExpandColors', 1, 1, ConnectionType.Video, 1, 0, 1);
          this.mFragSourceFile = 'mpexpandcolorsfrag';
          this.mVertSourceFile = 'mpemptyvert';
          this.mIsOnOffFilter = true;
        }
    };

    VideoFiltersLib.PaskaFilter = class PaskaFilter
      extends FilterLib.Filter {
        constructor() {
          super('Paska', 1, 1, ConnectionType.Video, 0, 0, 1);
          this.mFragSourceFile = 'mppaskafrag';
          this.mVertSourceFile = 'mpemptyvert';
          this.mIsOnOffFilter = true;
        }
    };

    VideoFiltersLib.PaskempiFilter = class PaskempiFilter
      extends FilterLib.Filter {
        constructor() {
          super('Paskempi', 1, 1, ConnectionType.Video, 0, 0, 2);
          this.mFragSourceFile = 'mppaskempifrag';
          this.mVertSourceFile = 'mpemptyvert';
          this.mIsOnOffFilter = true;
        }
    };

    VideoFiltersLib.ErodeFilter = class ErodeFilter extends FilterLib.Filter {
      constructor() {
        super('Erode', 1, 1, ConnectionType.Video);
        this.mFragSourceFile = 'mperodefrag';
        this.mVertSourceFile = 'mpemptyvert';
        this.mIsOnOffFilter = true;
        this.mIsSizeFilter = true;
      }
    };

    VideoFiltersLib.GrayScaleFilter = class GrayScaleFilter extends FilterLib.Filter {
      constructor() {
        super('GrayScale', 1, 1, ConnectionType.Video);
        this.mFragSourceFile = 'mpgrayscalefrag';
        this.mVertSourceFile = 'mpemptyvert';
        this.mIsOnOffFilter = true;
      }
    };

    VideoFiltersLib.TriangleFilter = class TriangleFilter extends FilterLib.Filter {
      constructor() {
        super('Triangle', 1, 1, ConnectionType.Video, 1);
        this.mFragSourceFile = 'mptrianglefrag';
        this.mVertSourceFile = 'mpemptyvert';
        this.mIsOnOffFilter = true;
        this.mIsSizeFilter = true;
      }
    };

    VideoFiltersLib.PixelateFilter = class PixelateFilter extends FilterLib.Filter {
      constructor() {
        super('Pixelate', 1, 1, ConnectionType.Video, 1);
        this.mFragSourceFile = 'mppixelfrag';
        this.mVertSourceFile = 'mpemptyvert';
        this.mIsOnOffFilter = true;
        this.mIsSizeFilter = true;
      }
    };

    VideoFiltersLib.PixelateNSFilter = class PixelateNSFilter extends FilterLib.Filter {
      constructor() {
        super('PixelateNS', 1, 1, ConnectionType.Video, 1);
        this.mFragSourceFile = 'mppixelnsfrag';
        this.mVertSourceFile = 'mpemptyvert';
        this.mIsOnOffFilter = true;
      }
    };

    VideoFiltersLib.HexaFilter = class HexaFilter extends FilterLib.Filter {
      constructor() {
        super('Hexa', 1, 1, ConnectionType.Video, 1);
        this.mFragSourceFile = 'mphexafrag';
        this.mVertSourceFile = 'mpemptyvert';
        this.mIsOnOffFilter = true;
        this.mIsSizeFilter = true;
      }
    };

    VideoFiltersLib.RGBFilter = class RGBFilter extends FilterLib.Filter {
      constructor() {
        super('RGB', 3, 1, ConnectionType.Video);
        this.mFragSourceFile = 'mprgbfrag';
        this.mVertSourceFile = 'mpemptyvert';
        this.mIsOnOffFilter = true;
      }
    };

    VideoFiltersLib.RedFilter = class RedFilter extends FilterLib.Filter {
      constructor() {
        super('Red', 1, 1, ConnectionType.Video);
        this.mFragSourceFile = 'mpredfrag';
        this.mVertSourceFile = 'mpemptyvert';
        this.mIsOnOffFilter = true;
      }
    };

    VideoFiltersLib.GreenFilter = class GreenFilter extends FilterLib.Filter {
      constructor() {
        super('Green', 1, 1, ConnectionType.Video);
        this.mFragSourceFile = 'mpgreenfrag';
        this.mVertSourceFile = 'mpemptyvert';
        this.mIsOnOffFilter = true;
      }
    };

    VideoFiltersLib.BlueFilter = class BlueFilter extends FilterLib.Filter {
      constructor() {
        super('Blue', 1, 1, ConnectionType.Video);
        this.mFragSourceFile = 'mpbluefrag';
        this.mVertSourceFile = 'mpemptyvert';
        this.mIsOnOffFilter = true;
      }
    };

    VideoFiltersLib.ColorBandedFilter = class ColorBandedFilter extends FilterLib.Filter {
      constructor() {
        super('ColorBanded', 1, 1, ConnectionType.Video, 1);
        this.mFragSourceFile = 'mpcolorbandedfrag';
        this.mVertSourceFile = 'mpemptyvert';
        this.mIsOnOffFilter = true;
      }
    };

    VideoFiltersLib.RasterizerFilter = class RasterizerFilter extends FilterLib.Filter {
      constructor() {
        super('Rasterizer', 1, 1, ConnectionType.Video, 4);
        this.mFragSourceFile = 'mprasterizerfrag';
        this.mVertSourceFile = 'mpemptyvert';
        this.mIsOnOffFilter = true;
        this.mIsSizeFilter = true;
      }
    };

    VideoFiltersLib.HalftoneFilter = class HalftoneFilter extends FilterLib.Filter {
      constructor() {
        super('Halftone', 1, 1, ConnectionType.Video, 2);
        this.mFragSourceFile = 'mphalftonefrag';
        this.mVertSourceFile = 'mpemptyvert';
        this.mIsOnOffFilter = true;
        this.mIsSizeFilter = true;
      }
    };

    VideoFiltersLib.HalftoneColorFilter = class HalftoneColorFilter extends FilterLib.Filter {
      constructor() {
        super('HalftoneColor', 1, 1, ConnectionType.Video, 2);
        this.mFragSourceFile = 'mphalftonecolorfrag';
        this.mVertSourceFile = 'mpemptyvert';
        this.mIsOnOffFilter = true;
        this.mIsSizeFilter = true;
      }
    };

    VideoFiltersLib.FaceLensFilter = class FaceLensFilter extends FilterLib.Filter {
      constructor() {
        super('FaceLens', 1, 1, ConnectionType.Video, 1, 0, 1);
        this.mFragSourceFile = 'mpfacedetectfrag'; // rename
        this.mVertSourceFile = 'mpfacedetectvert';
        this.mIsSizeFilter = true;
      }
    };

    VideoFiltersLib.FaceSwapFilter = class FaceSwapFilter extends FilterLib.Filter {
      constructor() {
        super('FaceSwap', 1, 1, ConnectionType.Video, 0, 0, 2);
        this.mFragSourceFile = 'mpfaceswapfrag';
        this.mVertSourceFile = 'mpemptyvert';
        this.mIsSizeFilter = true;
      }
    };

    VideoFiltersLib.MouthSwapFilter = class MouthSwapFilter extends FilterLib.Filter {
      constructor() {
        super('MouthSwap', 1, 1, ConnectionType.Video, 0, 0, 2);
        this.mFragSourceFile = 'mpmouthswapfrag';
        this.mVertSourceFile = 'mpemptyvert';
        this.mIsSizeFilter = true;
      }
    };

    return VideoFiltersLib;
  }
  if (typeof (VideoFiltersLib) === 'undefined') window.VideoFiltersLib = defineLibrary(); // eslint-disable-line no-param-reassign, no-undef
  else console.log('Library already defined.'); // eslint-disable-line no-console
}(window)); // eslint-disable-line no-undef
