var Alku = function(){
    PartBase.call(this);
    this.setEdgeDetection();
    this.setBloom(8);

    this.texture = TDEMO.TEXTURES.getTextures().farjan8;
    var material = new THREE.MeshBasicMaterial({map: this.texture, side: THREE.BackSide});
    var geometry = new THREE.SphereGeometry(100, 32, 32);
    this.sphere = new THREE.Mesh(geometry, material);
    this.sphere.rotation.x = -Math.PI/2;

    this.scene.add(this.sphere);
};


Alku.prototype = PartBase.prototype.inheritance();

Alku.prototype.animate = function(elapsedTime, delta){
    PartBase.prototype.animate.call(this, elapsedTime, delta, true);
    var hb = TDEMO.SYNC.getHeartBeat();
    this.texture.offset.x = hb;
    this.texture.offset.y = hb;
    this.texture.needsUpdate = true;
};
