var Laiva = function(){
    PartBase.call(this);

    //POSTPROCESSING

    this.farjan = TDEMO.TEXTURES.getTextures().farjan2;
    var material = new THREE.SpriteMaterial({map : this.farjan});
    var sprite = new THREE.Sprite(material);
    sprite.scale.x = 4;
    sprite.scale.y = 2;
    this.scene.add(sprite);

    this.plane = this.createScene(TDEMO.TEXTURES.getTextures().jumalauta2);
    this.plane.position.z = -100;
    this.scene.add(this.plane);

};

Laiva.prototype = PartBase.prototype.inheritance();

Laiva.prototype.animate = function(elapsedTime, delta){
    PartBase.prototype.animate.call(this, elapsedTime, delta, true);
    this.farjan.offset.y += delta*0.25;
    this.farjan.offset.y %= 1;
    this.farjan.offset.x -= delta*0.5;
    this.farjan.offset.x %= 4;
    this.farjan.needsUpdate = true;

    this.plane.rotation.z = TDEMO.SYNC.getObjRotation().z;


};

Laiva.prototype.createScene = function(map){
    var geometry = new THREE.PlaneBufferGeometry(800, 800);
    var material = new THREE.MeshBasicMaterial({
        map : map,
        side : THREE.DoubleSide
    });

    var plane = new THREE.Mesh(geometry, material);

    return plane;
}
