// music: Anteeksi x P-KL x EU
// legal council: Laki&Oikeus
// code: Haluttu, maksullinen
// add.gfx.: se bytejen hyvä graafikko (...btw. you're now also a member of JML)

var hetuModulo = [
     "0"
    ,"1"
    ,"2"
    ,"3"
    ,"4"
    ,"5"
    ,"6"
    ,"7"
    ,"8"
    ,"9"
    ,"A"
    ,"B"
    ,"C"
    ,"D"
    ,"E"
    ,"F"
    ,"H"
    ,"J"
    ,"K"
    ,"L"
    ,"M"
    ,"N"
    ,"P"
    ,"R"
    ,"S"
    ,"T"
    ,"U"
    ,"V"
    ,"W"
    ,"X"
    ,"Y"
];
 
var firstNames = [
    "Juhani",
    "Tapani",
    "Johannes",
    "Petteri",
    "Mikael",
    "Antero",
    "Tapio",
    "Antti",
    "Olavi",
    "Mikko",
    "Mika",
    "Maria",
    "Johanna",
    "Elina",
    "Susanna",
    "Kristiina",
    "Emilia",
    "Hannele",
    "Anna",
    "Helena",
    "Pauliina"
];

var groups = [
     "iSO"
    ,"Dekadence"
    ,"Primitive"
    ,"Damones"
    ,"Accession"
    ,"Paraguay"
    ,"Extend"
    ,"MFX"
    ,"epoch"
    ,"pwp"
    ,"#amigafin"
    ,"mercury"
    ,"simulaatio.org"
    ,"Byterapers"
    ,"peisik"
    ,"f"
    ,"Komplex"
];

var lastNames = [
    "Korhonen",
    "Virtanen",
    "Mäkinen",
    "Nieminen",
    "Mäkelä",
    "Hämäläinen",
    "Laine",
    "Heikkinen",
    "Koskinen",
    "Järvinen",
    "Lehtonen",
    "Lehtinen",
    "Saarinen",
    "Salminen",
    "Heinonen",
    "Niemi",
    "Heikkilä",
    "Kinnunen",
    "Salonen",
    "Turunen",
    "Salo",
    "Laitinen",
    "Tuominen",
    "Rantanen",
    "Karjalainen",
    "Jokinen",
    "Mattila",
    "Savolainen",
    "Lahtinen",
    "Ahonen",
    "Ojala",
    "Leppänen",
    "Väisänen",
    "Leinonen",
    "Hiltunen",
    "Miettinen",
    "Kallio",
    "Pitkänen",
    "Aaltonen",
    "Manninen",
    "Anttila",
    "Hakala",
    "Koivisto",
    "Laaksonen",
    "Räsänen",
    "Hirvonen",
    "Lehto",
    "Laakso",
    "Toivonen",
    "Rantala",
    "Mustonen",
    "Aalto",
    "Nurmi",
    "Peltonen",
    "Moilanen",
    "Niemelä",
    "Seppälä",
    "Pulkkinen",
    "Hänninen",
    "Lappalainen",
    "Partanen",
    "Saari",
    "Kettunen",
    "Kauppinen",
    "Kemppainen",
    "Koskela",
    "Seppänen",
    "Lahti",
    "Salmi",
    "Ahola",
    "Huttunen",
    "Suominen",
    "Ikonen",
    "Aho",
    "Kärkkäinen",
    "Pesonen",
    "Halonen",
    "Mikkonen",
    "Nyman",
    "Johansson",
    "Koponen",
    "Peltola",
    "Oksanen",
    "Lindholm",
    "Vainio",
    "Niskanen",
    "Heiskanen",
    "Mikkola",
    "Koski",
    "Immonen",
    "Honkanen",
    "Nurminen",
    "Vuorinen",
    "Harju",
    "Kokkonen",
    "Rissanen",
    "Määttä",
    "Karppinen",
    "Mäki",
    "Laukkanen",
    "Rajala",
    "Heino",
    "Juntunen",
    "Rautiainen",
    "Jääskeläinen",
    "Parviainen",
    "Kangas",
    "Keränen",
    "Hartikainen",
    "Paananen",
    "Leino",
    "Karlsson",
    "Mäenpää",
    "Martikainen",
    "Lindström",
    "Ruotsalainen",
    "Hakkarainen",
    "Hyvärinen",
    "Uusitalo",
    "Laurila",
    "Kokko",
    "Toivanen",
    "Tikkanen",
    "Viitanen",
    "Nevalainen",
    "Salmela",
    "Leskinen",
    "Nykänen",
    "Makkonen",
    "Häkkinen",
    "Holopainen",
    "Kuusisto",
    "Tamminen",
    "Eriksson",
    "Andersson",
    "Hietala",
    "Härkönen",
    "Korpela",
    "Ranta",
    "Kukkonen",
    "Hyvönen",
    "Jaakkola",
    "Karvonen",
    "Pasanen",
    "Jokela",
    "Karhu",
    "Tiainen",
    "Väänänen",
    "Kosonen",
    "Saarela",
    "Sillanpää",
    "Malinen",
    "Kujala",
    "Rautio",
    "Virta"
];


Demo.prototype.generateSensitiveInformation = function() {
    var firstNameIndex = Utils.getRandomArrayIndex(firstNames);
    var person = {
         "firstName": firstNames[firstNameIndex]
        ,"lastName": lastNames[Utils.getRandomArrayIndex(lastNames)]
        ,"group": groups[Utils.getRandomArrayIndex(groups)]
    }

    var dd = ("00".concat(Math.floor(Math.random() * 27)+1));
    dd = dd.substr(dd.length-2);
    var mm = ("00".concat(Math.floor(Math.random() * 11)+1));
    mm = mm.substr(mm.length-2);
    var yy = ("00".concat((Math.floor(Math.random() * 29) + 70)));
    yy = yy.substr(yy.length-2);

    var hetuSeq = Math.floor(Math.random() * 300);
    if ((firstNameIndex < 11 && hetuSeq%2==0) || (firstNameIndex >= 11 && hetuSeq%2==1)) {
        hetuSeq = hetuSeq + 1; 
    }

    var hetuLast = ("000" + hetuSeq) + hetuModulo[hetuSeq%31];
    hetuLast = hetuLast.substr(hetuLast.length-4);

    var hetu = dd+mm+yy+"-"+hetuLast;
    person['hetu'] = hetu;


    return Utils.deepCopyJson(person);
}

Demo.prototype.addLight = function(start, duration, layer)
{
    this.loader.addAnimation([
    {
         "start": start, "duration": duration, "layer": layer
        ,"light":{"index":0, "action":"begin"}
        ,"lightType": Light.type.DIRECTIONAL
        ,"direction":[
             {"x":0.5, "y":-1, "z":-0.5}
        ]
        ,"specularColor":[
             {"r":255, "g":255, "b":10, "a":255}
        ]
        ,"diffuseColor":[
             {"r":255*0.8, "g":255*0.6, "b":10*0.6, "a":255}
        ]
        ,"ambientColor":[
             {"r":255*0.5, "g":255*0.3, "b":10*0.3, "a":255}
        ]
    }]);
}

Demo.prototype.init = function()
{
    var start = 0;
    var duration = 146;
    var layer = 1;

    var p2Start = duration-1;
    var p2Duration = 50;
        
    this.addLight(start, duration, layer);

    this.loader.addAnimation({
         "start": start, "duration": duration, "layer": layer
        ,"image": "bad_flag_background.png"
    });

    this.loader.addAnimation({
         "start": 4, "duration": duration, "layer": layer
        ,"image": "eu_stars.png"
        ,"angle":[
            {"degreesZ":"{return Math.sin(getSceneTimeFromStart()*0.5)*360;}"}
        ]
        ,"color":[
            {"a":0}
           ,{"duration":1,"a":255}
        ]
    });


    this.loader.addAnimation(
    {
         "start": start, "duration": duration, "layer": layer
        ,"object": "euro.obj"
        ,"position":[{"y":-0.1}]
        ,"angle":[
            {"degreesX":90,"degreesZ":"{return -getSceneTimeFromStart()*100;}", "degreesY":180}
        ]
    });

    this.loader.addAnimation({
         "start": start+7, "duration": duration-7
        ,"layer": layer, "image": {"name":"anonymous.ogg", "video":{"speed":0.08} }
        ,"scale":[{"x":2.0,"y":2.0}]
        ,"color":[{"a":0},{"duration":1,"a":100},{"duration":duration-9},{"duration":1,"a":0}]
    });


    this.loader.addAnimation({
         "start": p2Start, "duration": p2Duration, "layer": layer
        ,"image": "party_background.png"
        ,"color":[{"a":0},{"duration":1,"a":255}]
    });
    this.loader.addAnimation({
         "start": p2Start, "duration": p2Duration, "layer": layer
        ,"image": "_embedded/data/mikronlove/boat.png"
        ,"color":[{"a":0},{"duration":5},{"duration":2,"a":255}]
        ,"angle":[{"degreesZ":"{return Math.sin(getSceneTimeFromStart())*10;}"}]
        ,"position":[{"x":getScreenWidth()/2.0,"y":getScreenHeight()/2.0},{"duration":60,"x":getScreenWidth()*1.4}]
    });
    this.loader.addAnimation({
         "start": p2Start+6, "duration": p2Duration, "layer": layer
        ,"image": "_embedded/data/mikronlove/hirmu_line.png"
        ,"position":[{"x":200,"y":0},{"duration":2,"y":500,"x":300},{"duration":20,"x":getScreenWidth()+300,"y":"{return Math.sin(getSceneTimeFromStart()*2)*50+500;}"}]
    });
    this.loader.addAnimation({
         "start": p2Start, "duration": p2Duration, "layer": layer
        ,"image": "party_foreground.png"
        ,"color":[{"a":0},{"duration":1,"a":255}]
    });

    var texts = [
        {
            "start":0, "duration":4, "lines":[
                 "WE PROTECT YOU"
            ]
        },{
            "start":4, "duration":3, "lines":[
                 "WE PROTECT YOUR DATA"
            ]
        },{
            "start":7, "duration":16, "lines":[
                 "The General Data Protection Regulation (GDPR)"
                ,"(EU) 2016/679 is a regulation in EU law"
                ,"on data protection and privacy"
                ,"for all individuals within the European Union"
                ,"and the European Economic Area."
            ]
        },{
            "start":22, "duration":17, "lines":[
                  "It also addresses the export of personal data"
                 ,"outside the EU and EEA. The GDPR aims primarily"
                 ,"to give control to citizens and residents over"
                 ,"their personal data and to simplify"
                 ,"the regulatory environment for international"
                 ,"business by unifying the regulation"
                 ,"within the EU"
            ]
        },{
            "start":39, "duration":13, "lines":[
                 "Superseding the Data Protection Directive,"
                 ,"the regulation contains provisions and"
                 ,"requirements pertaining to the processing"
                 ,"of personally identifiable information of data"
                 ,"subjects inside the European Union."
            ]
        },{
            "start":52, "duration":24, "lines":[
                  "Business processes that handle personal data"
                 ,"must be built with privacy by design and by"
                 ,"default, meaning that personal data must be"
                 ,"stored using pseudonymisation or full"
                 ,"anonymisation, and use the highest-possible"
                 ,"privacy settings by default, so that the data"
                 ,"is not available publicly without explicit"
                 ,"consent, and cannot be used to identify a subject"
                 ,"without additional information stored separately."
            ]
        },{
            "start":76, "duration":17, "lines":[
                  "No personal data may be processed unless it is"
                 ,"done under a lawful basis specified by"
                 ,"the regulation, or if the data controller or"
                 ,"processor has received explicit, opt-in consent"
                 ,"from the data's owner. The business must allow"
                 ,"this permission to be withdrawn at any time."
            ]
        },{
            "start":93, "duration":12, "lines":[
                 "Processor of personal data must clearly disclose"
                 ,"what data is being collected and how, why it is"
                 ,"being processed, how long it is being retained,"
                 ,"and if it is being shared with any third-parties."
            ]
        },{
            "start":105, "duration":10, "lines":[
                 "Users have the right to request a portable copy"
                 ,"of the data collected by a processor in a common"
                 ,"format, and the right to have their data erased"
                 ,"under certain circumstances."
            ]
        },{
            "start":115, "duration":16, "lines":[
                 "Public authorities, and businesses whose core"
                ,"activities centre around regular or systematic"
                ,"processing of personal data, are required to"
                ,"employ a data protection officer (DPO), who is"
                ,"responsible for managing compliance"
                ,"with the GDPR."
            ]
        },{
            "start":131, "duration":8, "lines":[
                 "Businesses must report any data breaches within"
                ,"72 hours if they have an adverse effect"
                ,"on user privacy."
            ]
        },{
            "start":p2Start+1, "duration":10, "lines":[
                 "Happy birthday to"
                ,"the one who hasn't coded a demo yet"
            ]
        },{
            "start":p2Start+10, "duration":10, "lines":[
                 "Happy birthday to"
                ,"Byterapers"
            ]
        },{
            "start":p2Start+19, "duration":10, "lines":[
                 "Happy birthday to"
                ,"Accession"
            ]
        }
    ];


    var textScale = 2.0;
    for (var i = 0; i < texts.length; i++) {
        var text = texts[i];
        var yh = ((text.lines.length)*textScale*40)/2.0;
        for (var j = 0; j < text.lines.length; j++) {
            var ydelta = (text.lines.length-j)*textScale*40;
            this.loader.addAnimation([
            {
                 "start": text.start, "duration": text.duration
                ,"layer": layer, "text":{"name":"arialbd.ttf","string":text.lines[j]}
                ,"scale": [
                      {"x":textScale,"y":textScale}
                ]
                ,"position": [{"x":getScreenWidth()/2.0, "y":getScreenHeight()/2.0+ydelta-yh}]
                ,"color": [
                     {"a":0}
                    ,{"duration":1,"a":200}
                    ,{"duration":text.duration-2}
                    ,{"duration":1,"a":0}]
            }]);
        }
    }

    this.loader.addAnimation([
    {
         "start": start, "duration": duration
        ,"layer": layer, "text":{"name":"arialbd.ttf","string":email.v}
        ,"scale": [{"x":textScale,"y":textScale}]
        ,"position": [{"x":getScreenWidth()*0.5, "y":getScreenHeight()*0.95}]
        ,"color": [{"a":"{return ((Math.sin(getSceneTimeFromStart()*2.5)+1)/2.0)*255;}"}]
    }]);

    var personalInformations = [
        {
             "name":"001.png"
            ,"start":15,"duration":5
            ,"personCount": 2
            ,"persons":[]
        },{
             "name":"002.png"
            ,"start":30,"duration":8
            ,"personCount": 4
            ,"persons":[]
        },{
             "name":"003.png"
            ,"start":42,"duration":8
            ,"personCount": 3
            ,"persons":[]
        },{
             "name":"004.png"
            ,"start":55,"duration":8
            ,"personCount": 3
            ,"persons":[]
        },{
             "name":"005.png"
            ,"start":64,"duration":10
            ,"personCount": 5
            ,"persons":[]
        },{
             "name":"006.png"
            ,"start":80,"duration":4
            ,"personCount": 1
            ,"persons":[]
        },{
             "name":"007.png"
            ,"start":100,"duration":6
            ,"personCount": 2
            ,"persons":[]
        },{
             "name":"008.png"
            ,"start":120,"duration":10
            ,"personCount": 4
            ,"persons":[]
        }
    ];
    for (var i = 0; i < personalInformations.length; i++) {
        var pi = Utils.deepCopyJson(personalInformations[i]);

        this.loader.addAnimation({
             "start": pi.start, "duration": pi.duration, "layer": layer
            ,"image": pi.name
            ,"color":[
                {"a":0}
               ,{"duration":0.5,"a":255}
               ,{"duration":pi.duration-1}
               ,{"duration":0.5,"a":0}
            ]
            ,"scale":[{"uniform2d":1.0}]
        });

        for(var j = 0; j < pi.personCount; j++) {
            var textScale = 3.0;
            var person = Utils.deepCopyJson(this.generateSensitiveInformation());
            pi.persons.push(person);
            var dur = pi.duration/pi.personCount;
            var start = pi.start + dur*j;
            var fullname = person.firstName + " " + person.lastName;
            this.loader.addAnimation([
            {
                 "start": start, "duration": dur
                ,"layer": layer, "text":{"name":"arialbd.ttf","string":fullname}
                ,"scale": [
                      {"x":textScale,"y":textScale}
                ]
                ,"position": [{"x":getScreenWidth()/2.0, "y":getScreenHeight()*0.7}]
                ,"color": [
                     {"a":0}
                    ,{"duration":0.25,"a":255}
                    ,{"duration":dur-0.5}
                    ,{"duration":0.25,"a":0}]
            }]);
            this.loader.addAnimation([
            {
                 "start": start, "duration": dur
                ,"layer": layer, "text":{"name":"arialbd.ttf","string":person.hetu}
                ,"scale": [
                      {"x":textScale,"y":textScale}
                ]
                ,"position": [{"x":getScreenWidth()/2.0, "y":getScreenHeight()*0.6}]
                ,"color": [
                     {"a":0}
                    ,{"duration":0.25,"a":255}
                    ,{"duration":dur-0.5}
                    ,{"duration":0.25,"a":0}]
            }]);
            this.loader.addAnimation([
            {
                 "start": start, "duration": dur
                ,"layer": layer, "text":{"name":"arialbd.ttf","string":person.group}
                ,"scale": [
                      {"x":textScale,"y":textScale}
                ]
                ,"position": [{"x":getScreenWidth()/2.0, "y":getScreenHeight()*0.5}]
                ,"color": [
                     {"a":0}
                    ,{"duration":0.25,"a":255}
                    ,{"duration":dur-0.5}
                    ,{"duration":0.25,"a":0}]
            }]);
        }


        /*for (var sceneName in this.scenes) {
            var scene = this.scenes[sceneName];
            loggerDebug("Processing animations for scene '" + sceneName + "'");
            loggerWarning("LOL " + JSON.stringify(scene,null,2));
        }*/

    }
}
