var introTimeline = new TimelineMax({ paused: true });

function initializeIntro() {
	var intro = scenes.intro;
	
	intro.sfx = {
		splash: document.getElementById("splashSfx"),
		hup: document.getElementById("hupSfx"),
		kritzel: document.getElementById("kritzelSfx"),
	};
	
	for (var child of ["cred1", "cred2", "cred3"]) {
		//intro[child].head.div.height = 0;
		//intro[child].type.div.width = 0;
		intro[child].head.div.style.overflow = intro[child].type.div.style.overflow = "hidden";
	} 
	for (var child of ["presents", "pretitle", "title1", "title2", "title3"]) {
		//intro[child].div.style.width = 0;
		intro[child].div.style.overflow = "hidden";
	}
	intro.wursthupe.div.style.opacity = 0;
	
	intro.background.beamer.fromTo(2, { rotation:3 }, { rotation:-1.5, repeat:-1, yoyo:true, ease:Sine.easeInOut } );
	
	var penDown = function(){ intro.sfx.kritzel.play(); },
	    penUp   = function(){ intro.sfx.kritzel.pause(); };
	
	introTimeline
		.add([ intro.background.set({ filter: "blur(15px)" }), intro.wursthupe.set({ scale: 1.2 }) ])
		.add(intro.to(1, {opacity: 1}))
		.call(function(){ intro.sfx.splash.play() })
		.add(intro.wursthupe.to(0.2, { scale: 1, opacity: 1 }))
		.call(function(){ intro.sfx.hup.play() }, null, null, "+=0.5")
		.add(intro.wursthupe.hup.from(1, { opacity: 0, ease: function(x){ return (x < 0.2 || x > 0.4) ? 1 : 0; }}))
		.add(intro.wursthupe.to(1, { x: "-=750", y: "-=290", scale: 0.651, rotation: -24.3 }))
		
		.call(penDown)
		.add(intro.presents.from(1, { width: 0 }), "-=0.3")
		.call(penUp)
		
		.call(penDown, null, null, "+=0.5")
		.add(intro.pretitle.from(0.2, { width: 0 }))
		.call(penUp, null, null, "+=0.8")
		
		.call(penDown, null, null, "+=0.5")
		.add(intro.title1.from(0.2, { width: 0 }))
		.add(intro.title2.from(0.2, { width: 0 }), "+=0.3")
		.add(intro.title3.from(0.2, { width: 0 }), "+=0.3")
		.call(penUp, null, null, "+=0.8")
	;
	
	for (var i=1; i <= 3; i++) {
		credit = intro["cred"+i];
		introTimeline
			.call(penDown, null, null, "+=1")
			.add(credit.type.from(0.3, { width: 0 }))
			.add(credit.head.from(0.3, { height: 0 }), "+=0.5")
			.call(penUp, null, null, "+=0.5")
	}
		
	introTimeline
		.add(intro.to(2, {opacity: 0}), "+=2")
		.add(intro.background.set({ filter: "" }))
	;
}