var kitchenTimeline;

function initializeKitchen() {
	var kitchen = scenes.kitchen, plant = kitchen.plant, recipe = kitchen.recipe,
		waffel = kitchen.waffel, chicken = waffel.chicken, flag = waffel.flag, ts = kitchen.ts, medo = kitchen.medo,
		denkblase = kitchen.thought_bubble, sprechblase = kitchen.speech_bubble;
		
	var sprechblaseTweens = [ sprechblase.fromTo(1.5, {opacity:0}, {opacity:1}), 
							  sprechblase.fromTo(3, {scale:0.25}, { scale:1, ease:Elastic.easeOut.config(0.8, 0.15) }),
							  sprechblase.waffles.fromTo(0.25, {opacity:0}, { opacity:1, delay:0.3 }),
							  sprechblase.waffles.fromTo(2.5, {scale:0}, { scale:1, delay:0.3, ease:Elastic.easeOut.config(1, 0.25) }),
							  sprechblase.waffles.fromTo(2.5, {rotation:50}, { rotation:0, delay:0.3, ease:Elastic.easeOut.config(0.8, 0.3) }),
							  sprechblase.to(1, { opacity:0, delay:2.5 }) ];
	var denkblaseRecipe = denkblase.bubble.recipe,
		stroke = denkblaseRecipe.stroke,
		strokes = [stroke.chicken, stroke.drops, stroke.flag1, stroke.gunpowder],
		denkblaseTweens = [];
	for(var i = 0; i < 4; i++) {
		strokes[i].div.style.overflow = 'hidden';
		denkblaseTweens.push([ TweenMax.staggerFromTo([denkblase.ts1.div, denkblase.medo1.div, 
													   denkblase.ts2.div, denkblase.medo2.div, 
													   denkblase.ts3.div, denkblase.medo3.div, 
													   denkblase.bubble.div], 0.3, {opacity:0}, {opacity:1, ease:Power1.easeIn }, 0.2),
							   TweenMax.to([denkblaseRecipe.div.firstChild, denkblaseRecipe.stroke.div], 0.7, { x:i*-30, y:i*-140, ease:Power1.easeInOut, delay:1 }),
							   TweenMax.from(strokes[i].div, 0.7, { width:0, ease:Power1.easeInOut, delay:3 }),
							   TweenMax.staggerTo([denkblase.ts1.div, denkblase.medo1.div, 
												   denkblase.ts2.div, denkblase.medo2.div, 
												   denkblase.ts3.div, denkblase.medo3.div, 
												   denkblase.bubble.div], 0.25, { opacity:0, delay:4 }, 0.1 ) ]);
	}
	stroke.flag2.div.style.overflow = 'hidden';
	denkblaseTweens[2].push(TweenMax.from(stroke.flag2.div, 0.7, { width:0, ease:Power1.easeInOut, delay:3.5 }));
	var recipeStyle = denkblaseRecipe.div.style;
	recipeStyle.left = '70px';
	recipeStyle.top = '50px';
	recipeStyle.width = '374px';
	recipeStyle.height = '170px';
	recipeStyle.overflow = 'hidden';
		
	kitchen.div.style.left = "360px";
	kitchen.div.style.top  = "90px";
	kitchen.div.style.overflow = 'hidden';

	kitchen.sound = document.getElementById('kitchenSound');
	kitchen.sound.volume = 0;
	kitchen.sound.loop = true;
	kitchen.sound.pause();
	kitchen.sfx = {
		blubber: document.getElementById('blubberSfx'),
		mints: document.getElementById('mintSfx'),
		huhn: document.getElementById('huhnSfx')
	};

	var plantFrameDuration = 1;
	var plantTimeline = (new TimelineMax({paused: true}))
		.add( [plant.ok   .fromTo(plantFrameDuration, {opacity:1}, {opacity:0, ease:Power2.easeIn}),
			   plant.ok   .    to(plantFrameDuration,              {y:(plant.dead1.topLeft.y-plant.ok.topLeft.y)*0.5, ease:Power2.easeOut}),
			   plant.dead1.fromTo(plantFrameDuration, {opacity:0}, {opacity:1, ease:Power2.easeOut})] )
		.add( [plant.dead1.    to(plantFrameDuration,              {opacity:0, ease:Power2.easeIn}),
			   plant.dead1.    to(plantFrameDuration,              {y:(plant.dead2.topLeft.y-plant.dead1.topLeft.y)*0.25, ease:Power2.easeOut}),
			   plant.dead2.fromTo(plantFrameDuration, {opacity:0}, {opacity:1, ease:Power2.easeOut})] )
		.add( [plant.dead2.    to(plantFrameDuration,              {opacity:0, ease:Power2.easeIn}),
			   plant.dead2.    to(plantFrameDuration,              {y:(plant.dead3.topLeft.y-plant.dead2.topLeft.y)*0.25, ease:Power2.easeOut}),
			   plant.dead3.fromTo(plantFrameDuration, {opacity:0}, {opacity:1, ease:Power2.easeOut})] )
		.add( [plant.dead3.    to(plantFrameDuration,              {opacity:0, ease:Power2.easeIn}),
			   plant.dead3.    to(plantFrameDuration,              {y:(plant.dead4.topLeft.y-plant.dead3.topLeft.y)*0.5, ease:Power2.easeOut}),
			   plant.dead4.fromTo(plantFrameDuration, {opacity:0}, {opacity:1, ease:Power2.easeOut})] );

	kitchen.div.style.overflow =
	recipe.chicken  .div.style.overflow =
	recipe.mints    .div.style.overflow =
	recipe.flag     .div.style.overflow =
	recipe.gunpowder.div.style.overflow = 'hidden';
	
	var skullDivs = [waffel.skull1.div, waffel.skull2.div, waffel.skull3.div];
	for(var i = 0; i < 100; i++) {
		var skullDiv = skullDivs[i%3];
		skullDivs.push(skullDiv.parentNode.appendChild(skullDiv.cloneNode(true)));
	}
	
	//var recipePartTween = function(d, a) { return recipe.from(d, { rotation: "-="+a, ease: Elastic.easeOut.config(2, 0.1), immediateRender:false }); };
	var cookingTimeline = (new TimelineMax({paused: true}))
		.add( sprechblaseTweens )
		.add( [medo.head.to(0.3, { rotation:"+=20", repeat:3, yoyo: true, ease: Power1.easeInOut}),
			   ts  .head.to(0.3, { rotation:"-=15", repeat:3, yoyo: true, ease: Power1.easeInOut, delay:0.2 })], "-=1" )
		.add(  recipe.fromTo(1, { scale: 0 }, { scale: 1, ease: Elastic.easeOut }))
		.add( [waffel.fromTo(1, {opacity:0}, {opacity:1}),
			   waffel.from  (1, {y:"+100", ease:Power1.easeOut})], "+=1" )
		.add( [medo.head.to(1, { rotation:20}),
			   ts  .head.to(1, { rotation:-15, delay:0.1})] )
		.addLabel('startBoiling')
		.add( TweenMax.staggerFromTo([waffel.fire2.div, waffel.fire3.div, waffel.fire1.div, waffel.fire4.div], 1, {opacity:0}, {opacity:1}, 0.4), "+=0.5" )
		.add('', "+0.5")
		.add( denkblaseTweens[0] )
		.addLabel('chicken', '-=3')
		.add( [//recipePartTween(1, 15),
			   recipe.chicken.from(1, {width:0, ease:Power2.easeInOut} )/*,
			   recipe.chicken.from(1, {scale:0, ease:Power2.easeIn} )*/])
		.addLabel('chickenPot', 'chicken+=1')
		.add( [chicken.fromTo(1, {opacity:0}, {opacity:1, ease:Power3.easeOut} ),
			   chicken.from(1, {scale:0.25, ease:Elastic.easeOut} ),
			   chicken.to(1,   {x:"+5", repeat: -1, yoyo: true, ease:Sine} ),
			   chicken.to(2.3, {y:"+4", repeat: -1, yoyo: true, ease:Sine})], 'chickenPot')
		.add('', "+0.5")
		.add( denkblaseTweens[1] )
		.addLabel('mints', "-=3.5")
		.add( [//recipePartTween(1, 5),
			   recipe.mints.from(1, {width:0, ease:Power2.easeInOut} )/*,
			   recipe.mints.from(1, {scale:2, ease:Power2.easeOut} )*/] )
		.add( plantTimeline.play(), 'mints+=1')
		.add('', "+0.5")
		.add( denkblaseTweens[2] )
		.addLabel('flag', "-=1.2")
		.add( [//recipePartTween(1, 5),
			   recipe.flag.from(1, {width:0, ease:Power2.easeInOut} )/*,
			   recipe.flag.from(1, {scale:2, ease:Power2.easeOut} )*/] )
		.add( [flag.fromTo(1, {opacity:0}, {opacity:1, ease:Power3.easeOut}),
			   flag.from(1, {scale:1.5, ease:Power3.easeOut}),
			   flag.to(1.5, {y:"+3", repeat: -1, yoyo: true, ease:Sine})], 'flag+=1')
		.add('', "+0.5")
		.add( denkblaseTweens[3] )
		.addLabel('gunpowder', "-=4")
		.add( [//recipePartTween(1, 5),
			   recipe.gunpowder.from(1, {width:0, ease:Power2.easeInOut} )/*,
			   recipe.gunpowder.from(1, {scale:2, ease:Power2.easeOut} )*/] )
		.add(  boilingTween = waffel.to(0.09, {scale:1.01, repeat: -1, yoyo: true, ease:function(p){ return p*p*Math.pow(Math.min(1, 0.2*boilingTween.totalTime()), 2); } }), 'gunpowder')
		.addLabel('gunpowderPot', 'gunpowder+=0.2')
		.add( [TweenMax.staggerFromTo(skullDivs, 1, { y:"+=0", x:"+=0" }, { y:"-=650", cycle:{x:function(i){ return (Math.random()-0.5)*16*i; } }, repeat:-1 }, 0.033),
			   TweenMax.staggerFromTo(skullDivs, 1, { opacity:1 }, { opacity:0, repeat:-1, ease:Power2.easeIn }, 0.033),
			   gunPowderZoom = TweenMax.staggerFromTo(skullDivs, 1, { scale:0 }, { scale:1, repeat:-1, cycle:{ delay:function(){ return Math.random()*10; } }, ease:function(p) { return p*(1+Math.pow(gunPowderZoom[0].totalTime(), 0.3)); } }, 0.1)], 'gunpowder');

	cookingTimeline.addCallback(function() { kitchen.sfx.huhn.play(); }, cookingTimeline.getLabelTime('chickenPot'));
	cookingTimeline.addCallback(function() { kitchen.sfx.mints.play(); }, cookingTimeline.getLabelTime('mints'));
	cookingTimeline.addCallback(function() { kitchen.sfx.blubber.play(); }, cookingTimeline.getLabelTime('gunpowderPot')+1);

	var dropDelay = 2.1;
	kitchenTimeline = (new TimelineMax({paused: true}))
		.add(ts.tomate.to(0.2, {y:"-20", scaleY:1.1, repeat: -1, yoyo: true, ease:Sine, delay:2 }))
		.add( medo.from(2, { x: -500, y: "-=50", ease:Power4.easeOut }), 1)
		.add([ts.from(2, { x: 600, ease:Expo }), ts.from(2, { y:250, ease:function(p){ return Math.pow(p, 0.7)+Math.abs(Math.sin(p*Math.PI*7))*(1-p);} })], "+=0.1")
		.addLabel('startCooking')
		.add(cookingTimeline.play(), "+=1")
		.add([kitchen.drop.    to(0.5, { y:"+=40", repeat:-1, repeatDelay:dropDelay }),
			  kitchen.drop.fromTo(0.5, { scale:0 },   { scale:0.5, repeat:-1, ease:Expo.easeOut, repeatDelay:dropDelay }),
			  kitchen.drop.fromTo(0.5, { opacity:1 }, { opacity:0, repeat:-1, ease:Expo.easeIn,  repeatDelay:dropDelay })], 0);

	for(var i = 1; i <= 4; i++)
	{
		var fire = waffel['fire'+i];
		fire.param = i;
		startFireTween.call(fire);
	}

	function startFireTween() {
		this.animTime = (this.animTime || 0) + 1;
		this.animScale = Math.min(1, (this.animScale || 0) + 0.1);
		var t = this.animTime+0.7*this.param,
			s = this.animScale;
			sy = s * 1.3 + 0.1*(Math.sin(t) + 0.7*Math.sin(2.3*t) + 0.5*Math.sin(4.4*t) + 0.6*Math.sin(7*t)),
			sx = sy * 0.75;
		this.to(0.1, { scaleY: sy, scaleX: sx, ease: Sine, onCompleteScope: this, onComplete: startFireTween });
	}
};

