; Chessington World Of Adventure
;
; a 128b intro by Gasman / Hooy-Program
; for Outline 2018

	org 0x8000

CALC_DELETE		equ 0x02
CALC_MULTIPLY	equ 0x04
CALC_ADDITION	equ 0x0f
CALC_SIN		equ 0x1f
CALC_INT		equ 0x27
CALC_DUPLICATE	equ 0x31
CALC_CONST		equ 0x34
CALC_STK_ZERO	equ 0xa0
CALC_ST_MEM_0	equ 0xc0
CALC_END_CALC	equ	0x38

sine	equ 0xbf00 ; we'll repurpose the 0xbf to select the AY data port

	call 3435 ; clear screen

; the good old sine generator routine
	rst 0x28
	db CALC_STK_ZERO
	db CALC_END_CALC

	ld hl,sine
sinelp
	push hl

	rst 0x28
	db CALC_CONST, 0x2c, 0x49 ;const pi/64 (ish)
	db CALC_ADDITION
	db CALC_DUPLICATE
	db CALC_SIN
	db CALC_CONST, 0x37, 0x70		; const 113
	;db CALC_CONST, 0x36, 0x6f		; const 60
	;db CALC_CONST, 0x36, 0x4f		; const 40ish
	db CALC_MULTIPLY
	db CALC_INT
	db CALC_ST_MEM_0
	db CALC_DELETE
	db CALC_END_CALC
	ld a,(iy+0x5a)			; third byte of calculator memory 0

	pop hl
	add a,0x80
	ld (hl),a
	inc l
	jr nz,sinelp


; set AY registers
	ld bc,0xfffd
	ld a,8  ; channel A volume
	out (c),a

	ld b,h ; now bc=0xbffd
	out (c),c  ; anything with bit 4 set will do

	ld b,c ; fdfd will work for accessing AY
	ld a,13 ; envelope shape
	out (c),a

	ld b,h ; now bc=0xbffd
	ld a,10 ; triangle
	out (c),a

	ld b,c
	inc a ; register 11; envelope speed
	out (c),a


framelp
	dec l
	push hl

	halt
	ld a,l
	and 0x0f

	ld l,a
    ; high bit of frame counter -> paper colour

	ld d,025o
	call stripe
	ld d,037o
	call stripe

	pop hl

	ld a,(hl)
	ld b,h
	out (c),a

	ld a,0x13

	; screen-flipping loop
	; e = flip counter (counts down from 8)
	; a = OUT value
	; hl = sine addr
	; b = temp var, used for delay counter and high byte of paging/AY port
	; c = always 0xfd

	ld b,h
fliplp

flipdelay1
	cp (hl)  ; a fairly good way to waste time in a single byte
	djnz flipdelay1
flipdelay2
	djnz flipdelay2

	ld b,0x7f
	out (c),a
	out (254),a
	xor 0x0b

	ld b,(hl)
	ex af,af'
	ld a,16
	add a,l
	ld l,a
	ex af,af'

	dec e
	jr nz,fliplp

	jr framelp

stripe
	res 3,l  ; use framecount mod 8 for starting stripe pos
	ld b,0x7f
	out (c),d
	ld h,0xd8
	ld de,8
	ld b,97  ; should be 96 to fill the screen, but going one over means we flip the paper colour
		; before re-running this routine on the second screen, and the 'res 3,l' ensures that we reset
		; screen address back to 0..7
stripelp
	ld (hl),a
	xor e
	add hl,de
	djnz stripelp
	ret
