/*
Ajna - hlavná stanica, koncová stanica
*/

var totalDuration = 119;

var textTime = -1;
var textIters = 8;
var textPositions = new Array(textIters);

function calculateTextValues() {
    var threshold = 0.05;
    var currentTime = (new Timer()).getTimeInSeconds();
    if (Math.abs(textTime-currentTime) > threshold) {
        for(var i = 0; i < textIters; i++) {
            textPositions[i]={
                 "x":getScreenWidth()*Math.random()
                ,"y":(getScreenHeight()-300)*Math.random()
                ,"scale":1+3*Math.random()
                ,"degreesZ":180*Math.random()-90
                ,"alpha":(0.1+0.9*Math.random())*255
            }
        }
        textTime = currentTime + threshold;
    }
}

Demo.prototype.addTextFlicker = function(start, duration, layer, textSection) {
    for(var i = 0; i < textIters; i++) {
        this.loader.addAnimation([
        {
             "start": start, "duration": duration
            ,"layer": layer
            ,"text":{"name":"DroidSerif-Regular.ttf","string":textSection}
            ,"scale": [
                  {"iter":i, "uniform2d":"{return textPositions[animation.iter].scale}"}
            ]
            ,"angle": [
                  {"iter":i, "degreesZ":"{return textPositions[animation.iter].degreesZ}"}
            ]
            ,"position":[
                {"iter":i, "x":"{return textPositions[animation.iter].x;}","y":"{return textPositions[animation.iter].y;}"}]
            //,"color":[{"a":"{return (1+Math.sin(getSceneTimeFromStart()*5))/2*255}"}]
            ,"color":[{"iter":i,"g":0,"b":0,"a":"{return textPositions[animation.iter].alpha;}"}]
            ,"runFunction":"{calculateTextValues();}"
            ,"initFunction":"{calculateTextValues();}"
        }]);
    }
}

var time = 0;
var clockDigits;
function getWeirdClockDigits(threshold, hours, minutes) {
    var currentTime = (new Timer()).getTimeInSeconds();
    if (Math.abs(time-currentTime) > threshold) {
        var hour = "00" + Math.floor(Math.random()*hours);
        var minute = "00" + Math.floor(Math.random()*minutes);

        clockDigits = hour.substr(hour.length-2) + ":" + minute.substr(minute.length-2);
        time = currentTime + threshold;
    }

    return clockDigits;
}

var lightIntensity = {
    "ambient": 255*0.5,
    "diffuse": 255*0.3,
    "specular": 255,
    "direction": {"x":-0.5, "y":-1.0, "z":-0.5}
}
function calcLightIntensity() {

    var p = Utils.clamp((Math.tan((new Timer()).getTimeInSeconds()*10.0)+1.0)/2.0)*0.3+0.7;
    var xDir = -0.5;
    var zDir = -0.5;
    if (Sync.getSyncValue('flicker') > 0.0) {
        xDir = [-0.5,0.5,0.0][(Math.floor(Math.random()*30))%3];
        zDir = [-0.5,0.5,0.0][(Math.floor(Math.random()*30))%3];
        p = Utils.clamp((Math.tan((new Timer()).getTimeInSeconds()*10.0)+1.0)/2.0)*0.1+0.9;
    }

    lightIntensity = {
        "ambient": 255*0.4*p,
        "diffuse": 255*0.1*p,
        "specular": 255*p,
        "direction": {"x":xDir, "y":-1.0, "z":zDir}
    };
}
Demo.prototype.addLight = function(start, duration, layer)
{
    this.loader.addAnimation([
    {
         "start": start, "duration": duration, "layer": layer
        ,"light":{"index":0, "action":"begin"}
        ,"lightType": Light.type.DIRECTIONAL
        ,"direction":[
             {"x":"{return lightIntensity.direction.x;}", "y":"{return lightIntensity.direction.y;}", "z":"{return lightIntensity.direction.z;}"}
        ]
        ,"generateShadowMap": false
        ,"specularColor":[
             {"r":"{return lightIntensity.specular;}", "g":"{return lightIntensity.specular;}", "b":"{return lightIntensity.specular;}", "a":255}
        ]
        ,"diffuseColor":[
             {"r":"{return lightIntensity.diffuse;}", "g":"{return lightIntensity.diffuse;}", "b":"{return lightIntensity.diffuse;}", "a":255}
        ]
        ,"ambientColor":[
             {"r":"{return lightIntensity.ambient;}", "g":"{return lightIntensity.ambient;}", "b":"{return lightIntensity.ambient;}", "a":255}
        ]
        ,"runFunction":"{calcLightIntensity();}"
    }]);
}

//var figureMesh = void null;
//var stainMeshTexture = void null;
//var figureShader = void null;
var figures = {
    //sitting chair
    "sitting":{
         "rotation":{"x":0,"y":-90,"z":0}
        ,"position":{"x":-2.3,"y":0.2,"z":-1.5}
        ,"mesh":{
            "rleg": [
                 {"x":0.3,"y":0,"z":0.5}
                ,{"z":-0.5}
                ,{"y":1.5}
                ,{"x":-0.3,"y":0.1,"z":-0.7}
            ]
            ,"lleg": [
                 {"x":-0.3,"y":0,"z":0.5}
                ,{"z":-0.5}
                ,{"y":1.5}
                ,{"x":0.3,"y":0.1,"z":-0.7}
            ]
            ,"body": [
                 {"x":0.0,"y":1.63,"z":-0.7}
                ,{"y":1.5}
            ]
            ,"head": [
                 {"x":0.0,"y":3.1,"z":-0.7}
                ,{"y":0.3,"x":0.3}
                ,{"y":0.3,"x":-0.3}
                ,{"y":-0.3,"x":-0.3}
                ,{"y":-0.3,"x":0.3}
            ]
            ,"rarm": [
                 {"x":0.0,"y":2.8,"z":-0.7}
                ,{"y":-0.7,"x":0.1,"z":0.1}
                ,{"y":-0.7,"x":0.2,"z":0.5}
            ]
            ,"larm": [
                 {"x":0.0,"y":2.8,"z":-0.7}
                ,{"y":-0.7,"x":-0.1,"z":0.1}
                ,{"y":-0.7,"x":-0.2,"z":0.5}
            ]
        }
    }
    ,"standing_middle":{
        "mesh":{
            "rleg": [
                 {"x":0.3,"y":0,"z":0.5}
                ,{"z":-0.5}
                ,{"y":1.2}
                ,{"x":-0.3,"y":0.8,"z":-0.1}
            ]
            ,"lleg": [
                 {"x":-0.3,"y":0,"z":0.5}
                ,{"z":-0.5}
                ,{"y":1.2}
                ,{"x":0.3,"y":0.8,"z":-0.1}
            ]
            ,"body": [
                 {"x":0.0,"y":2,"z":0}
                ,{"y":1.5}
            ]
            ,"head": [
                 {"x":0.0,"y":3.5,"z":0}
                ,{"y":0.3,"x":0.3}
                ,{"y":0.3,"x":-0.3}
                ,{"y":-0.3,"x":-0.3}
                ,{"y":-0.3,"x":0.3}
            ]
            ,"rarm": [
                 {"x":0.0,"y":3.4,"z":0}
                ,{"y":-0.7,"x":0.1,"z":0.3}
                ,{"y":-0.7,"x":0.2,"z":0.2}
            ]
            ,"larm": [
                 {"x":0.0,"y":3.4,"z":0}
                ,{"y":-0.7,"x":-0.1,"z":0.3}
                ,{"y":-0.7,"x":-0.2,"z":0.2}
            ]
        }
    }
    ,"laying":{
         "rotation":{"x":0,"y":-45,"z":-90}
        ,"position":{"x":4,"y":0.7,"z":-7.5}
        ,"mesh":{
            "rleg": [
                 {"x":0.3,"y":0,"z":0.5}
                ,{"z":-0.5}
                ,{"y":1.2}
                ,{"x":-0.3,"y":0.8,"z":-0.1}
            ]
            ,"lleg": [
                 {"x":0.1,"y":0,"z":0.5}
                ,{"z":-0.5}
                ,{"y":1.2}
                ,{"x":-0.1,"y":0.8,"z":-0.1}
            ]
            ,"body": [
                 {"x":0.0,"y":2,"z":0}
                ,{"y":1.5}
            ]
            ,"head": [
                 {"x":0.0,"y":3.5,"z":0}
                ,{"y":0.3,"x":0.3}
                ,{"y":0.3,"x":-0.3}
                ,{"y":-0.3,"x":-0.3}
                ,{"y":-0.3,"x":0.3}
            ]
            ,"rarm": [
                 {"x":0.0,"y":3.4,"z":0}
                ,{"y":-0.7,"x":0.1,"z":0.3}
                ,{"y":-0.7,"x":0.2,"z":0.2}
            ]
            ,"larm": [
                 {"x":-0.0,"y":3.4,"z":0}
                ,{"y":-0.7,"x":0.0,"z":0.3}
                ,{"y":-0.7,"x":0.1,"z":0.2}
            ]
        }
    }
};

function initFigure(animation) {
    /*figureShader = Shader.load({"programName": "Figure", "name":["figure.fs", "figure.vs"]});
    if (figureShader.ptr === void null) {
        loggerFatal("could not load figure shader");
    }*/
    //figureMesh = new Mesh();
    for(var figureName in figures) {
        var figure = figures[figureName];
        figure.ref = new Mesh();
        //stainMeshTexture = imageLoadImage("stain.png");
        //stainMesh.setMaterialTexture(stainMeshTexture);

        var precision = 24;

        //glLineWidth(10);
        var lineMax = 480;
        figure.ref.setFaceDrawType(LINES);

        var iterations = 20;//20;
        var rskew = 0.1;//0.1;
        for(var j = 0; j < iterations; j++) {
            for (var bp in figure.mesh) {
                var arr = figure.mesh[bp];
                //loggerWarning("PRKL " + JSON.stringify(arr, null, 2));
                var rp = {
                    "x":Math.random()*rskew,
                    "y":Math.random()*rskew,
                    "z":Math.random()*rskew
                };
                var p = arr[0];
                var x = p.x+rp.x;
                var y = p.y+rp.y;
                var z = p.z+rp.z;
                for(var i = 1; i < arr.length; i++) {
                    figure.ref.addVertex(x,y,z);
                    rp = {
                        "x":Math.random()*rskew,
                        "y":Math.random()*rskew,
                        "z":Math.random()*rskew
                    };
                    p = arr[i];
                    if (p.x !== void null) {
                        x += p.x+rp.x;
                    }
                    if (p.y !== void null) {
                        y += p.y+rp.y;
                    }
                    if (p.z !== void null) {
                        z += p.z+rp.z;
                    }
                    figure.ref.addVertex(x,y,z);
                }
            }
        }

        //}

        figure.ref.generate();
    }

}

function deinitFigure(animation) {
    for(var figureName in figures) {
        var figure = figures[figureName];
        figure.ref.delete();
    }

    //texturedQuadDeinit(stainMeshTexture.ptr);
}

function drawFigure(animation) {
    glPushMatrix();
    perspective2dEnd();

    //perspective2dBegin(getScreenWidth(), getScreenHeight());
    //glTranslatef(0,5,20);
    //glTranslatef(0,0,-0);
    //glTranslatef(-0.5,0,-20 + 20 * getSceneTimeFromStart()*0.5);
    var figure = animation.figure;

    var position = figure.position;
    if (position !== void null) {
        var x = position.x;
        var y = position.y;
        var z = position.z;

        glTranslatef(x,y,z);
    }
    var rotation = figure.rotation;
    if (rotation !== void null) {
        glRotatef(rotation.x,1,0,0);
        glRotatef(rotation.y,0,1,0);
        glRotatef(rotation.z,0,0,1);
    }
    //glColor4f(1,1,1,(1+Math.sin(getSceneTimeFromStart()*70))/2)
    glColor4f(0.1,0.1,0.1,1.0)
    //var shader = {"shader":{"ref": figureShader}};
    //Shader.enableShader(shader);
    //loggerDebug("DRAW PRKL!");
    figure.ref.draw(0.0,1.0);//0.3+0.8*(1+Math.sin(getSceneTimeFromStart()*10))/2);
    //Shader.disableShader(shader);

    //perspective2dEnd();
    glPopMatrix();
}


var stainMesh = void null;
var stainMeshTexture = void null;

var stainCount = 100;
function initStain(animation) {
    stainMesh = new Mesh();
    stainMeshTexture = imageLoadImage("stain.png");
    stainMesh.setMaterialTexture(stainMeshTexture);

    var precision = 24;

    //glLineWidth(10);
    var lineMax = 480;
    stainMesh.setFaceDrawType(TRIANGLES);

    for(var i = 0; i < stainCount; i++) {
        var x1 = Math.random()*getScreenWidth();
        var y1 = Math.random()*getScreenHeight();
        var size = 10 + Math.random()*90;
        var x2 = x1+size;
        var y2 = y1+size;
        var uMin = 0.0;
        var vMin = 0.0;
        var uMax = 1.0;
        var vMax = 1.0;

        stainMesh.addTexCoord(uMin, vMax);
        stainMesh.addVertex(x1,y2,0);
        stainMesh.addTexCoord(uMin, vMin);
        stainMesh.addVertex(x1,y1,0);
        stainMesh.addTexCoord(uMax, vMax);
        stainMesh.addVertex(x2,y2,0);

        stainMesh.addTexCoord(uMax, vMax);
        stainMesh.addVertex(x2,y2,0);
        stainMesh.addTexCoord(uMin, vMin);
        stainMesh.addVertex(x1,y1,0);
        stainMesh.addTexCoord(uMax, vMin);
        stainMesh.addVertex(x2,y1,0);
    }

    stainMesh.generate();
}

function deinitStain(animation) {
    stainMesh.delete();
    texturedQuadDeinit(stainMeshTexture.ptr);
}

function drawStain(animation) {
    glPushMatrix();

    perspective2dBegin(getScreenWidth(), getScreenHeight());
    var progress = (new Timer()).getTimeInSeconds()/totalDuration;
    progress = Math.floor(progress*stainCount)/100.0;
    glColor4f(1.0,0,0,0.5)
    stainMesh.draw(0.0,progress);

    perspective2dEnd();
    glPopMatrix();
}

Demo.prototype.addContent = function(start, duration, layer)
{
    Sync.addSync(
    [
         { "name":"flicker", "type":"rocket" }
    ]);

    this.loader.setScene("Title", {"useFbo": false});

    this.addLight(start, duration, layer);

    this.loader.addAnimation(
    {
         "start": start, "duration": duration, "layer": layer
        ,"camera": "Clock camera"
        ,"position":[
             {"x":4.5,"y":5.2,"z":-5.5}
            ,{"duration":10,"x":3.5,"y":4.0,"z":-5.0}
        ]
        ,"target":[
            {"x":4.0,"y":5.0,"z":-7.8}
        ]
    });
    this.loader.addAnimation(
    {
         "start": start+12.75, "duration": duration, "layer": layer
        ,"camera": "Whole room view"
        ,"position":[{"x":0.0,"y":1.0,"z":7.9}]
        ,"target":[{"x":0.0,"y":6.0,"z":-7.8}]
        //,"position":[{"x":-7.0,"y":3.0,"z":5.9}]
        //,"target":[{"x":0.0,"y":6.0,"z":0}]
        //,"position":[{"x":6.0,"y":1.0,"z":7.9}]
        //,"target":[{"x":6.0,"y":10.0,"z":-7.8}]
    });

    var tableStart = 49.75;
    this.loader.addAnimation(
    {
         "start": start+tableStart, "duration": duration, "layer": layer
        ,"camera": "Table camera"
        //,"perspective":[{"fov":45.0},{"start":78},{"duration":0.2,"fov":46.0},{"duration":0.2,"fov":45.0}]
        ,"position":[{"x":-7, "y":4.4, "z":-1.8},{"start":78},{"duration":45,"x":8.2,"y":4.8,"z":-0.3}]
        ,"target":[{"x":8.0,"y":3.0,"z":-1.8},{"start":78},{"duration":45,"y":5,"x":9,"z":-0.3}]
    });

    this.loader.addAnimation(
    { 
         "start": start, "duration": duration, "layer": layer
        ,"fbo":{"name":"wallFbo","action":"begin"}
    });

    this.loader.addAnimation({
         "start": start, "duration": duration, "layer": layer
        ,"image": "wall.png"
    });

    var makeFunkyWalls = true;
    if (makeFunkyWalls) {
        this.loader.addAnimation([{
             "start": start, "duration": duration
            ,"layer": layer
            ,"initFunction": "{initStain(animation);}"
            ,"deinitFunction": "{deinitStain(animation);}"
            ,"runFunction": "{drawStain(animation);}"
        }]);

        this.loader.addAnimation({
             "start": start+10, "duration": duration, "layer": layer
            ,"image": "wall_tiles.png"
            ,"shader":{
                "name":"mirrorscroll.fs",
                "variable":[
                      {"name":"speedX","value":[0.2]}
                     ,{"name":"speedY","value":[0.2]}
                ]
            }
            ,"color":[{"a":0},{"duration":1,"a":255}]
        });

        this.addTextFlicker(start+41, 3, layer, "all that lives must die");
        this.addTextFlicker(start+45, 2, layer, "that we shall die we know");
        this.addTextFlicker(start+47, 2, layer, "it's about the time");

        this.addTextFlicker(start+60+39.5, 3, layer, "all that lives must die");
        this.addTextFlicker(start+60+42, 2, layer, "that we shall die we know");
        this.addTextFlicker(start+60+45, 2, layer, "it's about the time");

        //backwall
        this.loader.addAnimation({
             "start": start, "duration": duration, "layer": layer
            ,"position":[{"x":320,"y":173}]
            ,"image": "wall_shade.png"
        });

        //ceiling
        this.loader.addAnimation({
             "start": start, "duration": duration, "layer": layer
            ,"position":[{"x":320,"y":540}]
            ,"image": "ceiling.png"
        });

        //table wall
        this.loader.addAnimation({
             "start": start, "duration": duration, "layer": layer
            ,"position":[{"x":1600,"y":175}]
            ,"image": "wall_shade.png"
        });

        //clock wall
        this.loader.addAnimation({
             "start": start, "duration": duration, "layer": layer
            ,"position":[{"x":1604,"y":540}]
            ,"image": "wall_shade.png"
        });

        //window wall
        this.loader.addAnimation({
             "start": start, "duration": duration, "layer": layer
            ,"scale":[{"uniform2d":1.02}]
            ,"position":[{"x":962,"y":540}]
            ,"image": "wall_shade.png"
        });

        var showFloor = true;
        if (showFloor) {
            this.loader.addAnimation({
                 "start": start, "duration": duration, "layer": layer
                ,"scale":[{"x":0.63,"y":0.52}]
                ,"position":[{"x":960,"y":175}]
                ,"image": "floor.png"
            });

            this.loader.addAnimation({
                 "start": start, "duration": duration, "layer": layer
                ,"scale":[{"uniform2d":0.16}]
                ,"position":[{"x":1000,"y":180}]
                ,"angle":[{"degreesZ":98}]
                ,"image": "carpet.png"
            });
        }
    }

    this.loader.addAnimation(
    { 
         "start": start, "duration": duration, "layer": layer
        ,"fbo":{"name":"wallFbo","action":"unbind"}
    }); 

    /*this.loader.addAnimation({
         "start": start, "duration": duration, "layer": layer
        ,"image": "wallFbo.color.fbo"
    }); return;*/

    this.loader.addAnimation([
    { 
         "start": start, "duration": duration
        ,"layer": layer
        ,"fbo":{"name":"distortionFbo","action":"begin","storeDepth":true}
    }]);

    this.loader.addAnimation(
    {
         "start": start, "duration": duration, "layer": layer
        ,"object": "walls.obj"
    });

    this.loader.addAnimation(
    {
         "start": start, "duration": duration, "layer": layer
        ,"object": "clock.obj"
        ,"scale":[{"uniform3d":1.8}]
        ,"position":[{"x":4,"y":5.0,"z":-7.7}]
        ,"nodes": {
            // minute hand
             "Cube": {
                "angle":[{"degreesZ":"{return getSceneTimeFromStart()*60*10;}"}]
            }
            // hour hand
            ,"Cube.001": {
                "angle":[{"degreesZ":"{return -getSceneTimeFromStart()*60;}"}]
            }
            // second hand
            ,"Cube.002": {
                "angle":[{"degreesZ":"{return getSceneTimeFromStart()*60*8;}"}]
            }
        }
    });

    this.loader.addAnimation(
    {
         "start": start, "duration": duration, "layer": layer
        ,"object": "Table.obj"
        ,"angle":[{"degreesY":90}]
        ,"position":[{"x":-5, "y":0.35, "z":-1.5}]
        ,"scale":[{"uniform3d":1.2}]
    });

    this.loader.addAnimation(
    {
         "start": start, "duration": duration, "layer": layer
        ,"object": "Table.obj"
        ,"angle":[{"degreesY":90}]
        ,"position":[{"x":-5, "y":0.35, "z":-1.5}]
        ,"scale":[{"uniform3d":1.2}]
        ,"shader":{"name":["fakest_shadow.fs","fakest_shadow.vs"]}
    });


    this.loader.addAnimation(
    {
         "start": start, "duration": duration, "layer": layer
        ,"object": "wall_lamp.obj"
        ,"position":[{"x":0, "y":7.0, "z":-0.5}]
        ,"scale":[{"x":5, "y":2.5, "z":2.5}]
        ,"angle":[{"degreesY":90}]
    });

    this.loader.addAnimation(
    {
         "start": start, "duration": duration, "layer": layer
        ,"object": "fluorescent.obj"
        ,"position":[{"x":0, "y":6.87, "z":-0.5}]
        ,"scale":[{"x":5, "y":2.5, "z":2.5}]
        ,"angle":[{"degreesY":90}]
        ,"shader":{"name":"fluorescent.fs"}
    });

    this.loader.addAnimation(
    {
         "start": start, "duration": duration, "layer": layer
        ,"object": "chair.obj"
        ,"angle":[{"degreesY":70}]
        ,"position":[{"x":-2.0, "y":0.0, "z":-1.5}]
        ,"scale":[{"uniform3d":1.5}]
    });


    this.loader.addAnimation(
    {
         "start": start, "duration": duration, "layer": layer
        ,"object": "chair.obj"
        ,"angle":[{"degreesY":70}]
        ,"position":[{"x":-2.0, "y":0.3, "z":-1.5}]
        ,"scale":[{"uniform3d":1.5}]
        ,"shader":{"name":["fakest_shadow.fs","fakest_shadow.vs"]}
    });

    this.loader.addAnimation(
    {
         "start": start, "duration": duration, "layer": layer
        ,"object": "window.obj"
        ,"position":[{"x":7.8, "y":5.0, "z":0.0}]
        ,"scale":[{"uniform2d":2.5}]
        ,"angle":[{"degreesY":90}]
    });

    this.loader.addAnimation([{
         "start": start+12, "duration": 4
        ,"layer": layer
        //,"figure": figures.sitting
        //,"figure": figures.standing_middle
        ,"figure": figures.laying
        ,"initFunction": "{initFigure(animation);}"
        ,"deinitFunction": "{deinitFigure(animation);}"
        ,"runFunction": "{drawFigure(animation);}"
        ,"shader":{"name":["figure.fs","figure.vs"]}
    }]);
    this.loader.addAnimation([{
         "start": start+20.5, "duration": 4
        ,"layer": layer
        ,"figure": figures.standing_middle
        ,"runFunction": "{drawFigure(animation);}"
        ,"shader":{"name":["figure.fs","figure.vs"]}
    }]);
    this.loader.addAnimation([{
         "start": start+31, "duration": 4
        ,"layer": layer
        ,"figure": figures.laying
        ,"runFunction": "{drawFigure(animation);}"
        ,"shader":{"name":["figure.fs","figure.vs"]}
    }]);
    this.loader.addAnimation([{
         "start": start+tableStart, "duration": 50
        ,"layer": layer
        ,"figure": figures.sitting
        ,"runFunction": "{drawFigure(animation);}"
        ,"shader":{"name":["figure.fs","figure.vs"]}
    }]);
    this.loader.addAnimation([{
         "start": start+tableStart+2, "duration": 6
        ,"layer": layer
        ,"figure": figures.laying
        ,"runFunction": "{drawFigure(animation);}"
        ,"shader":{"name":["figure.fs","figure.vs"]}
    }]);
    this.loader.addAnimation([{
         "start": start+tableStart+4, "duration": 6
        ,"layer": layer
        ,"figure": figures.standing_middle
        ,"runFunction": "{drawFigure(animation);}"
        ,"shader":{"name":["figure.fs","figure.vs"]}
    }]);
    this.loader.addAnimation([{
         "start": start+85, "duration": 20
        ,"layer": layer
        ,"figure": figures.laying
        ,"runFunction": "{drawFigure(animation);}"
        ,"shader":{"name":["figure.fs","figure.vs"]}
    }]);

    this.loader.addAnimation(
    {
         "start": start+16, "duration": 3, "layer": layer
        ,"text":{
             "name":"LCD-BOLD.TTF"
            ,"string":"{return getWeirdClockDigits(0.25, 24, 60);}"
        }
        ,"color": [
              {"r":0xDD,"g":0x20,"b":0x20}
        ]
        ,"angle":[{"degreesZ":0}]
        ,"scale": [{"uniform2d":16.0}]
        ,"position":[
            {"x":getScreenWidth()/2.0,"y":getScreenHeight()/2.0}
        ]
    });
    this.loader.addAnimation(
    {
         "start": start+20.5, "duration": 4, "layer": layer
        ,"text":{
             "name":"LCD-BOLD.TTF"
            ,"string":"{return getWeirdClockDigits(0.125, 24, 60);}"
        }
        ,"color": [
              {"r":0xDD,"g":0x20,"b":0x20}
        ]
        ,"angle":[{"degreesZ":0}]
        ,"scale": [{"uniform2d":16.0}]
        ,"position":[
            {"x":getScreenWidth()/2.0,"y":getScreenHeight()/2.0}
        ]
    });
    this.loader.addAnimation(
    {
         "start": start+31, "duration": 4, "layer": layer
        ,"text":{
             "name":"LCD-BOLD.TTF"
            ,"string":"{return getWeirdClockDigits(0.05, 99, 99);}"
        }
        ,"color": [
              {"r":0xDD,"g":0x20,"b":0x20}
        ]
        ,"angle":[{"degreesZ":0}]
        ,"scale": [{"uniform2d":16.0}]
        ,"position":[
            {"x":getScreenWidth()/2.0,"y":getScreenHeight()/2.0}
        ]
    });

    var postprocs = true;
    if (postprocs) {
        var videos = true;
        if (videos) {
            this.loader.addAnimation({
                 "start": start, "duration":25
                ,"layer": layer, "image": {"name":"videos/eye_03.ogg", "video":{"speed":.9} }
                ,"scale":[{"x":3.0,"y":3.0}]
                ,"color":[{"a":60}]
            });
            this.loader.addAnimation({
                 "start": start+24, "duration": (tableStart-24) //real:34
                ,"layer": layer, "image": {"name":"videos/schizo_01.ogg", "video":{"speed":1.2} }
                ,"scale":[{"x":3.0,"y":3.0}]
                ,"color":[{"a":80}]
            });
            this.loader.addAnimation({
                 "start": start+tableStart, "duration":30/1.5
                ,"layer": layer, "image": {"name":"videos/schizo_05.ogg", "video":{"speed":1.5} }
                ,"scale":[{"x":3.0,"y":3.0}]
                ,"color":[{"a":80}]
            });
            this.loader.addAnimation({
                 "start": start+tableStart+30/1.5, "duration":22/0.4
                ,"layer": layer, "image": {"name":"videos/schizo_03.ogg", "video":{"speed":0.4} }
                ,"scale":[{"x":3.0,"y":3.0}]
                ,"color":[{"a":80}]
            });
        }
        this.loader.addAnimation(
        { 
             "start": start, "duration": duration
            ,"layer": layer
            ,"fbo":{"name":"distortionFbo","action":"unbind"}
        });

        this.loader.addAnimation({
             "start": start, "duration": duration, "layer": layer
            ,"image": ["distortionFbo.color.fbo","distortionFbo.depth.fbo"]
            ,"shader":{
                "name":"distortion.fs", "variable":[
                      {"name":"distortionResolutionX","value":[1]}
                     ,{"name":"distortionResolutionY","value":[1]}
                     ,{"name":"distortionX","value":[0.02]}
                     ,{"name":"distortionY","value":[0.02]}
                     ,{"name":"distortionSpeed","value":[2.0]}
                     ,{"name":"shakeSizeY","value":[0.0005]}
                     ,{"name":"glitchSize","value":[0.0001]}
                     ,{"name":"noiseAlpha","value":[0.03]}
                ]
            }
        });
        this.loader.addAnimation([{
             "start": start, "duration": duration, "layer": layer
            ,"image": "vignette.png"
            ,"color":[{"a":200}]
        }]);
    } else {
        this.loader.addAnimation(
        { 
             "start": start, "duration": duration
            ,"layer": layer
            ,"fbo":{"name":"distortionFbo","action":"end"}
        });        
    }

    this.loader.addAnimation([{
         "start": start+duration-5, "duration": 6, "layer": layer
        ,"image": "_embedded/defaultWhite.png"
        ,"scale":[{"uniform2d":2.0}]
        ,"color":[{"r":0,"g":0,"b":0,"a":0},{"duration":4.5,"a":255}]
    }]);
}

Demo.prototype.init = function()
{
    var start = 0;
    var layer = 1;

    this.addContent(start, totalDuration, layer);
}
