#version 330 core

#define MAX_LIGHTS 4

#define LIGHT_DIRECTIONAL 1
#define LIGHT_POINT 2
#define LIGHT_SPOT 3

layout(location = 0) in vec3 vertexPosition;
layout(location = 1) in vec2 vertexTexCoord;
layout(location = 2) in vec3 vertexNormal;
layout(location = 3) in vec4 vertexColor;

out vec2 texCoord;
out vec4 vertexFragColor;

uniform mat4 mvp;
uniform float time = 1.0;

float rand(vec3 coord)
{
    return fract(sin(dot(coord.st,vec2(12.9898,78.233)+time)) * 43758.5453);
}

void main(void)
{
    vec4 position = vec4(vertexPosition+rand(vertexPosition.xyz)*0.3, 1);
    gl_Position = mvp * position;
    texCoord = vertexTexCoord;
    vertexFragColor = vertexColor;
} 
