/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extensions;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.Extension;
import org.openrndr.KeyboardModifier;
import org.openrndr.Program;
import org.openrndr.color.ColorRGBa;
import org.openrndr.draw.DrawPrimitive;
import org.openrndr.draw.Drawer;
import org.openrndr.draw.DrawerKt;
import org.openrndr.draw.VertexBuffer;
import org.openrndr.extensions.Debug3D;
import org.openrndr.extensions.Debug3D$WhenMappings;
import org.openrndr.extensions.OrbitalCamera;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 %2\u00020\u0001:\u0001%B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010#\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010$\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u001a\u0010\b\u001a\u00020\tX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0011X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/openrndr/extensions/Debug3D;", "Lorg/openrndr/Extension;", "eye", "Lorg/openrndr/math/Vector3;", "lookAt", "fov", "", "(Lorg/openrndr/math/Vector3;Lorg/openrndr/math/Vector3;D)V", "enabled", "", "getEnabled", "()Z", "setEnabled", "(Z)V", "grid", "Lorg/openrndr/draw/VertexBuffer;", "lastMousePosition", "Lorg/openrndr/math/Vector2;", "lastSeconds", "orbitalCamera", "Lorg/openrndr/extensions/OrbitalCamera;", "state", "Lorg/openrndr/extensions/Debug3D$Companion$STATE;", "windowSize", "afterDraw", "", "drawer", "Lorg/openrndr/draw/Drawer;", "program", "Lorg/openrndr/Program;", "beforeDraw", "mouseButtonDown", "event", "Lorg/openrndr/Program$Mouse$MouseEvent;", "mouseMoved", "mouseScrolled", "setup", "Companion", "openrndr-extensions"})
public final class Debug3D
implements Extension {
    private boolean enabled;
    private final OrbitalCamera orbitalCamera;
    private Companion.STATE state;
    private double lastSeconds;
    private Vector2 lastMousePosition;
    private Vector2 windowSize;
    private final VertexBuffer grid;
    private final double fov;
    public static final Companion Companion = new Companion(null);

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    @Override
    public void setup(@NotNull Program program) {
        Intrinsics.checkParameterIsNotNull(program, "program");
        this.windowSize = program.getWindow().getSize();
        program.getMouse().getMoved().listen(new Function1<Program.Mouse.MouseEvent, Unit>(this){
            final /* synthetic */ Debug3D this$0;

            public final void invoke(@NotNull Program.Mouse.MouseEvent it2) {
                Intrinsics.checkParameterIsNotNull(it2, "it");
                Debug3D.access$mouseMoved(this.this$0, it2);
            }
            {
                this.this$0 = debug3D;
                super(1);
            }
        });
        program.getMouse().getButtonDown().listen(new Function1<Program.Mouse.MouseEvent, Unit>(this){
            final /* synthetic */ Debug3D this$0;

            public final void invoke(@NotNull Program.Mouse.MouseEvent it2) {
                Intrinsics.checkParameterIsNotNull(it2, "it");
                Debug3D.access$mouseButtonDown(this.this$0, it2);
            }
            {
                this.this$0 = debug3D;
                super(1);
            }
        });
        program.getMouse().getButtonUp().listen(new Function1<Program.Mouse.MouseEvent, Unit>(this){
            final /* synthetic */ Debug3D this$0;

            public final void invoke(@NotNull Program.Mouse.MouseEvent it2) {
                Intrinsics.checkParameterIsNotNull(it2, "it");
                Debug3D.access$setState$p(this.this$0, Companion.STATE.NONE);
            }
            {
                this.this$0 = debug3D;
                super(1);
            }
        });
        program.getMouse().getScrolled().listen(new Function1<Program.Mouse.MouseEvent, Unit>(this){
            final /* synthetic */ Debug3D this$0;

            public final void invoke(@NotNull Program.Mouse.MouseEvent it2) {
                Intrinsics.checkParameterIsNotNull(it2, "it");
                Debug3D.access$mouseScrolled(this.this$0, it2);
            }
            {
                this.this$0 = debug3D;
                super(1);
            }
        });
    }

    @Override
    public void beforeDraw(@NotNull Drawer drawer, @NotNull Program program) {
        Intrinsics.checkParameterIsNotNull(drawer, "drawer");
        Intrinsics.checkParameterIsNotNull(program, "program");
        if (this.lastSeconds == -1.0) {
            this.lastSeconds = program.getSeconds();
        }
        double delta = program.getSeconds() - this.lastSeconds;
        this.lastSeconds = program.getSeconds();
        this.orbitalCamera.update(delta);
        drawer.background(ColorRGBa.Companion.getBLACK());
        Vector2 vector2 = this.windowSize;
        if (vector2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("windowSize");
        }
        double d = vector2.getX();
        Vector2 vector22 = this.windowSize;
        if (vector22 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("windowSize");
        }
        drawer.perspective(this.fov, d / vector22.getY(), 0.1, 1000.0);
        drawer.setView(this.orbitalCamera.viewMatrix());
        DrawerKt.isolated(drawer, (Function1<? super Drawer, Unit>)new Function1<Drawer, Unit>(this, drawer){
            final /* synthetic */ Debug3D this$0;
            final /* synthetic */ Drawer $drawer;

            public final void invoke(@NotNull Drawer $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                this.$drawer.setFill(ColorRGBa.Companion.getWHITE());
                this.$drawer.setStroke(ColorRGBa.Companion.getWHITE());
                Drawer.vertexBuffer$default(this.$drawer, Debug3D.access$getGrid$p(this.this$0), DrawPrimitive.LINES, 0, 0, 12, null);
                this.$drawer.setFill(ColorRGBa.Companion.getRED());
                this.$drawer.lineSegment(Vector3.Companion.getZERO(), Vector3.Companion.getUNIT_X());
                this.$drawer.setFill(ColorRGBa.Companion.getGREEN());
                this.$drawer.lineSegment(Vector3.Companion.getZERO(), Vector3.Companion.getUNIT_Y());
                this.$drawer.setFill(ColorRGBa.Companion.getBLUE());
                this.$drawer.lineSegment(Vector3.Companion.getZERO(), Vector3.Companion.getUNIT_Z());
            }
            {
                this.this$0 = debug3D;
                this.$drawer = drawer;
                super(1);
            }
        });
    }

    @Override
    public void afterDraw(@NotNull Drawer drawer, @NotNull Program program) {
        Intrinsics.checkParameterIsNotNull(drawer, "drawer");
        Intrinsics.checkParameterIsNotNull(program, "program");
        DrawerKt.isolated(drawer, (Function1<? super Drawer, Unit>)new Function1<Drawer, Unit>(drawer){
            final /* synthetic */ Drawer $drawer;

            public final void invoke(@NotNull Drawer $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                this.$drawer.setView(Matrix44.Companion.getIDENTITY());
                this.$drawer.ortho();
            }
            {
                this.$drawer = drawer;
                super(1);
            }
        });
    }

    private final void mouseScrolled(Program.Mouse.MouseEvent event) {
        if (Math.abs(event.getRotation().getX()) > 0.1) {
            return;
        }
        if (event.getRotation().getY() > 0.0) {
            this.orbitalCamera.dollyIn();
        } else if (event.getRotation().getY() < 0.0) {
            this.orbitalCamera.dollyOut();
        }
    }

    private final void mouseMoved(Program.Mouse.MouseEvent event) {
        if (Intrinsics.areEqual((Object)this.state, (Object)Companion.STATE.NONE)) {
            return;
        }
        Vector2 vector2 = this.lastMousePosition;
        if (vector2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("lastMousePosition");
        }
        Vector2 delta = vector2.minus(event.getPosition());
        this.lastMousePosition = event.getPosition();
        if (event.getModifiers().contains((Object)KeyboardModifier.SHIFT)) {
            Vector3 offset = Vector3.Companion.fromSpherical(this.orbitalCamera.getSpherical()).minus(this.orbitalCamera.getLookAt());
            double targetDistance = offset.getLength() * Math.tan(this.fov / (double)2 * Math.PI / (double)180);
            double d = (double)2 * delta.getX() * targetDistance;
            Vector2 vector22 = this.windowSize;
            if (vector22 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("windowSize");
            }
            double panX = d / vector22.getX();
            double d2 = (double)2 * delta.getY() * targetDistance;
            Vector2 vector23 = this.windowSize;
            if (vector23 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("windowSize");
            }
            double panY = d2 / vector23.getX();
            this.orbitalCamera.pan(panX, panY);
        } else {
            double d = Math.PI * 2 * delta.getX();
            Vector2 vector24 = this.windowSize;
            if (vector24 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("windowSize");
            }
            double rotX = d / vector24.getX();
            double d3 = Math.PI * 2 * delta.getY();
            Vector2 vector25 = this.windowSize;
            if (vector25 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("windowSize");
            }
            double rotY = d3 / vector25.getX();
            this.orbitalCamera.rotateTo(rotX, rotY);
        }
    }

    private final void mouseButtonDown(Program.Mouse.MouseEvent event) {
        Companion.STATE previousState = this.state;
        switch (Debug3D$WhenMappings.$EnumSwitchMapping$0[event.getButton().ordinal()]) {
            case 1: {
                this.state = Companion.STATE.ROTATE;
                break;
            }
            case 2: {
                this.state = Companion.STATE.PAN;
            }
        }
        if (Intrinsics.areEqual((Object)previousState, (Object)Companion.STATE.NONE)) {
            this.lastMousePosition = event.getPosition();
        }
    }

    public Debug3D(@NotNull Vector3 eye, @NotNull Vector3 lookAt, double fov) {
        VertexBuffer vertexBuffer;
        Intrinsics.checkParameterIsNotNull(eye, "eye");
        Intrinsics.checkParameterIsNotNull(lookAt, "lookAt");
        this.fov = fov;
        this.enabled = true;
        this.orbitalCamera = new OrbitalCamera(eye, lookAt);
        this.state = Companion.STATE.NONE;
        this.lastSeconds = -1.0;
        VertexBuffer vertexBuffer2 = DrawerKt.vertexBuffer(DrawerKt.vertexFormat(grid.1.INSTANCE), 84);
        Debug3D debug3D = this;
        VertexBuffer $receiver = vertexBuffer2;
        $receiver.put(grid.2.1.INSTANCE);
        debug3D.grid = vertexBuffer = vertexBuffer2;
    }

    public /* synthetic */ Debug3D(Vector3 vector3, Vector3 vector32, double d, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            vector32 = Vector3.Companion.getZERO();
        }
        if ((n2 & 4) != 0) {
            d = 90.0;
        }
        this(vector3, vector32, d);
    }

    public static final /* synthetic */ void access$mouseMoved(Debug3D $this, @NotNull Program.Mouse.MouseEvent event) {
        $this.mouseMoved(event);
    }

    public static final /* synthetic */ void access$mouseButtonDown(Debug3D $this, @NotNull Program.Mouse.MouseEvent event) {
        $this.mouseButtonDown(event);
    }

    @NotNull
    public static final /* synthetic */ Companion.STATE access$getState$p(Debug3D $this) {
        return $this.state;
    }

    public static final /* synthetic */ void access$setState$p(Debug3D $this, @NotNull Companion.STATE sTATE) {
        $this.state = sTATE;
    }

    public static final /* synthetic */ void access$mouseScrolled(Debug3D $this, @NotNull Program.Mouse.MouseEvent event) {
        $this.mouseScrolled(event);
    }

    @NotNull
    public static final /* synthetic */ VertexBuffer access$getGrid$p(Debug3D $this) {
        return $this.grid;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lorg/openrndr/extensions/Debug3D$Companion;", "", "()V", "STATE", "openrndr-extensions"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/openrndr/extensions/Debug3D$Companion$STATE;", "", "(Ljava/lang/String;I)V", "NONE", "ROTATE", "PAN", "openrndr-extensions"})
        public static final class STATE
        extends Enum<STATE> {
            public static final /* enum */ STATE NONE;
            public static final /* enum */ STATE ROTATE;
            public static final /* enum */ STATE PAN;
            private static final /* synthetic */ STATE[] $VALUES;

            static {
                STATE[] sTATEArray = new STATE[3];
                STATE[] sTATEArray2 = sTATEArray;
                sTATEArray[0] = NONE = new STATE();
                sTATEArray[1] = ROTATE = new STATE();
                sTATEArray[2] = PAN = new STATE();
                $VALUES = sTATEArray;
            }

            public static STATE[] values() {
                return (STATE[])$VALUES.clone();
            }

            public static STATE valueOf(String string) {
                return Enum.valueOf(STATE.class, string);
            }
        }
    }
}

