/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extensions;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Spherical;
import org.openrndr.math.Vector3;
import org.openrndr.math.transforms.TransformsKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 -2\u00020\u0001:\u0001-B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020\u001fJ\u0010\u0010!\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020\u0007H\u0002J\u0016\u0010#\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\u0007J\u0016\u0010&\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020\u00072\u0006\u0010(\u001a\u00020\u0007J\u000e\u0010)\u001a\u00020\u001f2\u0006\u0010*\u001a\u00020\u0007J\u0006\u0010+\u001a\u00020,R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u0014@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\t\"\u0004\b\u001d\u0010\u000b\u00a8\u0006."}, d2={"Lorg/openrndr/extensions/OrbitalCamera;", "", "eye", "Lorg/openrndr/math/Vector3;", "lookAt", "(Lorg/openrndr/math/Vector3;Lorg/openrndr/math/Vector3;)V", "dampingFactor", "", "getDampingFactor", "()D", "setDampingFactor", "(D)V", "dirty", "", "<set-?>", "getLookAt", "()Lorg/openrndr/math/Vector3;", "setLookAt", "(Lorg/openrndr/math/Vector3;)V", "lookAtEnd", "Lorg/openrndr/math/Spherical;", "spherical", "getSpherical", "()Lorg/openrndr/math/Spherical;", "setSpherical", "(Lorg/openrndr/math/Spherical;)V", "sphericalEnd", "zoomSpeed", "getZoomSpeed", "setZoomSpeed", "dollyIn", "", "dollyOut", "dollyTo", "distance", "pan", "x", "y", "rotateTo", "rotX", "rotY", "update", "timeDelta", "viewMatrix", "Lorg/openrndr/math/Matrix44;", "Companion", "openrndr-extensions"})
final class OrbitalCamera {
    @NotNull
    private Spherical spherical;
    @NotNull
    private Vector3 lookAt;
    private Spherical sphericalEnd;
    private Vector3 lookAtEnd;
    private boolean dirty;
    private double dampingFactor;
    private double zoomSpeed;
    private static final double EPSILON = 1.0E-6;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Spherical getSpherical() {
        return this.spherical;
    }

    private final void setSpherical(Spherical spherical) {
        this.spherical = spherical;
    }

    @NotNull
    public final Vector3 getLookAt() {
        return this.lookAt;
    }

    private final void setLookAt(Vector3 vector3) {
        this.lookAt = vector3;
    }

    public final double getDampingFactor() {
        return this.dampingFactor;
    }

    public final void setDampingFactor(double d) {
        this.dampingFactor = d;
    }

    public final double getZoomSpeed() {
        return this.zoomSpeed;
    }

    public final void setZoomSpeed(double d) {
        this.zoomSpeed = d;
    }

    public final void rotateTo(double rotX, double rotY) {
        this.sphericalEnd = this.sphericalEnd.plus(new Spherical(0.0, rotX, rotY));
        this.sphericalEnd = this.sphericalEnd.makeSafe();
        this.dirty = true;
    }

    public final void dollyIn() {
        double zoomScale = Math.pow(0.95, this.zoomSpeed);
        this.dollyTo(this.sphericalEnd.getRadius() * zoomScale - this.sphericalEnd.getRadius());
    }

    public final void dollyOut() {
        double zoomScale = Math.pow(0.95, this.zoomSpeed);
        this.dollyTo(this.sphericalEnd.getRadius() / zoomScale - this.sphericalEnd.getRadius());
    }

    private final void dollyTo(double distance) {
        this.sphericalEnd = this.sphericalEnd.plus(new Spherical(distance, 0.0, 0.0));
        this.dirty = true;
    }

    public final void pan(double x, double y) {
        Matrix44 view = this.viewMatrix();
        Vector3 xColumn = new Vector3(view.getC0r0(), view.getC0r1(), view.getC0r2()).times(x);
        Vector3 yColumn = new Vector3(view.getC1r0(), view.getC1r1(), view.getC1r2()).times(-y);
        this.lookAtEnd = this.lookAtEnd.plus(xColumn.plus(yColumn));
        this.dirty = true;
    }

    public final void update(double timeDelta) {
        if (!this.dirty) {
            return;
        }
        this.dirty = false;
        double dampingFactor = this.dampingFactor * timeDelta / 0.006;
        Spherical sphericalDelta = this.sphericalEnd.minus(this.spherical);
        Vector3 lookAtDelta = this.lookAtEnd.minus(this.lookAt);
        if (Math.abs(this.sphericalEnd.getRadius()) > 1.0E-6 || Math.abs(this.sphericalEnd.getTheta()) > 1.0E-6 || Math.abs(this.sphericalEnd.getPhi()) > 1.0E-6 || Math.abs(lookAtDelta.getX()) > 1.0E-6 || Math.abs(lookAtDelta.getY()) > 1.0E-6 || Math.abs(lookAtDelta.getZ()) > 1.0E-6) {
            this.spherical = this.spherical.plus(sphericalDelta.times(dampingFactor));
            this.lookAt = this.lookAt.plus(lookAtDelta.times(dampingFactor));
            this.dirty = true;
        } else {
            this.spherical = Spherical.copy$default(this.sphericalEnd, 0.0, 0.0, 0.0, 7, null);
            this.lookAt = Vector3.copy$default(this.lookAtEnd, 0.0, 0.0, 0.0, 7, null);
        }
        this.spherical = this.spherical.makeSafe();
    }

    @NotNull
    public final Matrix44 viewMatrix() {
        return TransformsKt.lookAt(Vector3.Companion.fromSpherical(this.spherical).plus(this.lookAt), this.lookAt, Vector3.Companion.getUNIT_Y());
    }

    public OrbitalCamera(@NotNull Vector3 eye, @NotNull Vector3 lookAt) {
        Intrinsics.checkParameterIsNotNull(eye, "eye");
        Intrinsics.checkParameterIsNotNull(lookAt, "lookAt");
        this.spherical = Spherical.Companion.fromVector(eye);
        this.lookAt = lookAt;
        this.sphericalEnd = Spherical.Companion.fromVector(eye);
        this.lookAtEnd = Vector3.copy$default(lookAt, 0.0, 0.0, 0.0, 7, null);
        this.dirty = true;
        this.dampingFactor = 0.05;
        this.zoomSpeed = 1.0;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/openrndr/extensions/OrbitalCamera$Companion;", "", "()V", "EPSILON", "", "openrndr-extensions"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

