/*
 * Decompiled with CFR 0.152.
 */
package scenes;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import modeling.Box;
import modeling.OBJLoaderKt;
import modeling.Triangle;
import org.jetbrains.annotations.NotNull;
import org.openrndr.draw.BufferWriter;
import org.openrndr.draw.Cubemap;
import org.openrndr.draw.CullTestPass;
import org.openrndr.draw.DrawPrimitive;
import org.openrndr.draw.Drawer;
import org.openrndr.draw.DrawerKt;
import org.openrndr.draw.RenderTarget;
import org.openrndr.draw.ShadeStyle;
import org.openrndr.draw.ShadeStyleKt;
import org.openrndr.draw.VertexBuffer;
import org.openrndr.draw.VertexFormat;
import org.openrndr.math.Matrix44;
import org.openrndr.math.transforms.TransformBuilder;
import org.openrndr.math.transforms.TransformBuilderKt;
import rndr.studio.demo.shading.FunctionsKt;
import scenes.CrowdIntro;
import scenes.RenderStyle;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u0016\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001b"}, d2={"Lscenes/CrowdIntro;", "", "()V", "irradiance", "Lorg/openrndr/draw/Cubemap;", "getIrradiance", "()Lorg/openrndr/draw/Cubemap;", "persons", "", "Lorg/openrndr/draw/VertexBuffer;", "getPersons", "()Ljava/util/List;", "previousModelView", "Lorg/openrndr/math/Matrix44;", "getPreviousModelView", "()Lorg/openrndr/math/Matrix44;", "setPreviousModelView", "(Lorg/openrndr/math/Matrix44;)V", "draw", "", "drawer", "Lorg/openrndr/draw/Drawer;", "time", "", "renderStyle", "Lscenes/RenderStyle;", "drawShadow", "demo-strap"})
public final class CrowdIntro {
    @NotNull
    private final List<VertexBuffer> persons;
    @NotNull
    private final Cubemap irradiance;
    @NotNull
    private Matrix44 previousModelView;

    @NotNull
    public final List<VertexBuffer> getPersons() {
        return this.persons;
    }

    @NotNull
    public final Cubemap getIrradiance() {
        return this.irradiance;
    }

    @NotNull
    public final Matrix44 getPreviousModelView() {
        return this.previousModelView;
    }

    public final void setPreviousModelView(@NotNull Matrix44 matrix44) {
        Intrinsics.checkParameterIsNotNull(matrix44, "<set-?>");
        this.previousModelView = matrix44;
    }

    public final void drawShadow(@NotNull Drawer drawer, double time) {
        Intrinsics.checkParameterIsNotNull(drawer, "drawer");
        DrawerKt.isolated(drawer, (Function1<? super Drawer, Unit>)new Function1<Drawer, Unit>(this, drawer){
            final /* synthetic */ CrowdIntro this$0;
            final /* synthetic */ Drawer $drawer;

            public final void invoke(@NotNull Drawer $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                this.$drawer.setCullTestPass(CullTestPass.BACK);
                this.$drawer.setShadeStyle(ShadeStyleKt.shadeStyle(drawShadow.1.INSTANCE));
                for (VertexBuffer person : this.this$0.getPersons()) {
                    Drawer.vertexBuffer$default($receiver, person, DrawPrimitive.TRIANGLES, 0, 0, 12, null);
                    this.$drawer.translate(10.0, 0.0, 0.0);
                }
            }
            {
                this.this$0 = crowdIntro;
                this.$drawer = drawer;
                super(1);
            }
        });
    }

    public final void draw(@NotNull Drawer drawer, double time, @NotNull RenderStyle renderStyle) {
        Intrinsics.checkParameterIsNotNull(drawer, "drawer");
        Intrinsics.checkParameterIsNotNull(renderStyle, "renderStyle");
        RenderTarget gbuffer = RenderTarget.Companion.getActive();
        DrawerKt.isolated(drawer, (Function1<? super Drawer, Unit>)new Function1<Drawer, Unit>(this, drawer, renderStyle, gbuffer, time){
            final /* synthetic */ CrowdIntro this$0;
            final /* synthetic */ Drawer $drawer;
            final /* synthetic */ RenderStyle $renderStyle;
            final /* synthetic */ RenderTarget $gbuffer;
            final /* synthetic */ double $time;

            public final void invoke(@NotNull Drawer $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                this.$drawer.setShadeStyle(ShadeStyleKt.shadeStyle((Function1<? super ShadeStyle, Unit>)new Function1<ShadeStyle, Unit>(this){
                    final /* synthetic */ draw.1 this$0;

                    public final void invoke(@NotNull ShadeStyle $receiver) {
                        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                        $receiver.setVertexPreamble("\n                    out vec4 previousView;\n                    out vec4 previousClip;\n                    out vec4 currentClip;\n                ");
                        $receiver.setFragmentPreamble("\n                    in vec4 previousView;\n                    in vec4 previousClip;\n                    in vec4 currentClip;\n                    " + FunctionsKt.getShadowOrthoFunction() + "\n                ");
                        $receiver.setVertexTransform("\n                    previousView = (p_previousModelView * u_modelMatrix * vec4(x_position,1.0));\n                    previousClip = u_projectionMatrix * previousView;\n                    currentClip = u_projectionMatrix * u_viewMatrix * u_modelMatrix * vec4(x_position, 1.0);\n                ");
                        $receiver.setFragmentTransform("\n                    x_fill.rgb *= pow(texture(p_irradiance, normalize(v_worldNormal)).rgb, vec3(1.0));\n\n                    o_normal.xyz = v_viewNormal;\n                    o_normal.w = 1.0;\n                    o_position.xyz = v_viewPosition;\n                    o_position.w = 1.0;\n\n                    vec3 viewDirection = normalize(inverse(mat3(u_viewNormalMatrix)) * v_viewPosition);\n                    vec3 s = reflect(v_worldNormal, viewDirection) * max(0.0, dot(normalize(v_viewNormal), normalize(viewDirection)));\n                    x_fill.rgb += texture(p_irradiance, normalize(s)).rgb * max(0.0, s.y);\n\n\n                    " + (this.this$0.$renderStyle.getLights().size() > 0 ? "\n                        float shadow = shadowOrtho(p_lightMap, v_worldPosition, v_worldNormal, p_lightProj, p_lightView);\n                        x_fill.rgb *= (0.5 + 0.5 * shadow);\n                        " : "") + "\n                    o_velocity.xy = (currentClip/currentClip.w - previousClip/previousClip.w).xy*vec2(1280, 720)*0.08;\n                    ");
                        $receiver.output("position", this.this$0.$gbuffer.colorBufferIndex("position"));
                        $receiver.output("normal", this.this$0.$gbuffer.colorBufferIndex("normal"));
                        $receiver.output("velocity", this.this$0.$gbuffer.colorBufferIndex("velocity"));
                        $receiver.parameter("time", this.this$0.$time);
                        $receiver.parameter("cut", Math.cos(this.this$0.$time) * 1.0 + 1.0);
                        $receiver.parameter("irradiance", this.this$0.this$0.getIrradiance());
                        $receiver.parameter("previousModelView", this.this$0.this$0.getPreviousModelView());
                        if (this.this$0.$renderStyle.getLights().size() > 0) {
                            $receiver.parameter("lightMap", this.this$0.$renderStyle.getLights().get(0).getMap());
                            $receiver.parameter("lightProj", this.this$0.$renderStyle.getLights().get(0).getProjection());
                            $receiver.parameter("lightView", this.this$0.$renderStyle.getLights().get(0).getView());
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }));
                Matrix44 m = Matrix44.Companion.getIDENTITY();
                for (VertexBuffer person : this.this$0.getPersons()) {
                    Drawer.vertexBuffer$default($receiver, person, DrawPrimitive.TRIANGLES, 0, 0, 12, null);
                    this.$drawer.translate(10.0, 0.0, 0.0);
                }
                this.this$0.setPreviousModelView(this.$drawer.getView());
            }
            {
                this.this$0 = crowdIntro;
                this.$drawer = drawer;
                this.$renderStyle = renderStyle;
                this.$gbuffer = renderTarget;
                this.$time = d;
                super(1);
            }
        });
    }

    public static /* bridge */ /* synthetic */ void draw$default(CrowdIntro crowdIntro, Drawer drawer, double d, RenderStyle renderStyle, int n2, Object object) {
        if ((n2 & 2) != 0) {
            d = 0.0;
        }
        crowdIntro.draw(drawer, d, renderStyle);
    }

    public CrowdIntro() {
        List list;
        CrowdIntro crowdIntro = this;
        crowdIntro.persons = list = (List)new ArrayList();
        this.irradiance = Cubemap.Companion.fromUrl("file:data/textures/evening_irr_hdr32.dds");
        this.previousModelView = Matrix44.Companion.getIDENTITY();
        Map<String, List<Triangle>> meshes = OBJLoaderKt.loadOBJfromLZMA(new URL("file:data/meshes/crowd.obj.lzma"));
        VertexFormat format2 = DrawerKt.vertexFormat(format.1.INSTANCE);
        for (final List<Triangle> mesh2 : meshes.values()) {
            Box bounds = OBJLoaderKt.bounds(mesh2);
            final Matrix44 correct2 = TransformBuilderKt.transform((Function1<? super TransformBuilder, Unit>)new Function1<TransformBuilder, Unit>(bounds){
                final /* synthetic */ Box $bounds;

                public final void invoke(@NotNull TransformBuilder $receiver) {
                    Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                    $receiver.translate(this.$bounds.getCorner().times(-1.0));
                }
                {
                    this.$bounds = box;
                    super(1);
                }
            });
            VertexBuffer person = DrawerKt.vertexBuffer(format2, mesh2.size() * 3);
            person.put((Function1<? super BufferWriter, Unit>)new Function1<BufferWriter, Unit>(){

                /*
                 * WARNING - void declaration
                 */
                @Override
                public final void invoke(@NotNull BufferWriter $receiver) {
                    Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                    Iterable $receiver$iv = mesh2;
                    for (Object element$iv : $receiver$iv) {
                        Triangle it2 = (Triangle)element$iv;
                        Triangle corrected = it2.transform(correct2);
                        int n2 = 0;
                        int n3 = 3;
                        while (n2 < n3) {
                            void i;
                            $receiver.write(corrected.getPositions()[i].div(50.0));
                            $receiver.write(corrected.getNormals()[i]);
                            ++i;
                        }
                    }
                }
            });
            this.persons.add(person);
        }
    }
}

