/*
 * Decompiled with CFR 0.152.
 */
package scenes;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.draw.BufferWriter;
import org.openrndr.draw.ColorBuffer;
import org.openrndr.draw.DrawPrimitive;
import org.openrndr.draw.Drawer;
import org.openrndr.draw.DrawerKt;
import org.openrndr.draw.RenderTarget;
import org.openrndr.draw.ShadeStyle;
import org.openrndr.draw.ShadeStyleKt;
import org.openrndr.draw.VertexBuffer;
import org.openrndr.draw.WrapMode;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;
import scenes.TexturedRectangle;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lscenes/TexturedRectangle;", "", "texture", "Lorg/openrndr/draw/ColorBuffer;", "width", "", "height", "(Lorg/openrndr/draw/ColorBuffer;DD)V", "floor", "Lorg/openrndr/draw/VertexBuffer;", "getFloor", "()Lorg/openrndr/draw/VertexBuffer;", "normalMap", "getNormalMap", "()Lorg/openrndr/draw/ColorBuffer;", "previousModelView", "Lorg/openrndr/math/Matrix44;", "getPreviousModelView", "()Lorg/openrndr/math/Matrix44;", "setPreviousModelView", "(Lorg/openrndr/math/Matrix44;)V", "getTexture", "draw", "", "drawer", "Lorg/openrndr/draw/Drawer;", "demo-strap"})
public final class TexturedRectangle {
    @NotNull
    private final ColorBuffer normalMap;
    @NotNull
    private Matrix44 previousModelView;
    @NotNull
    private final VertexBuffer floor;
    @NotNull
    private final ColorBuffer texture;

    @NotNull
    public final ColorBuffer getNormalMap() {
        return this.normalMap;
    }

    @NotNull
    public final Matrix44 getPreviousModelView() {
        return this.previousModelView;
    }

    public final void setPreviousModelView(@NotNull Matrix44 matrix44) {
        Intrinsics.checkParameterIsNotNull(matrix44, "<set-?>");
        this.previousModelView = matrix44;
    }

    @NotNull
    public final VertexBuffer getFloor() {
        return this.floor;
    }

    public final void draw(@NotNull Drawer drawer) {
        Intrinsics.checkParameterIsNotNull(drawer, "drawer");
        RenderTarget gbuffer = RenderTarget.Companion.getActive();
        DrawerKt.isolated(drawer, (Function1<? super Drawer, Unit>)new Function1<Drawer, Unit>(this, drawer, gbuffer){
            final /* synthetic */ TexturedRectangle this$0;
            final /* synthetic */ Drawer $drawer;
            final /* synthetic */ RenderTarget $gbuffer;

            public final void invoke(@NotNull Drawer $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                this.$drawer.translate(0.0, 36.0, 0.0);
                this.$drawer.setShadeStyle(ShadeStyleKt.shadeStyle((Function1<? super ShadeStyle, Unit>)new Function1<ShadeStyle, Unit>(this){
                    final /* synthetic */ draw.1 this$0;

                    public final void invoke(@NotNull ShadeStyle $receiver) {
                        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                        $receiver.setVertexPreamble("\n                    out vec4 previousView;\n                    out vec4 previousClip;\n                    out vec4 currentClip;\n                ");
                        $receiver.setFragmentPreamble("\n                    in vec4 previousView;\n                    in vec4 previousClip;\n                    in vec4 currentClip;\n                ");
                        $receiver.setVertexTransform("\n                    previousView = (p_previousModelView * vec4(x_position,1.0));\n                    previousClip = u_projectionMatrix * previousView;\n                    currentClip = u_projectionMatrix * u_viewMatrix * u_modelMatrix * vec4(x_position, 1.0);\n                ");
                        $receiver.setFragmentTransform("\n                    vec2 uv = va_position.xz*0.1;\n\n\n                    float normalFactor = max(1.0 + v_viewPosition.z/100.0, 0.0);\n\n                    vec3 normal = normalize(\n                                        mix( vec3(0.0, 1.0, 0.0), texture(p_normalMap, uv).xzy - vec3(0.5, 0.0, 0.5), 1.0-normalFactor)\n\n                                        );\n                    vec3 color = pow(texture(p_textureMap, va_texCoord0).rgb, vec3(2.2))*10.0;\n\n                    mat3 tbn = mat3(u_viewNormalMatrix * u_modelNormalMatrix);\n\n                    x_fill.rgb = color;\n\n                    o_position.xyz = v_viewPosition.xyz;\n                    o_position.w = 0.01;\n                    o_normal.xyz = tbn * normal;\n                    o_velocity.xy = vec2(0.0, 0.0);\n                    o_normal.w = max(1.0 + v_viewPosition.z/100.0, 0.0);\n\n                    o_velocity.xy = (currentClip/currentClip.w - previousClip/previousClip.w).xy*vec2(1280, 720)*0.08;\n\n                ");
                        this.this$0.this$0.getNormalMap().setWrapU(WrapMode.REPEAT);
                        this.this$0.this$0.getNormalMap().setWrapV(WrapMode.REPEAT);
                        this.this$0.this$0.getTexture().setWrapU(WrapMode.REPEAT);
                        this.this$0.this$0.getTexture().setWrapV(WrapMode.REPEAT);
                        $receiver.parameter("normalMap", this.this$0.this$0.getNormalMap());
                        $receiver.parameter("textureMap", this.this$0.this$0.getTexture());
                        $receiver.output("position", this.this$0.$gbuffer.colorBufferIndex("position"));
                        $receiver.output("normal", this.this$0.$gbuffer.colorBufferIndex("normal"));
                        $receiver.output("velocity", this.this$0.$gbuffer.colorBufferIndex("velocity"));
                        $receiver.parameter("previousModelView", this.this$0.this$0.getPreviousModelView());
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }));
                Drawer.vertexBuffer$default(this.$drawer, this.this$0.getFloor(), DrawPrimitive.TRIANGLES, 0, 0, 12, null);
                this.this$0.setPreviousModelView(this.$drawer.getView().times(this.$drawer.getModel()));
            }
            {
                this.this$0 = texturedRectangle;
                this.$drawer = drawer;
                this.$gbuffer = renderTarget;
                super(1);
            }
        });
    }

    @NotNull
    public final ColorBuffer getTexture() {
        return this.texture;
    }

    public TexturedRectangle(@NotNull ColorBuffer texture, final double width, final double height) {
        Intrinsics.checkParameterIsNotNull(texture, "texture");
        this.texture = texture;
        this.normalMap = ColorBuffer.Companion.fromUrl("file:data/textures/ground_normal.png");
        this.previousModelView = Matrix44.Companion.getIDENTITY();
        this.floor = DrawerKt.vertexBuffer(DrawerKt.vertexFormat(floor.1.INSTANCE), 6);
        this.floor.put((Function1<? super BufferWriter, Unit>)new Function1<BufferWriter, Unit>(){

            @Override
            public final void invoke(@NotNull BufferWriter $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                Vector3 p00 = new Vector3(-width / 2.0, -height / 2.0, 0.0);
                Vector3 p10 = new Vector3(width / 2.0, -height / 2.0, 0.0);
                Vector3 p11 = new Vector3(width / 2.0, height / 2.0, 0.0);
                Vector3 p01 = new Vector3(-width / 2.0, height / 2.0, 0.0);
                Vector2 t00 = new Vector2(0.0, 0.0);
                Vector2 t10 = new Vector2(1.0, 0.0);
                Vector2 t11 = new Vector2(1.0, 1.0);
                Vector2 t01 = new Vector2(0.0, 1.0);
                Vector3 n2 = Vector3.Companion.getUNIT_Z();
                $receiver.write(p00);
                $receiver.write(n2);
                $receiver.write(t00);
                $receiver.write(p10);
                $receiver.write(n2);
                $receiver.write(t10);
                $receiver.write(p11);
                $receiver.write(n2);
                $receiver.write(t11);
                $receiver.write(p11);
                $receiver.write(n2);
                $receiver.write(t11);
                $receiver.write(p01);
                $receiver.write(n2);
                $receiver.write(t01);
                $receiver.write(p00);
                $receiver.write(n2);
                $receiver.write(t00);
            }
        });
    }

    public /* synthetic */ TexturedRectangle(ColorBuffer colorBuffer, double d, double d2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            d = 128.0;
        }
        if ((n2 & 4) != 0) {
            d2 = 72.0;
        }
        this(colorBuffer, d, d2);
    }
}

