.pc =$0801 "Basic Upstart Program"
:BasicUpstart($3000)

//.var music = LoadSid("Numero_22.sid")
.var music = LoadSid("Fungus_Intro.sid")

.pc = $3000 "spritescroll"

//////////////////////////
// init & sprite setup //
////////////////////////

//nyomunk egy default kek szint
	lda #$0e
	ldx #$00
kezdoszin:
	sta $d800,x
	sta $d900,x
	sta $da00,x
	sta $db00,x
	inx
	cpx #$00
	bne kezdoszin


	
	sei
	lda #$7f
	sta $dc0d
	lda #$81
	sta $d01a
	lda #<irq
	sta $0314
	lda #>irq
	sta $0315

	lda #$20  //screen teteje  def:20
	sta $d012

	lda#$1b
	sta $d011
	cli



	lda #$00
	jsr $1000

///
//nointro
//jmp mainsetup
///


	lda #$ff
	sta $d015  //bekapcs

	lda #$bf   //a zold pottyet 7-es sprite - nem bantjuk
	sta $d017  //szethuz
	sta $d01d  //szethuz




//sprite mask $0e00 tol
	ldx #$38
	ldy #$00
sprsetup:
	txa
	sta $07f8,y
	inx
	iny
	cpy #$07
	bne sprsetup


	
	
	

//intro logo X

	lda #4*8+24
	sta $d000

	lda #8*8+24
	sta $d002

	lda #14*8+24
	sta $d004

	lda #19*8+24
	sta $d006

	lda #24*8+24-8
	sta $d008
	
	lda #30*8+30-256-6-8
	sta $d00a

	//bepattogo potty az I-re
	lda #19*8+24+32-8-8
	sta $d00c

	lda #00
	sta $d00f

//Intro logo Y
	lda #15*8+33
	sta $d001
	
	lda #11*8+33
	sta $d003
	sta $d005
	sta $d007
	sta $d009
	sta $d00b
	




	ldx #$01	// szinek

	stx $d027
	stx $d028
	stx $d029
	stx $d02a
	stx $d02b
	stx $d02c
	stx $d02e

	ldx #$05
	stx $d02d

//6os 8as sprite jobbra	
	lda #$a0     //20
	sta $d010




ize:	jmp ize


/////////////////////
// introkirako   ///
///////////////////
irq:
	inc $d019
	
	//inc lassit
	//lda lassit
	//cmp #$10
	//beq select
	//jmp introveg

// part selector
select:	jmp introkezd

introkezd:

	//varunk par framet hogy szinkronban legyen a zenevel
	dec introdelay
	lda introdelay
	cmp #$00
	bne i1v
	lda #$01
	sta introdelay


	lda #$00
	sta lassit


	ldx intro1
	lda harom,x
	tay
	
	//W bal szar
	lda #$f0
	sta $0e80,y


	ldx #$00
	
	//S also
i1:	lda balrol+3,y
	sta $0e00,x
	sta $0e03,x
	sta $0e06,x
	sta $0e09,x
	
	
	//L also
	lda jobbrol+3,y
	sta $0f40+16*3,x
	sta $0f40+17*3,x
	sta $0f40+18*3,x
	sta $0f40+19*3,x

	
	//R felso
	sta $0f00+0*3,x
	sta $0f00+1*3,x
	sta $0f00+2*3,x
	sta $0f00+3*3,x

	iny
	inx
	cpx #$03
	bne i1

	

	inc intro1
	lda intro1
	cmp #$14
	bne i1v
	lda #<introstep2
	sta select+1
	lda #>introstep2
	sta select+2
i1v:	jmp introveg



introstep2:
	lda #$00
	sta lassit

	ldx intro2
	lda v_harom,x
	tay


	//S szar
	lda #$f0
	sta $0e40,y
	
	//L szar
	lda #$0f
	sta $0f40,y


	lda harom,x
	tay

	//R szar
	lda #$0f
	sta $0f00+4*3,y

	ldx #$00
	
	//W also
i2:	lda balrol+15,y
	sta $0e80+16*3,x
	sta $0e80+17*3,x
	sta $0e80+18*3,x
	sta $0e80+19*3,x

	iny
	inx
	cpx #$03
	bne i2

	inc intro2
	lda intro2
	cmp #$10
	bne i2v
	lda #<introstep3
	sta select+1
	lda #>introstep3
	sta select+2
i2v:	jmp introveg


introstep3:
	lda #$00
	sta lassit

	ldx intro3
	lda v_harom,x
	tay

	//w kozepso cucc
	lda #$0f
	sta $0e81,y

	//w also maradek 8 pixel

	lda harom,x
	tay
	ldx #$00
	
	//W also
i3:	lda balrol+12,y
	sta $0ec0+16*3,x
	sta $0ec0+17*3,x
	sta $0ec0+18*3,x
	sta $0ec0+19*3,x

	iny
	inx
	cpx #$03
	bne i3


	inc intro3
	lda intro3
	cmp #$05
	bne i3v
	lda #<introstep4
	sta select+1
	lda #>introstep4
	sta select+2
i3v:	jmp introveg



introstep4:
	lda #$00
	sta lassit

	ldx intro4
	lda harom,x
	tay
	ldx #$00
	
	//S felso
i4:	lda balrol+12,y
	sta $0e40+0*3,x
	sta $0e40+1*3,x
	sta $0e40+2*3,x
	sta $0e40+3*3,x

	iny
	inx
	cpx #$03
	bne i4

	ldx intro4
	lda v_harom,x
	tay
	lda #$0f
	sta $0ec0,y


	inc intro4
	lda intro4
	cmp #$11
	bne i4v
	lda #<introstep5
	sta select+1
	lda #>introstep5
	sta select+2
i4v:	jmp introveg


introstep5:
	lda #$00
	sta lassit

	ldx intro5
	lda v_harom,x
	tax
	
	lda #$0f
	sta $0ec1+4*3,x
	

	inc intro5
	lda intro5
	cmp #$10   //0c
	bne i5v
	lda #<introstep6
	sta select+1
	lda #>introstep6
	sta select+2
i5v:	jmp introveg



introstep6:
	lda #$00
	sta lassit

	ldx intro6
	lda pattog,x
	sta $d00d

	inc intro6
	lda intro6
	cmp #$80
	bne i6v
	lda #<fade
	sta select+1
	lda #>fade
	sta select+2
i6v:	jmp introveg

fade:
	

	jsr $1003
	
	ldy #$00

rn0:	//random1 pos
	lda $d012 
	eor $dc04
	sbc $dc05 
	tax

	lda $0e00,x
rn1:	and rndsor
	sta $0e00,x

	lda $0e00+128,x
rn2:	and rndsor
	sta $0e00+128,x

	clc
	inc rn1+1
	inc rn2+1
	lda rn1+1
	cmp #$08
	bne rntov
	lda #$00
	sta rn1+1
	sta rn2+1
rntov:

	iny
db:	cpy #$02
	bne rn0
	

	inc db+1
	lda db+1
	sbc #$20
	bmi rnv

	ldx intro7
	lda pattog2,x
	sta $d00d


	//animaljuk a pattogo szart
	lda intro7
	tax
	lda p_frame_tabla,x
	tax
	lda k_mem,x
	tax
		
	ldy #$00
pmasol:	lda p_anim,x
	sta $0f80,y
	inx
	clc
	iny
	cpy #24
	bne pmasol


	inc intro7
	lda intro7
	cmp #$80	
	bne rnv
	lda #<kukac
	sta select+1
	lda #>kukac
	sta select+2

	lda #$00	//ha megallt a pattogo zold, lelojjuk a tobbit
	ldx #$00
fulltorles:
	sta $0e00,x
	sta $0ec0,x
	inx
	cpx #$c0
	bne fulltorles

	lda #$40
	sta $d015

rnv:	jmp nosound


///////////////////
//  kukac anim  //
/////////////////
kukac:
	
	ldy #$06
	lda #$0e
	sta $d021
	
	lda intro8
ivar: 	cmp $d012
	bne ivar
	sty $d021


	inc intro8wait
	lda intro8wait
	cmp #$40
	bne noredony
	clc
	dec intro8wait
	clc
	inc intro8


noredony:

//speed
	inc k_sp
	lda k_sp
	cmp #$01
	bne k_tov
	lda #$00
	sta k_sp



	//frame
	lda k_frame
	tax
	lda k_frame_tabla,x
	tax
	lda k_mem,x
	tax
		
	ldy #$00
kmasol:	lda kukacanim,x
	sta $0f80,y
	inx
	clc
	iny
	cpy #24
	bne kmasol

	//pos
	ldx k_frame
	lda $d00c
	sbc k_dx,x
	sta $d00c
	
	
	inc k_frame
	ldx k_frame
	cpx #$0a
	bne k_tov
	ldx #$00
	stx k_frame
k_tov:
	lda $d00c
	cmp #$00
	bne kukveg
	lda #<torles
	sta select+1
	lda #>torles
	sta select+2
	
	lda #$0e
	sta $d020
	sta $d021
	
	jsr $e544


	lda #$00
	sta $d015

	/////////////////
	// QBre ugrunk//
	///////////////
	
	jsr qblogo_init
	sei
	lda #<QB_irq
	sta $0314
	lda #>QB_irq
	sta $0315
	cli
	//jmp $ea31

kukveg:	jmp introveg


////////////////
//clear sceen//
//////////////
torles:

	inc intro10
	lda intro10
	cmp #$04
	bne torv
	lda #<fadeout
	sta select+1
	lda #>fadeout
	sta select+2
torv:	jmp introveg
	

///////////////
// fadeout ///
/////////////
fadeout:
	inc intro9
	ldx intro9
	lda szinbelso,x
	tax

	lda #$31
fade1:	cmp $d012
	bne fade1
	stx $d020
	stx $d021

	ldx intro9
	lda szinkulso,x
	tax

	lda #$fc
fade2:	cmp $d012
	bne fade2

	ldy #$0b
fw1:	dey
	bne fw1

	stx $d020
	stx $d021

	
	lda intro9

	cmp #$3f
	bne introveg
	jmp mainsetup

introveg:


	jsr $1003

nosound:
	jmp $ea7e



////////////////////////////////////
// main part init & sprite setup //
//////////////////////////////////
mainsetup:
	sei
	lda #<mainirq
	sta $0314
	lda #>mainirq
	sta $0315

	//lda #$20   //screen teteje  def:20
	//sta $d012

	cli
	
	jsr $1003


	lda #$ff
	//sta $d015  //bekapcs
	sta $d017  //szethuz
	sta $d01d  //szethuz



	//sprite mask $3000 tol

	lda #$c0
	sta $07f8
	sta $07f9


	lda #$c4
	sta $07fa
	sta $07fb


	lda #$c8
	sta $07fc
	sta $07fd

	lda #$cc
	sta $07fe
	sta $07ff


//	lda #$d0
//	sta $07fc


	
	
	


	lda #$32	// y pos reset
	sta $d001
	sta $d003

	lda #$5c
	sta $d005
	sta $d007

	lda #$86
	sta $d009
	sta $d00b

	lda #$b0
	sta $d00d
	sta $d00f




	ldx #$0f	// szinek
	stx $d027
	ldx #$0b
	stx $d028


	ldx #$0f
	stx $d029
	ldx #$0b
	stx $d02a


	ldx #$0f
	stx $d02b
	ldx #$0b
	stx $d02c

	ldx #$0f
	stx $d02d
	ldx #$0b
	stx $d02e

	lda #$00
	sta $d010
	

	ldx #$00	// nincs logo, helyette spritscroll, azt nullazza ki
logomasol:
	lda logo,x
	sta $4800,x
	inx
	cpx #$00
	bne logomasol

	lda #$ff	//100as sprite fillezes fullra, ez takarja a spritecroll elejet veget
	ldx #$00
blck:	
	sta $5900+64,x
	inx
	cpx #$40
	bne blck
	





	//lda #$96		//95: 0-4000  96:4000-8000
	//sta $dd00

//lda #$00
//sta $d020
//sta $d021

	lda $dd00	//VIC $4000tol....
	and #$fc
	ora #%00000010
	sta $dd00


	lda #$ff
	sta $d015  //bekapcs


//jsr $e544

mainize:	jmp mainize


/////////////////
// scroll    ///
///////////////
mainirq:
	inc $d019


	

ldy#$0c


//badline off
	sei
	lda #$2f
bl1:	cmp $d012
	bne bl1

	

	lda #$0b
	sta $d011
	

	ldx #$16
bl2:	dex
	bne bl2
	

sty $d020
sty $d021

lda #$1b
sta $d011
cli
	


/////////////////////////
// spriteok mahinlasa //
///////////////////////

	
	ldy #$00


	ldx #$2a

sp1:
	
	lda $d012
sp1c:	cmp $d012
	beq sp1c


ss1:	lda spsin1,y
	sta $47f8
	lda spsinh1,y
	sta $47f9
		
	lda sinbase,y
m1:	adc sinbase,y
	sta $d000
	sta $d002

	
	iny
	dex
	bne sp1	




	ldx#$2a

sp2:

	lda $d012
sp2c:	cmp $d012
	beq sp2c


ss2:	lda spsin2,y
	sta $47fa
	lda spsinh2,y
	sta $47fb

	lda sinbase,y
m2:	adc sinbase,y
	sta $d004
	sta $d006

	

	iny
	dex
	bne sp2	





	ldx#$2a

sp3:

	lda $d012
sp3c:	cmp $d012
	beq sp3c	


ss3:	lda spsin1,y
	sta $47fc
	lda spsinh1,y
	sta $47fd


	
	lda sinbase,y
m3:	adc sinbase,y
	sta $d008
	sta $d00a



	iny
	dex
	bne sp3	



	ldx#$29

sp4:

	lda $d012
sp4c:	cmp $d012
	beq sp4c	

ss4:	lda spsin2,y
	sta $47fe
	lda spsinh2,y
	sta $47ff

	lda sinbase,y
m4:	adc sinbase,y
	sta $d00c
	sta $d00e


	iny
	dex
	bne sp4	

//a 4. spritepakk utolso pixelsorat kezzel rakjuk ki

ss4u:	lda spsin2,y
	sta $47fe
	lda spsinh2,y
	sta $47ff

	lda sinbase,y
m4u:	adc sinbase,y
	sta $d00c
	sta $d00e


//	iny




//inc $d021

//elso ket spriteot ujra kirakjuk
	
	lda #$da
	sta $d001
	sta $d003

iny

	ldx#$1f

sp5:
	

	
ss5:	lda spsin1,y
	sta $47f8
	lda spsinh1,y
	sta $47f9
		
	lda sinbase,y
m5:	adc sinbase,y
	sta $d000
	sta $d002
	
	lda $d012
sp5c:	cmp $d012
	beq sp5c

	
	iny
	dex
	bne sp5


//also border kikapcshoz osszehuzzuk a kepet
lda $d011
and #$f7
sta $d011



//sin forgatok  novelese sprite maskhoz

	inc ss1+1
	inc ss1+7

	inc ss2+1
	inc ss2+7

	inc ss3+1
	inc ss3+7

	inc ss4+1
	inc ss4+7

	inc ss4u+1
	inc ss4u+7

	inc ss5+1
	inc ss5+7



//1-2 spriteot kinullazzuk egy ures framel a (30)
lda #$26
sta $47f8
sta $47f9



//sin forgatok  novelese X pos-hoz
	inc m1+1
	inc m2+1
	inc m3+1
	inc m4+1
	inc m4u+1
	inc m5+1

	
//elso srt visszarakjuk fentre
	//lda #$32	// y pos reset
	//sta $d001
	//sta $d003

vege:
	


	lda $d012
black:	cmp $d012
	beq black



	lda #$1b
	sta $d011


	ldx #$09
black2:	dex
	bne black2


deb1:
lda #$00
sta $d020
sta $d021
	
	

	


//////////////////////
//also Sprite logo //
////////////////////

also:	lda #$ff
		
	sta $d005
	sta $d007
	sta $d009
	sta $d00b
	sta $d00d
	sta $d00f
	





scrl:	lda #$70
	sta $d004
	lda #$70+24
	sta $d006
	lda #$70+24*2
	sta $d008
	lda #$70+24*3
	sta $d00a
	lda #$70+24*4
	sta $d00c
	lda #$70+24*5
	sta $d00e

	lda #$03
	sta $d017  //szethuz
	sta $d01d
	
	lda #$20
	sta $47fa
	lda #$21
	sta $47fb
	lda #$22
	sta $47fc
	lda #$23
	sta $47fd
	lda #$24
	sta $47fe
	lda #$25
	sta $47ff
		

///////////////////
// sprite mask ///
/////////////////

	lda #$00
	sta $d027	//takaro1
	sta $d028	//takaro2
	lda #101
	sta $47f8
	sta $47f9

	lda #$70-48
	sta $d000
	lda #$70+24*6-8
	sta $d002

	//lda #$ff	
	//sta $d001 	//takaro1
	//sta $d003	//takaro2


spszin:	lda #$00
	sta $d029
	sta $d02a
	sta $d02b
	sta $d02c
	sta $d02d
	sta $d02e
	

//1-2 spriteto megegyszer kirakjuk hogy szeen kitakarja a scroll elejet veget

	lda #$04
str1:	cmp $d012
	bne str1
	
	lda #$04
	nop
	nop
	nop
	
	

	sta $d001
	sta $d003

	
	
	



	lda #$1b
spvar:	cmp $d012
	bne spvar

swing:	lda scrlsin
	sta also+1
	inc swing+1

	

/////////////////
//Sprite reset//
///////////////


	lda #$32	// y pos reset
	sta $d001
	sta $d003

	lda #$5c
	sta $d005
	sta $d007

	lda #$86
	sta $d009
	sta $d00b
	
	lda #$b0
	sta $d00d
	sta $d00f

	//1-2 spriteot kinullazzuk egy ures framel a (30)
	lda #$26
	sta $47f8
	sta $47f9

	jsr $1003

	lda #$ff
	sta $d017  //szethuz
	sta $d01d


	ldx #$0f
	stx $d027
	stx $d029
	stx $d02b
	stx $d02d

	ldx #$0b
	stx $d028
	stx $d02a
	stx $d02c
	stx $d02e

	inc ss1+1
	inc ss1+7

	inc ss2+1
	inc ss2+7

	inc ss3+1
	inc ss3+7

	inc ss4+1
	inc ss4+7

	inc ss4u+1
	inc ss4u+7

	inc ss5+1
	inc ss5+7



///////////////////////////////////////////////
//swirl minta kibontakozas utan stabilizal ///
/////////////////////////////////////////////
	
	lda sw_rise
	cmp #$01
	bne marad

	ldx sw_count
	lda spr_in,x
	sta spszin+1
	
	inc sw_count
	lda sw_count
	cmp #$7f
	bne marad

	lda #$00
	sta sw_rise

	inc ss1+2
	inc ss1+8

	inc ss2+2
	inc ss2+8

	inc ss3+2
	inc ss3+8

	inc ss4+2
	inc ss4+8

	inc ss4u+2
	inc ss4u+8

	inc ss5+2
	inc ss5+8


marad:

////////////////////
////swirl vege ////
//////////////////

	clc
	inc sw_main	
	

	lda sw_off
	cmp #$ff
	bne no_off

////sp szin
	ldx sw_main
	lda spr_out,x
	sta spszin+1

	lda sw_main
	cmp #$80
	bne no_off
	


	clc
	inc ss1+2
	inc ss1+8
	

	inc ss2+2
	inc ss2+8


	inc ss3+2
	inc ss3+8



	inc ss4+2
	inc ss4+8


	inc ss4u+2
	inc ss4u+8


	inc ss5+2
	inc ss5+8

no_off:

	

	jsr $ffe4      // volte bill lenyomas
        beq no_bill

//inc deb1+1
	lda #$ff
	sta sw_bill

no_bill:

	// ha vol bill, akkor az akualis kort kifuttatjuk majd atallitjuk a leallos mintara a spriteokat
	lda sw_bill
	cmp #$ff
	bne semmisenemsem
	
	
	lda sw_main
	cmp #$00
	bne semmisenemsem
	

	
	lda #$ff
	sta sw_off	//elinditjuk a kifutas szamolot


//inc deb1+1

	lda #$00
	sta sw_bill

	clc
	inc ss1+2
	inc ss1+8
	

	inc ss2+2
	inc ss2+8


	inc ss3+2
	inc ss3+8



	inc ss4+2
	inc ss4+8


	inc ss4u+2
	inc ss4u+8


	inc ss5+2
	inc ss5+8





semmisenemsem:


	lda ss1+2	//outrocheck
	cmp #$83
	bne ez_sem

ka1:	lda $d011 //megvarjuk a kepernyo aljat
	bpl ka1
ka2:	lda $d011 
	bmi ka2

	lda #$00
	sta $d027
	sta $d028


	lda #$00
	sta $d015  //spritekikapcs

	lda $dd00	//VIC $0000tol....
	and #$fc
	ora #%00000011
	sta $dd00

	lda #$18 //font 2000tol
  	sta $d018


	sei

	lda #$28   //screen teteje 
	sta $d012

	lda #<endseq
	sta $0314
	lda #>endseq
	sta $0315
	cli


ez_sem:


jsr sprtxtscr


	jmp $ea31



///////////
//endseq//
/////////

endseq:
	
	inc $d019




	lda #$2f
es1:	cmp $d012
	bne es1

	ldy #$00
es1w:	iny
	cpy #$08	//$02 kell megallas utan
	bne es1w



	lda #$0c
	sta $d021
	sta $d020
	
	lda #$fc
es2:	cmp $d012
	bne es2
	
	ldy #$00
es2w:	iny
	cpy #$08	//$02 kell megallas utan
	bne es2w


	lda #$00
	sta $d020
	sta $d021


//spritecucc config  -  1 pixellel a vege elott belojjuk...
	lda es2-1
	cmp #$ce
	beq kell
	jmp nemkell

kell:
	lda #$07			//0f
	sta $d015

	lda #$00
	sta $d017
	sta $d01d

	lda #$89+3*8
	sta $d001

	lda #$8a+3*8
	sta $d003
	sta $d005
	sta $d007

	lda #$05
	sta $d027	//kukac
	lda #$00
	sta $d028	//the
	sta $d029	//end
	lda #$02
	sta $d02a	//ver maybe

	lda #$00
	sta $d000
	sta $d002
	sta $d004
	sta $d006

	lda #$3e	//kukac
	sta $07f8

	lda #$38	//the
	sta $07f9
	lda #$39	//end
	sta $07fa

	ldx #$00	
theendcopy:
	lda theend,x
	sta $0e00,x
	lda theend+24,x
	sta $0e40,x
	
	lda #$00
	sta $0e00+24,x
	sta $0e00+39,x

	inx
	cpx #24
	bne theendcopy
	


	ldx #$00
ir:	lda szoveg,x
	sta $0400+15*40,x
	lda #$0c
	sta $d800+15*40,x

	lda #$00
	sta $d800+9*40,x
	
	lda #$40
	sta $0400+9*40,x

	inx
	cpx #$a0
	bne ir
	
	lda #$0b		//$0b
	ldx #$00
eqf2:	sta $d800+13*40,x
	inx
	cpx #40
	bne eqf2


nemkell:



//rastercsikot osszehuzzuk
	lda nemkellhuzas
	cmp #$01
	beq anim

	
	lda es2-1
	cmp #$cd 

	//lda es1-1
	//cmp #$79

corr:	beq nemhuz
	clc	
	inc es1-1
	inc es1-1
	dec es2-1
	//felsot kicsit begyorsitjuk neha
	dec felspeed
	bne anim
	lda #$03
	sta felspeed
	inc es1-1
	jmp anim



nemhuz:

	dec es1-1
	dec es2-1
	dec es2-1
	lda #$02
	sta es2w+2
	lda #$07
	sta es1w+2
	
	lda #$01
	sta nemkellhuzas

//	clc
//	inc esp
//	lda esp
//	cmp #02		//the end betolas anim speed  def:02
//	beq anim
//	jmp endseq_semmi

anim:
	lda #$00
	sta esp




//kukacanimalo

	lda ka_mehet
	cmp #$01	 
	bne e_move

	lda endframe
	tax
	lda k_frame_tabla,x
	tax
	lda k_mem,x
	tax
		
	ldy #$00
kmasol2:	
	lda kukacanim,x
	sta $0f80,y
	inx
	clc
	iny
	cpy #24
	bne kmasol2


//end move
e_move:
	lda e_mehet
	cmp #$01
	bne t_move
	clc
	ldx endframe	
	lda $d004
	adc k_dx2-4,x
	sta $d004
	cmp #$17
	bne t_move
	lda #$01
	sta t_mehet
	
	



//the move
t_move:
	lda t_mehet
	cmp #$01
	bne k_move
	clc
	ldx endframe	
	lda $d002
	adc k_dx2,x
	sta $d002
	cmp #$19	//igy er hozza a T hez
	bne k_move
	lda #$01
	sta k_mehet




//kukac move
k_move:
	lda k_mehet
	cmp #$01
	bne e_kesz
	clc
	ldx endframe	
	lda $d000
	adc k_dx2,x
	sta $d000



	
e_kesz:
	lda $d000
	cmp #$83
	bne nonstop1
	lda #$00
	//sta e_mehet
	sta t_mehet
	sta k_mehet
	sta ka_mehet


nonstop1:
	lda $d004
	cmp #$b6
	bne nonstop2
	lda #$00
	sta e_mehet

	//animnak itt van vege, atvaltunk EQ-ra

ka11:	lda $d011 //megvarjuk a kepernyo aljat
	bpl ka11
ka22:	lda $d011 
	bmi ka22
	sei

	lda #$82-8 	//-8
	sta $d012

	lda #<eqpart
	sta $0314
	lda #>eqpart
	sta $0315
	cli
	jmp $ea31


nonstop2:




	inc endframe
	ldx endframe
	cpx #$0a
	bne k_tov2
	ldx #$00
	stx endframe


k_tov2:







endseq_semmi:


/// credits szinanim
	ldx #$00
credloop:
	lda cred,x
	cmp #$ff
	beq nemvalt
	clc	
	inc cred,x
nemvalt:
	lda cred,x
	tay
	lda credszin,y
	sta $d800+16*40,x
	inx
	cpx #80
	bne credloop

	
	
	
	jsr $1003


	jmp $ea31


/////////////////////////
// SPRITE  TEXTSCROLL //
///////////////////////
sprtxtscr:

	clc
	dec scrl+1
	dec scrl+1+5
	dec scrl+1+10
	dec scrl+1+15
	dec scrl+1+20
	dec scrl+1+25

	lda scrl+1
	cmp #$68
	beq masolgat

	jmp scrollveg

masolgat:

	clc
	lda #$70
	sta scrl+1
	adc #$18
	sta scrl+1+5
	adc #$18
	sta scrl+1+10
	adc #$18
	sta scrl+1+15
	adc #$18
	sta scrl+1+20
	adc #$18
	sta scrl+1+25


	ldx #$00
	ldy #$00
sprcopy:

	lda $4801,x
	sta $4800,x

	lda $4802,x
	sta $4801,x

	lda $4840,x
	sta $4802,x

	lda $4841,x
	sta $4840,x

	lda $4842,x
	sta $4841,x

	lda $4880,x
	sta $4842,x

	lda $4881,x
	sta $4880,x

	lda $4882,x
	sta $4881,x

	lda $48c0,x
	sta $4882,x

	lda $48c1,x
	sta $48c0,x

	lda $48c2,x
	sta $48c1,x

	lda $4900,x
	sta $48c2,x

	lda $4901,x
	sta $4900,x

	lda $4902,x
	sta $4901,x

	lda $4940,x
	sta $4902,x

	lda $4941,x
	sta $4940,x

	lda $4942,x
	sta $4941,x

	inx
	inx
	inx

	iny
	cpy #$08
	bne sprcopy

	

	inc $4942
	inc $4942+3
	inc $4942+6
	inc $4942+9
	inc $4942+12
	inc $4942+15
	inc $4942+18
	inc $4942+21

	lda #>font
	sta fcopy+2
	inc scload+1
	bne scload
	inc scload+2



scload:	lda scrtxt
	
	cmp #64		// 64 jelzi a scroll veget, nyomunk egy spacet manualisan
	bne mehetmeg
	lda #$ff
	sta sw_bill
	lda #$20


mehetmeg:
	tay
	
	asl
	asl
	asl
	tax

	tya
	lsr
	lsr
	lsr
	lsr
	lsr
	clc
	adc fcopy+2
	sta fcopy+2



	ldy #$00
fcopy:	lda font,x
	sta $4942,y
	inx
	iny
	iny
	iny
	cpy #$18
	bne fcopy

scrollveg:
	

	rts

///////////////
// EQ PART ///
/////////////
eqpart:

	inc $d019

	nop
	nop




	ldx #00
eqszinezo:	
	

	lda eqszin,x
	sta $d021
	sta $d021

	ldy eqvar,x
ww1:	dey
	bne ww1

	inx
	cpx #32
	bne eqszinezo

	lda #$0c
	nop	
	nop

	sta $d021
	sta $d020





///////////////
// SID copy //
/////////////

	lda #$34
	sta $01

	lda #$00
	jsr $1003

	ldx #$1c
SID_olvas:
	lda $d400,x
	sta $0800,x
	dex
	bpl SID_olvas


	lda #$37
	sta $01



	ldx #$1c
SID_ir:
	lda $0800,x
	sta $d400,x
	dex
	bpl SID_ir

//////////////////////
// End of SID copy //
////////////////////

//dec $d020


	lda #$cb		// $ce
eqalsovar:
	cmp $d012
	bne eqalsovar

	ldx#$02
sal:	dex
	bne sal



	lda #$00
	sta $d020
	sta $d021






//ch1
	ldy $0801
	

	ldx leoszt,y
	lda eqheight
	sta eq,x

	
//ch2
	ldy $0808
	

	ldx leoszt,y
	lda eqheight
	sta eq,x


//ch3
	ldy $080f
	

	ldx leoszt,y
	lda eqheight
	sta eq,x



	//lda #$00
	//sta eq+80


//jmp vege


/////////////////
//eq felepites//
///////////////


	ldx #$00
	stx bbb+1
	inx
	stx jjj+1
	



	ldx #$00
eqcalc:
	
	lda #$00
	sta temp
	sta temp+1
	sta temp+2
	sta temp+3

	//bal

bbb:	lda eq,x

	beq jjj
	asl
	asl
	tay

	lda cbal,y
	sta temp+3


	lda cbal+1,y
	sta temp+2
	

	lda cbal+2,y
	sta temp+1


	lda cbal+3,y
	sta temp+0



	//jobb

jjj:	lda eq+1,x

	beq ures
	asl
	asl
	tay
	
	lda cjobb,y
	ora temp+3
	sta temp+3


	lda cjobb+1,y
	ora temp+2
	sta temp+2


	lda cjobb+2,y
	ora temp+1
	sta temp+1


	lda cjobb+3,y
	ora temp+0
	sta temp+0

	jmp ures


ures:
	

	inc bbb+1
	inc jjj+1



	lda temp+0
	tay
	lda c_konv,y
	sta $0400+9*40,x		//9*


	lda temp+1
	tay
	lda c_konv,y
	sta $0400+10*40,x		//10*


	lda temp+2
	tay
	lda c_konv,y
	sta $0400+11*40,x


	lda temp+3
	tay
	lda c_konv,y
	sta $0400+12*40,x


	
	inx

	cpx #$28
	beq mirror
	jmp eqcalc


///////////////
// eq mirror//
/////////////
mirror:



	ldx #$00
	stx mb+1
	inx
	stx mj+1
	



	ldx #$00
meqcalc:


	//bal

mb:	lda eq,x

	beq mb_ures
	tay
	lda mcbal,y
	sta temp


	jmp mj

mb_ures:
	sta temp,x


	//jobb

mj:	lda eq+1,x

	beq mj_ures

	tay
	lda mcjobb,y
	
	ora temp
	sta temp

	jmp mures

mj_ures:
	sta temp

mures:
	
	tay
	lda tc_konv,y
	sta $0400+13*40,x


	inc mb+1	
	inc mj+1
	

	inx

	cpx #$28
	bne meqcalc




	
/////////////////
//eq efektezes//
///////////////

// atalgolas

	ldx #80
atlag:
	lda eq,x
	asl
	//adc #$02
	adc eq-1,x
	adc eq+1,x


	lsr
	lsr
	
	//cmp #$00
	beq nonDeC

	tay
	dey
	tya
nonDeC:	
	
	sta eqt,x



	dex
	bpl atlag




//inc $d020


//atrak eredetibe

	ldx #79
atrak:	lda eqt,x
	sta eq,x
	dex
	bpl atrak

// eq peak magassag noveles

	inc eqhs
	lda eqhs
	cmp #$02
	bne eqvege
	lda #$00
	sta eqhs

	lda eqheight
	cmp #$1f
	beq eqvege
	inc eqheight






eqvege:
	jmp $ea7e
	//jmp $ea31

///////////////////////////
// QBPARTY logo twister //
/////////////////////////
.pc =$ce10 "QB fx init"
qblogo_init:
	
	lda #$18 //font 2000tol
  	sta $d018

	//lda #$0e
	//sta $d020
	//sta $d021

	ldx #$00

qbszinfill:
	lda #$0e
	sta $d800,x
	sta $d900,x
	sta $da00,x
	sta $db00,x

	lda #145
	sta $0400,x
	sta $0500,x
	sta $0600,x
	sta $0700,x

	inx
	cpx #$00
	bne qbszinfill



	ldx #$0f
scrcfg:	
	lda qbscreen,x
	sta $0400+10*40+12,x
	lda qbscreen+40,x
	sta $0400+11*40+12,x
	lda qbscreen+80,x
	sta $0400+12*40+12,x
	lda qbscreen+120,x
	sta $0400+13*40+12,x


	lda #$09		//09
	sta $d800+10*40+12,x
	sta $d800+11*40+12,x	
	sta $d800+12*40+12,x
	sta $d800+13*40+12,x

	dex
	bpl scrcfg

	lda $d016
	ora #%00010000
	sta $d016
	
	lda #$00
	sta $d022

	lda #$03
	sta $d023



	//sprite init
	lda #$01
	sta $d01c	//multicol

	lda #$00
	sta $d017
	sta $d01d

	lda #$ec
	sta $d000
	lda #$7b
	sta $d001
	lda #$0e00/64
	sta $07f8
	lda #$0d
	sta $d027
	lda #$00
	sta $d025
	lda #$03
	sta $d026

	jsr $1003

	rts

//////////////
// QB main //
////////////
.pc =$0d00 "QB fx main code"
QB_irq:
	inc $d019

//dec $d020

	lda #$0f
	sta ocount
	
	

	lda #$00
	sta olvas+1
	sta olvas+4
	
	sta pos
	
	lda #$20
	sta olvas+5
	lda #$cc
	sta olvas+2

start:


	ldx pos
smod:	lda sintabla,x
	tax


	lda pos_lo,x
	sta pp+1
	lda pos_hi,x
	sta pp+2



	ldx #$1f
	
pp:	lda osztotabla,x
	tay

olvas:	lda $2400,y
	sta $2000,x
	
	dex
	bpl pp		

	
	lda olvas+1
	clc
	adc #$20
	sta olvas+1
	sta olvas+4

	bcc otov	
	inc olvas+2
	inc olvas+5

otov:

	inc pos
	
	dec ocount
	bpl start	
	
	
	inc smod+1
	bne s_tov

	///////////////////
	// vissza ugrunk//
	/////////////////
	sei
	lda #<irq
	sta $0314
	lda #>irq
	sta $0315
	cli
	
	lda $d016
	eor #%00010000
	sta $d016

	jsr $e544

	ldx #$00
fontcopy:
	lda $0900,x
	sta $2000,x
	lda $0a00,x
	sta $2100,x
	inx
	cpx #$00
	bne fontcopy

	lda #$00
	sta $d01c


	//jmp $ea31

s_tov:

	lda q4masol
	beq q4check

q4c:	ldx #60
	lda qbsprite,x
	sta $0e00,x
	lda qbsprite+1,x
	sta $0e00+1,x
	lda qbsprite+2,x
	sta $0e00+2,x
	
	lda q4c+1
	beq q4check
	clc
	sbc #$02
	sta q4c+1


q4check:

	lda smod+1
	cmp #$93	//itt rakjuk ki a 4est
	bne kicheck

	lda #$01
	sta $d015
	sta q4masol
	jmp s_tov2

kicheck:
	cmp #$d4	//itt vesszuk le a 4est
	bne s_tov2
	lda #$00
	sta $d015



s_tov2:




//inc $d020


	jsr $1003

	jmp $ea31

.pc =$3f00 "sin pos"
sinpos:
.byte 1

.pc =$3f01 "spin"
spin:
.byte 192

.pc =$3f02 "spin2"
spin2:
.byte 202

.pc =$3f03 "skip"
skip:
.byte 0

.pc =$3f19 "fontlap"
flap:
.byte 0

.pc =$4000 "spritecucc hat"
spcucc_h:
.byte 14,7,225,7,1,248,7,128,126,3,224,30,1,248,7,0,126,3,0,31,129,0,7,225,0,1,249,0,24,127,0,30,31,0,31,135,0,31,227,0,29,248,0,28,126,0,28,30,0,28,7,8,14,3,8,7,129,14,7,225,15,129,249,0
.byte 28,15,195,14,3,240,15,0,252,7,192,62,3,240,15,0,252,3,0,63,3,0,15,195,0,3,243,0,48,255,0,60,63,0,63,15,0,63,195,0,59,240,0,56,252,0,56,62,0,56,15,16,28,3,16,15,3,28,15,193,31,3,241,0
.byte 56,31,131,28,7,224,30,1,248,15,128,126,7,224,31,1,248,7,0,126,3,0,31,131,0,7,227,0,97,251,0,120,127,0,126,31,0,127,135,0,119,224,0,113,248,0,112,126,0,112,31,32,56,7,32,30,3,56,31,129,62,7,225,0
.byte 112,63,2,56,15,192,60,3,240,31,0,252,15,192,62,3,240,14,0,252,2,0,63,2,0,15,194,0,195,246,0,240,254,0,252,62,0,255,14,0,239,192,0,227,240,0,224,252,0,224,62,64,112,14,64,60,2,112,63,2,124,15,194,0
.byte 96,126,6,112,31,128,120,7,224,62,1,248,31,128,126,7,224,30,1,248,6,0,126,6,0,31,134,1,135,238,1,225,254,1,248,126,1,254,30,1,223,128,1,199,224,1,193,248,1,192,126,64,224,30,64,120,6,96,126,2,120,31,130,0
.byte 64,252,14,96,63,0,112,15,192,124,3,240,63,0,254,15,192,62,3,240,14,0,252,14,0,63,14,3,15,222,3,195,254,3,240,254,3,252,62,3,191,0,3,143,192,3,131,240,3,128,254,65,192,62,64,240,14,64,252,2,112,63,2,0
.byte 193,248,28,64,126,0,96,31,128,120,7,224,126,1,252,31,128,124,7,224,28,1,248,28,0,126,28,6,31,188,7,135,252,7,225,252,7,248,124,7,126,0,7,31,128,7,7,224,7,1,252,131,128,124,129,224,28,193,248,4,224,126,4,0
.byte 195,240,56,192,252,0,192,63,0,112,15,192,124,3,248,63,0,248,15,192,56,3,240,56,0,252,56,12,63,120,15,15,248,15,195,248,15,240,248,14,252,0,14,63,0,14,15,192,14,3,248,135,0,248,131,192,56,195,240,8,192,252,8,0
.byte 135,224,112,193,248,0,192,126,0,224,31,128,120,7,240,126,1,240,31,128,112,7,224,112,1,248,112,24,126,240,30,31,240,31,135,240,31,225,240,29,248,0,28,126,0,28,31,128,28,7,240,142,1,240,135,128,112,135,224,16,193,248,16,0
.byte 143,192,224,131,240,0,192,252,0,192,63,0,240,15,224,124,3,224,63,0,224,15,192,224,3,240,224,48,253,224,60,63,224,63,15,224,63,195,224,59,240,0,56,252,0,56,63,0,56,15,224,28,3,224,15,0,224,143,192,32,195,240,32,0
.byte 159,129,192,135,224,0,129,248,0,192,126,0,224,31,192,120,7,192,126,1,192,31,129,192,7,225,192,97,251,192,120,127,192,126,31,192,127,135,192,119,224,0,113,248,0,112,126,0,112,31,192,56,7,192,30,1,192,159,128,64,135,224,64,0
.byte 63,3,128,143,192,0,131,240,0,192,252,0,192,63,128,240,15,128,124,3,128,63,3,128,15,195,128,67,247,128,112,255,128,124,63,128,127,15,128,111,192,0,99,240,0,96,252,0,96,63,128,112,15,128,60,3,128,63,0,128,143,192,128,0
.byte 126,7,0,31,128,0,135,224,0,129,248,0,192,127,0,224,31,0,120,7,0,126,7,0,31,135,0,71,239,0,97,255,0,120,127,0,126,31,0,95,128,0,71,224,0,65,248,0,64,127,0,96,31,0,120,7,0,126,1,0,159,129,0,0
.byte 124,14,0,63,0,0,15,192,0,131,240,0,192,254,0,192,62,0,240,14,0,124,14,0,63,14,0,207,222,0,195,254,0,240,254,0,252,62,0,255,0,0,207,192,0,195,240,0,192,254,0,64,62,0,112,14,0,124,2,0,63,2,0,0
.byte 120,28,0,126,0,0,31,128,0,135,224,0,129,252,0,192,124,0,224,28,0,120,28,0,126,28,0,159,188,0,199,252,0,225,252,0,248,124,0,254,0,0,223,128,0,199,224,0,193,252,0,192,124,0,96,28,0,120,4,0,126,4,0,0
.byte 240,56,0,124,0,0,63,0,0,15,192,0,131,248,0,192,248,0,192,56,0,240,56,0,124,56,0,191,120,0,207,248,0,195,248,0,240,248,0,252,0,0,191,0,0,143,192,0,131,248,0,192,248,0,192,56,0,240,8,0,124,8,0,0
.byte 224,112,0,120,0,0,126,0,0,31,128,0,135,240,0,129,240,0,192,112,0,224,112,0,120,112,0,254,240,0,159,240,0,199,240,0,225,240,0,248,0,0,254,0,0,159,128,0,135,240,0,129,240,0,192,112,0,224,16,0,120,16,0,0
.byte 192,224,0,240,0,0,124,0,0,63,0,0,15,224,0,131,224,0,192,224,0,192,224,0,240,224,0,125,224,0,191,224,0,207,224,0,195,224,0,240,0,0,252,0,0,191,0,0,143,224,0,131,224,0,192,224,0,192,32,0,240,32,0,0
.byte 193,192,0,224,0,0,120,0,0,126,0,0,31,192,0,135,192,0,129,192,0,193,192,0,225,192,0,123,192,0,255,192,0,159,192,0,199,192,0,224,0,0,120,0,0,126,0,0,31,192,0,135,192,0,129,192,0,192,64,0,224,64,0,0
.byte 195,128,0,192,0,0,240,0,0,124,0,0,63,128,0,15,128,0,131,128,0,195,128,0,195,128,0,247,128,0,127,128,0,191,128,0,207,128,0,192,0,0,240,0,0,124,0,0,63,128,0,15,128,0,131,128,0,192,128,0,192,128,0,0
.byte 135,0,0,192,0,0,224,0,0,120,0,0,127,0,0,31,0,0,135,0,0,135,0,0,199,0,0,239,0,0,127,0,0,255,0,0,159,0,0,192,0,0,224,0,0,120,0,0,127,0,0,31,0,0,135,0,0,129,0,0,193,0,0,0
.byte 142,0,0,192,0,0,192,0,0,240,0,0,126,0,0,62,0,0,14,0,0,142,0,0,206,0,0,222,0,0,254,0,0,126,0,0,190,0,0,192,0,0,192,0,0,240,0,0,126,0,0,62,0,0,14,0,0,130,0,0,194,0,0,0
.byte 156,0,0,128,0,0,192,0,0,224,0,0,124,0,0,124,0,0,28,0,0,156,0,0,156,0,0,252,0,0,252,0,0,124,0,0,252,0,0,128,0,0,192,0,0,224,0,0,124,0,0,124,0,0,28,0,0,132,0,0,132,0,0,0
.byte 56,0,0,128,0,0,192,0,0,192,0,0,248,0,0,120,0,0,56,0,0,56,0,0,184,0,0,248,0,0,248,0,0,248,0,0,120,0,0,128,0,0,192,0,0,192,0,0,248,0,0,120,0,0,56,0,0,8,0,0,136,0,0,0
.byte 112,0,0,128,0,0,128,0,0,192,0,0,240,0,0,112,0,0,112,0,0,112,0,0,240,0,0,240,0,0,240,0,0,240,0,0,112,0,0,128,0,0,128,0,0,192,0,0,240,0,0,112,0,0,112,0,0,16,0,0,144,0,0,0
.byte 96,0,0,0,0,0,128,0,0,192,0,0,224,0,0,224,0,0,96,0,0,96,0,0,96,0,0,224,0,0,224,0,0,224,0,0,224,0,0,0,0,0,128,0,0,192,0,0,224,0,0,224,0,0,96,0,0,32,0,0,32,0,0,0
.byte 64,0,0,0,0,0,128,0,0,128,0,0,192,0,0,192,0,0,64,0,0,64,0,0,64,0,0,192,0,0,192,0,0,192,0,0,192,0,0,0,0,0,128,0,0,128,0,0,192,0,0,192,0,0,64,0,0,64,0,0,64,0,0,0
.byte 192,0,0,0,0,0,0,0,0,128,0,0,192,0,0,192,0,0,192,0,0,192,0,0,192,0,0,192,0,0,192,0,0,192,0,0,192,0,0,0,0,0,0,0,0,128,0,0,192,0,0,192,0,0,192,0,0,64,0,0,64,0,0,0
.byte 192,0,0,0,0,0,0,0,0,128,0,0,192,0,0,192,0,0,192,0,0,192,0,0,192,0,0,192,0,0,192,0,0,192,0,0,192,0,0,0,0,0,0,0,0,128,0,0,192,0,0,192,0,0,192,0,0,64,0,0,64,0,0,0
.byte 128,0,0,0,0,0,0,0,0,0,0,0,128,0,0,128,0,0,128,0,0,128,0,0,128,0,0,128,0,0,128,0,0,128,0,0,128,0,0,0,0,0,0,0,0,0,0,0,128,0,0,128,0,0,128,0,0,128,0,0,128,0,0,0
.byte 128,0,0,0,0,0,0,0,0,0,0,0,128,0,0,128,0,0,128,0,0,128,0,0,128,0,0,128,0,0,128,0,0,128,0,0,128,0,0,0,0,0,0,0,0,0,0,0,128,0,0,128,0,0,128,0,0,128,0,0,128,0,0,0
.byte 128,0,0,0,0,0,0,0,0,0,0,0,128,0,0,128,0,0,128,0,0,128,0,0,128,0,0,128,0,0,128,0,0,128,0,0,128,0,0,0,0,0,0,0,0,0,0,0,128,0,0,128,0,0,128,0,0,128,0,0,128,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,1,0
.byte 0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,1,0
.byte 0,0,1,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,1,0
.byte 0,0,3,0,0,1,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,2,0,0,3,0,0,3,0
.byte 0,0,3,0,0,3,0,0,3,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,2,0,0,3,0,0,3,0
.byte 0,0,2,0,0,3,0,0,3,0,0,3,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,2,0,0,2,0,0,3,0
.byte 0,0,6,0,0,2,0,0,3,0,0,3,0,0,3,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,4,0,0,6,0,0,7,0
.byte 0,0,14,0,0,6,0,0,6,0,0,3,0,0,3,0,0,1,0,0,1,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,1,0,0,1,0,0,1,0,0,1,0,0,1,0,0,8,0,0,8,0,0,14,0,0,14,0
.byte 0,0,28,0,0,14,0,0,14,0,0,7,0,0,3,0,0,3,0,0,1,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,1,0,0,1,0,0,1,0,0,1,0,0,1,0,0,17,0,0,16,0,0,28,0,0,30,0
.byte 0,0,57,0,0,28,0,0,30,0,0,14,0,0,7,0,0,3,0,0,1,0,0,1,0,0,0,0,0,1,0,0,1,0,0,1,0,0,1,0,0,1,0,0,1,0,0,1,0,0,1,0,0,33,0,0,33,0,0,57,0,0,62,0
.byte 0,0,113,0,0,56,0,0,60,0,0,30,0,0,15,0,0,3,0,0,3,0,0,1,0,0,0,0,0,3,0,0,3,0,0,3,0,0,3,0,0,3,0,0,3,0,0,3,0,0,3,0,0,65,0,0,65,0,0,113,0,0,124,0
.byte 0,0,225,0,0,113,0,0,120,0,0,62,0,0,30,0,0,7,0,0,3,0,0,1,0,0,1,0,0,2,0,0,3,0,0,3,0,0,3,0,0,3,0,0,3,0,0,3,0,0,3,0,0,131,0,0,129,0,0,225,0,0,249,0
.byte 0,1,195,0,0,225,0,0,240,0,0,124,0,0,62,0,0,15,0,0,3,0,0,3,0,0,1,0,0,2,0,0,3,0,0,3,0,0,3,0,0,3,0,0,2,0,0,2,0,0,2,0,1,3,0,1,3,0,1,195,0,1,241,0
.byte 0,3,131,0,1,193,0,1,225,0,0,248,0,0,126,0,0,30,0,0,7,0,0,3,0,0,1,0,0,7,0,0,6,0,0,7,0,0,7,0,0,7,0,0,7,0,0,6,0,0,6,0,2,2,0,2,3,0,3,131,0,3,225,0
.byte 0,7,3,0,3,131,0,3,193,0,1,240,0,0,252,0,0,62,0,0,15,0,0,3,0,0,3,0,0,13,0,0,14,0,0,15,0,0,15,0,0,15,0,0,15,0,0,14,0,0,14,0,4,6,0,4,3,0,7,3,0,7,195,0
.byte 0,14,7,0,7,3,0,7,129,0,3,225,0,1,248,0,0,126,0,0,30,0,0,7,0,0,3,0,0,25,0,0,31,0,0,30,0,0,31,0,0,31,0,0,29,0,0,29,0,0,28,0,8,14,0,8,6,0,14,7,0,15,131,0
.byte 0,28,15,0,14,3,0,15,3,0,7,193,0,3,240,0,0,252,0,0,62,0,0,15,0,0,3,0,0,51,0,0,61,0,0,62,0,0,63,0,0,59,0,0,59,0,0,57,0,0,56,0,16,28,0,16,14,0,28,15,0,31,3,0
.byte 0,56,30,0,28,7,0,30,3,0,15,129,0,7,225,0,1,248,0,0,126,0,0,30,0,0,7,0,0,99,0,0,121,0,0,127,0,0,126,0,0,119,0,0,115,0,0,113,0,0,113,0,32,56,0,32,30,0,56,30,0,62,7,0
.byte 0,112,62,0,56,15,0,60,3,0,31,3,0,15,193,0,3,240,0,0,252,0,0,62,0,0,15,0,0,195,0,0,243,0,0,253,0,0,254,0,0,239,0,0,227,0,0,227,0,0,225,0,64,112,0,64,60,0,112,62,0,124,15,0
.byte 0,224,126,0,112,30,0,120,7,0,62,3,0,31,129,0,7,225,0,1,248,0,0,126,0,0,30,0,1,135,0,1,227,0,1,249,0,1,255,0,1,222,0,1,199,0,1,195,0,1,193,0,128,225,0,128,120,0,224,126,0,248,30,0
.byte 1,192,252,0,224,62,0,240,15,0,124,3,0,63,3,0,15,193,0,3,240,0,0,252,0,0,62,0,3,15,0,3,195,0,3,243,0,3,253,0,3,190,0,3,143,0,3,131,0,3,131,1,1,193,1,0,240,1,192,252,1,240,62,0
.byte 3,129,249,1,192,126,1,224,30,0,248,7,0,126,3,0,31,129,0,7,225,0,1,249,0,0,127,0,6,31,0,7,135,0,7,227,0,7,249,0,7,126,0,7,30,0,7,7,0,7,3,2,3,129,2,1,225,3,129,248,3,224,126,0
.byte 7,3,241,3,128,252,3,192,62,1,240,15,0,252,3,0,63,3,0,15,193,0,3,241,0,0,253,0,12,63,0,15,15,0,15,195,0,15,243,0,14,252,0,14,62,0,14,15,0,14,3,4,7,3,4,3,193,7,3,240,7,192,252,0

.byte 15,224,126,15,248,30,14,126,7,14,31,131,14,7,225,7,1,249,7,129,255,3,225,222,9,251,199,14,127,195,15,159,193,7,231,193,1,248,1,8,126,0,8,31,128,14,7,224,15,129,248,15,224,120,15,248,28,14,126,3,14,31,129,0
.byte 31,192,252,31,240,62,28,252,15,28,63,3,28,15,195,14,3,241,15,3,253,7,195,190,19,247,143,28,255,131,31,63,131,15,207,129,3,240,1,16,252,0,16,63,0,28,15,192,31,3,240,31,192,240,31,240,56,28,252,3,28,63,3,0
.byte 63,129,248,63,224,126,57,248,31,56,126,7,56,31,131,28,7,225,30,7,249,15,135,126,39,239,31,57,255,7,62,127,3,31,159,1,7,224,1,33,248,0,32,126,0,56,31,128,62,7,224,63,129,224,63,224,112,57,248,2,56,126,2,0
.byte 127,3,240,127,192,252,115,240,62,112,252,14,112,63,2,56,15,194,60,15,242,31,14,252,79,222,62,115,254,14,124,254,2,63,62,2,15,192,2,67,240,0,64,252,0,112,63,0,124,15,192,127,3,192,127,192,224,115,240,6,112,252,2,0
.byte 126,7,224,127,129,248,103,224,126,97,248,30,96,126,6,112,31,130,120,31,226,62,29,248,95,188,126,103,252,30,121,252,6,126,124,2,31,128,2,71,224,0,65,248,0,96,126,0,120,31,128,126,7,128,127,129,192,103,224,14,97,248,6,0
.byte 124,15,192,127,3,240,79,192,254,67,240,62,64,252,14,96,63,2,112,63,194,124,59,240,127,120,254,79,248,62,115,248,14,124,248,2,63,0,2,79,192,0,67,240,0,64,252,0,112,63,0,124,15,0,127,3,128,79,192,28,67,240,12,0
.byte 248,31,128,254,7,224,223,129,252,199,224,124,193,248,28,64,126,4,96,127,132,120,119,224,254,241,252,223,240,124,231,240,28,121,240,4,126,0,4,159,128,0,135,224,0,193,248,0,224,126,0,248,30,0,254,7,0,223,128,56,199,224,24,0
.byte 240,63,0,252,15,192,255,3,248,207,192,248,195,240,56,192,252,8,192,255,8,112,239,192,253,227,248,255,224,248,207,224,56,243,224,8,124,0,8,191,0,0,143,192,0,195,240,0,192,252,0,240,60,0,252,14,0,255,0,112,207,192,48,0
.byte 224,126,0,248,31,128,254,7,240,159,129,240,135,224,112,193,248,16,193,254,16,225,223,128,251,199,240,255,193,240,223,192,112,231,192,16,120,0,16,254,0,0,159,128,0,135,224,0,193,248,0,224,120,0,248,28,0,254,0,224,159,128,96,0
.byte 192,252,0,240,63,0,252,15,224,191,3,224,143,192,224,131,240,32,195,252,32,195,191,0,247,143,224,255,131,224,255,128,224,207,128,32,240,0,32,124,0,0,63,0,0,143,192,0,195,240,0,192,240,0,240,56,0,252,1,192,191,0,192,0
.byte 193,248,0,224,126,0,248,31,192,254,7,192,159,129,192,135,224,64,135,248,64,199,126,0,239,31,192,255,7,192,255,1,192,223,0,64,224,0,64,120,0,0,126,0,0,159,128,0,135,224,0,193,224,0,224,112,0,248,3,128,254,1,128,0
.byte 195,240,0,192,252,0,240,63,128,124,15,128,63,3,128,143,192,128,143,240,128,206,252,0,222,63,128,254,15,128,254,3,128,254,0,128,192,0,128,240,0,0,124,0,0,63,0,0,143,192,0,195,192,0,192,224,0,240,7,0,124,3,0,0
.byte 135,224,0,193,248,0,224,127,0,120,31,0,126,7,0,31,129,0,159,225,0,157,248,0,252,127,0,252,31,0,252,7,0,252,1,0,192,1,0,224,0,0,120,0,0,126,0,0,159,128,0,135,128,0,193,192,0,224,14,0,120,6,0,0
.byte 143,192,0,195,240,0,192,254,0,240,62,0,124,14,0,63,2,0,63,194,0,187,240,0,248,254,0,248,62,0,248,14,0,248,2,0,192,2,0,192,0,0,240,0,0,124,0,0,63,0,0,143,0,0,195,128,0,192,28,0,240,12,0,0
.byte 159,128,0,135,224,0,193,252,0,224,124,0,120,28,0,126,4,0,127,132,0,247,224,0,241,252,0,240,124,0,240,28,0,240,4,0,128,4,0,192,0,0,224,0,0,120,0,0,126,0,0,158,0,0,135,0,0,192,56,0,224,24,0,0
.byte 63,0,0,143,192,0,195,248,0,192,248,0,240,56,0,124,8,0,127,8,0,111,192,0,227,248,0,224,248,0,224,56,0,224,8,0,128,8,0,192,0,0,192,0,0,240,0,0,124,0,0,60,0,0,142,0,0,192,112,0,192,48,0,0
.byte 126,0,0,159,128,0,135,240,0,193,240,0,224,112,0,120,16,0,126,16,0,95,128,0,199,240,0,193,240,0,192,112,0,192,16,0,128,16,0,128,0,0,192,0,0,224,0,0,120,0,0,120,0,0,156,0,0,128,224,0,192,96,0,0
.byte 124,0,0,63,0,0,143,224,0,195,224,0,192,224,0,240,32,0,252,32,0,255,0,0,207,224,0,195,224,0,192,224,0,192,32,0,0,32,0,128,0,0,192,0,0,192,0,0,240,0,0,112,0,0,56,0,0,129,192,0,192,192,0,0
.byte 120,0,0,126,0,0,159,192,0,135,192,0,193,192,0,224,64,0,248,64,0,254,0,0,223,192,0,199,192,0,193,192,0,192,64,0,0,64,0,128,0,0,128,0,0,192,0,0,224,0,0,96,0,0,112,0,0,131,128,0,129,128,0,0
.byte 240,0,0,124,0,0,63,128,0,143,128,0,195,128,0,192,128,0,240,128,0,252,0,0,191,128,0,143,128,0,131,128,0,128,128,0,0,128,0,0,0,0,128,0,0,192,0,0,192,0,0,192,0,0,96,0,0,7,0,0,131,0,0,0
.byte 224,0,0,120,0,0,127,0,0,159,0,0,135,0,0,193,0,0,225,0,0,248,0,0,255,0,0,159,0,0,135,0,0,129,0,0,1,0,0,0,0,0,128,0,0,128,0,0,192,0,0,192,0,0,64,0,0,14,0,0,134,0,0,0
.byte 192,0,0,240,0,0,126,0,0,62,0,0,142,0,0,194,0,0,194,0,0,240,0,0,254,0,0,190,0,0,142,0,0,130,0,0,2,0,0,0,0,0,0,0,0,128,0,0,192,0,0,192,0,0,192,0,0,28,0,0,12,0,0,0
.byte 192,0,0,224,0,0,124,0,0,124,0,0,156,0,0,132,0,0,196,0,0,224,0,0,124,0,0,124,0,0,28,0,0,4,0,0,4,0,0,0,0,0,0,0,0,128,0,0,128,0,0,128,0,0,192,0,0,56,0,0,24,0,0,0
.byte 192,0,0,192,0,0,248,0,0,120,0,0,56,0,0,136,0,0,200,0,0,192,0,0,248,0,0,120,0,0,56,0,0,8,0,0,8,0,0,0,0,0,0,0,0,0,0,0,128,0,0,128,0,0,128,0,0,112,0,0,48,0,0,0
.byte 128,0,0,192,0,0,240,0,0,112,0,0,112,0,0,144,0,0,144,0,0,192,0,0,240,0,0,112,0,0,112,0,0,16,0,0,16,0,0,0,0,0,0,0,0,0,0,0,128,0,0,128,0,0,128,0,0,96,0,0,96,0,0,0
.byte 128,0,0,192,0,0,224,0,0,224,0,0,96,0,0,32,0,0,160,0,0,192,0,0,224,0,0,224,0,0,96,0,0,32,0,0,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,0,0,64,0,0,64,0,0,0
.byte 128,0,0,128,0,0,192,0,0,192,0,0,64,0,0,64,0,0,192,0,0,128,0,0,192,0,0,192,0,0,64,0,0,64,0,0,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,0,0,64,0,0,0
.byte 0,0,0,128,0,0,192,0,0,192,0,0,192,0,0,64,0,0,64,0,0,128,0,0,192,0,0,192,0,0,192,0,0,64,0,0,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,0,0,192,0,0,0
.byte 0,0,0,128,0,0,192,0,0,192,0,0,192,0,0,64,0,0,64,0,0,128,0,0,192,0,0,192,0,0,192,0,0,64,0,0,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,0,0,128,0,0,0
.byte 0,0,0,0,0,0,128,0,0,128,0,0,128,0,0,128,0,0,128,0,0,0,0,0,128,0,0,128,0,0,128,0,0,128,0,0,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,0,0,128,0,0,0
.byte 0,0,0,0,0,0,128,0,0,128,0,0,128,0,0,128,0,0,128,0,0,0,0,0,128,0,0,128,0,0,128,0,0,128,0,0,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,0,0,128,0,0,0
.byte 0,0,0,0,0,0,128,0,0,128,0,0,128,0,0,128,0,0,128,0,0,0,0,0,128,0,0,128,0,0,128,0,0,128,0,0,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,1,0,0,1,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,1,0,0,1,0,0,1,0,0,1,0,0,1,0
.byte 0,0,1,0,0,1,0,0,1,0,0,1,0,0,1,0,0,1,0,0,1,0,0,0,0,0,1,0,0,1,0,0,1,0,0,1,0,0,0,0,0,1,0,0,1,0,0,1,0,0,1,0,0,1,0,0,1,0,0,1,0,0,1,0
.byte 0,0,1,0,0,1,0,0,1,0,0,1,0,0,1,0,0,1,0,0,1,0,0,1,0,0,1,0,0,1,0,0,1,0,0,1,0,0,0,0,0,1,0,0,1,0,0,1,0,0,1,0,0,1,0,0,1,0,0,1,0,0,1,0
.byte 0,0,3,0,0,3,0,0,3,0,0,3,0,0,3,0,0,1,0,0,1,0,0,1,0,0,3,0,0,3,0,0,3,0,0,1,0,0,1,0,0,2,0,0,2,0,0,3,0,0,3,0,0,3,0,0,3,0,0,3,0,0,3,0
.byte 0,0,3,0,0,3,0,0,3,0,0,3,0,0,3,0,0,3,0,0,3,0,0,1,0,0,3,0,0,3,0,0,3,0,0,3,0,0,1,0,0,2,0,0,2,0,0,3,0,0,3,0,0,3,0,0,3,0,0,3,0,0,3,0
.byte 0,0,3,0,0,3,0,0,3,0,0,2,0,0,2,0,0,3,0,0,3,0,0,3,0,0,3,0,0,3,0,0,3,0,0,3,0,0,1,0,0,3,0,0,2,0,0,2,0,0,3,0,0,3,0,0,3,0,0,3,0,0,2,0
.byte 0,0,7,0,0,7,0,0,7,0,0,6,0,0,6,0,0,2,0,0,3,0,0,3,0,0,7,0,0,7,0,0,7,0,0,3,0,0,3,0,0,5,0,0,4,0,0,6,0,0,7,0,0,7,0,0,7,0,0,7,0,0,6,0
.byte 0,0,15,0,0,15,0,0,15,0,0,15,0,0,14,0,0,6,0,0,6,0,0,3,0,0,11,0,0,15,0,0,15,0,0,7,0,0,3,0,0,9,0,0,9,0,0,14,0,0,14,0,0,15,0,0,15,0,0,15,0,0,15,0
.byte 0,0,31,0,0,31,0,0,31,0,0,29,0,0,28,0,0,14,0,0,14,0,0,7,0,0,19,0,0,31,0,0,31,0,0,15,0,0,3,0,0,19,0,0,17,0,0,28,0,0,30,0,0,31,0,0,31,0,0,31,0,0,29,0
.byte 0,0,62,0,0,63,0,0,59,0,0,57,0,0,57,0,0,28,0,0,30,0,0,14,0,0,39,0,0,59,0,0,63,0,0,31,0,0,7,0,0,35,0,0,33,0,0,57,0,0,62,0,0,62,0,0,63,0,0,59,0,0,57,0
.byte 0,0,126,0,0,127,0,0,115,0,0,115,0,0,113,0,0,56,0,0,60,0,0,30,0,0,79,0,0,115,0,0,127,0,0,63,0,0,15,0,0,67,0,0,67,0,0,113,0,0,124,0,0,126,0,0,127,0,0,115,0,0,115,0
.byte 0,0,254,0,0,254,0,0,231,0,0,227,0,0,225,0,0,113,0,0,121,0,0,63,0,0,159,0,0,231,0,0,251,0,0,127,0,0,30,0,0,135,0,0,131,0,0,225,0,0,249,0,0,254,0,0,254,0,0,231,0,0,227,0
.byte 0,1,252,0,1,254,0,1,207,0,1,195,0,1,195,0,0,225,0,0,241,0,0,125,0,1,63,0,1,207,0,1,243,0,0,255,0,0,62,0,1,15,0,1,3,0,1,195,0,1,241,0,1,252,0,1,254,0,1,207,0,1,195,0
.byte 0,3,249,0,3,254,0,3,158,0,3,135,0,3,131,0,1,193,0,1,225,0,0,249,0,2,127,0,3,159,0,3,231,0,1,251,0,0,126,0,2,30,0,2,7,0,3,131,0,3,225,0,3,249,0,3,254,0,3,158,0,3,135,0
.byte 0,7,241,0,7,252,0,7,62,0,7,15,0,7,3,0,3,131,0,3,195,0,1,243,0,4,255,0,7,63,0,7,207,0,3,243,0,0,252,0,4,62,0,4,15,0,7,3,0,7,195,0,7,241,0,7,252,0,7,62,0,7,15,0
.byte 0,15,225,0,15,249,0,14,126,0,14,30,0,14,7,0,7,3,0,7,131,0,3,227,0,9,251,0,14,127,0,15,159,0,7,231,0,1,248,0,8,126,0,8,30,0,14,7,0,15,131,0,15,225,0,15,249,0,14,126,0,14,30,0
.byte 0,31,195,0,31,241,0,28,252,0,28,62,0,28,15,0,14,3,0,15,3,0,7,195,0,19,246,0,28,254,0,31,62,0,15,206,0,3,240,0,16,252,0,16,62,0,28,15,0,31,3,0,31,195,0,31,241,0,28,252,0,28,62,0
.byte 0,63,131,0,63,225,0,57,249,0,56,126,0,56,30,0,28,7,0,30,7,0,15,135,0,39,239,0,57,254,0,62,126,0,31,158,0,7,224,0,33,248,0,32,126,0,56,30,0,62,7,0,63,131,0,63,225,0,57,248,0,56,126,0
.byte 0,127,3,0,127,195,0,115,241,0,112,252,0,112,62,0,56,15,0,60,15,0,31,15,0,79,223,0,115,254,0,124,254,0,63,62,0,15,192,0,67,240,0,64,252,0,112,62,0,124,15,0,127,3,0,127,195,0,115,240,0,112,252,0
.byte 0,254,7,0,255,131,0,231,225,0,225,249,0,224,126,0,112,30,0,120,31,0,62,31,0,159,189,0,231,253,0,249,252,0,126,124,0,31,128,0,135,224,0,129,248,0,224,126,0,248,30,0,254,6,0,255,131,0,231,224,0,225,248,0
.byte 1,252,15,1,255,3,1,207,195,1,195,241,1,192,252,0,224,62,0,240,63,0,124,59,1,63,123,1,207,249,1,243,248,0,252,248,0,63,0,1,15,192,1,3,240,1,192,252,1,240,62,1,252,14,1,255,2,1,207,193,1,195,240,0
.byte 3,248,30,3,254,7,3,159,131,3,135,225,3,129,249,1,192,126,1,224,126,0,248,119,2,126,243,3,159,241,3,231,241,1,249,240,0,126,0,2,31,128,2,7,224,3,129,248,3,224,126,3,248,30,3,254,6,3,159,129,3,135,225,0
.byte 7,240,62,7,252,15,7,63,3,7,15,195,7,3,241,3,128,252,3,192,254,1,240,239,4,253,227,7,63,227,7,207,225,3,243,224,0,252,0,4,63,0,4,15,192,7,3,240,7,192,252,7,240,60,7,252,14,7,63,1,7,15,193,0


.pc =$6000 "spritecucc eleje"
spcucc_e:
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,0,0,128,0,0,128,0,0,128,0,0,0
.byte 128,0,0,128,0,0,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,0,0,128,0,0,128,0,0,128,0,0,0
.byte 192,0,0,128,0,0,128,0,0,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,0,0,64,0,0,192,0,0,192,0,0,0
.byte 192,0,0,192,0,0,192,0,0,128,0,0,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,0,0,64,0,0,192,0,0,192,0,0,0
.byte 64,0,0,192,0,0,192,0,0,192,0,0,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,0,0,64,0,0,64,0,0,192,0,0,0
.byte 96,0,0,64,0,0,192,0,0,192,0,0,192,0,0,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,0,0,32,0,0,96,0,0,224,0,0,0
.byte 112,0,0,96,0,0,96,0,0,192,0,0,192,0,0,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,0,16,0,0,112,0,0,112,0,0,0
.byte 56,0,0,112,0,0,112,0,0,224,0,0,192,0,0,192,0,0,128,0,0,0,0,0,0,0,0,128,0,0,128,0,0,128,0,0,128,0,0,128,0,0,128,0,0,128,0,0,128,0,0,8,0,0,8,0,0,56,0,0,120,0,0,0
.byte 28,0,0,56,0,0,120,0,0,112,0,0,224,0,0,192,0,0,128,0,0,0,0,0,0,0,0,128,0,0,128,0,0,128,0,0,128,0,0,128,0,0,128,0,0,128,0,0,128,0,0,132,0,0,4,0,0,28,0,0,124,0,0,0
.byte 142,0,0,28,0,0,60,0,0,120,0,0,240,0,0,192,0,0,192,0,0,128,0,0,0,0,0,192,0,0,192,0,0,192,0,0,192,0,0,192,0,0,192,0,0,192,0,0,192,0,0,130,0,0,130,0,0,142,0,0,62,0,0,0
.byte 135,0,0,14,0,0,30,0,0,124,0,0,120,0,0,224,0,0,192,0,0,128,0,0,0,0,0,64,0,0,192,0,0,192,0,0,192,0,0,192,0,0,192,0,0,192,0,0,192,0,0,193,0,0,129,0,0,135,0,0,31,0,0,0
.byte 195,128,0,135,0,0,15,0,0,62,0,0,124,0,0,240,0,0,192,0,0,192,0,0,128,0,0,64,0,0,192,0,0,192,0,0,192,0,0,192,0,0,64,0,0,64,0,0,64,0,0,192,128,0,192,128,0,195,128,0,143,128,0,0
.byte 193,192,0,131,128,0,7,128,0,31,0,0,126,0,0,120,0,0,224,0,0,192,0,0,128,0,0,96,0,0,96,0,0,224,0,0,224,0,0,224,0,0,96,0,0,96,0,0,96,0,0,64,64,0,192,64,0,193,192,0,135,192,0,0
.byte 192,224,0,193,192,0,131,192,0,15,128,0,63,0,0,124,0,0,240,0,0,192,0,0,192,0,0,176,0,0,112,0,0,240,0,0,240,0,0,240,0,0,240,0,0,112,0,0,112,0,0,96,32,0,192,32,0,192,224,0,195,224,0,0
.byte 224,112,0,192,224,0,129,224,0,7,192,0,31,128,0,126,0,0,120,0,0,224,0,0,192,0,0,152,0,0,120,0,0,120,0,0,248,0,0,248,0,0,184,0,0,56,0,0,56,0,0,112,16,0,96,16,0,224,112,0,193,240,0,0
.byte 240,56,0,192,112,0,192,240,0,131,224,0,15,192,0,63,0,0,124,0,0,240,0,0,192,0,0,204,0,0,188,0,0,124,0,0,252,0,0,220,0,0,220,0,0,156,0,0,28,0,0,56,8,0,112,8,0,240,56,0,192,248,0,0
.byte 120,28,0,224,56,0,192,120,0,129,240,0,7,224,0,31,128,0,126,0,0,120,0,0,224,0,0,198,0,0,158,0,0,126,0,0,126,0,0,238,0,0,206,0,0,142,0,0,14,0,0,28,4,0,120,4,0,120,28,0,224,124,0,0
.byte 124,14,0,240,28,0,192,60,0,192,248,0,131,240,0,15,192,0,63,0,0,124,0,0,240,0,0,195,0,0,207,0,0,191,0,0,127,0,0,247,0,0,199,0,0,199,0,0,135,0,0,14,2,0,60,2,0,124,14,0,240,62,0,0
.byte 126,7,0,120,14,0,224,30,0,192,124,0,129,248,0,7,224,0,31,128,0,126,0,0,120,0,0,225,128,0,199,128,0,159,128,0,127,128,0,123,128,0,227,128,0,195,128,0,131,128,0,7,1,0,30,1,0,126,7,0,120,31,0,0
.byte 63,3,128,124,7,0,240,15,0,192,62,0,192,252,0,131,240,0,15,192,0,63,0,0,124,0,0,240,192,0,195,192,0,207,192,0,191,192,0,125,192,0,241,192,0,193,192,0,193,192,0,131,128,128,15,0,128,63,3,128,124,15,128,0
.byte 31,129,192,126,3,128,120,7,128,224,31,0,192,126,0,129,248,0,7,224,0,31,128,0,126,0,0,248,96,0,225,224,0,199,224,0,159,224,0,126,224,0,120,224,0,224,224,0,192,224,0,129,192,64,7,128,64,31,129,192,126,7,192,0
.byte 143,192,224,63,1,192,124,3,192,240,15,128,192,63,0,192,252,0,131,240,0,143,192,0,191,0,0,252,48,0,240,240,0,195,240,0,207,240,0,63,112,0,124,112,0,240,112,0,192,112,0,192,224,32,131,192,32,15,192,224,63,3,224,0
.byte 135,224,112,31,128,224,126,1,224,120,7,192,224,31,128,192,126,0,129,248,0,135,224,0,159,128,0,254,24,0,248,120,0,225,248,0,199,248,0,31,184,0,126,56,0,120,56,0,224,56,0,192,112,16,129,224,16,7,224,112,31,129,240,0
.byte 195,240,56,15,192,112,63,0,240,124,3,224,240,15,192,192,63,0,192,252,0,195,240,0,207,192,0,255,12,0,252,60,0,240,252,0,195,252,0,15,220,0,63,28,0,124,28,0,240,28,0,192,56,8,192,240,8,131,240,56,143,192,248,0
.byte 193,248,28,7,224,56,31,128,120,126,1,240,248,7,224,224,31,128,192,126,0,193,248,0,199,224,0,223,134,0,254,30,0,248,126,0,225,254,0,7,238,0,31,142,0,126,14,0,248,14,0,224,28,4,192,120,4,129,248,28,135,224,124,0
.byte 64,252,14,3,240,28,15,192,60,63,0,248,124,3,240,112,15,192,64,63,0,64,252,0,67,240,0,111,195,0,127,15,0,124,63,0,112,255,0,3,247,0,15,199,0,63,7,0,124,7,0,112,14,2,64,60,2,64,252,14,67,240,62,0
.byte 96,126,6,1,248,14,7,224,30,31,128,124,126,1,248,120,7,224,96,31,128,96,126,0,97,248,0,119,225,128,127,135,128,126,31,128,120,127,128,1,251,128,7,227,128,31,131,128,126,3,128,120,7,2,96,30,2,64,126,6,65,248,30,0
.byte 112,63,2,0,252,6,3,240,14,15,192,62,127,0,252,124,3,240,112,15,192,112,63,0,112,252,0,123,240,192,127,195,192,127,15,192,124,63,192,0,253,192,3,241,192,15,193,192,127,1,192,124,3,130,112,15,2,64,63,2,64,252,14,0
.byte 56,31,131,0,126,2,1,248,6,7,224,30,63,128,126,62,1,248,56,7,224,56,31,128,56,126,0,61,248,96,63,225,224,63,135,224,62,31,224,0,126,224,1,248,224,7,224,224,63,128,224,62,1,193,56,7,129,32,31,131,32,126,7,0
.byte 28,15,195,0,63,3,0,252,3,3,240,14,31,192,62,31,0,252,28,3,240,28,15,192,28,63,0,30,252,48,31,240,240,31,195,240,31,15,240,0,63,112,0,252,112,3,240,112,31,192,112,31,0,225,28,3,193,16,15,195,16,63,3,0
.byte 14,7,225,0,31,131,0,126,3,1,248,7,15,224,30,15,128,126,14,1,248,14,7,224,14,31,128,15,126,24,15,248,120,15,225,248,15,135,248,0,31,184,0,126,56,1,248,56,15,224,56,15,128,112,14,1,224,8,7,225,8,31,131,0
.byte 7,3,241,0,15,193,0,63,3,0,252,3,7,240,15,7,192,62,7,0,252,7,3,240,7,15,192,7,191,12,7,252,60,7,240,252,7,195,252,0,15,220,0,63,28,0,252,28,7,240,28,7,192,56,7,0,240,4,3,241,4,15,195,0
.byte 3,129,248,0,7,225,0,31,129,0,126,3,3,248,7,3,224,30,3,128,126,3,129,248,3,135,224,3,223,134,3,254,30,3,248,126,3,225,254,0,7,238,0,31,142,0,126,14,3,248,14,3,224,28,3,128,120,2,1,248,2,7,225,0
.byte 1,192,252,0,3,240,0,15,193,0,63,3,1,252,3,1,240,15,1,192,62,1,192,252,1,195,240,1,239,194,1,255,14,1,252,62,1,240,254,0,3,246,0,15,198,0,63,6,1,252,6,1,240,14,1,192,60,1,0,252,1,3,241,0
.byte 0,224,126,0,1,248,0,7,224,0,31,129,0,254,3,0,248,7,0,224,30,0,224,126,0,225,248,0,247,226,0,255,134,0,254,30,0,248,126,0,1,250,0,7,226,0,31,130,0,254,2,0,248,6,0,224,30,0,128,126,0,129,248,0
.byte 0,112,62,0,0,252,0,3,240,0,15,193,0,127,3,0,124,3,0,112,15,0,112,62,0,112,252,0,123,243,0,127,195,0,127,15,0,124,63,0,0,255,0,3,243,0,15,195,0,127,3,0,124,2,0,112,14,0,64,62,0,64,252,0
.byte 0,56,30,0,0,126,0,1,248,0,7,224,0,63,129,0,62,3,0,56,7,0,56,30,0,56,126,0,61,249,0,63,227,0,63,135,0,62,31,0,0,127,0,1,251,0,7,227,0,63,131,0,62,3,0,56,6,0,32,30,0,32,126,0
.byte 0,28,15,0,0,62,0,0,252,0,3,240,0,31,193,0,31,3,0,28,3,0,28,15,0,28,62,0,30,253,0,31,243,0,31,195,0,31,15,0,0,63,0,0,253,0,3,241,0,31,193,0,31,3,0,28,3,0,16,15,0,16,62,0
.byte 0,14,7,0,0,30,0,0,126,0,1,248,0,15,224,0,15,129,0,14,3,0,14,7,0,14,30,0,15,126,0,15,249,0,15,227,0,15,135,0,0,31,0,0,127,0,1,249,0,15,225,0,15,129,0,14,3,0,8,7,0,8,30,0
.byte 0,7,3,0,0,15,0,0,62,0,0,252,0,7,240,0,7,193,0,7,3,0,7,3,0,7,15,0,7,190,0,7,253,0,7,243,0,7,195,0,0,15,0,0,62,0,0,252,0,7,240,0,7,193,0,7,3,0,4,3,0,4,15,0
.byte 0,3,131,0,0,7,0,0,30,0,0,126,0,3,248,0,3,224,0,3,129,0,3,131,0,3,135,0,3,222,0,3,254,0,3,249,0,3,227,0,0,7,0,0,30,0,0,126,0,3,248,0,3,224,0,3,129,0,2,3,0,2,7,0
.byte 0,1,195,0,0,3,0,0,15,0,0,62,0,1,252,0,1,240,0,1,193,0,1,195,0,1,195,0,1,239,0,1,254,0,1,253,0,1,243,0,0,3,0,0,15,0,0,62,0,1,252,0,1,240,0,1,193,0,1,3,0,1,3,0
.byte 0,0,225,0,0,3,0,0,7,0,0,30,0,0,254,0,0,248,0,0,224,0,0,225,0,0,227,0,0,247,0,0,254,0,0,254,0,0,249,0,0,3,0,0,7,0,0,30,0,0,254,0,0,248,0,0,224,0,0,129,0,0,131,0
.byte 0,0,113,0,0,3,0,0,3,0,0,15,0,0,126,0,0,124,0,0,112,0,0,113,0,0,115,0,0,123,0,0,127,0,0,126,0,0,125,0,0,3,0,0,3,0,0,15,0,0,126,0,0,124,0,0,112,0,0,65,0,0,67,0
.byte 0,0,56,0,0,1,0,0,3,0,0,7,0,0,62,0,0,62,0,0,56,0,0,56,0,0,57,0,0,63,0,0,63,0,0,62,0,0,62,0,0,1,0,0,3,0,0,7,0,0,62,0,0,62,0,0,56,0,0,32,0,0,33,0
.byte 0,0,28,0,0,1,0,0,3,0,0,3,0,0,31,0,0,30,0,0,28,0,0,28,0,0,29,0,0,31,0,0,31,0,0,31,0,0,30,0,0,1,0,0,3,0,0,3,0,0,31,0,0,30,0,0,28,0,0,16,0,0,17,0
.byte 0,0,14,0,0,0,0,0,1,0,0,3,0,0,15,0,0,14,0,0,14,0,0,14,0,0,14,0,0,15,0,0,15,0,0,15,0,0,14,0,0,0,0,0,1,0,0,3,0,0,15,0,0,14,0,0,14,0,0,8,0,0,8,0
.byte 0,0,6,0,0,0,0,0,1,0,0,3,0,0,7,0,0,7,0,0,6,0,0,6,0,0,6,0,0,7,0,0,7,0,0,7,0,0,7,0,0,0,0,0,1,0,0,3,0,0,7,0,0,7,0,0,6,0,0,4,0,0,4,0
.byte 0,0,2,0,0,0,0,0,0,0,0,1,0,0,3,0,0,3,0,0,2,0,0,2,0,0,2,0,0,3,0,0,3,0,0,3,0,0,3,0,0,0,0,0,0,0,0,1,0,0,3,0,0,3,0,0,2,0,0,2,0,0,2,0
.byte 0,0,3,0,0,0,0,0,0,0,0,1,0,0,3,0,0,3,0,0,3,0,0,3,0,0,3,0,0,3,0,0,3,0,0,3,0,0,3,0,0,0,0,0,0,0,0,1,0,0,3,0,0,3,0,0,3,0,0,2,0,0,2,0
.byte 0,0,3,0,0,0,0,0,0,0,0,0,0,0,3,0,0,3,0,0,3,0,0,3,0,0,3,0,0,3,0,0,3,0,0,3,0,0,3,0,0,0,0,0,0,0,0,0,0,0,3,0,0,3,0,0,3,0,0,2,0,0,2,0
.byte 0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,1,0,0,1,0,0,1,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,1,0,0,1,0
.byte 0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,1,0,0,1,0,0,1,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,1,0,0,1,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 128,0,0,128,0,0,128,0,0,128,0,0,128,0,0,0,0,0,0,0,0,0,0,0,128,0,0,128,0,0,128,0,0,0,0,0,0,0,0,128,0,0,128,0,0,128,0,0,128,0,0,128,0,0,128,0,0,128,0,0,128,0,0,0
.byte 128,0,0,128,0,0,128,0,0,128,0,0,128,0,0,128,0,0,128,0,0,0,0,0,128,0,0,128,0,0,128,0,0,128,0,0,0,0,0,128,0,0,128,0,0,128,0,0,128,0,0,128,0,0,128,0,0,128,0,0,128,0,0,0
.byte 192,0,0,192,0,0,192,0,0,192,0,0,192,0,0,128,0,0,128,0,0,128,0,0,64,0,0,192,0,0,192,0,0,128,0,0,0,0,0,64,0,0,64,0,0,192,0,0,192,0,0,192,0,0,192,0,0,192,0,0,192,0,0,0
.byte 192,0,0,192,0,0,192,0,0,192,0,0,192,0,0,192,0,0,192,0,0,128,0,0,192,0,0,192,0,0,192,0,0,192,0,0,128,0,0,64,0,0,64,0,0,192,0,0,192,0,0,192,0,0,192,0,0,192,0,0,192,0,0,0
.byte 192,0,0,192,0,0,64,0,0,64,0,0,64,0,0,192,0,0,192,0,0,192,0,0,192,0,0,64,0,0,192,0,0,192,0,0,128,0,0,64,0,0,64,0,0,64,0,0,192,0,0,192,0,0,192,0,0,64,0,0,64,0,0,0
.byte 224,0,0,224,0,0,224,0,0,96,0,0,96,0,0,64,0,0,192,0,0,192,0,0,224,0,0,224,0,0,224,0,0,192,0,0,192,0,0,160,0,0,32,0,0,96,0,0,224,0,0,224,0,0,224,0,0,224,0,0,96,0,0,0
.byte 240,0,0,240,0,0,240,0,0,112,0,0,112,0,0,96,0,0,96,0,0,192,0,0,208,0,0,240,0,0,112,0,0,224,0,0,192,0,0,144,0,0,16,0,0,112,0,0,112,0,0,240,0,0,240,0,0,240,0,0,112,0,0,0
.byte 248,0,0,248,0,0,248,0,0,184,0,0,56,0,0,112,0,0,112,0,0,224,0,0,200,0,0,248,0,0,248,0,0,240,0,0,192,0,0,200,0,0,136,0,0,56,0,0,120,0,0,248,0,0,248,0,0,248,0,0,184,0,0,0
.byte 124,0,0,252,0,0,220,0,0,156,0,0,28,0,0,56,0,0,120,0,0,112,0,0,228,0,0,220,0,0,252,0,0,120,0,0,224,0,0,196,0,0,132,0,0,28,0,0,124,0,0,124,0,0,252,0,0,220,0,0,156,0,0,0
.byte 126,0,0,254,0,0,206,0,0,206,0,0,142,0,0,28,0,0,60,0,0,120,0,0,242,0,0,206,0,0,254,0,0,252,0,0,240,0,0,194,0,0,194,0,0,142,0,0,62,0,0,126,0,0,254,0,0,206,0,0,206,0,0,0
.byte 127,0,0,127,0,0,231,0,0,199,0,0,135,0,0,14,0,0,30,0,0,124,0,0,249,0,0,231,0,0,223,0,0,254,0,0,120,0,0,225,0,0,193,0,0,135,0,0,31,0,0,127,0,0,127,0,0,231,0,0,199,0,0,0
.byte 63,128,0,127,128,0,243,128,0,195,128,0,195,128,0,135,0,0,143,0,0,190,0,0,252,128,0,243,128,0,207,128,0,255,0,0,124,0,0,240,128,0,192,128,0,195,128,0,143,128,0,63,128,0,127,128,0,243,128,0,195,128,0,0
.byte 31,192,0,127,192,0,121,192,0,225,192,0,193,192,0,131,128,0,135,128,0,159,0,0,254,64,0,249,192,0,231,192,0,223,128,0,126,0,0,120,64,0,224,64,0,193,192,0,135,192,0,31,192,0,127,192,0,121,192,0,225,192,0,0
.byte 143,224,0,63,224,0,124,224,0,240,224,0,192,224,0,193,192,0,195,192,0,207,128,0,255,32,0,252,224,0,243,224,0,207,192,0,63,0,0,124,32,0,240,32,0,192,224,0,195,224,0,143,224,0,63,224,0,124,224,0,240,224,0,0
.byte 135,240,0,31,240,0,126,112,0,120,112,0,224,112,0,192,224,0,193,224,0,199,192,0,223,144,0,254,112,0,249,240,0,231,224,0,31,128,0,126,16,0,120,16,0,224,112,0,193,240,0,135,240,0,31,240,0,126,112,0,120,112,0,0
.byte 195,248,0,143,248,0,63,56,0,124,56,0,240,56,0,192,112,0,192,240,0,195,224,0,111,200,0,127,56,0,124,248,0,115,240,0,15,192,0,63,8,0,124,8,0,240,56,0,192,248,0,195,248,0,143,248,0,63,56,0,124,56,0,0
.byte 193,252,0,135,252,0,31,156,0,126,28,0,120,28,0,224,56,0,224,120,0,225,240,0,119,228,0,127,156,0,126,124,0,121,248,0,7,224,0,31,132,0,126,4,0,120,28,0,224,124,0,193,252,0,135,252,0,31,156,0,126,28,0,0
.byte 192,254,0,195,254,0,143,206,0,63,14,0,124,14,0,240,28,0,240,60,0,240,248,0,251,242,0,127,206,0,127,62,0,124,252,0,3,240,0,15,194,0,63,2,0,124,14,0,240,62,0,192,254,0,195,254,0,15,206,0,63,14,0,0
.byte 224,127,0,193,255,0,135,231,0,31,135,0,126,7,0,120,14,0,248,30,0,248,124,0,189,249,0,63,231,0,63,159,0,62,126,0,1,248,0,7,225,0,31,129,0,126,7,0,120,31,0,96,127,0,193,255,0,7,231,0,31,135,0,0
.byte 240,63,128,192,255,128,195,243,128,143,195,128,63,3,128,124,7,0,252,15,0,220,62,0,222,252,128,159,243,128,31,207,128,31,63,0,0,252,0,3,240,128,15,192,128,63,3,128,124,15,128,112,63,128,64,255,128,3,243,128,15,195,128,0
.byte 120,31,192,224,127,192,193,249,192,135,225,192,31,129,192,126,3,128,126,7,128,238,31,0,207,126,64,143,249,192,15,231,192,15,159,128,0,126,0,1,248,64,7,224,64,31,129,192,126,7,192,120,31,192,96,127,192,129,249,192,7,225,192,0
.byte 124,15,224,240,63,224,192,252,224,195,240,224,143,192,224,63,1,192,127,3,192,247,15,128,199,191,32,199,252,224,135,243,224,7,207,192,0,63,0,0,252,32,3,240,32,15,192,224,63,3,224,60,15,224,112,63,224,128,252,224,131,240,224,0
.byte 126,7,240,120,31,240,224,126,112,193,248,112,135,224,112,31,128,224,127,129,224,123,135,192,227,223,144,195,254,112,131,249,240,3,231,224,0,31,128,0,126,16,1,248,16,7,224,112,31,129,240,30,7,240,56,31,240,192,126,112,129,248,112,0
.byte 63,3,248,124,15,248,240,63,56,192,252,56,195,240,56,143,192,112,191,192,240,125,195,224,241,239,200,193,255,56,193,252,248,129,243,240,128,15,192,0,63,8,0,252,8,3,240,56,15,192,248,15,3,248,28,15,248,192,63,56,192,252,56,0
.byte 31,129,252,126,7,252,248,31,156,224,126,28,193,248,28,135,224,56,159,224,120,126,225,240,248,247,228,224,255,156,192,254,124,128,249,248,128,7,224,0,31,132,0,126,4,1,248,28,7,224,124,7,129,252,14,7,252,64,31,156,64,126,28,0
.byte 15,192,254,63,3,254,124,15,206,112,63,14,64,252,14,67,240,28,79,240,60,63,112,248,124,123,242,112,127,206,64,127,62,64,124,252,64,3,240,0,15,194,0,63,2,0,252,14,3,240,62,3,192,254,7,3,254,96,15,206,64,63,14,0
.byte 7,224,126,31,129,254,126,7,230,120,31,134,96,126,6,65,248,14,71,248,30,31,184,124,126,61,250,120,63,230,96,63,158,64,62,126,64,1,248,0,7,226,0,31,130,0,126,6,1,248,30,1,224,126,3,129,254,112,7,230,96,31,134,0
.byte 3,240,62,15,192,254,127,3,242,124,15,194,112,63,2,64,252,6,67,252,14,15,220,62,127,30,254,124,31,242,112,31,206,64,31,62,64,0,252,0,3,242,0,15,194,0,63,2,0,252,14,0,240,62,1,192,254,56,3,242,48,15,194,0
.byte 1,248,31,7,224,127,63,129,251,62,7,227,56,31,131,32,126,2,33,254,6,7,238,30,63,143,127,62,15,251,56,15,231,32,15,158,32,0,126,0,1,249,0,7,225,0,31,131,0,126,7,0,120,31,0,224,127,28,1,251,24,7,227,0
.byte 0,252,15,3,240,63,31,192,255,31,3,243,28,15,195,16,63,3,16,255,3,3,247,14,31,199,191,31,7,255,28,7,243,16,7,207,16,0,62,0,0,253,0,3,241,0,15,195,0,63,3,0,60,15,0,112,63,14,0,255,12,3,243,0
.byte 0,126,7,1,248,31,15,224,127,15,129,249,14,7,225,8,31,131,8,127,131,1,251,135,15,227,222,15,131,255,14,3,251,8,3,231,8,0,30,0,0,126,0,1,248,0,7,225,0,31,131,0,30,7,0,56,31,7,0,127,6,1,249,0
.byte 0,63,3,0,252,15,7,240,63,7,192,253,7,3,241,4,15,193,4,63,195,0,253,195,7,241,239,7,193,255,7,1,255,4,1,243,4,0,15,0,0,62,0,0,252,0,3,241,0,15,195,0,15,3,0,28,15,3,128,63,3,0,253,0
.byte 0,31,131,0,126,7,3,248,30,3,224,126,3,129,248,2,7,225,2,31,225,0,126,227,3,248,247,3,224,254,3,128,255,2,0,251,2,0,7,0,0,30,0,0,126,0,1,248,0,7,225,0,7,131,0,14,7,1,192,30,1,128,126,0
.byte 0,15,195,0,63,3,1,252,15,1,240,62,1,192,252,1,3,240,1,15,241,0,63,115,1,252,123,1,240,127,1,192,127,1,0,127,1,0,3,0,0,15,0,0,62,0,0,252,0,3,241,0,3,195,0,7,3,0,224,15,0,192,62,0
.byte 0,7,225,0,31,131,0,254,7,0,248,30,0,224,126,0,129,248,0,135,248,0,31,185,0,254,63,0,248,63,0,224,62,0,128,63,0,128,3,0,0,7,0,0,30,0,0,126,0,1,248,0,1,225,0,3,131,0,112,7,0,96,30,0
.byte 0,3,241,0,15,195,0,127,3,0,124,15,0,112,62,0,64,252,0,67,252,0,15,221,0,127,31,0,124,31,0,112,31,0,64,31,0,64,3,0,0,3,0,0,15,0,0,62,0,0,252,0,0,241,0,1,195,0,56,3,0,48,15,0
.byte 0,1,248,0,7,225,0,63,131,0,62,7,0,56,30,0,32,126,0,33,254,0,7,238,0,63,143,0,62,15,0,56,15,0,32,14,0,32,1,0,0,3,0,0,7,0,0,30,0,0,126,0,0,120,0,0,225,0,28,3,0,24,7,0
.byte 0,0,252,0,3,241,0,31,195,0,31,3,0,28,15,0,16,62,0,16,254,0,3,246,0,31,199,0,31,7,0,28,7,0,16,7,0,16,1,0,0,3,0,0,3,0,0,15,0,0,62,0,0,60,0,0,113,0,14,3,0,12,3,0
.byte 0,0,126,0,1,248,0,15,225,0,15,131,0,14,7,0,8,30,0,8,126,0,1,250,0,15,227,0,15,131,0,14,3,0,8,3,0,8,0,0,0,1,0,0,3,0,0,7,0,0,30,0,0,30,0,0,56,0,7,1,0,6,3,0
.byte 0,0,62,0,0,252,0,7,241,0,7,195,0,7,3,0,4,15,0,4,63,0,0,255,0,7,243,0,7,195,0,7,3,0,4,3,0,4,0,0,0,1,0,0,3,0,0,3,0,0,15,0,0,14,0,0,28,0,3,129,0,3,3,0
.byte 0,0,30,0,0,126,0,3,248,0,3,225,0,3,131,0,2,7,0,2,31,0,0,127,0,3,251,0,3,227,0,3,131,0,2,3,0,2,0,0,0,0,0,0,1,0,0,3,0,0,7,0,0,6,0,0,14,0,1,192,0,1,129,0
.byte 0,0,15,0,0,62,0,1,252,0,1,241,0,1,195,0,1,3,0,1,15,0,0,63,0,1,253,0,1,241,0,1,193,0,1,1,0,1,0,0,0,0,0,0,1,0,0,3,0,0,3,0,0,3,0,0,6,0,0,224,0,0,193,0
.byte 0,0,7,0,0,30,0,0,254,0,0,248,0,0,225,0,0,131,0,0,135,0,0,31,0,0,255,0,0,249,0,0,225,0,0,129,0,0,128,0,0,0,0,0,0,0,0,1,0,0,3,0,0,3,0,0,2,0,0,112,0,0,96,0
.byte 0,0,3,0,0,15,0,0,126,0,0,124,0,0,113,0,0,67,0,0,67,0,0,15,0,0,126,0,0,124,0,0,112,0,0,64,0,0,64,0,0,0,0,0,0,0,0,1,0,0,3,0,0,3,0,0,3,0,0,56,0,0,48,0
.byte 0,0,3,0,0,7,0,0,62,0,0,62,0,0,56,0,0,33,0,0,35,0,0,7,0,0,62,0,0,62,0,0,56,0,0,32,0,0,32,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,3,0,0,28,0,0,24,0
.byte 0,0,3,0,0,3,0,0,31,0,0,30,0,0,28,0,0,17,0,0,19,0,0,3,0,0,31,0,0,30,0,0,28,0,0,16,0,0,16,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,14,0,0,12,0
.byte 0,0,1,0,0,3,0,0,15,0,0,14,0,0,14,0,0,8,0,0,9,0,0,3,0,0,15,0,0,14,0,0,14,0,0,8,0,0,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,6,0,0,6,0
.byte 0,0,1,0,0,3,0,0,7,0,0,7,0,0,6,0,0,4,0,0,5,0,0,3,0,0,7,0,0,7,0,0,6,0,0,4,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,2,0
.byte 0,0,0,0,0,1,0,0,3,0,0,3,0,0,2,0,0,2,0,0,2,0,0,1,0,0,3,0,0,3,0,0,2,0,0,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,2,0
.byte 0,0,0,0,0,1,0,0,3,0,0,3,0,0,3,0,0,2,0,0,2,0,0,1,0,0,3,0,0,3,0,0,3,0,0,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,3,0
.byte 0,0,0,0,0,0,0,0,3,0,0,3,0,0,3,0,0,2,0,0,2,0,0,0,0,0,3,0,0,3,0,0,3,0,0,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0
.byte 0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,1,0,0,1,0,0,0,0,0,1,0,0,1,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0
.byte 0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,1,0,0,1,0,0,0,0,0,1,0,0,1,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0


.pc =$2b00 "sinbase"
sinbase:

.byte 50,48,46,44,42,40,39,37,35,34,32,31,30,28,27,26
.byte 25,24,23,23,22,22,21,21,21,21,21,21,22,22,23,23
.byte 24,25,26,27,28,29,30,32,33,34,36,37,39,40,42,43
.byte 45,46,48,50,51,52,54,55,57,58,59,60,61,62,63,64
.byte 65,65,66,66,67,67,67,68,68,68,68,68,67,67,67,66
.byte 66,65,65,64,63,62,62,61,60,59,59,58,57,56,55,54
.byte 54,53,52,51,51,50,50,49,48,48,48,47,47,47,46,46
.byte 46,46,46,46,46,46,47,47,47,47,48,48,48,49,49,49
.byte 50,50,50,51,51,51,52,52,52,52,53,53,53,53,53,53
.byte 53,53,52,52,52,51,51,51,50,50,49,48,48,47,46,45
.byte 45,44,43,42,41,40,40,39,38,37,37,36,35,34,34,33
.byte 33,32,32,32,31,31,31,31,31,32,32,32,33,33,34,34
.byte 35,36,37,38,39,40,41,42,44,45,47,48,49,51,53,54
.byte 56,57,59,60,62,63,65,66,67,69,70,71,72,73,74,75
.byte 76,76,77,77,78,78,78,78,78,78,77,77,76,76,75,74
.byte 73,72,71,69,68,67,65,64,62,60,59,57,55,53,51,50

.byte 50,48,46,44,42,40,39,37,35,34,32,31,30,28,27,26
.byte 25,24,23,23,22,22,21,21,21,21,21,21,22,22,23,23
.byte 24,25,26,27,28,29,30,32,33,34,36,37,39,40,42,43
.byte 45,46,48,50,51,52,54,55,57,58,59,60,61,62,63,64
.byte 65,65,66,66,67,67,67,68,68,68,68,68,67,67,67,66
.byte 66,65,65,64,63,62,62,61,60,59,59,58,57,56,55,54
.byte 54,53,52,51,51,50,50,49,48,48,48,47,47,47,46,46
.byte 46,46,46,46,46,46,47,47,47,47,48,48,48,49,49,49
.byte 50,50,50,51,51,51,52,52,52,52,53,53,53,53,53,53
.byte 53,53,52,52,52,51,51,51,50,50,49,48,48,47,46,45
.byte 45,44,43,42,41,40,40,39,38,37,37,36,35,34,34,33
.byte 33,32,32,32,31,31,31,31,31,32,32,32,33,33,34,34
.byte 35,36,37,38,39,40,41,42,44,45,47,48,49,51,53,54
.byte 56,57,59,60,62,63,65,66,67,69,70,71,72,73,74,75
.byte 76,76,77,77,78,78,78,78,78,78,77,77,76,76,75,74
.byte 73,72,71,69,68,67,65,64,62,60,59,57,55,53,51,50



.pc =$8000 "sp_sin  129-195"
spsin1:
.byte 128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128
.byte 128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128
.byte 128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128
.byte 128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128
.byte 128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128
.byte 128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128
.byte 128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128
.byte 128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128

.byte 128,128,129,129,130,130,131,131,132,132,133,133,134,134,135,135,136,136,137,137,138,138,139,139,140,140,141,141,142,142,143,143
.byte 144,144,145,145,146,146,147,147,148,148,149,149,150,150,151,151,152,152,153,153,154,154,155,155,156,156,157,157,158,158,159,159
.byte 160,160,161,161,162,162,163,163,164,164,165,165,166,166,167,167,168,168,169,169,170,170,171,171,172,172,173,173,174,174,175,175
.byte 176,176,177,177,178,178,179,179,180,180,181,181,182,182,183,183,184,184,185,185,186,186,187,187,188,188,189,189,190,190,191,191
.byte 128,128,129,129,130,130,131,131,132,132,133,133,134,134,135,135,136,136,137,137,138,138,139,139,140,140,141,141,142,142,143,143
.byte 144,144,145,145,146,146,147,147,148,148,149,149,150,150,151,151,152,152,153,153,154,154,155,155,156,156,157,157,158,158,159,159
.byte 160,160,161,161,162,162,163,163,164,164,165,165,166,166,167,167,168,168,169,169,170,170,171,171,172,172,173,173,174,174,175,175
.byte 176,176,177,177,178,178,179,179,180,180,181,181,182,182,183,183,184,184,185,185,186,186,187,187,188,188,189,189,190,190,191,191

.byte 128,128,129,129,130,130,131,131,132,132,133,133,134,134,135,135,136,136,137,137,138,138,139,139,140,140,141,141,142,142,143,143
.byte 144,144,145,145,146,146,147,147,148,148,149,149,150,150,151,151,152,152,153,153,154,154,155,155,156,156,157,157,158,158,159,159
.byte 160,160,161,161,162,162,163,163,164,164,165,165,166,166,167,167,168,168,169,169,170,170,171,171,172,172,173,173,174,174,175,175
.byte 176,176,177,177,178,178,179,179,180,180,181,181,182,182,183,183,184,184,185,185,186,186,187,187,188,188,189,189,190,190,191,191
.byte 128,128,129,129,130,130,131,131,132,132,133,133,134,134,135,135,136,136,137,137,138,138,139,139,140,140,141,141,142,142,143,143
.byte 144,144,145,145,146,146,147,147,148,148,149,149,150,150,151,151,152,152,153,153,154,154,155,155,156,156,157,157,158,158,159,159
.byte 160,160,161,161,162,162,163,163,164,164,165,165,166,166,167,167,168,168,169,169,170,170,171,171,172,172,173,173,174,174,175,175
.byte 176,176,177,177,178,178,179,179,180,180,181,181,182,182,183,183,184,184,185,185,186,186,187,187,188,188,189,189,190,190,191,191

.byte 128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128
.byte 128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128
.byte 128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128
.byte 128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128
.byte 128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128
.byte 128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128
.byte 128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128
.byte 128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128

.byte 128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128
.byte 128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128
.byte 128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128
.byte 128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128
.byte 128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128
.byte 128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128
.byte 128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128
.byte 128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128



.pc =$8500 "sp_sin  192-256"
spsin2:
.byte 192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192
.byte 192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192
.byte 192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192
.byte 192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192
.byte 192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192
.byte 192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192
.byte 192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192
.byte 192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192


.byte 192,192,193,193,194,194,195,195,196,196,197,197,198,198,199,199,200,200,201,201,202,202,203,203,204,204,205,205,206,206,207,207
.byte 208,208,209,209,210,210,211,211,212,212,213,213,214,214,215,215,216,216,217,217,218,218,219,219,220,220,221,221,222,222,223,223
.byte 224,224,225,225,226,226,227,227,228,228,229,229,230,230,231,231,232,232,233,233,234,234,235,235,236,236,237,237,238,238,239,239
.byte 240,240,241,241,242,242,243,243,244,244,245,245,246,246,247,247,248,248,249,249,250,250,251,251,252,252,253,253,254,254,255,255
.byte 192,192,193,193,194,194,195,195,196,196,197,197,198,198,199,199,200,200,201,201,202,202,203,203,204,204,205,205,206,206,207,207
.byte 208,208,209,209,210,210,211,211,212,212,213,213,214,214,215,215,216,216,217,217,218,218,219,219,220,220,221,221,222,222,223,223
.byte 224,224,225,225,226,226,227,227,228,228,229,229,230,230,231,231,232,232,233,233,234,234,235,235,236,236,237,237,238,238,239,239
.byte 240,240,241,241,242,242,243,243,244,244,245,245,246,246,247,247,248,248,249,249,250,250,251,251,252,252,253,253,254,254,255,255

.byte 192,192,193,193,194,194,195,195,196,196,197,197,198,198,199,199,200,200,201,201,202,202,203,203,204,204,205,205,206,206,207,207
.byte 208,208,209,209,210,210,211,211,212,212,213,213,214,214,215,215,216,216,217,217,218,218,219,219,220,220,221,221,222,222,223,223
.byte 224,224,225,225,226,226,227,227,228,228,229,229,230,230,231,231,232,232,233,233,234,234,235,235,236,236,237,237,238,238,239,239
.byte 240,240,241,241,242,242,243,243,244,244,245,245,246,246,247,247,248,248,249,249,250,250,251,251,252,252,253,253,254,254,255,255
.byte 192,192,193,193,194,194,195,195,196,196,197,197,198,198,199,199,200,200,201,201,202,202,203,203,204,204,205,205,206,206,207,207
.byte 208,208,209,209,210,210,211,211,212,212,213,213,214,214,215,215,216,216,217,217,218,218,219,219,220,220,221,221,222,222,223,223
.byte 224,224,225,225,226,226,227,227,228,228,229,229,230,230,231,231,232,232,233,233,234,234,235,235,236,236,237,237,238,238,239,239
.byte 240,240,241,241,242,242,243,243,244,244,245,245,246,246,247,247,248,248,249,249,250,250,251,251,252,252,253,253,254,254,255,255

.byte 192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192
.byte 192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192
.byte 192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192
.byte 192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192
.byte 192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192
.byte 192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192
.byte 192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192
.byte 192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192

.byte 192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192
.byte 192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192
.byte 192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192
.byte 192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192
.byte 192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192
.byte 192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192
.byte 192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192
.byte 192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192

.pc =$8a00"sp_sin_h  0-64"
spsinh1:

.byte 038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038
.byte 038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038
.byte 038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038
.byte 038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038
.byte 038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038
.byte 038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038


.byte 038,038,038,038,038,038,038,038,038,038,038,038,038,038,039,039,040,040,041,041,042,042,043,043,044,044,045,045,046,046,047,047
.byte 048,048,049,049,050,050,051,051,052,052,053,053,054,054,055,055,056,056,057,057,058,058,059,059,060,060,061,061,062,062,063,063


.byte 0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15
.byte 16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23,24,24,25,25,26,26,27,27,28,28,29,29,30,30,30,30
.byte 30,30,30,30,30,30,30,30,30,30,30,30,38,38,39,39,40,40,41,41,42,42,43,43,44,44,45,45,46,46,47,47
.byte 48,48,49,49,50,50,51,51,52,52,53,53,54,54,55,55,56,56,57,57,58,58,59,59,60,60,61,61,62,62,63,63
.byte 0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15
.byte 16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23,24,24,25,25,26,26,27,27,28,28,29,29,30,30,30,30
.byte 30,30,30,30,30,30,30,30,30,30,30,30,38,38,39,39,40,40,41,41,42,42,43,43,44,44,45,45,46,46,47,47
.byte 48,48,49,49,50,50,51,51,52,52,53,53,54,54,55,55,56,56,57,57,58,58,59,59,60,60,61,61,62,62,63,63

.byte 0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15
.byte 16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23,24,24,25,25,26,26,27,27,28,28,29,29,30,30,30,30
.byte 30,30,30,30,30,30,30,30,30,30,30,30,38,38,39,39,40,40,41,41,42,42,43,43,44,44,45,45,46,46,47,47
.byte 48,48,49,49,50,50,51,51,52,52,53,53,54,54,55,55,56,56,57,57,58,58,59,59,60,60,61,61,62,62,63,63
.byte 0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15
.byte 16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23,24,24,25,25,26,26,27,27,28,28,29,29,30,30,30,30
.byte 30,30,30,30,30,30,30,30,30,30,30,30,38,38,39,39,40,40,41,41,42,42,43,43,44,44,45,45,46,46,47,47
.byte 48,48,49,49,50,50,51,51,52,52,53,53,54,54,55,55,56,56,57,57,58,58,59,59,60,60,61,61,62,62,63,63

.byte 0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15
.byte 016,016,017,017,018,018,019,019,020,020,021,021,022,022,023,023,024,024,025,025,026,026,027,027,028,028,029,029,030,030,030,030
.byte 038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038
.byte 038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038
.byte 038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038
.byte 038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038
.byte 038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038
.byte 038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038


.byte 038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038
.byte 038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038
.byte 038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038
.byte 038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038
.byte 038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038
.byte 038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038
.byte 038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038
.byte 038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038,038



.pc =$8f00 "sp_sin_h  64-128"
spsinh2:

.byte 099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099
.byte 099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099
.byte 099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099
.byte 099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099
.byte 099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099
.byte 099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099
.byte 099,099,099,099,099,099,099,099,099,099,099,099,102,102,103,103,104,104,105,105,106,106,107,107,108,108,109,109,110,110,111,111
.byte 112,112,113,113,114,114,115,115,116,116,117,117,118,118,119,119,120,120,121,121,122,122,123,123,124,124,125,125,126,126,127,127


.byte 64,64,65,65,66,66,67,67,68,68,69,69,70,70,71,71,72,72,73,73,74,74,75,75,76,76,77,77,78,78,79,79
.byte 80,80,81,81,82,82,83,83,84,84,85,85,86,86,87,87,88,88,89,89,90,90,91,91,92,92,93,93,94,94,95,95
.byte 96,96,97,97,98,98,99,99,99,99,99,99,102,102,103,103,104,104,105,105,106,106,107,107,108,108,109,109,110,110,111,111
.byte 112,112,113,113,114,114,115,115,116,116,117,117,118,118,119,119,120,120,121,121,122,122,123,123,124,124,125,125,126,126,127,127
.byte 64,64,65,65,66,66,67,67,68,68,69,69,70,70,71,71,72,72,73,73,74,74,75,75,76,76,77,77,78,78,79,79
.byte 80,80,81,81,82,82,83,83,84,84,85,85,86,86,87,87,88,88,89,89,90,90,91,91,92,92,93,93,94,94,95,95
.byte 96,96,97,97,98,98,99,99,99,99,99,99,102,102,103,103,104,104,105,105,106,106,107,107,108,108,109,109,110,110,111,111
.byte 112,112,113,113,114,114,115,115,116,116,117,117,118,118,119,119,120,120,121,121,122,122,123,123,124,124,125,125,126,126,127,127

.byte 64,64,65,65,66,66,67,67,68,68,69,69,70,70,71,71,72,72,73,73,74,74,75,75,76,76,77,77,78,78,79,79
.byte 80,80,81,81,82,82,83,83,84,84,85,85,86,86,87,87,88,88,89,89,90,90,91,91,92,92,93,93,94,94,95,95
.byte 96,96,97,97,98,98,99,99,99,99,99,99,102,102,103,103,104,104,105,105,106,106,107,107,108,108,109,109,110,110,111,111
.byte 112,112,113,113,114,114,115,115,116,116,117,117,118,118,119,119,120,120,121,121,122,122,123,123,124,124,125,125,126,126,127,127
.byte 64,64,65,65,66,66,67,67,68,68,69,69,70,70,71,71,72,72,73,73,74,74,75,75,76,76,77,77,78,78,79,79
.byte 80,80,81,81,82,82,83,83,84,84,85,85,86,86,87,87,88,88,89,89,90,90,91,91,92,92,93,93,94,94,95,95
.byte 96,96,97,97,98,98,99,99,99,99,99,99,102,102,103,103,104,104,105,105,106,106,107,107,108,108,109,109,110,110,111,111
.byte 112,112,113,113,114,114,115,115,116,116,117,117,118,118,119,119,120,120,121,121,122,122,123,123,124,124,125,125,126,126,127,127


.byte 64,64,65,65,66,66,67,67,68,68,69,69,70,70,71,71,72,72,73,73,74,74,75,75,76,76,77,77,78,78,79,79
.byte 80,80,81,81,82,82,83,83,84,84,85,85,86,86,87,87,88,88,89,89,90,90,91,91,92,92,93,93,94,94,95,95
.byte 096,096,097,097,098,098,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099
.byte 099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099
.byte 099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099
.byte 099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099
.byte 099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099
.byte 099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099

.byte 099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099
.byte 099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099
.byte 099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099
.byte 099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099
.byte 099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099
.byte 099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099
.byte 099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099
.byte 099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099,099



.pc =$2d00 "logo"
logo:
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0






////////////////////////
// intro cucccok //////
//////////////////////


.pc =$3f04 "step1"
intro1:
.byte 0

.pc =$3f05 "lassit"
lassit:
.byte 0

.pc =$3f06 "step2"
intro2:
.byte 0

.pc =$3f07 "step3"
intro3:
.byte 0

.pc =$3f08 "step4"
intro4:
.byte 0

.pc =$3f09 "step5"
intro5:
.byte 0

.pc =$3f0a "step6"
intro6:
.byte 0

.pc =$3f0b "rnd"
randombyte:
.byte 0

.pc =$3f0c "step7"
intro7:
.byte 0

.pc =$3f0d "step8"
intro8:
.byte 34

.pc =$3f0e "kukac frame"
k_frame:
.byte 4

.pc =$3f0f "kukac speed"
k_sp:
.byte 0

.pc =$3f10 "screen kitolas"
kitol:
.byte 1

.pc =$3f11 "step8b"
intro8wait:
.byte 0

.pc =$3f12 "step9"
intro9:
.byte 0

.pc =$3f13 "step10"
intro10:
.byte 0


.pc =$3f14 "swirlrise"
sw_rise:
.byte 1

.pc =$3f15 "swirlcount"
sw_count:
.byte 0

.pc =$3f16 "swirl_main"
sw_main:
.byte 0

.pc =$3f17 "swirl_bill"
sw_bill:
.byte 0

.pc =$3f18 "swirl_offff"
sw_off:
.byte 0

.pc =$3f1a "end frame counter"
endframe:
.byte 0

.pc =$3f1b "end speed"
esp:
.byte 0

.pc =$3f1c "the mehet"
t_mehet:
.byte 0

.pc =$3f1d "kukac mehet"
k_mehet:
.byte 0

.pc =$3f1e "end mehet"
e_mehet:
.byte 1

.pc =$3f1f "kukac anim mehet"
ka_mehet:
.byte 1

.pc =$3f20 "szurke sav felso gyorsitas"
felspeed:
.byte 7		//7

.pc =$3f21 "eq magassag  - max 40"
eqheight:
.byte 0

.pc =$3f22 "eq magassag novelo speed"
eqhs:
.byte 0

.pc =$3f23 "scroll lefutas szama"
scr_no:
.byte 0

.pc =$3f24 "intro zene eltolas"
introdelay:
.byte 8

.pc =$3f25 "outro rasterosszehuzo"
nemkellhuzas:
.byte 0


.pc =$9b00 "random bit sor"   //kerek helyen kell lenni a kod miatt
rndsor:
.byte 127,191,223,239,247,251,253,254


.pc =$0e00 "intro logo karakterei"
fullspr:

.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0  //0e00
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0  //0e40
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0  //0e80
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0   //0ec0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0  //0f00
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0   //0f40
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

.byte 0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0   //0f80
.byte 255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0


.pc =$9400 "pattogas"
pattog:
.byte 0,2,3,6,8,11,14,18,22,27,31,37,42,49,55,62,69,77,85,94,102,112,121,114,108,102,96,91,86,82,78,75,72,69
.byte 67,65,63,62,62,61,61,62,63,64,66,68,71,73,77,81,85,89,94,99,105,111,118,121,116,112,108,104,101,99,96
.byte 94,93,92,91,91,91,92,93,94,96,98,101,103,107,111,115,119,121,117,114,112,110,108,107,106,106,106,106
.byte 107,108,110,112,114,117,120,121,118,116,115,114,113,113,113,114,115,116,118,120,121,119,118,117,117
.byte 117,118,119,120,121,120,119,119,120,121

.pc =$9480 "pattogas2"
pattog2:
.byte 120,122,123,126,128,131,134,138,142,147,151,157,162,169,175,182,189,197,205,214,222,232,242,242,242,242
.byte 242,234,228,222,217,212,208,204,200,197,194,191,189,188,186,185,185,185,185,186,187,189,191,193,196,199
.byte 202,206,211,215,220,226,232,238,242,242,242,242,242,240,236,233,230,227,225,223,221,220,220,219,219,220
.byte 221,222,224,226,228,231,235,238,242,242,242,242,242,242,242,242,241,240,239,238,238,238,238,239,241,242
.byte 242,242,242,242,242,242,242,242,242,242,242,242,242,242,242,242,242,242,242,242,242,242,242,242


.pc =$9580 "balrol"
balrol:
.byte 000,000,000,  128,000,000,  192,000,000,  224,000,000,  240,000,000,  248,000,000,  252,000,000,  254,000,000
.byte 255,000,000,  255,128,000,  255,192,000,  255,224,000,  255,240,000,  255,248,000,  255,252,000,  255,254,000
.byte 255,255,000,  255,255,128,  255,255,192,  255,255,224,  255,255,240,  255,255,248,  255,255,252,  255,255,254,  255,255,255

.pc =$9600 "jobbrol"
jobbrol:
.byte 000,000,000,  000,000,001,  000,000,003,  000,000,007,  000,000,015,  000,000,031,  000,000,063,  000,000,127
.byte 000,000,255,  000,001,255,  000,003,255,  000,007,255,  000,015,255,  000,031,255,  000,063,255,  000,127,255
.byte 000,255,255,  001,255,255,  003,255,255,  007,255,255,  015,255,255,  031,255,255,  063,255,255,  127,255,255,  255,255,255

.pc =$9800 "harom"
harom:
.byte 0,3,6,9,12,15,18,21,24,27,30,33,36,39,42,45,48,51,54,57,60,63,66,69,72,75,78,81,84,87,90

.pc =$9820 "visszaharom"
v_harom:
.byte 45,42,39,36,33,30,27,24,21,18,15,12,9,6,3,0

.pc =$9830"kukacanim"
kukacanim:
.byte 0,7,192,0,15,224,0,15,224,0,14,224,0,30,240,0,254,254,1,252,127,0,248,62
.byte 0,0,0,0,7,0,0,31,192,0,63,224,0,127,240,3,248,254,7,240,127,3,224,62
.byte 0,0,0,0,0,0,0,14,0,0,127,192,1,255,240,15,255,254,31,224,255,15,128,62
.byte 0,0,0,0,0,0,0,0,0,0,127,0,3,255,224,63,255,254,127,227,255,62,0,62
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,255,254,255,255,255,127,255,254


.pc =$98b0 "kukac mozgatas"
k_dx:
.byte 0,0,0,0,0,1,2,2,2,0,0,0,0,0,0,0,0,0

.pc =$9b10 "kukac mozgatas"
k_dx2:
.byte 0,2,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0



.pc =$98c2 "kukac frame kezdopont"
k_mem:
.byte 0,24,48,72,96,120,144,168,192

.pc =$98d0 "kukac frame tabla"
k_frame_tabla:
.byte 0,1,2,3,4,3,2,1,0


.pc =$98e0 "pattogo frametabla"
p_frame_tabla:
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,3,4,3,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,3,4,3,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,3,4,4,3
.byte 2,1,0,0,0,0,0,0,0,0,0,1,2,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4

.pc =$9960 "pattogo anim"
p_anim:
.byte 0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0
.byte 0,0,0,0,0,0,0,255,0,1,255,128,1,255,128,1,255,128,1,255,128,0,255,0
.byte 0,0,0,0,0,0,0,0,0,3,255,192,7,255,224,7,255,224,7,255,224,3,255,192
.byte 0,0,0,0,0,0,0,0,0,0,0,0,15,255,240,31,255,248,31,255,248,15,255,240
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,255,254,255,255,255,127,255,254

.pc =$99e0 "theendminta"
theend:
.byte 96,0,0,96,0,0,96,96,124,112,124,108,96,108,124,108,108,96,124,108,124,0,0,0
.byte 0,0,0,0,0,12,124,124,12,108,108,124,124,108,108,96,108,108,124,108,124,0,0,0


.pc =$9a10 "belso szin"
szinbelso:
.byte 14,14,14,14
.byte 14,14,14,14
.byte 14,14,14,14
.byte 14,14,14,14
.byte 14,14,14,14
.byte 14,14,14,14
.byte 14,14,14,14
.byte 14,14,14,14

.byte 14,14,03,03
.byte 01,01,15,15
.byte 12,12,12,12
.byte 12,12,12,12
.byte 12,12,12,12
.byte 12,12,12,12
.byte 12,12,12,12
.byte 12,12,12,12



.pc =$9a50 "kulso szin"
szinkulso:


.byte 14,14,06,06
.byte 00,00,00,00
.byte 00,00,00,00
.byte 00,00,00,00
.byte 00,00,00,00
.byte 00,00,00,00
.byte 00,00,00,00
.byte 00,00,00,00


.byte 00,00,00,00
.byte 00,00,00,00
.byte 00,00,00,00
.byte 00,00,00,00
.byte 00,00,00,00
.byte 00,00,00,00
.byte 00,00,00,00
.byte 00,00,00,00

.pc =$2e00 "sprite fade in"
spr_in:
.byte 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
.byte 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
.byte 11,11,11,11,12,12,12,12,15,15,15,15,01,01,01,01,07,07,07,07,01,01,01,01,01,01,01,01,01,01,01,01
.byte 01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01
.byte 01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01

.pc =$2ea0 "sprite fade out"
spr_out:

.byte 01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01
.byte 01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01
.byte 15,15,15,15,12,12,12,12,12,11,11,11,11,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
.byte 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00


.pc =$0900 "font"
font:

.byte 0,126,66,90,94,64,126,0
.byte 0,0,124,12,124,108,124,0
.byte 0,96,96,124,108,108,124,0
.byte 0,0,124,108,96,108,124,0
.byte 0,12,12,124,108,108,124,0
.byte 0,0,124,108,124,96,124,0
.byte 0,0,124,108,96,112,96,96
.byte 0,0,124,108,108,124,12,124
.byte 0,0,96,124,108,108,108,0
.byte 0,0,48,0,48,48,48,0
.byte 0,0,24,0,24,24,24,56
.byte 0,0,108,108,112,108,108,0
.byte 48,48,48,48,48,48,48,0
.byte 0,0,68,108,124,108,108,0
.byte 0,0,124,108,108,108,108,0
.byte 0,0,124,108,108,108,124,0
.byte 0,0,124,108,108,124,96,96
.byte 0,0,124,108,108,108,124,6
.byte 0,0,124,108,96,96,96,0
.byte 0,0,124,96,124,12,124,0
.byte 96,96,96,112,96,108,124,0
.byte 0,0,108,108,108,108,124,0
.byte 0,0,108,108,108,56,16,0
.byte 0,0,108,108,124,108,68,0
.byte 0,0,108,108,56,108,108,0
.byte 0,0,108,108,56,48,96,96
.byte 0,0,124,12,124,96,124,0
.byte 0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0
.byte 0,48,48,48,48,0,48,0
.byte 0,108,72,0,0,0,0,0
.byte 0,108,108,254,108,254,108,108
.byte 0,0,0,0,0,0,0,0
.byte 0,0,102,76,24,50,102,0
.byte 0,0,0,0,0,0,0,0
.byte 0,48,32,0,0,0,0,0
.byte 0,0,56,96,96,96,56,0
.byte 0,0,112,24,24,24,112,0
.byte 0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,96,96,192
.byte 0,0,0,124,124,0,0,0
.byte 0,0,0,0,0,96,96,0
.byte 0,4,12,24,48,96,64,0
.byte 0,0,124,108,108,108,124,0
.byte 0,0,56,24,24,24,24,0
.byte 0,0,124,12,124,96,124,0
.byte 0,0,124,12,60,12,124,0
.byte 0,0,108,108,124,12,12,0
.byte 0,0,124,96,124,12,124,0
.byte 0,0,124,96,124,108,124,0
.byte 0,0,124,12,28,12,12,0
.byte 0,0,124,108,124,108,124,0
.byte 0,0,124,108,124,12,124,0
.byte 0,0,48,48,0,48,48,0
.byte 0,0,48,48,0,48,48,96
.byte 0,0,0,58,34,227,0,0
.byte 0,0,0,43,170,234,0,0
.byte 0,0,0,160,32,56,0,0

.byte 0,124,12,28,48,0,48,0

.pc =$2200 "eq elemei - font"
eqfont:
.byte 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,241,255,255,255,255,255,255,241,241,255,255,255,255,255,241,241,241,255,255,255,255,241,241,241,241,255,255,255,241,241,241,241,241,255,255,241,241,241,241,241,241,255,241,241,241,241,241,241,241,241,241,241,241,241,241,241,241
.byte 255,255,255,255,255,255,255,31,255,255,255,255,255,255,255,17,255,255,255,255,255,255,241,17,255,255,255,255,255,241,241,17,255,255,255,255,241,241,241,17,255,255,255,241,241,241,241,17,255,255,241,241,241,241,241,17,255,241,241,241,241,241,241,17,241,241,241,241,241,241,241,17
.byte 255,255,255,255,255,255,31,31,255,255,255,255,255,255,31,17,255,255,255,255,255,255,17,17,255,255,255,255,255,241,17,17,255,255,255,255,241,241,17,17,255,255,255,241,241,241,17,17,255,255,241,241,241,241,17,17,255,241,241,241,241,241,17,17,241,241,241,241,241,241,17,17
.byte 255,255,255,255,255,31,31,31,255,255,255,255,255,31,31,17,255,255,255,255,255,31,17,17,255,255,255,255,255,17,17,17,255,255,255,255,241,17,17,17,255,255,255,241,241,17,17,17,255,255,241,241,241,17,17,17,255,241,241,241,241,17,17,17,241,241,241,241,241,17,17,17
.byte 255,255,255,255,31,31,31,31,255,255,255,255,31,31,31,17,255,255,255,255,31,31,17,17,255,255,255,255,31,17,17,17,255,255,255,255,17,17,17,17,255,255,255,241,17,17,17,17,255,255,241,241,17,17,17,17,255,241,241,241,17,17,17,17,241,241,241,241,17,17,17,17
.byte 255,255,255,31,31,31,31,31,255,255,255,31,31,31,31,17,255,255,255,31,31,31,17,17,255,255,255,31,31,17,17,17,255,255,255,31,17,17,17,17,255,255,255,17,17,17,17,17,255,255,241,17,17,17,17,17,255,241,241,17,17,17,17,17,241,241,241,17,17,17,17,17
.byte 255,255,31,31,31,31,31,31,255,255,31,31,31,31,31,17,255,255,31,31,31,31,17,17,255,255,31,31,31,17,17,17,255,255,31,31,17,17,17,17,255,255,31,17,17,17,17,17,255,255,17,17,17,17,17,17,255,241,17,17,17,17,17,17,241,241,17,17,17,17,17,17
.byte 255,31,31,31,31,31,31,31,255,31,31,31,31,31,31,17,255,31,31,31,31,31,17,17,255,31,31,31,31,17,17,17,255,31,31,31,17,17,17,17,255,31,31,17,17,17,17,17,255,31,17,17,17,17,17,17,255,17,17,17,17,17,17,17,241,17,17,17,17,17,17,17
.byte 31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,17,31,31,31,31,31,31,17,17,31,31,31,31,31,17,17,17,31,31,31,31,17,17,17,17,31,31,31,17,17,17,17,17,31,31,17,17,17,17,17,17,31,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17


//tukorkep
.byte 0,0,0,0,0,0,0,0,14,0,0,0,0,0,0,0,14,14,0,0,0,0,0,0,14,14,14,0,0,0,0,0,14,14,14,14,0,0,0,0,14,14,14,14,14,0,0,0,14,14,14,14,14,14,0,0,14,14,14,14,14,14,14,0,14,14,14,14,14,14,14,14
.byte 224,0,0,0,0,0,0,0,238,0,0,0,0,0,0,0,238,14,0,0,0,0,0,0,238,14,14,0,0,0,0,0,238,14,14,14,0,0,0,0,238,14,14,14,14,0,0,0,238,14,14,14,14,14,0,0,238,14,14,14,14,14,14,0,238,14,14,14,14,14,14,14
.byte 224,224,0,0,0,0,0,0,238,224,0,0,0,0,0,0,238,238,0,0,0,0,0,0,238,238,14,0,0,0,0,0,238,238,14,14,0,0,0,0,238,238,14,14,14,0,0,0,238,238,14,14,14,14,0,0,238,238,14,14,14,14,14,0,238,238,14,14,14,14,14,14
.byte 224,224,224,0,0,0,0,0,238,224,224,0,0,0,0,0,238,238,224,0,0,0,0,0,238,238,238,0,0,0,0,0,238,238,238,14,0,0,0,0,238,238,238,14,14,0,0,0,238,238,238,14,14,14,0,0,238,238,238,14,14,14,14,0,238,238,238,14,14,14,14,14
.byte 224,224,224,224,0,0,0,0,238,224,224,224,0,0,0,0,238,238,224,224,0,0,0,0,238,238,238,224,0,0,0,0,238,238,238,238,0,0,0,0,238,238,238,238,14,0,0,0,238,238,238,238,14,14,0,0,238,238,238,238,14,14,14,0,238,238,238,238,14,14,14,14
.byte 224,224,224,224,224,0,0,0,238,224,224,224,224,0,0,0,238,238,224,224,224,0,0,0,238,238,238,224,224,0,0,0,238,238,238,238,224,0,0,0,238,238,238,238,238,0,0,0,238,238,238,238,238,14,0,0,238,238,238,238,238,14,14,0,238,238,238,238,238,14,14,14
.byte 224,224,224,224,224,224,0,0,238,224,224,224,224,224,0,0,238,238,224,224,224,224,0,0,238,238,238,224,224,224,0,0,238,238,238,238,224,224,0,0,238,238,238,238,238,224,0,0,238,238,238,238,238,238,0,0,238,238,238,238,238,238,14,0,238,238,238,238,238,238,14,14
.byte 224,224,224,224,224,224,224,0,238,224,224,224,224,224,224,0,238,238,224,224,224,224,224,0,238,238,238,224,224,224,224,0,238,238,238,238,224,224,224,0,238,238,238,238,238,224,224,0,238,238,238,238,238,238,224,0,238,238,238,238,238,238,238,0,238,238,238,238,238,238,238,14
.byte 224,224,224,224,224,224,224,224,238,224,224,224,224,224,224,224,238,238,224,224,224,224,224,224,238,238,238,224,224,224,224,224,238,238,238,238,224,224,224,224,238,238,238,238,238,224,224,224,238,238,238,238,238,238,224,224,238,238,238,238,238,238,238,224,238,238,238,238,238,238,238,238




.pc =$2800 "endtxt"
szoveg:
//     1234567890          1234567890
//		 1234567890          1234567890
.text "                                        "
.text "greetings to:  mash, feryx, leon, oswald"
.text "          swirl / dnp @ qb2018          "

.pc =$2900 "scroll tex"
scrtxt:
//     1234567890          1234567890          1234567890          1234567890          1234567890          1234567890          12345678
//		 1234567890          1234567890          1234567890          1234567890          1234567890          1234567890
.text "    hello and welcome to my new demo called swirl, inspired by bj0rn r0sten's great work. special thanks to jeff for this great "
.text "tune: fungus.  code and design by dnp. used apps for creating this wonder: kickass, notepad and of course excel :)   i'm not was"
.text "ting your time any more, let's see the endpart           "
.byte 60,61,62
.text "   "
//     1234     3 egesz jo
.byte 64
.text "                                          "



.pc =$9700 "scrollsinus"
scrlsin:
.byte 10,9,8,7,7,6,5,5,4,3,3,2,2,1,1,1
.byte 0,0,0,0,0,0,0,0,0,0,0,0,1,1,2,2
.byte 2,3,4,4,5,6,6,7,8,8,9,10,11,11,12,13
.byte 13,14,15,15,16,17,17,17,18,18,19,19,19,19,19,19
.byte 19,19,19,19,19,19,18,18,18,17,17,16,16,15,14,14
.byte 13,12,12,11,10,10,9,8,7,7,6,5,5,4,3,3
.byte 2,2,1,1,1,0,0,0,0,0,0,0,0,0,0,0
.byte 0,1,1,2,2,2,3,4,4,5,6,6,7,8,8,9
.byte 10,11,11,12,13,13,14,15,15,16,17,17,17,18,18,19
.byte 19,19,19,19,19,19,19,19,19,19,19,18,18,18,17,17
.byte 16,16,15,14,14,13,12,12,11,10,10,9,8,7,7,6
.byte 5,5,4,3,3,2,2,1,1,1,0,0,0,0,0,0
.byte 0,0,0,0,0,0,1,1,2,2,2,3,4,4,5,6
.byte 6,7,8,8,9,10,11,11,12,13,13,14,15,15,16,17
.byte 17,17,18,18,19,19,19,19,19,19,19,19,19,19,19,19
.byte 18,18,18,17,17,16,16,15,14,14,13,12,12,11,10,10


.pc =$9b30 "credits szinpos"
cred:
//     g   r   e   e   t   i   n   g   s       t   o   :           m   a   s   h   ,       f   e   r   y   x   ,       l   e   o   n   ,       o   s   w   a   l   d
.byte 148,147,146,145,144,143,142,141,140,000,170,171,172,000,000,164,163,162,161,160,000,140,141,142,143,144,145,000,124,123,122,121,120,000,100,101,102,103,104,105
//                                             s   w   i   r   l       /       d   n   p       @       q   b   2   0   1   8
.byte 000,000,000,000,000,000,000,000,000,000,065,061,069,067,060,000,050,000,040,041,042,000,043,000,048,047,046,045,044,043,000,000,000,000,000,000,000,000,000,000

.pc =$9c00 "credits szin"
credszin:

.byte 12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12
.byte 12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12
.byte 12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12
.byte 12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12

.byte 12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12
.byte 12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12
.byte 12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12
.byte 12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12

.byte 12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12
.byte 12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12
.byte 12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12
.byte 12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12

.byte 12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12
.byte 12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12
.byte 12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12
.byte 15,15,01,01,01,03,03,14,14,06,06,00,00,00,00,00



.pc =$9d00 "char_jobb"
cjobb:
.byte 0,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,4,0,0,0,5,0,0,0,6,0,0,0,7,0,0,0,8,0,0,0,8,1,0,0,8,2,0,0,8,3,0,0,8,4,0,0,8,5,0,0,8,6,0,0,8,7,0,0,8,8,0,0,8,8,1,0,8,8,2,0,8,8,3,0,8,8,4,0,8,8,5,0,8,8,6,0,8,8,7,0,8,8,8,0,8,8,8,1,8,8,8,2,8,8,8,3,8,8,8,4,8,8,8,5,8,8,8,6,8,8,8,7

.pc =$9d80 "char_bal"
cbal:
.byte 0,0,0,0,16,0,0,0,32,0,0,0,48,0,0,0,64,0,0,0,80,0,0,0,96,0,0,0,112,0,0,0,128,0,0,0,128,16,0,0,128,32,0,0,128,48,0,0,128,64,0,0,128,80,0,0,128,96,0,0,128,112,0,0,128,128,0,0,128,128,16,0,128,128,32,0,128,128,48,0,128,128,64,0,128,128,80,0,128,128,96,0,128,128,112,0,128,128,128,0,128,128,128,16,128,128,128,32,128,128,128,48,128,128,128,64,128,128,128,80,128,128,128,96,128,128,128,112

.pc =$9e00 "char_konv"
c_konv:
.byte 64,65,66,67,68,69,70,71,72,64,64,64,64,64,64,64,73,74,75,76,77,78,79,80,81,64,64,64,64,64,64,64,82,83,84,85,86,87,88,89,90,64,64,64,64,64,64,64,91,92,93,94,95,96,97,98,99,64,64,64,64,64,64,64,100,101,102,103,104,105,106,107,108,64,64,64,64,64,64,64,109,110,111,112,113,114,115,116,117,64,64,64,64,64,64,64,118,119,120,121,122,123,124,125,126,64,64,64,64,64,64,64,127,128,129,130,131,132,133,134,135,64,64,64,64,64,64,64,136,137,138,139,140,141,142,143,144


.pc =$9f00 "eq downscale"
leoszt:
.byte 1,1,1,1,9,18,23,27,30,32,34,36,37,39,40,41,42,43,44,45,45,46,47,48,48,49,49,50,50,51,51,52,52,53,53,54,54,54,55,55,56,56,56,57,57,57,58,58,58,58,59,59,59,60,60,60,60,61,61,61,61,61,62,62,62,62,63,63,63,63,63,64,64,64,64,64,64,65,65,65,65,65,65,66,66,66,66,66,66,67,67,67,67,67,67,67,68,68,68,68,68,68,68,69,69,69,69,69,69,69,69,70,70,70,70,70,70,70,70,70,71,71,71,71,71,71,71,71,71,72,72,72,72,72,72,72,72,72,72,73,73,73,73,73,73,73,73,73,73,73,74,74,74,74,74,74,74,74,74,74,74,74,75,75,75,75,75,75,75,75,75,75,75,75,76,76,76,76,76,76,76,76,76,76,76,76,76,76,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79

.pc =$2710 "tukor char_konv"
tc_konv:
.byte 145,146,147,148,149,150,151,152,153,145,145,145,145,145,145,145,154,155,156,157,158,159,160,161,162,145,145,145,145,145,145,145,163,164,165,166,167,168,169,170,171,145,145,145,145,145,145,145,172,173,174,175,176,177,178,179,180,145,145,145,145,145,145,145,181,182,183,184,185,186,187,188,189,145,145,145,145,145,145,145,190,191,192,193,194,195,196,197,198,145,145,145,145,145,145,145,199,200,201,202,203,204,205,206,207,145,145,145,145,145,145,145,208,209,210,211,212,213,214,215,216,145,145,145,145,145,145,145,217,218,219,220,221,222,223,224,225


.pc =$27a0 "tukor jobb char"
mcjobb: 
.byte 0,0,0,0, 1,1,1,1, 3,3,3,3, 4,4,4,4, 5,5,5,5, 6,6,6,6, 7,7,7,7, 8,8,8,8

.pc =$27c0 "tukor bal char"
mcbal: 
.byte 0,0,0,0, 16,16,16,16, 32,32,32,32, 48,48,48,48, 64,64,64,64, 80,80,80,80, 96,96,96,96, 112,112,112,112




.pc =$9b80 "eq szin"
eqszin:
.byte 10,2,10,2,7,8,7,8
.byte 7,8,7,8,7,8,7,8
.byte 13,5,13,5,13,5,13,5
.byte 13,5,13,5,13,5,13,0

.byte 0

.pc =$9ba1 "eq var"
eqvar:
.byte 1,8,8,8,8,8,8,8
.byte 1,8,8,8,8,8,8,8
.byte 1,8,8,8,8,8,8,8
.byte 1,8,8,8,8,8,8,8
.byte 1

.pc =$3d00"eq"
eq:
.byte 0

.pc =$3d80 "eq_temp"
eqt:
.byte 0

.pc =$3e00 "temp"
temp:
.byte 0


.pc =$c000 "QB oszto"
osztotabla:
.byte 32,31,30,29,28,27,26,25,24,23,22,21,20,19,18,17,16,15,14,13,12,11,10,9,8,7,6,5,4,3,2,1
.byte 32,32,31,30,29,28,27,26,25,24,22,21,20,19,18,17,16,15,14,13,12,10,9,8,7,6,5,4,3,2,1,0
.byte 32,32,31,30,29,28,27,25,24,23,22,21,20,19,18,17,16,15,14,13,12,11,10,9,7,6,5,4,3,2,1,0
.byte 0,32,32,31,30,29,27,26,25,24,23,22,20,19,18,17,16,15,14,12,11,10,9,8,7,5,4,3,2,1,0,0
.byte 0,32,32,31,30,28,27,26,25,24,22,21,20,19,18,17,16,15,14,13,12,10,9,8,7,6,4,3,2,1,0,0
.byte 0,0,32,32,31,29,28,27,26,24,23,22,21,19,18,17,16,15,13,12,11,10,8,7,6,5,3,2,1,0,0,0
.byte 0,0,32,32,30,29,28,27,25,24,23,21,20,19,18,17,16,15,14,13,11,10,9,7,6,5,4,2,1,0,0,0
.byte 0,0,0,32,32,30,29,28,26,25,24,22,21,20,18,17,16,14,13,12,10,9,8,6,5,4,2,1,0,0,0,0
.byte 0,0,0,32,31,30,29,27,26,25,23,22,20,19,18,17,16,15,14,12,11,9,8,7,5,4,3,1,0,0,0,0
.byte 0,0,0,0,32,31,30,28,27,26,24,23,21,20,18,17,16,14,13,11,10,8,7,6,4,3,1,0,0,0,0,0
.byte 0,0,0,0,32,31,30,28,27,25,24,22,21,19,18,17,16,15,13,12,10,9,7,6,4,3,1,0,0,0,0,0
.byte 0,0,0,0,0,32,31,29,28,26,25,23,22,20,19,17,15,14,12,11,9,8,6,5,3,2,0,0,0,0,0,0
.byte 0,0,0,0,0,32,31,29,27,26,24,23,21,19,18,17,16,15,13,11,10,8,7,5,3,2,0,0,0,0,0,0
.byte 0,0,0,0,0,0,32,30,29,27,25,24,22,20,19,17,15,14,12,10,9,7,5,4,2,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,32,30,28,27,25,23,21,20,18,17,16,14,13,11,9,7,6,4,2,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,32,30,28,26,24,23,21,19,17,15,13,11,10,8,6,4,2,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,32,30,28,26,24,22,20,18,17,16,14,12,10,8,6,4,2,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,32,31,29,27,25,23,21,19,17,15,13,11,9,7,5,3,1,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,32,31,29,27,25,22,20,18,17,16,14,12,9,7,5,3,1,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,32,31,29,26,24,22,19,17,15,12,10,8,5,3,1,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,32,31,28,26,23,21,18,17,16,13,11,8,6,3,1,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,32,30,28,25,22,20,17,14,12,9,6,4,1,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,32,30,27,24,21,18,17,16,13,10,7,4,1,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,32,29,26,23,20,17,14,11,8,5,2,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,32,29,25,22,19,17,15,12,9,5,2,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,32,28,24,21,17,13,10,6,2,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,31,27,23,19,17,15,11,7,3,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,31,26,22,17,12,8,3,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,30,25,20,17,14,9,4,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,29,23,17,11,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,28,21,17,13,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,17,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,23,17,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,17,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,17,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,13,17,21,28,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,11,17,23,29,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,4,9,14,17,20,25,30,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,3,8,12,17,22,26,31,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,3,7,11,15,17,19,23,27,31,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,2,6,10,13,17,21,24,28,32,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,2,5,9,12,15,17,19,22,25,29,32,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,2,5,8,11,14,17,20,23,26,29,32,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,1,4,7,10,13,16,17,18,21,24,27,30,32,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,1,4,6,9,12,14,17,20,22,25,28,30,32,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,1,3,6,8,11,13,16,17,18,21,23,26,28,31,32,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,1,3,5,8,10,12,15,17,19,22,24,26,29,31,32,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,1,3,5,7,9,12,14,16,17,18,20,22,25,27,29,31,32,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,32,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,2,4,6,8,10,12,14,16,17,18,20,22,24,26,28,30,32,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,2,4,6,8,10,11,13,15,17,19,21,23,24,26,28,30,32,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,2,4,6,7,9,11,13,14,16,17,18,20,21,23,25,27,28,30,32,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,2,4,5,7,9,10,12,14,15,17,19,20,22,24,25,27,29,30,32,0,0,0,0,0,0
.byte 0,0,0,0,0,0,2,3,5,7,8,10,11,13,15,16,17,18,19,21,23,24,26,27,29,31,32,0,0,0,0,0
.byte 0,0,0,0,0,0,2,3,5,6,8,9,11,12,14,15,17,19,20,22,23,25,26,28,29,31,32,0,0,0,0,0
.byte 0,0,0,0,0,1,3,4,6,7,9,10,12,13,15,16,17,18,19,21,22,24,25,27,28,30,31,32,0,0,0,0
.byte 0,0,0,0,0,1,3,4,6,7,8,10,11,13,14,16,17,18,20,21,23,24,26,27,28,30,31,32,0,0,0,0
.byte 0,0,0,0,1,3,4,5,7,8,9,11,12,14,15,16,17,18,19,20,22,23,25,26,27,29,30,31,32,0,0,0
.byte 0,0,0,0,1,2,4,5,6,8,9,10,12,13,14,16,17,18,20,21,22,24,25,26,28,29,30,32,32,0,0,0
.byte 0,0,0,1,2,4,5,6,7,9,10,11,13,14,15,16,17,18,19,20,21,23,24,25,27,28,29,30,32,32,0,0
.byte 0,0,0,1,2,3,5,6,7,8,10,11,12,13,15,16,17,18,19,21,22,23,24,26,27,28,29,31,32,32,0,0
.byte 0,0,1,2,3,4,6,7,8,9,10,12,13,14,15,16,17,18,19,20,21,22,24,25,26,27,28,30,31,32,32,0
.byte 0,0,1,2,3,4,5,7,8,9,10,11,12,14,15,16,17,18,19,20,22,23,24,25,26,27,29,30,31,32,32,0
.byte 0,1,2,3,4,5,6,7,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,27,28,29,30,31,32,32
.byte 0,1,2,3,4,5,6,7,8,9,10,12,13,14,15,16,17,18,19,20,21,22,24,25,26,27,28,29,30,31,32,32
.byte 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32
// db=67
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

.pc =$c900 "QB screen chars"
qbscreen:
//    25*4chr = 208*32pixel
//    01 02 03 04 05 06 07 08 09 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25  26  27  28  29  30  31  32  33  34  35  36  37  38  39  40

.byte 00,04,08,12,16,20,24,28,32,36,40,44,48,52,56,60,64,68,72,76,80,84,88,92,96,145,145,145,145,145,145,145,145,145,145,145,145,145,145,145
.byte 01,05,09,13,17,21,25,29,33,37,41,45,49,53,57,61,65,69,73,77,81,85,89,93,97,145,145,145,145,145,145,145,145,145,145,145,145,145,145,145
.byte 02,06,10,14,18,22,26,30,34,38,42,46,50,54,58,62,66,70,74,78,82,86,90,94,98,145,145,145,145,145,145,145,145,145,145,145,145,145,145,145
.byte 03,07,11,15,19,23,27,31,35,39,43,47,51,55,59,63,67,71,75,79,83,87,91,95,99,145,145,145,145,145,145,145,145,145,145,145,145,145,145,145

.pc =$ca00 "QB sintabla"
sintabla:
.byte 68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,33,44,54,61,65,66,64,58,50,41,30,20,11,5,1,0,2,6,13,22,32,42,50,58,63,66,66,64,59,52,44,35,26,17,10,4,1,0,1,4,9,16,24,32,40,48,55,61,65,66,66,64,60,54,48,40,32,24,17,11,6,2,0,0,1,4,9,14,21,28,35,43,49,55,60,64,66,66,66,64,60,55,50,44,37,30,23,17,12,7,3,1,0,0,1,3,7,11,17,22,29,35,41,47,52,57,61
.byte 64,66,66,66,65,63,60,56,51,46,40,34,29,23,18,13,9,5,3,1,0,0,0,2,4,8,11,16,21,26,31,36,41,46,51,55,58,61,64,65,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,59,57,54,52,50,47,44,42,39,36,33,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68
.byte 68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68


.pc =$cc00 "QB font"
QBfont:
.byte 0,0,0,0,85,106,111,111,111,111,111,111,111,111,111,111,111,111,111,111,111,111,85,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,85,170,255,91,91,91,91,91,91,91,91,91,91,91,91,91,155,219,91,27,27,27,21,0,0,0,0,0
.byte 0,21,26,27,91,155,219,219,219,219,219,219,219,219,219,219,219,219,219,219,219,219,213,208,208,208,80,0,0,0,0,0
.byte 0,80,144,208,213,218,223,214,214,214,214,214,214,214,214,214,214,214,214,214,234,255,85,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,85,166,246,246,246,246,246,246,246,246,246,246,246,246,246,246,246,246,86,6,6,6,5,0,0,0,0,0
.byte 0,0,0,0,85,170,255,245,245,245,245,245,245,245,245,245,245,245,245,245,246,247,245,245,245,245,85,0,0,0,0,0
.byte 0,0,0,0,85,169,253,189,189,189,189,189,189,189,189,189,189,189,189,189,189,253,85,85,119,119,127,119,119,85,0,0
.byte 0,0,0,0,85,170,255,85,85,170,191,189,189,189,189,189,189,189,189,189,190,191,85,85,119,119,119,119,127,85,0,0
.byte 0,0,0,0,85,170,255,111,111,111,111,111,111,111,111,111,111,111,111,111,175,255,85,85,127,119,119,119,119,85,0,0
.byte 0,0,0,0,85,106,111,111,111,111,111,111,111,111,111,111,111,111,111,111,111,111,85,85,127,117,119,119,127,85,0,0
.byte 0,0,0,0,85,170,255,91,91,91,91,85,85,85,85,85,85,85,85,85,85,85,85,85,127,119,127,119,119,85,0,0
.byte 0,21,26,27,91,155,219,219,219,219,219,91,91,91,91,91,91,91,91,91,91,91,85,85,127,119,117,117,117,85,0,0
.byte 0,80,144,208,213,255,255,213,213,213,213,213,213,213,213,214,214,214,214,214,234,255,85,85,119,119,127,87,127,85,0,0
.byte 0,0,0,0,85,246,246,86,86,86,86,86,86,86,86,166,246,246,246,246,246,246,85,85,86,87,85,64,64,64,0,0
.byte 0,0,0,0,85,165,245,245,245,245,245,245,245,245,245,245,245,245,245,245,253,253,85,85,170,255,85,0,0,0,0,0
.byte 0,0,0,0,85,169,189,189,189,189,189,189,189,189,189,189,189,189,189,189,189,189,189,189,189,253,85,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0

.pc =$cb10 "QB pos_low & hi"
pos_lo:

.byte $00,$20,$40,$60,$80,$a0,$c0,$e0
.byte $00,$20,$40,$60,$80,$a0,$c0,$e0
.byte $00,$20,$40,$60,$80,$a0,$c0,$e0
.byte $00,$20,$40,$60,$80,$a0,$c0,$e0

.byte $00,$20,$40,$60,$80,$a0,$c0,$e0
.byte $00,$20,$40,$60,$80,$a0,$c0,$e0
.byte $00,$20,$40,$60,$80,$a0,$c0,$e0
.byte $00,$20,$40,$60,$80,$a0,$c0,$e0

.byte $00,$20,$40,$60,$80,$a0,$c0,$e0


pos_hi:

.byte $c0,$c0,$c0,$c0,$c0,$c0,$c0,$c0
.byte $c1,$c1,$c1,$c1,$c1,$c1,$c1,$c1
.byte $c2,$c2,$c2,$c2,$c2,$c2,$c2,$c2
.byte $c3,$c3,$c3,$c3,$c3,$c3,$c3,$c3

.byte $c4,$c4,$c4,$c4,$c4,$c4,$c4,$c4
.byte $c5,$c5,$c5,$c5,$c5,$c5,$c5,$c5
.byte $c6,$c6,$c6,$c6,$c6,$c6,$c6,$c6
.byte $c7,$c7,$c7,$c7,$c7,$c7,$c7,$c7

.byte $c8,$c8,$c8,$c8,$c8,$c8,$c8,$c8


.pc =$c9a0 "QB pos byte"
pos:
.byte 0

.pc =$c9a1 "QB oszlopszamolo"
ocount:
.byte 0

.pc =$c9a2 "QB sprite fx on/off"
q4masol:
.byte 0

.pc=$0b40 "QB sprite"
qbsprite:
.byte 85,85,80,106,90,144,111,91,208,111,91,208,111,91,208,111,91,208,111,91,208,111,91,212,111,171,244,111,255,244,85,91,212,0,27,208,0,27,208,0,27,208,0,27,208,0,27,208,0,27,208,0,27,208,0,27,208,0,21,80,0,0,0


.pc=music.location "Music"
.fill music.size, music.getData(i)