import QtQuick 2.3
import AdaptDemoSystem 1.0

Group {
    id: blur
    name: "blurDepth"
    effectName: "Blur"
    enabled: sync(name+".ON")

    property real posX: 0.0
    property real posY: 0.0
    Texture {
        textureUnit: 0
        textureRT: "depth"
        textureWrap: "clamp"
    }

    Blit {
        textureRT: "orig"
        blitRT: 0
    }

//    Blit {
//        textureRT: "depth1"
//        blitRT: 0
//    }

    Shader {
        file: "blur"
        ShaderParam {
            paramName: "g_blurStrength"
            property real strengthAddPerLoop: sync(blur.name+".strength.addPerLoop")
            paramValue: sync(blur.name+".strength")*(1.0)
        }
        ShaderParam { paramName: "g_screenSize"; paramValue: sync(blur.name+".screenSize") }
        ShaderParam { paramName: "g_readSize"; paramValue: 1.0 }
    }
    DrawVB {
        type: "quad"
        depthTest: false
        depthWrite: false
        blendMode: "off"
        drawBuffers: 1
    }

    Repeater {
        model: sync(name+".blurLoops")
        delegate: Group {
            Blit {
                textureRT: "depth"
                blitRT: 0
            }
//            Blit {
//                textureRT: "depth"+index
//                blitRT: 0
//            }

           Shader {
                file: "blur"
                ShaderParam {
                    paramName: "g_blurStrength"
                    property real strengthAddPerLoop: sync(name+".strength.addPerLoop")
                    paramValue: sync(name+".strength")*(1.0+index*strengthAddPerLoop)
                }
                ShaderParam { paramName: "g_screenSize"; paramValue: sync(name+".screenSize") }
                ShaderParam { paramName: "g_readSize"; paramValue: index===0 ? 1.0 : sync(name+".screenSize") }
            }
            DrawVB {
                type: "quad"
                depthTest: false
                depthWrite: false
                blendMode: "off"
                drawBuffers: 1
            }
        }
    }

    Blit {
        textureRT: "depth"
        blitRT: 0
    }

    Texture {
        textureUnit: 0
        textureRT: "orig"
    }

        Shader {
            file: "fx/_SharedQML/overlay"
        }

        DrawVB {
            ShaderParam {
                paramName: "flip"
                paramValue: 1.0
            }
            ShaderParam {
                paramName: "overlayAlpha"
                paramValue: 0.0
            }
            ShaderParam {
                paramName: "g_overlayScale"
                paramValue: 1.0
            }
            ShaderParam {
                paramName: "g_posX"
                paramValue: 0.0
            }
            ShaderParam {
                paramName: "g_posY"
                paramValue: 0.0
            }

            type: "quad"
            depthTest: false
            depthWrite: false
            drawBuffers: 1
        }



//    Blit {
//        textureRT: "colorBuffer"
//    }
//    Texture {
//        textureUnit: 0
//        textureRT: "colorBuffer"
//    }
//    Texture {
//        textureUnit: 1
//        textureRT: "screenBuffer2"
//    }

//    Shader {
//        file: "fx/_SharedQML/overlayAdd"
//    }

//    DrawVB {
//        ShaderParam {
//            paramName: "flip"
//            paramValue: 0.0
//        }
//        ShaderParam {
//            paramName: "overlayAlpha"
//            paramValue: 0.25
//        }
//        ShaderParam {
//            paramName: "g_overlayScale"
//            paramValue: 1.0
//        }
//        ShaderParam {
//            paramName: "g_posX"
//            paramValue: 0.0
//        }
//        ShaderParam {
//            paramName: "g_posY"
//            paramValue: 0.0
//        }

//        type: "quad"
//        depthTest: false
//        depthWrite: false
//    }



}
