import QtQuick 2.4
import AdaptDemoSystem 1.0

Group {
    id: mirrorMesh
    name: "mirrorMesh"
    enabled: sync(name+".ON")
    Shader { file: "smPackInt" }
    TextureSel { name: parent.name }
    DrawMesh {
      file: meshSel(mirrorMesh.name)
      smoothNormals: true; normalSmoothAngle: 20;
      blendMode: blendSel(mirrorMesh.name)
      depthTest: true; depthWrite: true;
      halfFloats: true
      intPack: true
      // autoCenter: false; autoScale: false
      //  cull: true; cullBack: true
      Pos { x: sync(mirrorMesh.name+".x"); y: sync(mirrorMesh.name+".y"); z: sync(mirrorMesh.name+".z")}
      Sca { s: sync(mirrorMesh.name+".sca"); x: 1.0; y: 1.0; z: 1.0 }
      Rot { d: sync(mirrorMesh.name+".rotX"); ax: 1.0; ay: 0.0; az: 0.0 }
      ShaderParam { paramName: "g_uvScale"; paramValue: sync(mirrorMesh.name+".uvScale")}
      ShaderParam { paramName: "g_bump"; paramValue: sync(mirrorMesh.name+".bump")}
      ShaderParam { paramName: "g_texBrightness"; paramValue: sync(mirrorMesh.name+".texBright") }
      ShaderParam { paramName: "g_texAmbient"; paramValue: sync(mirrorMesh.name+".ambient") }
      ShaderParam { paramName: "g_prevAmount"; paramValue: 0.0 }
      ShaderParam { paramName: "g_prevBlurAmount"; paramValue: sync(mirrorMesh.name+".prevBlurAmount") }
      ShaderParam { paramName: "g_color"; paramValueVec4: "1.0, 1.0, 1.0, 1.0"}
      ShaderParam { paramName: "g_bright"; paramValue: 1.0}
    }

}
