import QtQuick 2.3
import "."
import AdaptDemoSystem 1.0

Group {
    id: surferNets
    name: "surferNet"
    enabled: sync(name+".ON");
    // Surfer nets v0 (surface nets variation with deepr touch)

    property string surfPotShader: "surfPot"
    property string surfGeomShader: "surfGeom"

    property string textureFile: ""
    property string textureRt: ""

    // The dimension of the 3D surface grid as square root of the actual, all three dimension are the same.
    property int surfGridDim3DSqrt: 10
    // Do not change this value directly, should be power of two of the selected dimension square root,
    property int surfGridDim3D: surfGridDim3DSqrt*surfGridDim3DSqrt
    // The final size of the rectangular surface grid 2D texture is (surfGridDim3DSqrt*surfGridDim3D) x (surfGridDim3DSqrt*surfGridDim3D)
    property int surfGridRes2D: surfGridDim3DSqrt*surfGridDim3D

    // 1. Generate the potential field to 3D grid points, now a simple plasma or a set of couple of blobby balls
    RenderTarget {

        RenderTargetLayer {
            textureRT: "surfPotentials"
            // "RGBA32F"
            format: "RGBA32F"
            width: surferNets.surfGridRes2D
            height: surferNets.surfGridRes2D
//                Clear {
//                    cR: -1.0; cG: 0.0; cB: 0.0; cA: 1.0;
//                }
        }
        Texture {
            textureUnit: 0
            textureRT: "mainDepth"
        }
        Shader {
            file: sceneDir+surfPotShader
        }
        DrawVB {
            type: "quad"; depthTest: false; depthWrite: false; blendMode: "normal"
            ShaderParam { paramName: "flip"; paramValue: 1.0 }
            ShaderParam { paramName: "surfGridRes2D"; paramValue: surferNets.surfGridRes2D }
            ShaderParam { paramName: "surfGridDim3D"; paramValue: surferNets.surfGridDim3D }
        }
    }

    // 2a. Calculate the grid point normals from the potential field
    RenderTarget {
        RenderTargetLayer {
            textureRT: "surfNormals"
            // "RGBA32F"
            format: "RGBA32F"
            width: surferNets.surfGridRes2D
            height: surferNets.surfGridRes2D
            Clear {
                cR: 0.0; cG: 0.0; cB: 0.0; cA: 1.0;
            }
        }
        Texture {
            textureUnit: 0
            textureRT: "surfPotentials"
        }
        Shader {
            file: sceneDir+"surfNormals"
        }
        DrawVB {
            type: "quad"; depthTest: false; depthWrite: false; blendMode: "off"
            ShaderParam { paramName: "flip"; paramValue: 1.0 }
            ShaderParam { paramName: "surfGridRes2D"; paramValue: surferNets.surfGridRes2D }
            ShaderParam { paramName: "surfGridDim3D"; paramValue: surferNets.surfGridDim3D }
        }
    }

    // 3. Calculate the center average positions of all the intersecting edges in each grid cube
    RenderTarget {
        RenderTargetLayer {
            textureRT: "surfCenters"
            // "RGBA32F"
            format: "RGBA32F"
            width: surferNets.surfGridRes2D
            height: surferNets.surfGridRes2D
//                Clear {
//                    cR: 0.0; cG: 0.0; cB: 0.0; cA: 1.0;
//                }
        }
        Texture {
            textureUnit: 0
            textureRT: "surfEdges"
        }
        Texture {
            textureUnit: 1
            textureRT: "surfPotentials"
        }
        Texture {
            textureUnit: 2
            textureRT: "surfNormals"
        }
        Shader {
            file: sceneDir+"surfCenters"
        }
        DrawVB {
            type: "quad"; depthTest: false; depthWrite: false; blendMode: "normal"
            ShaderParam { paramName: "flip"; paramValue: 1.0 }
            ShaderParam { paramName: "surfGridRes2D"; paramValue: surferNets.surfGridRes2D }
            ShaderParam { paramName: "surfGridDim3D"; paramValue: surferNets.surfGridDim3D }
        }
    }


    // 4. Draw the surface by using the informations generated in step 2, source is a VBO with single point primitive for each
    //    grid cell and these points are converted to max 3*2 triangles in geometry shader.
    //    The primitives are generated only to grid cells having negative multiplied corner potentials value.

    Shader {
        file: sceneDir+surfGeomShader
    }
    Texture { textureUnit: 0; textureRT: "surfCenters" }
    Texture { textureUnit: 1; textureRT: "surfPotentials" }
    Texture { textureUnit: 2; textureRT: "surfNormals" }
    Repeater { model: textureRt !== "" ? 1 : 0; delegate:
        Texture { textureUnit: 3; textureRT: textureRt}
    }
    Repeater { model: textureFile !== "" ? 1 : 0; delegate:
            TextureImage { textureUnit: 3; file: textureFile }
    }
  //  Texture { textureUnit: 3; textureRT: "prevBlur" }
    DrawVB {
        type: "pointGridDraw"
        name: "surfGeom"
        vboId: sceneName+name
        depthTest: true
        depthWrite: true

        blendMode: "off"
       // blendMode: drawBlendMode
       // blendMode: "off"

        gridWidth: surferNets.surfGridRes2D
        gridHeight: surferNets.surfGridRes2D
        drawNumPoints: gridWidth*gridHeight

        Pos { x: 0.0; y: sync(surferNets.name+".y"); z: 0.0 }
        Sca { s: sync(surferNets.name+".scale"); x: 1.0; y: 1.0; z: 1.0 }


        ShaderParam { paramName: "surfGridRes2D"; paramValue: surferNets.surfGridRes2D }
        ShaderParam { paramName: "surfGridDim3D"; paramValue: surferNets.surfGridDim3D }
        ShaderParam { paramName: "g_texBrightness"; paramValue: sync(surferNets.name+".texBright") }
        ShaderParam { paramName: "g_smooths"; paramValue: sync(surferNets.name+".smooths") }
        ShaderParam { paramName: "g_spikes"; paramValue: sync(surferNets.name+".spikes") }

        ShaderParam { paramName: "g_scaleY"; paramValue: sync(surferNets.name+".scaleY") }
        ShaderParam { paramName: "g_twistOfsY"; paramValue: sync(surferNets.name+".twistOfsY") }
        ShaderParam { paramName: "g_twistY"; paramValue: sync(surferNets.name+".twistY") }

        ShaderParam { paramName: "g_exploAmp"; paramValue: sync(surferNets.name+".exploAmp") }
        ShaderParam { paramName: "g_exploFreq"; paramValue: sync(surferNets.name+".exploFreq") }
        ShaderParam { paramName: "g_exploPos"; paramValue: sync(surferNets.name+".exploPos") }

        ShaderParam { paramName: "g_envPosScr"; paramValue: sync(surferNets.name+".envPosScr") }
        ShaderParam { paramName: "g_envPosNorm"; paramValue: sync(surferNets.name+".envPosNorm") }

        drawBuffers: 2
    }
}
