#version 430

layout(binding=0) uniform sampler2D texScreen;
layout(binding=1) uniform sampler2D texOverlay;

in vec2 uv;

layout(location = 0) out vec4 frag;
// layout(location = 1) out vec4 frag2;

uniform float g_time;
/*
float rand(vec2 co){
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}

vec3 tonemapUC2(vec3 x) {
    float A = 0.15;
    float B = 0.50;
    float C = 0.10;
    float D = 0.20;
    float E = 0.02;
    float F = 0.30;
    return ((x*(A*x+C*B)+D*E)/(x*(A*x+B)+D*F))-E/F;
}
*/


uniform float flip=1.0;

uniform float overlayAlpha=1.0;

uniform float g_posX = 0.0;
uniform float g_posY = 0.0;

uniform float g_overlayScale = 1.0;

uniform float g_scaleCX = 0.0;
uniform float g_scaleCY = 0.0;

uniform float g_scaleX=1.0;
uniform float g_scaleY=1.0;
uniform float g_rot=0.0;

vec2 rotateXY(vec2 p, float a) {
vec2 r = p;
r.x = cos(a)*p.x - sin(a)*p.y;
r.y = sin(a)*p.x + cos(a)*p.y;
return r;
}



uniform float g_alphaFromColor = 1.0;

void main() {

    vec2 uvS = uv;
    vec2 uvO = uvS+vec2(g_posX, g_posY);
    if (flip > 0.5) {
        uvS.y = 1.0-uvS.y;
    }

    uvO -= vec2(g_scaleCX, g_scaleCY);
    uvO *= g_overlayScale;
    uvO.x *= g_scaleX;
    uvO.y *= g_scaleY;
    uvO.x *= 1.667;
    uvO = rotateXY(uvO, g_rot/360.0*2.0*3.141592);
    uvO.x /= 1.667;
    uvO += vec2(g_scaleCX, g_scaleCY);

    vec4 screen = texture2D(texScreen, uvS*1.0+vec2(0.0, 0.0));
    vec4 color = texture2D(texOverlay, uvO);

    float alfs = color.a;
    float alpha = alfs*overlayAlpha;
    color = mix(color, screen*color, alpha);
    frag = color;
//    frag2 = vec4(0.0, 0.0, 0.0, 0.0);
}

