import QtQuick 2.3
import "../" // to import RocketScene
import "../_SharedQML"
import AdaptDemoSystem 1.0

RocketScene {
    FlyCamera { id: flyCam }
    Defaults { }
    
    VariClock {
        id: clock
    }

    property int staticUpdateCounter: 0
    
    property int frameIndex: 0

    function isStaticUpdating() {
        if (staticUpdateCounter <= 2) {
            return true;
        }
        return false;
    }
    
    Connections {
        target: demo; onFrameRendered: {
            frameIndex++;

            staticUpdateCounter++;
            if (staticUpdateCounter > 2) {
              //  transMesh.enabled = false;
            }
        }
    }

    BgBall {}

    BgBlur { }

    Shader {
        file: sceneDir+"smPlastic"
    }

    DrawMesh {
        id: mesh
        name: "mesh"
        enabled: true;
        smoothNormals: true; normalSmoothAngle: 60;
        file: meshSel(name)
        TextureSel { name: mesh.name }
        blendMode: blendSel(name);
        depthTest: true; depthWrite: true;

        Pos { x: syncOsc(mesh.name+".x"); y: syncFFT(mesh.name+".y"); z: sync(mesh.name+".z")}
        Rot { d: syncOsc(mesh.name+".rotY"); ax: 0.0; ay: 1.0; az: 0.0 }
        Sca { s: syncFFT(mesh.name+".sca"); x: 1.0; y: 1.0; z: 1.0 }
        ShaderParam { paramName: "g_texBrightness"; paramValue: sync(mesh.name+".bright") }
        ShaderParam { paramName: "g_texAmbient"; paramValue: sync(mesh.name+".ambient") }
        ShaderParam { paramName: "g_uvScale"; paramValue: sync(mesh.name+".uvScale") }
        ShaderParam { paramName: "g_prevBlurAmount"; paramValue: sync(mesh.name+".prevBlur") }
        ShaderParam { paramName: "g_bump"; paramValue: sync(mesh.name+".bump") }

    }

    DrawMesh {
        id: palikka
        name: "palikka"
        enabled: true;
        smoothNormals: true; normalSmoothAngle: 60;
        file: meshSel(name)
        TextureSel { name: palikka.name }
        blendMode: blendSel(name);
        depthTest: true; depthWrite: true;
        autoScale: true; autoCenter: true;

        Pos { x: syncOsc(palikka.name+".x"); y: syncOsc(palikka.name+".y"); z: sync(palikka.name+".z")}
        Rot { d: sync(palikka.name+".rotY"); ax: 0.0; ay: 1.0; az: 0.0 }
        Sca { s: sync(palikka.name+".sca"); x: 1.0; y: 1.0; z: 1.0 }
        ShaderParam { paramName: "g_texBrightness"; paramValue: sync(palikka.name+".bright") }
        ShaderParam { paramName: "g_texAmbient"; paramValue: sync(palikka.name+".ambient") }
        ShaderParam { paramName: "g_uvScale"; paramValue: sync(palikka.name+".uvScale") }
        ShaderParam { paramName: "g_prevBlurAmount"; paramValue: sync(palikka.name+".prevBlur") }
        ShaderParam { paramName: "g_bump"; paramValue: sync(palikka.name+".bump") }

    }




    Blit { textureRT: "depth"; blitRT: 1 }
    Reflect { }
    PrevBlur { }

    Coords { }
    Tonemap { }
    SMAA { }   
}
