#version 430


vec4 rotateXZ(vec4 p, float a) {
  vec4 r = p;
  r.x = cos(a)*p.x - sin(a)*p.z;
  r.z = sin(a)*p.x + cos(a)*p.z;
  return r;
}

vec3 rotateXZ3(vec3 p, float a) {
  return rotateXZ(vec4(p, 0.0), a).xyz;
}

vec4 rotateXY(vec4 p, float a) {
  vec4 r = p;
  r.x = cos(a)*p.x - sin(a)*p.y;
  r.y = sin(a)*p.x + cos(a)*p.y;
  return r;
}

vec4 rotateYZ(vec4 p, float a) {
  vec4 r = p;
  r.y = cos(a)*p.y - sin(a)*p.z;
  r.z = sin(a)*p.y + cos(a)*p.z;
  return r;
}

layout(triangles) in;
layout(triangle_strip, max_vertices = 8) out;

in vec3 position[3];
in vec3 normal[3];
in vec2 uv[3];
in vec3 tangent[3];
in float bright[3];
in vec3 origCenter[3];

out vec3 posG;
out vec3 normalG;
out vec2 uvG;
out vec3 tangentG;
out float brightG;
out vec3 origCenterG;

uniform float g_time;
uniform float g_emit = 1.0;

uniform float windowWidth;
uniform float windowHeight;

layout(binding=0) uniform sampler2D tex;

void main(void) {

    float dgl = 3000.0;
    vec3 dd = position[1]-position[0];
    if (dot(dd,dd) > dgl) {
      return;
    }
    dd = position[2]-position[0];
        if (dot(dd,dd) > dgl) {
          return;
        }
        dd = position[2]-position[1];
            if (dot(dd,dd) > dgl) {
              return;
            }

    for (int i = 0; i < gl_in.length(); ++i) {
        gl_Position = gl_in[i].gl_Position;
        posG = position[i];
        float d = 800.0;
        if (dot(posG, posG) > d*d) {
            return;
        }
        normalG = normal[i];
        uvG = uv[i];
        tangentG = tangent[i];
        brightG = bright[i];
        origCenterG = origCenter[i];

        EmitVertex();
    }
    EndPrimitive();
}
