#version 430



vec4 rotateXZ(vec4 p, float a) {
  vec4 r = p;
  r.x = cos(a)*p.x - sin(a)*p.z;
  r.z = sin(a)*p.x + cos(a)*p.z;
  return r;
}

vec3 rotateXZ3(vec3 p, float a) {
  return rotateXZ(vec4(p, 0.0), a).xyz;
}

vec4 rotateXY(vec4 p, float a) {
  vec4 r = p;
  r.x = cos(a)*p.x - sin(a)*p.y;
  r.y = sin(a)*p.x + cos(a)*p.y;
  return r;
}

vec4 rotateYZ(vec4 p, float a) {
  vec4 r = p;
  r.y = cos(a)*p.y - sin(a)*p.z;
  r.z = sin(a)*p.y + cos(a)*p.z;
  return r;
}

layout(triangles) in;
layout(triangle_strip, max_vertices = 3) out;
//layout(line_strip, max_vertices = 15) out;

in vec3 normal[3];
in vec2 uv[3];
in vec3 tangent[3];
in vec4 origPos[3];
in vec3 instPos[3];

in int inInst[3];

in vec3 instVel[3];
in float instAge[3];
in float instRec[3];

out vec4 posG;
out vec3 normalG;
out vec3 normalWSG;
out vec2 uvG;
out vec3 tangentG;
out vec3 colorG;
out vec4 posW;
out vec4 posMod;
out vec4 posInst;

out float instG;


uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;
uniform mat4 viewMatrix;
uniform mat4 modelMatrix;

uniform float g_time;

uniform float windowWidth;
uniform float windowHeight;

uniform float furLength = 1.0;

// uniform float makkara;

layout(binding=0) uniform sampler2D tex;
layout(binding=1) uniform sampler2D texNorm;
layout(binding=2) uniform sampler2D texEnv;
layout(binding=3) uniform sampler2D texPrevFrame;
layout(binding=4) uniform sampler2D texDepth;

layout(binding=0, offset=0) uniform atomic_uint ac;
layout(binding=0, rgba32f) uniform image2D emittedPartPos;
layout(binding=1, rgba32f) uniform image2D voxPosComp;
layout(binding=2, rgba32f) uniform image2D voxNorComp;

uniform float g_instLayer = 0.0;

uniform float zNear = 0.1;
uniform float zFar = 1000.0;
// convert from 0.0 to 1.0 depth sample ds to linear depth
float linearDepth(float ds) {
    ds = 2.0*ds-1.0;
    float zLinear = 2.0*zNear*zFar/(zFar+zNear-ds*(zFar-zNear));
    return zLinear;
}

float atanSafe(float y, float x) {
 float ret=0.0;
        if (x!=0.0) {
                if (x>0.0) {
                        ret=atan(y/x);
                } else	{
                        ret=atan(y/x)+3.141592;
                }
        } else {
                if (y>=0.0) {
                        ret=0.5*3.141592;
                } else {
                        ret=-0.5*3.141592;
                }
        }
 return ret;
}

vec3 rotAroundAxis(vec3 vec, vec3 axis, float alpha) {
  float ca = cos(alpha);
  float sa = sin(alpha);
  float u = axis.x;
  float v = axis.y;
  float w = axis.z;
  vec3 rot;
  rot.x = u*(u*vec.x+v*vec.y+w*vec.z)*(1.0-ca)+vec.x*ca+(-w*vec.y+v*vec.z)*sa;
  rot.y = v*(u*vec.x+v*vec.y+w*vec.z)*(1.0-ca)+vec.y*ca+(w*vec.x-u*vec.z)*sa;
  rot.z = w*(u*vec.x+v*vec.y+w*vec.z)*(1.0-ca)+vec.z*ca+(-v*vec.x+u*vec.y)*sa;
  return rot;
}

vec3 cross(vec3 a, vec3 b) {
  vec3 r;
  r.x = a.y*b.z - a.z*b.y;
  r.y = a.z*b.x - a.x*b.z;
  r.z = a.x*b.y - a.y*b.x;
  return r;
}


uniform float g_voxelDim;


void main(void) {

        vec3 controlBase = vec3(0.0);

        float times = g_time*0.1;
       vec3 faceNormal = vec3(0.0);
        vec4 facePos = vec4(0.0);

        float vd2 = g_voxelDim*g_voxelDim;
        int vd3 = int(vd2*g_voxelDim);

        // float rotAngle = atanSafe(instVel[0].y,instVel[0].x)+0.50*3.141592;

      //  mat4 mvp = projectionMatrix * modelViewMatrix;


           uint counter = inInst[0];

           instG = inInst[0];

           if (counter >= atomicCounter(ac)) {
             return;
           }

           //counter += uint(g_instLayer)*1280*720;

           uint cy = counter/(vd3);
           uint cx = counter-uint(cy*vd3);
           ivec2 listCoord = ivec2(cx,cy);
           //vec3 myInstPos = vec3(vec2(listCoord)*0.2, 0.0);
           vec3 myInstPos = imageLoad(emittedPartPos, listCoord).xyz*2.0+vec3(2.0/(g_voxelDim*g_voxelDim));
           instG = myInstPos.x*1.0;

           vec4 vpc = imageLoad(voxPosComp, listCoord);
           vec4 vnc = imageLoad(voxNorComp, listCoord);

           vnc = rotateXY(vnc, g_time+myInstPos.x*2.1+cos(myInstPos.y*1.2));
           vnc = rotateXZ(vnc, g_time*0.3+myInstPos.z*1.1+sin(myInstPos.x*3.12));

      //  myInstPos += vpc.xyz*4.0/(g_voxelDim*g_voxelDim);
        for (int i = 0; i < gl_in.length(); ++i) {
                gl_Position = gl_in[i].gl_Position; // -vec4(1.5, 0.0, 0.0, 0.0);

                gl_Position.xyz *= 4.0/(g_voxelDim*g_voxelDim);

                gl_Position = modelMatrix*gl_Position;
                normalG = normal[i];
                normalG = normalize((modelMatrix*(vec4(normalG, 0.0))).xyz);

                posMod = gl_Position;

                posInst = gl_Position+vec4(myInstPos, 1.0);
                posW = gl_Position+vec4(myInstPos, 1.0);
                vec4 pos4 = vec4(gl_Position);



                vec3 zVec = vec3(0.0, 0.0, 1.0);
                float dotsi = dot(vnc.rgb, zVec);
                //   if (abs(dotsi)>0.005) {
                        vec3 rotAxis = normalize(cross(vnc.rgb, zVec));
                        //rotAxis = normalize(rotAxis);
                        float angle = acos(dotsi)+3.14*1.0;
                        //float length = sqrt(dot(vPosTrans.xyz, vPosTrans.xyz));
                        //vPosTrans.xyz/=length;
                        gl_Position.xyz = rotAroundAxis(gl_Position.xyz, rotAxis, -angle*1.0);
                        normalG = rotAroundAxis(normalG, rotAxis, -angle*1.0);
                //   }

                gl_Position = viewMatrix*gl_Position + viewMatrix*vec4(myInstPos, 1.0);

                colorG = vec3(vnc.rgb);

                gl_Position.xyz -= normal[i]*0.0;
                facePos += origPos[i];

                float depu = 0.0;
                vec3 ssNormal = vec3(0.0);

                normalWSG = (vec4(normalG, 0.0)).xyz;
                normalG = (modelViewMatrix * vec4(normalG, 0.0)).xyz;

                gl_Position = projectionMatrix*gl_Position;

                posG = gl_Position;

                faceNormal += normal[i];
                uvG = uv[i];
                tangentG = tangent[i];
                EmitVertex();
        }
        facePos /= 3.0;

        EndPrimitive();

}
