import QtQuick 2.3
import "../" // to import RocketScene
import "../_SharedQML"
import AdaptDemoSystem 1.0

RocketScene {
    FlyCamera { id: flyCam }
    Group {
        //setup default textures
        TextureImage { textureUnit: 1; file: "../../images/_SK57414_normal.png"}
        TextureImage { textureUnit: 2; file: "../../images/area_lights.jpg"}
        Texture { textureUnit: 3; textureRT: "prev" }
        Texture { textureUnit: 4; textureRT: "prevBlur" }
        Texture { textureUnit: 5; textureRT: "prevNormal" }
    }
    
    // clear RGB & Z here so we are sure it happens at least once properly...
    Shader { file: sceneDir+"smBg" }
    DrawMesh {
        //file: "mesh/tri.lwo"; Clear { cR: 1.0; cG: 1.0; cB: 1.0; cA: 0.0; cD: 1.0; }
        file: "mesh/tri.lwo"; Clear { cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0; cD: 1.0; }
        //file: "mesh/tri.lwo"; Clear { cR: 0.90; cG: 0.90; cB: 0.90; cA: 0.0; cD: 1.0; }
        Sca { s: 0.0; }
    }
    
    VariClock {
        id: clock
    }

    property int staticUpdateCounter: 0
    
    property int frameIndex: 0

    function isStaticUpdating() {
        if (staticUpdateCounter <= 2) {
            return true;
        }
        return false;
    }
    
    Connections {
        target: demo; onFrameRendered: {
            frameIndex++;

            staticUpdateCounter++;
            if (staticUpdateCounter > 2) {
              //  transMesh.enabled = false;
            }
        }
    }


    Group {
        // background ball with smokey etc textures
        id: bgBall
        name: "bgBall"
        enabled: sync("bgBall.ON")
        Shader { file: sceneDir+"smBg" }
        TextureSel { textureUnit: 0; name: parent.name }
        DrawMesh {
            file: "mesh/ball5000.x";
            enabled: true; smoothNormals: true; normalSmoothAngle: 80;
            blendMode: blendSel(bgBall.name)
            depthTest: true; depthWrite: true;
            //  cull: true; cullBack: true
            Sca { s: 400.0; x: 1.0; y: 10.0; z: 1.0 }
            Pos { x: 0.0; y: -0.005; z: 0.0}
            Rot { d: -0; ax: 1.0; ay: 0.0; az: 0.0 }
            ShaderParam { paramName: "g_uvScale"; paramValue: 1.0}
            ShaderParam { paramName: "g_uvScaleY"; paramValue: 1.0}
            ShaderParam { paramName: "g_uvOfsY"; paramValue: syncOsc("bg.uvOfsY") }
            ShaderParam { paramName: "g_bump"; paramValue: 0.650}
            ShaderParam { paramName: "g_texBrightness"; paramValue: 1.0 }
            ShaderParam { paramName: "g_texAmbient"; paramValue: 0.0 }
            ShaderParam { paramName: "g_color"; paramValueVec4: "1.0, 1.0, 1.0, 1.0"}
            ShaderParam { paramName: "g_bright"; paramValue: sync("bg.bright")}
        }
        Blit {  textureRT: "bgBall" }
    }

    Blur {}

    Shader {
        file: sceneDir+"smPlastic"
    }

    DrawMesh {
        id: mesh
        name: "mesh"
        enabled: true;
        // smoothNormals: true; normalSmoothAngle: 60;
        file: meshSel(name)
        TextureSel { name: mesh.name }
        blendMode: blendSel(name);
        depthTest: true; depthWrite: true;
        autoScale: false; autoCenter: false

        Pos { x: syncOsc(mesh.name+".x"); y: syncFFT(mesh.name+".y"); z: sync(mesh.name+".z")}
        Rot { d: syncOsc(mesh.name+".rotY"); ax: 0.0; ay: 1.0; az: 0.0 }
        Sca { s: syncFFT(mesh.name+".sca"); x: 1.0; y: 1.0; z: 1.0 }
        ShaderParam { paramName: "g_texBrightness"; paramValue: sync(mesh.name+".bright") }
        ShaderParam { paramName: "g_texAmbient"; paramValue: sync(mesh.name+".ambient") }
        ShaderParam { paramName: "g_uvScale"; paramValue: sync(mesh.name+".uvScale") }
        ShaderParam { paramName: "g_prevBlurAmount"; paramValue: sync(mesh.name+".prevBlur") }
        ShaderParam { paramName: "g_bump"; paramValue: sync(mesh.name+".bump") }

    }

    Blit { textureRT: "depth"; blitRT: 1 }
    Reflect { }
    PrevBlur { }

    Coords { }
    Tonemap { }
    SMAA { }   
}
