import QtQuick 2.3
import "../" // to import RocketScene
import "../_SharedQML"
import AdaptDemoSystem 1.0

RocketScene { 
  FlyCamera { }
  Shader { file: "smPlastic" }
  TextureImage { textureUnit: 0; file: "../../images/meteor_b.png"}
  DrawMesh { 
    Clear { cR: 0.0; cG: 0.0; cB: 0.0 }
    file: "mesh/hand.x"; smoothNormals: true; normalSmoothAngle: 20; 
    Pos { x: sync("box.x"); y: sync("box.y"); z: sync("box.z")}
    Rot { d: 0; ax: 1.0; ay: 0.0; az: 0.0 }
    Sca { s: 5.0; x: 1.0; y: 1.0; z: 1.0 }
    ShaderParam { paramName: "g_uvScale"; paramValue: 10.0}
    ShaderParam { paramName: "g_texBrightness"; paramValue: 1.03 }
    ShaderParam { paramName: "g_texAmbient"; paramValue: 0.03 }
    ShaderParam { paramName: "g_bump"; paramValue: 0.50}
    ShaderParam { paramName: "g_prevAmount"; paramValue: 0.0 }
    ShaderParam { paramName: "g_prevBlurAmount"; paramValue: sync("prevBlurAmount") }
    ShaderParam { paramName: "g_color"; paramValueVec4: "1.0, 1.0, 1.10, 1.0" }
    ShaderParam { paramName: "g_bright"; paramValue: 1.0}
    blendMode: "off"; depthTest: true; depthWrite: true; cull: true; cullBack: true
  }
  Coords { }
}
