//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using
using SharpDX.DXGI;
using SharpDX.D3DCompiler;
using SharpDX.Direct3D; 
using Framefield.Core.Rendering;
using System.Dynamic;
using Framefield.Core;

namespace Framefield.Core.ID17edb483_8ac4_4de6_af55_da4f0cd357be
{
    public class Class_ChromaticAbberation2 : FXImageFunction
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            Image = 1,
            Size = 2,
            CenterOffsetX = 3,
            CenterOffsetY = 4,
            BulgeAmount = 5,
            BulgeOffset = 6,
            Samples = 7,
            Scale = 8,
            Intensity = 9
        }
        //<<< _inputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var Image = inputs[(int)InputId.Image].Eval(context).Image; // Needs to be checked for null!
            var Size = inputs[(int)InputId.Size].Eval(context).Value;
            var CenterOffsetX = inputs[(int)InputId.CenterOffsetX].Eval(context).Value;
            var CenterOffsetY = inputs[(int)InputId.CenterOffsetY].Eval(context).Value;
            var CenterOffset = new Vector2(CenterOffsetX, CenterOffsetY);
            var BulgeAmount = inputs[(int)InputId.BulgeAmount].Eval(context).Value;
            var BulgeOffset = inputs[(int)InputId.BulgeOffset].Eval(context).Value;
            var Bulge = new Vector2(BulgeAmount, BulgeOffset);
            var Samples = inputs[(int)InputId.Samples].Eval(context).Value;
            var Scale = inputs[(int)InputId.Scale].Eval(context).Value;
            var Intensity = inputs[(int)InputId.Intensity].Eval(context).Value;
            //<<< _params
            
            if(Image == null)
                return context;


            return PrepareAndEvalOnChange(context, () => {
                ClearRenderTarget(context, new SharpDX.Color4(0, 0, 0, 0));

                //>>> _setup
                using (var ImageView = new ShaderResourceView(context.D3DDevice, Image))
                {
                    _effect.GetVariableByName("RenderTargetSize").AsVector().Set(new Vector2(_usedViewport.Width, _usedViewport.Height));
                    _effect.GetVariableByName("Image").AsShaderResource().SetResource(ImageView);
                    _effect.GetVariableByName("Size").AsScalar().Set(Size);
                    _effect.GetVariableByName("CenterOffset").AsVector().Set(new Vector2(CenterOffsetX, CenterOffsetY));
                    _effect.GetVariableByName("Bulge").AsVector().Set(new Vector2(BulgeAmount, BulgeOffset));
                    _effect.GetVariableByName("Samples").AsScalar().Set(Samples);
                    _effect.GetVariableByName("Scale").AsScalar().Set(Scale);
                    _effect.GetVariableByName("Intensity").AsScalar().Set(Intensity);
                //<<< _setup

                Render(context);

                //>>> _cleanup
                }
                //<<< _cleanup
            });
        }

    }
}

