/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.seamcat.Logging;
import org.seamcat.eventbus.EventBusFactory;
import org.seamcat.events.FileOpenedEvent;
import org.seamcat.events.WorkspaceSavedEvent;
import org.seamcat.loadsave.WorkspaceSaver;
import org.seamcat.model.Workspace;
import org.seamcat.model.engines.InterferenceSimulationEngine;
import org.seamcat.model.engines.SimulationListener;
import org.seamcat.model.engines.SingleResult;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.factory.Model;
import org.seamcat.model.types.result.Results;
import org.seamcat.model.types.result.SingleValueTypes;
import org.seamcat.model.workspace.SimulationControl;
import org.seamcat.plugin.SandboxInitializer;
import org.seamcat.presentation.RecentlyUsed;
import org.seamcat.scenario.WorkspaceScenario;
import org.seamcat.simulation.Simulation;

public class CommandLine {
    private static final Logger LOG = Logger.getLogger(CommandLine.class);
    private static final String WS = "Workspace";
    private static final String OUTPUT = "result";
    private static final String EVENTS = "events";
    private static RecentlyUsed recentlyUsed = new RecentlyUsed();
    private static int width = 70;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        File file;
        Logging.initializeCommandLine();
        SandboxInitializer.initializeSandbox();
        System.out.print(" \n \n                                      \u2553@\n                                   \u2553\u2584\u2593\u2593\u258c\n                               ,\u2557\u2593\u2593\u2593\u2593\u2593\u2593\u258c\n                          ,\u2557\u03a6\u2593\u2593\u2593\u2580\u2559` \u2590\u2593\u2593\u258c\n                      ,\u2584\u2593\u2593\u2580\u2580^       \u2590\u2593\u2593\u258c  ,\u2553\u2557\u2584\u03c6\u03c6\u03c6\u03c6\u03c6\u2584\u2557\u2553,\n                    \u2584\u2593\u2593\u2580`,\u2553\u2554\u2584\u2584\u2584\u2584\u2554\u2553, \u2590\u2593\u2593\u2593\u2593\u2580\u2559`,\u2553\u2553\u2554\u2584\u2584\u2584\u2584\u2584\u2584\u2560\u2580\u2593\u2593\u2566\n                  \u2584\u2593\u2580\u2553\u2584\u2593\u2593\u2593\u2593\u2593\u2593\u2593\u2593\u2593\u2593\u2593\u2593\u2593\u2593\u2593\u2593\u2593\u2584\u03a6\u2593\u2593\u2593\u2593\u2593\u2593\u2593\u2593\u2593\u2593\u2593\u2593\u2593\u2593\u2593\u2584\u2560\u2580\u2593\u2584\n                \u2553\u2593\u2580\u2553\u2593\u2593\u2593\u2580`    `\u2559\u2580\u2593\u2593\u2584 `\u2559\u2580\u2593\u2593\u2580^ ,\u2593\u2593\u2593\u2580`     `\u2559\u2593\u2593\u2593\u00d6\u2580\u2593\u2584\n               \u2554\u2593\u00dc\u03a6\u2593\u2593^    \u2553\u03c6\u03c6\u03c6   \u255f\u2593\u2593    H  \u2553\u2593\u2593\u2580   #\u03c6\u03c6\u03c6@   \u2559\u2593\u2593\u2584\"\u2593\u2593,\n              ,\u2593H\u256b\u2593\u2593    \u2554\u2593\u2580`      \u255f\u2593\u2593   \u258c  \u2593\u2593\u00d1    \u256b\u2593       \u2559\u2593\u2593N \u256b\u2593\u2566\n              \u255f\u258cj\u2593\u2593\u2593    \u255f\u2593        ]\u2593\u2593 \u2584\u2553\u2593  \u2593\u2593\u2310    \u256b\u2593\u2580\u2580\u2310     \u2593\u2593\u2593  \u256b\u2593\u2584\n              \u2593\u2310\u2551\u2593\u2593\u2593H   `\u2563\u2593\u2566\u2553\u2553\u2310   \u2563\u2593\u2580 \u255f\u2593\u2580H \u256b\u2593\u258c    \u256b\u2593\u2584\u2584\u2584~   \u2551\u2593\u2593\u2593\u2310  \u256b\u2593H\n              \u2593\u2310\u2551\u2593\u2593\u2593\u2593\u2584    `\"\u2559\"  \u2553\u2593\u2593\u2580 ,\u255f\u2593\u2556\u2553, \u256b\u2593\u2593,  `````  ,\u2593\u2593\u2593\u2593\u2593    \u256b\u2593\u2555\n              \u256bH`\u2593\u2593\u00dc\u2580\u2593\u2593\u2593\u2584\u2553\u2553\u2553\u2553\u2557\u03a6\u2593\u2593\u2593\u255f\u2593\u2593\u2580\u2580\u2560\u2560\u2580\u2580\u2593\u2593\u256c\u2580\u2593\u2593\u258c\u2584\u2553\u2553\u2553\u2557\u03a6\u2593\u2593\u2593\u2580\u2563\u2593\u258c     \u2593\u2593\u2584\n              \u2559\u2593 \u255f\u2593\u2593  `\u2559\u2580\u2580\u2580\u2593\u2580\u2580\u2580\",\u2593\u2593\u00bc\u2593\u2593\u2563,]W\u2593\u2584\u2559\u2593\u258c \"\u2580\u2580\u2580\u2580\u2580\u2580\u2580\"  \u2551\u2593\u2593,,,,,,\u2560\u2593\u2593\u2593,\n               \u255a\u2593 \u256b\u2593\u2593  ,,\u2553\u2554\u2584\u2584@\" \u256b\u2593,\u00ab\u2580\u2580   \"\u255f\u00d1\u2556\u255a\u2593\u2593\u2593\u2593\u2593\u2580`     \u00e1\u2593\u2593\u2593\u2593\u2593\u2593\u2593\u2593\u2593\u2593\u2593\u2593\u2593\u2593\u258c\n     \u2559\u2593\u2593\u2593\u2593\u2593\u2593\u2593\u2593\u2593\u2593\u2593\u2593\u2593\u2593\u2593`     \u2551\u2593\u2593\u2580\u2580\u2593\u2593\"\u2261\u2584\u2592   ,\u255f\u2556\u2569\u2590\u2593\u00d1,\u255d\u2580\u2580\u2580\u2559^```\u2593\u2593\u258c \u2559\u2593\n       \u2580\u2593\u2593\u2593\u2559\u2559\u2559\u2559\u2559\u2559\u255f\u2593\u2593`  \u2553\u2557\u2584\u2584\u2593\u2584\u2584\u2566,\u2514\u2593\u2593 \u2593\u2593\u2593\"%\u2563\u2593\u2580\u2553\u2593\u2593 ,\u2553\u2584\u2584\u2584\u2584\u2584\u2553   \u256b\u2593\u258c \u255a\u2593\n        \u2559\u2593\u2593N     \u2593\u2593\u00d1\u2553\u2593\u2593\u2593\u2580\u2580\u2559\u2559\u2559\u2580\u2563\u2593\u2593\u2593\u2563\u2593\u2593\u2566J\u2592\u2592\u2553\u2584\u2593\u2593\u256c\u2593\u2593\u2593\u2593\u2580\u2580\u2580\u2580\u2580\u2563\u2593\u2593\u258c\u2302\u2593\u2593\u2592 \u2563H\n          \u256b\u2593H   ]\u2593\u2593\u2593\u2593\u2580`  ,,,    \u2559\u2593\u2593\u00d1\"\u2559\u2580\u256b\u2593\u2580\u2559`\u2563\u2593\u2593\u2559         \u2559\u2593\u2593\u2593\u2593\u2593 \u2551\u258c\n           \u2563\u2593\u2555  \u2551\u2593\u2593\u2593\u2580    \u2593\u2593\u2580\u2593\u2593    \u256b\u2593\u258c N\u2551\u2593\u2310 \u2563\u2593\u258c   *\u2580\u2580\u2593\u2580\u2580\u2559   \u256b\u2593\u2593\u2593 \u2551\u258c\n            \u2593\u2593\u2310 \u2559\u2593\u2593\u2593     \u2593\u258c\u2553\u2563\u2593\u2310   ]\u2593\u2593 \u255f\u258c\u2580N\u2590\u2593\u2593      j\u2593M     j\u2593\u2593\u2593 \u2563M\n             \u2563\u2593\u2555 \u256b\u2593\u2593     \u2593\u2593\u2559^     \u2551\u2593\u2593 \"\u258c   \u2593\u2593\u2555     j\u2593M     j\u2593\u2593\u2580\u2554\u2593\n              \u255f\u2593\u2584 \u256b\u2593\u2593,   \u2580\u2580      \u2554\u2593\u2593\u0393  \u2560   \u255a\u2593\u2593,    \u2590\u2593M    \u2553\u2593\u2593\u2580\u2554\u2593\u2310\n               \u2559\u2593\u2593,\u2559\u2593\u2593\u2593\u2553      ,\u2584\u2593\u2593\u2580`  \u2553\u2563\u2556   \u2559\u2593\u2593\u2593\u2553       \u2553\u2593\u2593\u2593\u00d6\u2584\u2593`\n                 \u2559\u2563\u2593\u2584\u2559\u2580\u2593\u2593\u2593\u2593\u2593\u2593\u2593\u2593\u2593\u2593\u00d1\u03c6\u2593\u2593\u2593\u2593\u2580\u2593\u2593\u2593\u2593\u2593\u2584\u2563\u2593\u2593\u2593\u2593\u2593\u2593\u2593\u2593\u2593\u2593\u2580\u2559\u2584\u2593\u2580\n                   `\u2559\u2580\u2593\u2584\u2584\u2592\u2580\u2580\u2580\u2580\u2580\u2580\u2580\u2580\u2580\u2559`\u2553\u2557\u2593\u2593\u2593\u2593^\u2559\u2580\u2580\u2580\u2580\u2580\u2580\u2580\u2580\u2580^ \u2553\u2593\u2593\u2580`\n                       `\"\u2559\u2580\u2580\u00c6\u03a6\u00c6\u00c6\u00c6\u00c6\u2580\u2580\u2580\"`j\u2593\u2593\u2593        ,\u2553\u03c6\u2593\u2593\u2580\u2559\n                                       \u2590\u2593\u2593\u2593   ,\u2554\u03c6\u2593\u2593\u2593\u2580\u2559\n                                       \u2590\u2593\u2593\u2593\u2593\u2593\u2593\u2593\u2580\u2559`\n                                       \u2590\u2593\u2593\u2593\u2580\u2559\n                                       \u2590\u2593\u2559\n \n ");
        HashMap commands = new HashMap();
        if (args.length == 0) {
            System.out.println("No workspace specified. Select one from recently used:");
            LinkedList<String> history = recentlyUsed.getHistory();
            int i = 1;
            HashMap<Integer, String> wss = new HashMap<Integer, String>();
            Iterator iterator = history.iterator();
            while (iterator.hasNext()) {
                String item = (String)iterator.next();
                if (!item.endsWith(".sws")) continue;
                wss.put(i, item);
                System.out.println("[" + i + "] " + item);
                ++i;
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            System.out.print("Enter workspace to simulate: ");
            String s = br.readLine();
            try {
                int key = Integer.parseInt(s);
                if (!wss.containsKey(key)) {
                    System.out.println("Invalid selection '" + s + "'");
                    return;
                }
                commands.put(WS, wss.get(key));
            }
            catch (NumberFormatException e) {
                System.out.println("Invalid selection '" + s + "'");
                return;
            }
        } else {
            for (String arg : args) {
                if (arg.contains("=")) {
                    String[] split = arg.split("=");
                    commands.put(split[0], split[1]);
                    continue;
                }
                commands.put(WS, arg);
            }
        }
        if (!(file = new File((String)commands.get(WS))).exists()) {
            LOG.error("Could not find workspace file: " + file.getAbsolutePath());
            return;
        }
        try {
            Workspace workspace = Model.openWorkspace(file);
            if (workspace != null) {
                EventBusFactory.getEventBus().publish(new FileOpenedEvent(file.getAbsolutePath()));
                if (commands.containsKey(EVENTS)) {
                    SimulationControl prototype = Factory.prototype(SimulationControl.class, workspace.getSimulationControl());
                    Factory.when(prototype.numberOfEvents()).thenReturn(Integer.parseInt((String)commands.get(EVENTS)));
                    workspace.setSimulationControl(Factory.build(prototype));
                }
                CommandLine.simulate(workspace, true);
                workspace.setHasBeenCalculated(true);
                File result = commands.containsKey(OUTPUT) ? new File(CommandLine.fileWithExtension((String)commands.get(OUTPUT))) : new File(CommandLine.fileWithExtension(workspace.getName()));
                WorkspaceSaver workspaceSaver = new WorkspaceSaver(workspace);
                workspaceSaver.saveToFile(result);
                recentlyUsed.handleSavedWorkspace(new WorkspaceSavedEvent(result.getAbsolutePath()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            Model.getSimulationPool().getPool().shutdown();
        }
    }

    private static String fileWithExtension(String name) {
        if (name.endsWith(".swr")) {
            return name;
        }
        if (name.endsWith(".sws")) {
            return name.substring(0, name.length() - 4) + ".swr";
        }
        return name + ".swr";
    }

    private static void simulate(Workspace workspace, boolean logTime) {
        final WorkspaceScenario scenario = new WorkspaceScenario(workspace);
        workspace.prune();
        workspace.setScenario(scenario);
        workspace.prepareSimulate();
        final StringBuilder sb = new StringBuilder();
        final int filter = scenario.numberOfEvents() / width;
        Simulation simulation = new Simulation(workspace, scenario, new SimulationListener(){

            @Override
            public void simulationBegin(int totalEvents) {
                System.out.print(CommandLine.fill("", ' '));
            }

            @Override
            public void eventComplete(SingleResult result) {
                if (scenario.numberOfEvents() < width) {
                    int i = width / scenario.numberOfEvents();
                    for (int j = 0; j < i; ++j) {
                        sb.append("=");
                    }
                    System.out.print(CommandLine.fill(sb.toString(), ' '));
                } else if (result.eventNo % filter == width) {
                    sb.append("=");
                    System.out.print(CommandLine.fill(sb.toString(), ' '));
                }
            }

            @Override
            public void simulationEnd() {
                System.out.print(CommandLine.fill("", '='));
                System.out.println();
            }
        });
        InterferenceSimulationEngine engine = new InterferenceSimulationEngine(simulation);
        engine.simulateInterference(Model.getSimulationPool());
        if (logTime) {
            System.out.println("Simulated " + scenario.numberOfEvents() + " events");
            Results stats = workspace.getSimulationResults().getSimulationStatistics();
            List<SingleValueTypes<?>> types = stats.getSingleValueTypes();
            for (SingleValueTypes<?> type : types) {
                System.out.println(type.toString());
            }
        }
    }

    private static String fill(String content, char filler) {
        StringBuilder sb = new StringBuilder("[[").append(content);
        for (int white = width - content.length(); white > 0; --white) {
            sb.append(filler);
        }
        sb.append("]]\r");
        return sb.toString();
    }
}

