/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat;

import java.io.File;
import java.util.prefs.Preferences;
import javax.swing.JFrame;
import javax.swing.UIManager;
import org.apache.log4j.Logger;
import org.seamcat.Logging;
import org.seamcat.SplashScreen;
import org.seamcat.commands.DisplayWelcomeCommand;
import org.seamcat.commands.OpenWorkspaceFileCommand;
import org.seamcat.eventbus.EventBusFactory;
import org.seamcat.events.WorkspacesPaneEmptyEvent;
import org.seamcat.events.WorkspacesPaneNonEmptyEvent;
import org.seamcat.exception.SeamcatUncaughtExceptionHandler;
import org.seamcat.migration.BackwardMigrationNotSupportedException;
import org.seamcat.model.factory.Model;
import org.seamcat.plugin.SandboxInitializer;
import org.seamcat.presentation.DialogHelper;
import org.seamcat.presentation.MainWindow;
import org.seamcat.presentation.SeamcatAwtExceptionHandler;

public final class Seamcat {
    static final String BATCH_FILEEXTENSION = "sbj";
    static final String LIBRARY_FILEEXTENSION = "sli";
    static final String WORKSPACE_FILEEXTENSION = "sws";
    public static final String SEAMCAT_HOME = "SEAMCAT_HOME";
    public static final long ctm = System.currentTimeMillis();
    private static final Logger LOG = Logger.getRootLogger();
    public static final String LOOK_AND_FEEL_KEY = "SEAMCAT_LF";
    public static final String SHOW_WELCOME = "SEAMCAT_WELCOME";
    private static SplashScreen splash = new SplashScreen(new JFrame("Launching SEAMCAT"));

    public static SplashScreen getSplashScreen() {
        return splash;
    }

    public static void main(String[] args) {
        try {
            Seamcat.initializeApplication(args);
        }
        catch (BackwardMigrationNotSupportedException e) {
            LOG.warn("Backward migration attempted");
            DialogHelper.backwardMigrationNotSupported();
            System.exit(1);
        }
        catch (Exception e) {
            LOG.error("Exception during initialization", e);
            DialogHelper.generalSeamcatInitializationError(e);
            System.exit(1);
        }
    }

    private static void initializeApplication(String[] args) {
        Seamcat.setupExceptionHandler();
        Logging.initialize();
        Logging.initializeFromHomeDir(Model.getSeamcatHomeDir());
        SandboxInitializer.initializeSandbox();
        String lf = "";
        Preferences pref = Preferences.userNodeForPackage(Seamcat.class);
        try {
            lf = pref.get(LOOK_AND_FEEL_KEY, "com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel");
            UIManager.setLookAndFeel(lf);
        }
        catch (Exception ex) {
            System.out.println("Unable to Load Look and Feel: " + lf);
            ex.printStackTrace();
        }
        Model.getInstance().setShowWelcome(Boolean.parseBoolean(pref.get(SHOW_WELCOME, "true")));
        MainWindow mainWindow = MainWindow.getInstance();
        EventBusFactory.getEventBus().subscribe(mainWindow);
        LOG.debug("Initializing MainWindow");
        mainWindow.init();
        mainWindow.setSize(1100, 700);
        mainWindow.setExtendedState(6);
        mainWindow.setVisible(true);
        for (String s : args) {
            try {
                File f = new File(s);
                if (f.exists()) {
                    if (s.toLowerCase().endsWith(WORKSPACE_FILEEXTENSION)) {
                        LOG.info("Opening workspace from: " + s);
                        EventBusFactory.getEventBus().publish(new OpenWorkspaceFileCommand(f));
                    } else if (s.toLowerCase().endsWith(LIBRARY_FILEEXTENSION)) {
                        LOG.info("Importing Library from: " + s);
                    }
                    EventBusFactory.getEventBus().publish(new WorkspacesPaneNonEmptyEvent());
                    continue;
                }
                EventBusFactory.getEventBus().publish(new WorkspacesPaneEmptyEvent());
            }
            catch (Exception e) {
                LOG.warn("Unable to open file: " + s, e);
            }
        }
        if (args.length == 0) {
            EventBusFactory.getEventBus().publish(new WorkspacesPaneEmptyEvent());
        }
        LOG.addAppender(Model.getInstance().getLogFileAppender());
        splash.setVisible(false);
        splash.dispose();
        if (Model.getInstance().showWelcomeScreen()) {
            EventBusFactory.getEventBus().publish(new DisplayWelcomeCommand());
        }
    }

    private static void setupExceptionHandler() {
        System.setProperty("sun.awt.exception.handler", SeamcatAwtExceptionHandler.class.getName());
        Thread.setDefaultUncaughtExceptionHandler(new SeamcatUncaughtExceptionHandler());
    }
}

