/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.batch;

import java.util.ArrayList;
import java.util.List;
import org.seamcat.model.Workspace;
import org.seamcat.objectutils.WorkspaceCloneHelper;
import org.seamcat.presentation.batch.BatchViewState;

public class BatchJobList {
    private final List<Workspace> batchItems = new ArrayList<Workspace>();
    private String absoluteLocation;
    private boolean incrementalSave = true;
    private String name;
    private String description;

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public BatchJobList() {
        this.description = "";
    }

    public BatchJobList(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public BatchViewState getViewState() {
        BatchViewState state = new BatchViewState(this.description, this.incrementalSave);
        state.setWorkspaces(new ArrayList<Workspace>());
        for (Workspace batchItem : this.batchItems) {
            state.getWorkspaces().add(WorkspaceCloneHelper.clone(batchItem));
        }
        return state;
    }

    public void addBatchJob(Workspace bj) {
        this.batchItems.add(bj);
    }

    public void remove(Workspace workspace) {
        this.batchItems.remove(workspace);
    }

    public List<Workspace> getBatchJobs() {
        return this.batchItems;
    }

    public boolean isEmpty() {
        return this.batchItems.isEmpty();
    }

    public int size() {
        return this.batchItems.size();
    }

    public String getAbsoluteLocation() {
        return this.absoluteLocation;
    }

    public void setAbsoluteLocation(String absoluteLocation) {
        this.absoluteLocation = absoluteLocation;
    }

    public boolean hasLocation() {
        return this.absoluteLocation != null;
    }

    public boolean hasBeenCalculated() {
        if (!this.batchItems.isEmpty()) {
            return this.batchItems.get(0).isHasBeenCalculated();
        }
        return false;
    }

    public boolean getIncrementalSave() {
        return this.incrementalSave;
    }

    public void setIncrementalSave(boolean incrementalSave) {
        this.incrementalSave = incrementalSave;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

