/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.calculator;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Scanner;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.seamcat.calculator.CalculatorButton;
import org.seamcat.calculator.CalculatorInputField;
import org.seamcat.calculator.MemoryButton;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.presentation.SeamcatIcons;

public class Calculator
extends JDialog {
    private static final String B = "constant-B";
    private static final String CANCEL_DIALOG = "cancel-dialog";
    private static final String CLEAR = "C";
    private static final String CLEARALL = "CA";
    public static final String COMMA = ",";
    private static final String DIVIDE = "/";
    private static final String E = "constant-E";
    private static final String EQUALS = "==";
    private static final String LIST = ";";
    private static final Logger LOG = Logger.getLogger(Calculator.class);
    private static final String MINUS = "-";
    private static final String MULTIPLY = "*";
    private static final String SIGN = "--";
    private static final double SQRT2 = Math.sqrt(2.0);
    private static final double SQRT3 = Math.sqrt(3.0);
    private static final String TRANSFER = "transfer";
    private JButton aCosD = new CalculatorButton("I");
    protected JButton add = new CalculatorButton(null);
    private JButton aSinD = new CalculatorButton("X");
    private JButton aTanD = new CalculatorButton("P");
    private JButton average = new CalculatorButton("Z");
    protected JButton cbrt = new CalculatorButton("O");
    private JButton ceil = new CalculatorButton(null);
    private JButton change_sign = new CalculatorButton(null);
    private JButton clear = new CalculatorButton(null);
    protected JButton clearAll = new CalculatorButton(null);
    private JButton comma = new CalculatorButton(null);
    protected JButton constant_boltzmann = new CalculatorButton(null);
    protected JButton constant_e = new CalculatorButton(null);
    protected JButton constant_pi = new CalculatorButton(null);
    protected JButton constant_sqrt2 = new CalculatorButton(null);
    protected JButton constant_sqrt3 = new CalculatorButton(null);
    protected JButton cos = new CalculatorButton("R");
    private JButton cosH = new CalculatorButton("D");
    private BinaryOperation currentOperation;
    protected JButton dbm2watt = new CalculatorButton("Q");
    protected JButton dgr2rad = new CalculatorButton(null);
    private JFormattedTextField display = new JFormattedTextField();
    protected JButton divide = new CalculatorButton(null);
    private JButton ee = new CalculatorButton("J");
    protected JButton equals = new CalculatorButton(null);
    private boolean firstEntryOfBinaryOperation = false;
    private JButton floor = new CalculatorButton("N");
    private boolean insideBinaryOperation = false;
    private boolean lastActionWasEquals = false;
    protected JButton list_separate = new CalculatorButton(null);
    private JButton log10 = new CalculatorButton("U");
    private JButton min = new CalculatorButton("K");
    protected JButton minus = new CalculatorButton(null);
    protected JButton multiply = new CalculatorButton(null);
    private final ActionListener numberAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (Calculator.this.firstEntryOfBinaryOperation) {
                Calculator.this.firstEntryOfBinaryOperation = false;
                Calculator.this.lastActionWasEquals = false;
                Calculator.this.removeLastEntry();
            }
            Calculator.this.numberActionPerformed(e.getActionCommand());
            Calculator.this.equals.requestFocusInWindow();
        }
    };
    private JButton pow = new CalculatorButton("L");
    private JButton powerSum = new CalculatorButton("V");
    protected JButton rad2dgr = new CalculatorButton(null);
    protected JButton random = new CalculatorButton("G");
    protected JButton sin = new CalculatorButton("M");
    private JButton sinH = new CalculatorButton("S");
    protected JButton sqrt = new CalculatorButton("T");
    private JLabel statusLabel = new JLabel("SEAMCAT Calculator");
    private JButton stdDev = new CalculatorButton("L");
    private JButton tan = new CalculatorButton("Y");
    private JButton tanH = new CalculatorButton("F");
    private double tempBinaryOperatorValue = 0.0;
    private double tempEqualsValue = 0.0;
    protected JButton transfer = new CalculatorButton(null);
    private boolean transferValue = false;
    protected JButton watt2dbm = new CalculatorButton("W");

    private static double fromdBm2Watt(double dbm) {
        return Math.pow(10.0, (dbm - 30.0) / 10.0);
    }

    private static double fromWatt2dBm(double watt) {
        if (watt == 0.0) {
            LOG.warn("fromWatt2dBm - Returned -1000 instead of NaN");
            return -1000.0;
        }
        return 10.0 * Math.log10(watt) + 30.0;
    }

    public static void main(String[] args) {
        try {
            if (UIManager.getSystemLookAndFeelClassName().equalsIgnoreCase("com.sun.java.swing.plaf.gtk.GTKLookAndFeel")) {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            } else {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
        }
        catch (Exception exception) {
            System.err.println(exception.getLocalizedMessage());
        }
        BasicConfigurator.configure();
        JFrame main = new JFrame("Calculator");
        main.setIconImage(SeamcatIcons.getImage("SEAMCAT_ICON_CALCULATOR", 1));
        Calculator calc = new Calculator(main);
        main.setContentPane(calc.getContentPane());
        main.setDefaultCloseOperation(3);
        main.setSize(calc.getSize());
        main.setLocation(calc.getLocation());
        main.setResizable(false);
        main.setVisible(true);
    }

    private static double powerSummation(double ... powers) {
        double total = 0.0;
        for (double power : powers) {
            total += Math.pow(10.0, (power - 30.0) / 10.0);
        }
        return 10.0 * Math.log10(total) + 30.0;
    }

    public Calculator(Frame owner) {
        super(owner, true);
        this.init();
        this.setLocationRelativeTo(owner);
    }

    public Calculator(JDialog owner) {
        super((Dialog)owner, true);
        this.init();
        this.setLocationRelativeTo(owner);
    }

    void addFillComponents(Container panel, int[] cols, int[] rows) {
        Dimension filler = new Dimension(10, 10);
        boolean filled_cell_11 = false;
        CellConstraints cc = new CellConstraints();
        if (cols.length > 0 && rows.length > 0 && cols[0] == 1 && rows[0] == 1) {
            panel.add(Box.createRigidArea(filler), cc.xy(1, 1));
            filled_cell_11 = true;
        }
        for (int col : cols) {
            if (col == 1 && filled_cell_11) continue;
            panel.add(Box.createRigidArea(filler), cc.xy(col, 1));
        }
        for (int row : rows) {
            if (row == 1 && filled_cell_11) continue;
            panel.add(Box.createRigidArea(filler), cc.xy(1, row));
        }
    }

    private void clearDisplay() {
        this.display.setText("");
    }

    private void completeBinaryOperation() throws Exception {
        switch (this.currentOperation) {
            case Add: {
                this.tempBinaryOperatorValue += this.getValue();
                break;
            }
            case Substract: {
                this.tempBinaryOperatorValue -= this.getValue();
                break;
            }
            case Multiply: {
                this.tempBinaryOperatorValue *= this.getValue();
                break;
            }
            case Divide: {
                this.tempBinaryOperatorValue /= this.getValue();
            }
        }
    }

    public JPanel createPanel() {
        JPanel mainPanel = new JPanel();
        FormLayout formlayout = new FormLayout("FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE", "CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE");
        CellConstraints cc = new CellConstraints();
        mainPanel.setLayout(formlayout);
        mainPanel.add((Component)this.generateNumericButton("7"), cc.xy(13, 7));
        mainPanel.add((Component)this.generateNumericButton("8"), cc.xy(14, 7));
        mainPanel.add((Component)this.generateNumericButton("9"), cc.xy(15, 7));
        mainPanel.add((Component)this.generateNumericButton("4"), cc.xy(13, 9));
        mainPanel.add((Component)this.generateNumericButton("5"), cc.xy(14, 9));
        mainPanel.add((Component)this.generateNumericButton("6"), cc.xy(15, 9));
        mainPanel.add((Component)this.generateNumericButton("1"), cc.xy(13, 11));
        mainPanel.add((Component)this.generateNumericButton("2"), cc.xy(14, 11));
        mainPanel.add((Component)this.generateNumericButton("3"), cc.xy(15, 11));
        mainPanel.add((Component)this.generateNumericButton("0"), cc.xy(13, 13));
        this.comma.setActionCommand(".");
        this.comma.setText(".");
        this.comma.setMargin(new Insets(2, 5, 2, 5));
        this.comma.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String str = Calculator.this.display.getText();
                if (Calculator.this.display.getText().indexOf(Calculator.LIST) > -1) {
                    str = str.substring(str.lastIndexOf(Calculator.LIST));
                }
                if (str.indexOf(".") < 0) {
                    if (str.length() == 0) {
                        Calculator.this.display.setText(Calculator.this.display.getText() + "0.");
                    } else {
                        Calculator.this.display.setText(Calculator.this.display.getText() + ".");
                    }
                }
                Calculator.this.equals.requestFocusInWindow();
            }
        });
        mainPanel.add((Component)this.comma, cc.xy(14, 13));
        this.transfer.setIcon(SeamcatIcons.getImageIcon("SEAMCAT_ICON_TRANSFER_RESULT"));
        this.transfer.setToolTipText("Close and copy result to SEAMCAT [INSERT]");
        this.transfer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Calculator.this.transferValue = true;
                Calculator.this.setVisible(false);
            }
        });
        mainPanel.add((Component)this.transfer, cc.xy(18, 15));
        this.change_sign.setActionCommand("+ / -");
        this.change_sign.setText("+ / -");
        this.change_sign.setToolTipText("Change sign of current input [SHIFT + MINUS]");
        this.change_sign.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Calculator.this.display.getText().indexOf(Calculator.LIST) > -1) {
                    String str = Calculator.this.display.getText();
                    String nmb = str.substring(str.lastIndexOf(Calculator.LIST) + 1);
                    nmb = nmb.indexOf(Calculator.MINUS) > -1 ? nmb.substring(1) : Calculator.MINUS + nmb;
                    Calculator.this.display.setText(str.substring(0, str.lastIndexOf(Calculator.LIST) + 1) + nmb);
                } else {
                    String str = Calculator.this.display.getText();
                    str = str.length() > 0 && str.charAt(0) == '-' ? str.substring(1) : Calculator.MINUS + str;
                    Calculator.this.display.setText(str);
                }
                Calculator.this.equals.requestFocusInWindow();
            }
        });
        mainPanel.add((Component)this.change_sign, cc.xy(18, 5));
        this.display.setFocusLostBehavior(0);
        this.display.setHorizontalAlignment(4);
        this.display.setEditable(false);
        this.display.setEnabled(true);
        mainPanel.add((Component)this.display, cc.xywh(2, 3, 21, 1));
        this.tan.setActionCommand("tanD");
        this.tan.setText("tanD");
        this.tan.setToolTipText("Internal SEAMCAT function: Mathematics.tanD(double)");
        this.tan.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    double value = Calculator.this.getValue();
                    double result = Mathematics.tanD(value);
                    Calculator.this.setValue(result);
                    LOG.debug("Result of Mathematics.tanD (" + value + ") = " + result);
                    Calculator.this.equals.requestFocusInWindow();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        mainPanel.add((Component)this.tan, cc.xy(2, 7));
        this.log10.setActionCommand("Log10");
        this.log10.setText("Log10");
        this.log10.setToolTipText("Internal java function: Math.log10(double)");
        this.log10.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    double value = Calculator.this.getValue();
                    double result = Math.log10(value);
                    Calculator.this.setValue(result);
                    LOG.debug("Result of Math.log10 (" + value + ") = " + result);
                    Calculator.this.equals.requestFocusInWindow();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        mainPanel.add((Component)this.log10, cc.xy(4, 7));
        this.aCosD.setActionCommand("acosD");
        this.aCosD.setText("acosD");
        this.aCosD.setToolTipText("Internal SEAMCAT function: Mathematics.acosD(double)");
        this.aCosD.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    double value = Calculator.this.getValue();
                    double result = Mathematics.acosD(value);
                    Calculator.this.setValue(result);
                    LOG.debug("Result of Mathematics.acosD (" + value + ") = " + result);
                    Calculator.this.equals.requestFocusInWindow();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        mainPanel.add((Component)this.aCosD, cc.xy(6, 7));
        this.aSinD.setActionCommand("asinD");
        this.aSinD.setText("asinD");
        this.aSinD.setToolTipText("Internal SEAMCAT function: Mathematics.asinD(double)");
        this.aSinD.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    double value = Calculator.this.getValue();
                    double result = Mathematics.asinD(value);
                    Calculator.this.setValue(result);
                    LOG.debug("Result of Mathematics.asinD (" + value + ") = " + result);
                    Calculator.this.equals.requestFocusInWindow();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        mainPanel.add((Component)this.aSinD, cc.xy(8, 7));
        this.aTanD.setActionCommand("atanD");
        this.aTanD.setText("atanD");
        this.aTanD.setToolTipText("Internal SEAMCAT function: Mathematics.atanD(double)");
        this.aTanD.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    double value = Calculator.this.getValue();
                    double result = Mathematics.atanD(value);
                    Calculator.this.setValue(result);
                    LOG.debug("Result of Mathematics.atanD (" + value + ") = " + result);
                    Calculator.this.equals.requestFocusInWindow();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        mainPanel.add((Component)this.aTanD, cc.xy(2, 9));
        this.sinH.setActionCommand("sinh");
        this.sinH.setText("sinh");
        this.sinH.setToolTipText("Internal SEAMCAT function: Mathematics.sinh(double)");
        this.sinH.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    double value = Calculator.this.getValue();
                    double result = Mathematics.sinh(value);
                    Calculator.this.setValue(result);
                    LOG.debug("Result of Mathematics.sinh (" + value + ") = " + result);
                    Calculator.this.equals.requestFocusInWindow();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        mainPanel.add((Component)this.sinH, cc.xy(4, 9));
        this.cosH.setActionCommand("cosh");
        this.cosH.setText("cosh");
        this.cosH.setToolTipText("Internal SEAMCAT function: Mathematics.cosh(double)");
        this.cosH.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    double value = Calculator.this.getValue();
                    double result = Mathematics.cosh(value);
                    Calculator.this.setValue(result);
                    LOG.debug("Result of Mathematics.cosh (" + value + ") = " + result);
                    Calculator.this.equals.requestFocusInWindow();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        mainPanel.add((Component)this.cosH, cc.xy(6, 9));
        this.tanH.setActionCommand("tanh");
        this.tanH.setText("tanh");
        this.tanH.setToolTipText("Internal SEAMCAT function: Mathematics.tanhD(double)");
        this.tanH.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    double value = Calculator.this.getValue();
                    double result = Mathematics.tanh(value);
                    Calculator.this.setValue(result);
                    LOG.debug("Result of Mathematics.tanh (" + value + ") = " + result);
                    Calculator.this.equals.requestFocusInWindow();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        mainPanel.add((Component)this.tanH, cc.xy(8, 9));
        this.ee.setActionCommand("Max");
        this.ee.setText("<html>X * 10<sup>y</sup>");
        this.ee.setToolTipText("Internal SEAMCAT function: X * 10^Y");
        this.ee.setForeground(Color.RED);
        this.ee.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                double[] val = Calculator.this.getValues();
                if (val.length == 2) {
                    double result = val[0] * Math.pow(10.0, val[1]);
                    Calculator.this.clearDisplay();
                    Calculator.this.setValue(result);
                    LOG.debug("Result of " + val[0] + " * 10 ^ " + val[1] + " = " + result);
                } else {
                    JOptionPane.showMessageDialog(Calculator.this, "XeY is only applicable to lists with 2 elements");
                }
                Calculator.this.equals.requestFocusInWindow();
            }
        });
        mainPanel.add((Component)this.ee, cc.xy(2, 11));
        this.min.setActionCommand("Min");
        this.min.setText("<html>X<sup>y</sup>");
        this.min.setToolTipText("Internal SEAMCAT function: Math.pow(double, double)");
        this.min.setForeground(Color.RED);
        this.min.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                double[] values = Calculator.this.getValues();
                if (values.length == 2) {
                    double result = Math.pow(values[0], values[1]);
                    Calculator.this.clearDisplay();
                    Calculator.this.setValue(result);
                    StringBuffer val = new StringBuffer("Result of Math.pow ({");
                    for (int i = 0; i < values.length; ++i) {
                        val.append(values[i]);
                        if (i + 1 >= values.length) continue;
                        val.append(Calculator.LIST);
                    }
                    val.append("}) = " + result);
                    LOG.debug(val.toString());
                } else {
                    JOptionPane.showMessageDialog(Calculator.this, "Pow (x;y) is only applicable to lists with 2 elements");
                }
                Calculator.this.equals.requestFocusInWindow();
            }
        });
        mainPanel.add((Component)this.min, cc.xy(4, 11));
        this.stdDev.setActionCommand("Std. Dev.");
        this.stdDev.setText("Std. Dev.");
        this.stdDev.setToolTipText("Internal SEAMCAT function: Mathematics.getStdDev(double[])");
        this.stdDev.setForeground(Color.RED);
        this.stdDev.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                double[] values = Calculator.this.getValues();
                double result = Mathematics.getStdDev(values);
                Calculator.this.clearDisplay();
                Calculator.this.setValue(result);
                StringBuffer val = new StringBuffer("Result of Mathematics.getStdDev ({");
                for (int i = 0; i < values.length; ++i) {
                    val.append(values[i]);
                    if (i + 1 >= values.length) continue;
                    val.append(Calculator.LIST);
                }
                val.append("}) = " + result);
                LOG.debug(val.toString());
                Calculator.this.equals.requestFocusInWindow();
            }
        });
        mainPanel.add((Component)this.stdDev, cc.xy(6, 11));
        this.average.setActionCommand("Average");
        this.average.setText("Average");
        this.average.setToolTipText("Internal SEAMCAT function: Mathematics.getAverage(double[])");
        this.average.setForeground(Color.RED);
        this.average.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                double[] values = Calculator.this.getValues();
                double result = Mathematics.getAverage(values);
                Calculator.this.clearDisplay();
                Calculator.this.setValue(result);
                StringBuffer val = new StringBuffer("Result of Mathematics.getAverage ({");
                for (int i = 0; i < values.length; ++i) {
                    val.append(values[i]);
                    if (i + 1 >= values.length) continue;
                    val.append(Calculator.LIST);
                }
                val.append("}) = " + result);
                LOG.debug(val.toString());
                Calculator.this.equals.requestFocusInWindow();
            }
        });
        mainPanel.add((Component)this.average, cc.xy(8, 11));
        this.pow.setActionCommand("Pow (x;y)");
        this.pow.setText("Pow (x;y)");
        this.pow.setToolTipText("Internal Java function: Math.pow(x, y)");
        this.pow.setForeground(Color.RED);
        this.pow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                double[] val = Calculator.this.getValues();
                if (val.length == 2) {
                    double result = Math.pow(val[0], val[1]);
                    Calculator.this.clearDisplay();
                    Calculator.this.setValue(result);
                    LOG.debug("Result of Math.pow (" + val[0] + ", " + val[1] + ") = " + result);
                } else {
                    JOptionPane.showMessageDialog(Calculator.this, "Pow (x;y) is only applicable to lists with 2 elements");
                }
                Calculator.this.equals.requestFocusInWindow();
            }
        });
        mainPanel.add((Component)this.pow, cc.xy(2, 13));
        this.powerSum.setActionCommand("\u03a3 Power");
        this.powerSum.setText("\u03a3 Power");
        this.powerSum.setToolTipText("Internal SEAMCAT function: CDMASystem.powerSummation(double[])");
        this.powerSum.setForeground(Color.RED);
        this.powerSum.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                double[] values = Calculator.this.getValues();
                double result = Calculator.powerSummation(values);
                Calculator.this.clearDisplay();
                Calculator.this.setValue(result);
                StringBuffer val = new StringBuffer("Result of CDMASystem.powerSummation ({");
                for (int i = 0; i < values.length; ++i) {
                    val.append(values[i]);
                    if (i + 1 >= values.length) continue;
                    val.append(Calculator.LIST);
                }
                val.append("}) = " + result);
                LOG.debug(val.toString());
                Calculator.this.equals.requestFocusInWindow();
            }
        });
        mainPanel.add((Component)this.powerSum, cc.xy(4, 13));
        this.floor.setActionCommand("Floor");
        this.floor.setText("Floor");
        this.floor.setToolTipText("Internal Java function: Math.floor(double)");
        this.floor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    double value = Calculator.this.getValue();
                    double result = Math.floor(value);
                    Calculator.this.setValue(result);
                    LOG.debug("Result of Math.floor (" + value + ") = " + result);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Calculator.this.equals.requestFocusInWindow();
            }
        });
        mainPanel.add((Component)this.floor, cc.xy(6, 13));
        this.ceil.setActionCommand("Ceil");
        this.ceil.setText("Ceil");
        this.ceil.setToolTipText("Internal Java function: Math.ceil(double)");
        this.ceil.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    double value = Calculator.this.getValue();
                    double result = Math.ceil(value);
                    Calculator.this.setValue(result);
                    LOG.debug("Result of Math.ceil (" + value + ") = " + result);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Calculator.this.equals.requestFocusInWindow();
            }
        });
        mainPanel.add((Component)this.ceil, cc.xy(8, 13));
        this.sqrt.setActionCommand("sqrt");
        this.sqrt.setText("SQRT");
        this.sqrt.setToolTipText("Squareroot");
        this.sqrt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    double value = Calculator.this.getValue();
                    double result = Math.sqrt(value);
                    Calculator.this.setValue(result);
                    LOG.debug("Result of Math.sqrt (" + value + ") = " + result);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Calculator.this.equals.requestFocusInWindow();
            }
        });
        mainPanel.add((Component)this.sqrt, cc.xy(10, 5));
        this.cbrt.setActionCommand("cbrt");
        this.cbrt.setText("CBRT");
        this.cbrt.setToolTipText("Cubicroot");
        this.cbrt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    double value = Calculator.this.getValue();
                    double result = Math.cbrt(value);
                    Calculator.this.setValue(result);
                    LOG.debug("Result of Math.cbrt (" + value + ") = " + result);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Calculator.this.equals.requestFocusInWindow();
            }
        });
        mainPanel.add((Component)this.cbrt, cc.xy(10, 7));
        this.random.setActionCommand("random");
        this.random.setText("Random");
        this.random.setToolTipText("Generates a random number between 0 and 1. Number is inserted at current cursor location.");
        this.random.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    double result = Math.random();
                    Calculator.this.setValue(result);
                    LOG.debug("Result of Math.random () = " + result);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Calculator.this.equals.requestFocusInWindow();
            }
        });
        mainPanel.add((Component)this.random, cc.xy(10, 9));
        this.dgr2rad.setActionCommand("Dgr->Rad");
        this.dgr2rad.setText("Dgr\u21d2Rad");
        this.dgr2rad.setToolTipText("Convert input from Degrees to Radians");
        this.dgr2rad.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    double value = Calculator.this.getValue();
                    double result = Math.toRadians(value);
                    Calculator.this.setValue(result);
                    LOG.debug("Result of Math.toRadians (" + value + ") = " + result);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Calculator.this.equals.requestFocusInWindow();
            }
        });
        mainPanel.add((Component)this.dgr2rad, cc.xy(10, 11));
        this.rad2dgr.setActionCommand("rad2dgr");
        this.rad2dgr.setText("Rad\u21d2Dgr");
        this.rad2dgr.setToolTipText("Convert input from Radians to Degrees");
        this.rad2dgr.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    double value = Calculator.this.getValue();
                    double result = Math.toDegrees(value);
                    Calculator.this.setValue(result);
                    LOG.debug("Result of Math.toDegrees (" + value + ") = " + result);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Calculator.this.equals.requestFocusInWindow();
            }
        });
        mainPanel.add((Component)this.rad2dgr, cc.xy(10, 13));
        this.clear.setActionCommand("Clear");
        this.clear.setText(CLEAR);
        this.clear.setToolTipText("Clear last entry [BACKSPACE]");
        this.clear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (Calculator.this.firstEntryOfBinaryOperation) {
                        Calculator.this.removeLastEntry();
                        Calculator.this.firstEntryOfBinaryOperation = false;
                    } else {
                        Calculator.this.display.setText(Calculator.this.display.getText().substring(0, Calculator.this.display.getText().length() - 1));
                        Calculator.this.statusLabel.setText("");
                    }
                    Calculator.this.equals.requestFocusInWindow();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        mainPanel.add((Component)this.clear, cc.xy(15, 5));
        this.clearAll.setActionCommand(CLEARALL);
        this.clearAll.setText("A");
        this.clearAll.setToolTipText("Clear All [DELETE]");
        this.clearAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Calculator.this.clearDisplay();
                Calculator.this.insideBinaryOperation = false;
                Calculator.this.statusLabel.setText("");
                Calculator.this.equals.requestFocusInWindow();
            }
        });
        mainPanel.add((Component)this.clearAll, cc.xy(14, 5));
        this.list_separate.setActionCommand(LIST);
        this.list_separate.setName("List separate");
        this.list_separate.setText(LIST);
        this.list_separate.setForeground(Color.RED);
        this.list_separate.setToolTipText("Separate list entries [SHIFT + ADD]");
        this.list_separate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Calculator.this.firstEntryOfBinaryOperation = false;
                Calculator.this.numberActionPerformed(e.getActionCommand());
                Calculator.this.insideBinaryOperation = false;
                Calculator.this.equals.requestFocusInWindow();
            }
        });
        mainPanel.add((Component)this.list_separate, cc.xy(13, 5));
        this.dbm2watt.setActionCommand("dBm\u21d2Watt");
        this.dbm2watt.setText("dBm\u21d2Watt");
        this.dbm2watt.setToolTipText("Internal SEAMCAT function: CDMASystem.fromdBm2Watt(double)");
        this.dbm2watt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    double value = Calculator.this.getValue();
                    double result = Calculator.fromdBm2Watt(value);
                    Calculator.this.setValue(result);
                    LOG.debug("Result of CDMASystem.fromdBm2Watt (" + value + ") = " + result);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Calculator.this.equals.requestFocusInWindow();
            }
        });
        mainPanel.add((Component)this.dbm2watt, cc.xy(2, 5));
        this.watt2dbm.setActionCommand("Watt\u21d2dBm");
        this.watt2dbm.setText("Watt\u21d2dBm");
        this.watt2dbm.setToolTipText("Internal SEAMCAT function: CDMASystem.fromWatt2dBm(double)");
        this.watt2dbm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    double value = Calculator.this.getValue();
                    double result = Calculator.fromWatt2dBm(value);
                    Calculator.this.setValue(result);
                    LOG.debug("Result of CDMASystem.fromWatt2dBm (" + value + ") = " + result);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Calculator.this.equals.requestFocusInWindow();
            }
        });
        mainPanel.add((Component)this.watt2dbm, cc.xy(4, 5));
        this.sin.setActionCommand("sinD");
        this.sin.setText("sinD");
        this.sin.setToolTipText("Internal SEAMCAT function: Mathematics.sinD(double)");
        this.sin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    double value = Calculator.this.getValue();
                    double result = Mathematics.sinD(value);
                    Calculator.this.setValue(result);
                    LOG.debug("Result of Mathematics.sinD (" + value + ") = " + result);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Calculator.this.equals.requestFocusInWindow();
            }
        });
        mainPanel.add((Component)this.sin, cc.xy(6, 5));
        this.cos.setActionCommand("cosD");
        this.cos.setText("cosD");
        this.cos.setToolTipText("Internal SEAMCAT function: Mathematics.cosD(double)");
        this.cos.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    double value = Calculator.this.getValue();
                    double result = Mathematics.cosD(value);
                    Calculator.this.setValue(result);
                    LOG.debug("Result of Mathematics.cosD (" + value + ") = " + result);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Calculator.this.equals.requestFocusInWindow();
            }
        });
        mainPanel.add((Component)this.cos, cc.xy(8, 5));
        this.minus.setText(MINUS);
        this.minus.setToolTipText("Substraction");
        this.minus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (Calculator.this.insideBinaryOperation) {
                        if (Calculator.this.getValueString().equals("") || Calculator.this.firstEntryOfBinaryOperation) {
                            Calculator.this.currentOperation = BinaryOperation.Substract;
                            return;
                        }
                        Calculator.this.completeBinaryOperation();
                    } else {
                        Calculator.this.tempBinaryOperatorValue = Calculator.this.getValue();
                    }
                    Calculator.this.currentOperation = BinaryOperation.Substract;
                    Calculator.this.insideBinaryOperation = true;
                    Calculator.this.firstEntryOfBinaryOperation = true;
                    Calculator.this.setValue(Calculator.this.tempBinaryOperatorValue);
                    LOG.debug("Enter value to substract from " + Calculator.this.tempBinaryOperatorValue);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Calculator.this.equals.requestFocusInWindow();
            }
        });
        mainPanel.add((Component)this.minus, cc.xy(18, 7));
        this.add.setText("+");
        this.add.setToolTipText("Addition");
        this.add.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (Calculator.this.insideBinaryOperation) {
                        if (Calculator.this.getValueString().equals("") || Calculator.this.firstEntryOfBinaryOperation) {
                            Calculator.this.currentOperation = BinaryOperation.Add;
                            return;
                        }
                        Calculator.this.completeBinaryOperation();
                    } else {
                        Calculator.this.tempBinaryOperatorValue = Calculator.this.getValue();
                    }
                    Calculator.this.currentOperation = BinaryOperation.Add;
                    Calculator.this.insideBinaryOperation = true;
                    Calculator.this.setValue(Calculator.this.tempBinaryOperatorValue);
                    Calculator.this.firstEntryOfBinaryOperation = true;
                    LOG.debug("Enter value to add to " + Calculator.this.tempBinaryOperatorValue);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Calculator.this.equals.requestFocusInWindow();
            }
        });
        mainPanel.add((Component)this.add, cc.xy(18, 9));
        this.multiply.setText(MULTIPLY);
        this.multiply.setToolTipText("Multiplication");
        this.multiply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (Calculator.this.insideBinaryOperation) {
                        if (Calculator.this.getValueString().equals("") || Calculator.this.firstEntryOfBinaryOperation) {
                            Calculator.this.currentOperation = BinaryOperation.Multiply;
                            return;
                        }
                        Calculator.this.completeBinaryOperation();
                    } else {
                        Calculator.this.tempBinaryOperatorValue = Calculator.this.getValue();
                    }
                    Calculator.this.currentOperation = BinaryOperation.Multiply;
                    Calculator.this.insideBinaryOperation = true;
                    Calculator.this.firstEntryOfBinaryOperation = true;
                    Calculator.this.setValue(Calculator.this.tempBinaryOperatorValue);
                    LOG.debug("Enter value to multiply with " + Calculator.this.tempBinaryOperatorValue);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Calculator.this.equals.requestFocusInWindow();
            }
        });
        mainPanel.add((Component)this.multiply, cc.xy(18, 11));
        this.divide.setText(DIVIDE);
        this.divide.setToolTipText("Division");
        this.divide.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (Calculator.this.insideBinaryOperation) {
                        if (Calculator.this.getValueString().equals("") || Calculator.this.firstEntryOfBinaryOperation) {
                            Calculator.this.currentOperation = BinaryOperation.Divide;
                            return;
                        }
                        Calculator.this.completeBinaryOperation();
                    } else {
                        Calculator.this.tempBinaryOperatorValue = Calculator.this.getValue();
                    }
                    Calculator.this.currentOperation = BinaryOperation.Divide;
                    Calculator.this.insideBinaryOperation = true;
                    Calculator.this.firstEntryOfBinaryOperation = true;
                    Calculator.this.setValue(Calculator.this.tempBinaryOperatorValue);
                    LOG.debug("Enter value to divide " + Calculator.this.tempBinaryOperatorValue + " with");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Calculator.this.equals.requestFocusInWindow();
            }
        });
        mainPanel.add((Component)this.divide, cc.xy(18, 13));
        this.constant_pi.setText("pi");
        this.constant_pi.setToolTipText("The double value that is closer than any other to pi, the ratio of the circumference of a circle to its diameter.");
        this.constant_pi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    double result = Math.PI;
                    Calculator.this.setValue(result);
                    LOG.debug("Inserted Math.PI = " + result);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Calculator.this.equals.requestFocusInWindow();
            }
        });
        mainPanel.add((Component)this.constant_pi, cc.xy(20, 5));
        this.constant_e.setText("e");
        this.constant_e.setToolTipText("The double value that is closer than any other to e, the base of the natural logarithms.");
        this.constant_e.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    double result = Math.E;
                    Calculator.this.setValue(result);
                    LOG.debug("Inserted Math.E = " + result);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Calculator.this.equals.requestFocusInWindow();
            }
        });
        mainPanel.add((Component)this.constant_e, cc.xy(20, 7));
        this.constant_sqrt2.setText("SQRT2");
        this.constant_sqrt2.setToolTipText("The double value that is closer than any other to sqrt(2)");
        this.constant_sqrt2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    double result = SQRT2;
                    Calculator.this.setValue(result);
                    LOG.debug("Inserted CDMASystem.SQRT2 = " + result);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Calculator.this.equals.requestFocusInWindow();
            }
        });
        mainPanel.add((Component)this.constant_sqrt2, cc.xy(20, 9));
        this.constant_sqrt3.setText("SQRT3");
        this.constant_sqrt3.setToolTipText("The double value that is closer than any other to sqrt(3)");
        this.constant_sqrt3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    double result = SQRT3;
                    Calculator.this.setValue(result);
                    LOG.debug("Inserted CDMASystem.SQRT3 = " + result);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Calculator.this.equals.requestFocusInWindow();
            }
        });
        mainPanel.add((Component)this.constant_sqrt3, cc.xy(20, 11));
        this.constant_boltzmann.setText("B");
        this.constant_boltzmann.setToolTipText("Boltzmann's constant, k = 1.38x10^-23 (Joules/K)");
        this.constant_boltzmann.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    double result = 1.38E-23;
                    Calculator.this.setValue(result);
                    LOG.debug("Inserted 1.38e-23d = " + result);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Calculator.this.equals.requestFocusInWindow();
            }
        });
        mainPanel.add((Component)this.constant_boltzmann, cc.xy(20, 13));
        this.equals.setText("=");
        this.equals.setToolTipText("Equals [ENTER]");
        this.equals.setMargin(new Insets(2, 5, 2, 5));
        this.equals.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (Calculator.this.insideBinaryOperation) {
                        if (Calculator.this.getValueString().equals("")) {
                            return;
                        }
                        Calculator.this.tempEqualsValue = Calculator.this.getValue();
                        Calculator.this.completeBinaryOperation();
                    } else if (Calculator.this.lastActionWasEquals) {
                        switch (Calculator.this.currentOperation) {
                            case Add: {
                                Calculator.this.tempBinaryOperatorValue = Calculator.this.tempBinaryOperatorValue + Calculator.this.tempEqualsValue;
                                break;
                            }
                            case Substract: {
                                Calculator.this.tempBinaryOperatorValue = Calculator.this.tempBinaryOperatorValue - Calculator.this.tempEqualsValue;
                                break;
                            }
                            case Multiply: {
                                Calculator.this.tempBinaryOperatorValue = Calculator.this.tempBinaryOperatorValue * Calculator.this.tempEqualsValue;
                                break;
                            }
                            case Divide: {
                                Calculator.this.tempBinaryOperatorValue = Calculator.this.tempBinaryOperatorValue / Calculator.this.tempEqualsValue;
                            }
                        }
                    } else {
                        Calculator.this.currentOperation = BinaryOperation.Add;
                        Calculator.this.tempEqualsValue = 0.0;
                        Calculator.this.tempBinaryOperatorValue = 0.0;
                        return;
                    }
                    Calculator.this.setValue(Calculator.this.tempBinaryOperatorValue);
                    Calculator.this.insideBinaryOperation = false;
                    Calculator.this.lastActionWasEquals = true;
                    LOG.debug("Result is " + Calculator.this.tempBinaryOperatorValue);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Calculator.this.equals.requestFocusInWindow();
            }
        });
        mainPanel.add((Component)this.equals, cc.xy(15, 13));
        mainPanel.add((Component)new MemoryButton(1, this, 112), cc.xy(22, 5));
        mainPanel.add((Component)new MemoryButton(2, this, 113), cc.xy(22, 7));
        mainPanel.add((Component)new MemoryButton(3, this, 114), cc.xy(22, 9));
        mainPanel.add((Component)new MemoryButton(4, this, 115), cc.xy(22, 11));
        mainPanel.add((Component)new MemoryButton(5, this, 116), cc.xy(22, 13));
        mainPanel.add((Component)this.statusLabel, cc.xywh(2, 15, 17, 1));
        this.addFillComponents(mainPanel, new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 23}, new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15});
        return mainPanel;
    }

    protected JButton generateModifyButton(final String value) {
        JButton button = new JButton(value);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Calculator.this.display.setText(Calculator.this.display.getText() + value);
                Calculator.this.equals.requestFocusInWindow();
            }
        });
        return button;
    }

    protected JButton generateNumericButton(String str) {
        final CalculatorButton but = new CalculatorButton(null);
        but.setActionCommand(str);
        ((AbstractButton)but).setText(str);
        but.setForeground(Color.BLUE);
        but.addActionListener(this.numberAction);
        but.setMargin(new Insets(2, 5, 2, 5));
        ((JPanel)this.getContentPane()).getInputMap(2).put(KeyStroke.getKeyStroke(str), str);
        ((JPanel)this.getContentPane()).getInputMap(2).put(KeyStroke.getKeyStroke("NUMPAD" + str), str);
        ((JPanel)this.getContentPane()).getActionMap().put(str, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                but.doClick();
            }
        });
        return but;
    }

    public double getValue() throws Exception {
        try {
            double value = Double.parseDouble(this.getValueString());
            return value;
        }
        catch (NumberFormatException ex) {
            JOptionPane.showMessageDialog(this, "Input does not appear to be a valid number!", "Input error", 2);
            throw ex;
        }
    }

    private double[] getValues() {
        double[] values;
        String str = this.display.getText();
        if (str.charAt(str.length() - 1) == ';') {
            str = str.substring(0, str.length() - 1);
        }
        if (str.indexOf(59) > -1) {
            Scanner scanner = new Scanner(str.replace(".", COMMA));
            scanner.useDelimiter(LIST);
            ArrayList<Double> list = new ArrayList<Double>();
            while (scanner.hasNextDouble()) {
                try {
                    list.add(scanner.nextDouble());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            values = new double[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                values[i] = (Double)list.get(i);
            }
        } else {
            values = new double[1];
            try {
                values[0] = this.getValue();
            }
            catch (Exception ex) {
                LOG.error(ex);
            }
        }
        return values;
    }

    private String getValueString() {
        String str = null;
        str = this.display.getText();
        if (this.display.getText().indexOf(LIST) > -1) {
            str = str.substring(str.lastIndexOf(LIST) + 1);
        }
        return str;
    }

    private void init() {
        this.setTitle("SEAMCAT Calculator");
        this.initializePanel();
        this.pack();
        this.transfer.setVisible(false);
        this.setResizable(false);
        this.setLocation(100, 100);
        this.registerKeyListeners();
    }

    protected void initializePanel() {
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.createPanel(), "Center");
    }

    private void numberActionPerformed(String s) {
        this.display.setText(this.display.getText() + s);
    }

    private void registerKeyListeners() {
        ((JPanel)this.getContentPane()).getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), CANCEL_DIALOG);
        ((JPanel)this.getContentPane()).getActionMap().put(CANCEL_DIALOG, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Calculator.this.setVisible(false);
            }
        });
        ((JPanel)this.getContentPane()).getInputMap(2).put(KeyStroke.getKeyStroke(109, 0), MINUS);
        ((JPanel)this.getContentPane()).getActionMap().put(MINUS, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Calculator.this.minus.doClick();
            }
        });
        ((JPanel)this.getContentPane()).getInputMap(2).put(KeyStroke.getKeyStroke(107, 0), "+");
        ((JPanel)this.getContentPane()).getActionMap().put("+", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Calculator.this.add.doClick();
            }
        });
        ((JPanel)this.getContentPane()).getInputMap(2).put(KeyStroke.getKeyStroke(106, 0), MULTIPLY);
        ((JPanel)this.getContentPane()).getActionMap().put(MULTIPLY, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Calculator.this.multiply.doClick();
            }
        });
        ((JPanel)this.getContentPane()).getInputMap(2).put(KeyStroke.getKeyStroke(111, 0), DIVIDE);
        ((JPanel)this.getContentPane()).getActionMap().put(DIVIDE, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Calculator.this.divide.doClick();
            }
        });
        ((JPanel)this.getContentPane()).getInputMap(2).put(KeyStroke.getKeyStroke(59, 0), LIST);
        ((JPanel)this.getContentPane()).getInputMap(2).put(KeyStroke.getKeyStroke(107, 1), LIST);
        ((JPanel)this.getContentPane()).getActionMap().put(LIST, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Calculator.this.list_separate.doClick();
            }
        });
        ((JPanel)this.getContentPane()).getInputMap(2).put(KeyStroke.getKeyStroke(109, 1), SIGN);
        ((JPanel)this.getContentPane()).getActionMap().put(SIGN, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Calculator.this.change_sign.doClick();
            }
        });
        ((JPanel)this.getContentPane()).getInputMap(2).put(KeyStroke.getKeyStroke(66, 0), B);
        ((JPanel)this.getContentPane()).getActionMap().put(B, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Calculator.this.constant_boltzmann.doClick();
            }
        });
        ((JPanel)this.getContentPane()).getInputMap(2).put(KeyStroke.getKeyStroke(69, 0), E);
        ((JPanel)this.getContentPane()).getActionMap().put(E, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Calculator.this.constant_e.doClick();
            }
        });
        ((JPanel)this.getContentPane()).getInputMap(2).put(KeyStroke.getKeyStroke(110, 0), COMMA);
        ((JPanel)this.getContentPane()).getInputMap(2).put(KeyStroke.getKeyStroke(44, 0), COMMA);
        ((JPanel)this.getContentPane()).getInputMap(2).put(KeyStroke.getKeyStroke(46, 0), COMMA);
        ((JPanel)this.getContentPane()).getActionMap().put(COMMA, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (Calculator.this.firstEntryOfBinaryOperation) {
                    Calculator.this.firstEntryOfBinaryOperation = false;
                    Calculator.this.lastActionWasEquals = false;
                    Calculator.this.removeLastEntry();
                }
                Calculator.this.comma.doClick();
            }
        });
        this.display.getInputMap(0).put(KeyStroke.getKeyStroke(8, 0), CLEAR);
        ((JPanel)this.getContentPane()).getInputMap(2).put(KeyStroke.getKeyStroke(8, 0), CLEAR);
        ((JPanel)this.getContentPane()).getInputMap(2).put(KeyStroke.getKeyStroke(67, 0), CLEAR);
        ((JPanel)this.getContentPane()).getActionMap().put(CLEAR, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Calculator.this.clear.doClick();
            }
        });
        ((JPanel)this.getContentPane()).getInputMap(2).put(KeyStroke.getKeyStroke(127, 0), CLEARALL);
        this.display.getInputMap(0).put(KeyStroke.getKeyStroke(127, 0), CLEARALL);
        ((JPanel)this.getContentPane()).getInputMap(2).put(KeyStroke.getKeyStroke(65, 0), CLEARALL);
        ((JPanel)this.getContentPane()).getActionMap().put(CLEARALL, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Calculator.this.clearAll.doClick();
            }
        });
        ((JPanel)this.getContentPane()).getInputMap(2).put(KeyStroke.getKeyStroke(35, 0), EQUALS);
        ((JPanel)this.getContentPane()).getInputMap(2).put(KeyStroke.getKeyStroke(61, 0), EQUALS);
        ((JPanel)this.getContentPane()).getInputMap(2).put(KeyStroke.getKeyStroke(10, 0), EQUALS);
        ((JPanel)this.getContentPane()).getInputMap(2).put(KeyStroke.getKeyStroke(32, 0), EQUALS);
        ((JPanel)this.getContentPane()).getActionMap().put(EQUALS, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Calculator.this.equals.doClick();
            }
        });
        ((JPanel)this.getContentPane()).getInputMap(2).put(KeyStroke.getKeyStroke(10, 2), TRANSFER);
        ((JPanel)this.getContentPane()).getInputMap(2).put(KeyStroke.getKeyStroke(155, 0), TRANSFER);
        ((JPanel)this.getContentPane()).getActionMap().put(TRANSFER, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Calculator.this.transfer.doClick();
            }
        });
        this.display.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0), EQUALS);
    }

    private void removeLastEntry() {
        String str = null;
        str = this.display.getText();
        if (this.display.getText().indexOf(LIST) > -1) {
            str = str.substring(0, str.lastIndexOf(LIST) + 1);
            this.display.setText(str);
        } else {
            this.display.setText("");
        }
    }

    public void resetFocus() {
        this.equals.requestFocusInWindow();
    }

    public void setValue(double result) {
        String str = Double.toString(result);
        if (this.display.getText().indexOf(LIST) > -1) {
            this.display.setText(this.display.getText().substring(0, this.display.getText().lastIndexOf(LIST) + 1) + str);
        } else {
            this.display.setText(str);
        }
        this.firstEntryOfBinaryOperation = true;
        this.lastActionWasEquals = false;
    }

    public void show(CalculatorInputField field) {
        this.clearDisplay();
        this.lastActionWasEquals = false;
        this.transferValue = false;
        try {
            this.setValue(((Number)field.getValue()).doubleValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.transfer.setVisible(true);
        this.setVisible(true);
        this.statusLabel.setText("");
        try {
            if (this.transferValue && !this.getValueString().equals("")) {
                field.setValue(this.getValue());
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Unable to transfer result to field!", "Field error", 2);
        }
        this.transfer.setVisible(false);
    }

    private static enum BinaryOperation {
        Add,
        Divide,
        Multiply,
        Substract;

    }
}

