/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.calculator;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.JFormattedTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;
import org.seamcat.calculator.Calculator;
import org.seamcat.calculator.ImageIconBorder;
import org.seamcat.presentation.MainWindow;
import org.seamcat.presentation.SeamcatIcons;
import org.seamcat.presentation.SeamcatTextFieldFormats;

public class CalculatorInputField
extends JFormattedTextField
implements DocumentListener {
    private static final long serialVersionUID = 1L;
    private static Calculator CALC;
    private final MouseAdapter mouseListener;
    private final MouseMotionListener mouseMotionListener;
    private final AbstractAction action;
    private boolean integerMode = false;
    private boolean allowNegatives = true;
    private boolean allowZero = true;
    private boolean fractionMode = false;
    private Color invalid = new Color(255, 120, 120);
    private Color valid;
    private static final JFormattedTextField.AbstractFormatterFactory DOUBLE_FACTORY;

    public CalculatorInputField() {
        super(DOUBLE_FACTORY);
        DefaultFormatter formatter = (DefaultFormatter)this.getFormatter();
        formatter.setCommitsOnValidEdit(true);
        this.setBorder(new ImageIconBorder(this, SeamcatIcons.getImageIcon("SEAMCAT_ICON_CALCULATOR", 0), SeamcatIcons.getImageIcon("SEAMCAT_ICON_CALCULATOR", 3)));
        this.setColumns(8);
        this.setHorizontalAlignment(4);
        this.addFocusListener(SeamcatTextFieldFormats.SELECTALL_FOCUSHANDLER);
        this.valid = this.getBackground();
        this.getDocument().addDocumentListener(this);
        this.mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getPoint().getX() >= CalculatorInputField.this.getSize().getWidth() - 16.0) {
                    if (CalculatorInputField.this.isEnabled()) {
                        try {
                            CalculatorInputField.this.commitEdit();
                        }
                        catch (ParseException ex) {
                            CalculatorInputField.this.setValue(0);
                        }
                        try {
                            if (CALC == null) {
                                CALC = new Calculator(MainWindow.getInstance());
                            }
                            CALC.show(CalculatorInputField.this);
                        }
                        catch (Exception exception) {}
                    }
                } else {
                    CalculatorInputField.this.requestFocus();
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                CalculatorInputField.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        };
        this.addMouseListener(this.mouseListener);
        this.mouseMotionListener = new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                if (e.getPoint().getX() >= CalculatorInputField.this.getSize().getWidth() - 16.0) {
                    CalculatorInputField.this.setCursor(Cursor.getPredefinedCursor(0));
                } else {
                    CalculatorInputField.this.setCursor(Cursor.getPredefinedCursor(2));
                }
            }
        };
        this.addMouseMotionListener(this.mouseMotionListener);
        this.getInputMap(0).put(KeyStroke.getKeyStroke(82, 2), this.getClass().getName());
        this.action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    CalculatorInputField.this.commitEdit();
                }
                catch (ParseException ex) {
                    CalculatorInputField.this.setValue(0);
                }
                try {
                    if (CALC == null) {
                        CALC = new Calculator(MainWindow.getInstance());
                    }
                    CALC.show(CalculatorInputField.this);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        this.getActionMap().put(this.getClass().getName(), this.action);
    }

    public CalculatorInputField(double value) {
        this();
        this.setValue(value);
    }

    public double getValueAsDouble() {
        try {
            return this.getValueAsNumber().doubleValue();
        }
        catch (NullPointerException ne) {
            try {
                return Double.parseDouble(this.getText());
            }
            catch (Exception e) {
                return 0.0;
            }
        }
    }

    public int getValueAsInteger() {
        return this.getValueAsNumber().intValue();
    }

    public Number getValueAsNumber() {
        if (this.integerMode) {
            try {
                return Integer.parseInt(this.getText());
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }
        String valueText = this.getText();
        if (valueText.indexOf(",") != -1) {
            valueText = valueText.replace(",", "");
            return Double.parseDouble(valueText);
        }
        try {
            return Double.parseDouble(this.getText());
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    public boolean isIntegerMode() {
        return this.integerMode;
    }

    public void setIntegerMode(boolean integerMode) {
        this.integerMode = integerMode;
        if (integerMode) {
            super.setFormatterFactory(SeamcatTextFieldFormats.INTEGER_FACTORY);
        } else {
            super.setFormatterFactory(DOUBLE_FACTORY);
            this.fractionMode = false;
        }
    }

    public void setAllowNegatives(boolean allowNegatives) {
        this.allowNegatives = allowNegatives;
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.update(this.validateValue(this.getValueAsDouble()));
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.update(this.validateValue(this.getValueAsDouble()));
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.update(this.validateValue(this.getValueAsDouble()));
    }

    protected boolean validateValue(double value) {
        if (this.fractionMode) {
            return value >= 0.0 && value <= 1.0;
        }
        if (!this.allowNegatives) {
            return value >= 0.0;
        }
        return true;
    }

    protected void update(boolean v) {
        this.setBackground(v ? this.valid : this.invalid);
    }

    public void dispose() {
        this.removeMouseListener(this.mouseListener);
        this.removeMouseMotionListener(this.mouseMotionListener);
        this.getActionMap().remove(this.getClass().getName());
    }

    static {
        DecimalFormat format = new DecimalFormat();
        format.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.ENGLISH));
        format.setMinimumFractionDigits(1);
        format.setMaximumFractionDigits(15);
        NumberFormatter f = new NumberFormatter(format);
        f.setAllowsInvalid(true);
        DOUBLE_FACTORY = new DefaultFormatterFactory(f, f, f);
    }
}

