/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.calculator;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;
import org.seamcat.calculator.Calculator;
import org.seamcat.presentation.SeamcatIcons;

public class MemoryButton
extends JButton {
    private static final String KEYMAP_PREFIX = "Store-f";
    private static final Logger LOG = Logger.getLogger(MemoryButton.class);
    private static final HashMap<Integer, Double> VALUES = new HashMap(5, 1.0f);
    private Calculator calc;
    private int index;
    private String no_value_tool_tip;
    private boolean valueSet = false;

    public MemoryButton(int _index, Calculator _calc, int keyevent) {
        super(String.valueOf(_index), SeamcatIcons.getImageIcon("SEAMCAT_ICON_CALCULATOR_MEMORY_EMPTY"));
        this.index = _index;
        this.no_value_tool_tip = "<html>Memory space " + this.index + ": No value stored<br>Click or press F" + this.index + " to store value";
        this.setToolTipText(this.no_value_tool_tip);
        this.calc = _calc;
        this.setMargin(new Insets(2, 2, 2, 2));
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!MemoryButton.this.valueSet || (e.getModifiers() & 1) == 1) {
                    MemoryButton.this.storeValue();
                } else if ((e.getModifiers() & 2) == 2) {
                    MemoryButton.this.resetValue();
                } else {
                    MemoryButton.this.retrieveValue();
                }
                MemoryButton.this.calc.resetFocus();
            }
        });
        this.getInputMap(2).put(KeyStroke.getKeyStroke(keyevent, 0), KEYMAP_PREFIX + this.index);
        this.getActionMap().put(KEYMAP_PREFIX + this.index, new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                MemoryButton.this.doClick();
            }
        });
    }

    @Override
    public void repaint() {
        this.setValueSet(VALUES.containsKey(this.index));
        super.repaint();
    }

    public void resetValue() {
        VALUES.remove(this.index);
        this.setValueSet(false);
    }

    public void retrieveValue() {
        if (this.valueSet) {
            this.calc.setValue(VALUES.get(this.index));
            LOG.debug("Retrieved value [" + VALUES.get(this.index) + "] from memory position " + this.index);
        }
    }

    private void setValueSet(boolean value) {
        this.valueSet = value;
        if (this.valueSet) {
            this.setIcon(SeamcatIcons.getImageIcon("SEAMCAT_ICON_CALCULATOR_MEMORY_FULL"));
            this.setToolTipText("<html>Memory space " + this.index + ": " + VALUES.get(this.index) + "<br>Click or press F" + this.index + " to use value<br>Shift + Click to store new value<br>Control + Click to clear value");
        } else {
            this.valueSet = false;
            this.setIcon(SeamcatIcons.getImageIcon("SEAMCAT_ICON_CALCULATOR_MEMORY_EMPTY"));
            this.setToolTipText(this.no_value_tool_tip);
        }
    }

    public void storeValue() {
        try {
            double value = this.calc.getValue();
            VALUES.put(this.index, value);
            this.setValueSet(true);
            LOG.debug("Stored value [" + value + "] in memory position " + this.index);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

