/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.cdma;

import org.apache.log4j.Logger;
import org.seamcat.cdma.CDMADownlink;
import org.seamcat.cdma.CDMASystem;
import org.seamcat.cdma.CdmaBaseStation;
import org.seamcat.cdma.CdmaUserTerminal;
import org.seamcat.cdma.NonInterferedCapacitySearch;
import org.seamcat.cdma.exceptions.ScalingException;
import org.seamcat.dmasystems.AbstractDmaBaseStation;
import org.seamcat.dmasystems.AbstractDmaLink;
import org.seamcat.dmasystems.AbstractDmaSystem;
import org.seamcat.dmasystems.UserShouldBeIgnoredException;
import org.seamcat.eventbus.EventBusFactory;
import org.seamcat.events.CapacityEndingTest;
import org.seamcat.events.CapacityEndingTrial;
import org.seamcat.events.CapacityStartingTest;
import org.seamcat.exception.SimulationInvalidException;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.simulation.result.MultiValueDef;
import org.seamcat.model.types.result.Results;
import org.seamcat.simulation.cellular.cdma.CDMADownLink;
import org.seamcat.simulation.hybrid.HybridSystemPlugin;

public class CDMADownlinkSystem
extends CDMASystem {
    private static final Logger LOG = Logger.getLogger(CDMADownlinkSystem.class);

    public CDMADownlinkSystem(HybridSystemPlugin plugin) {
        super(plugin);
        this.setPlugin(plugin);
    }

    public CDMADownlinkSystem(AbstractDmaSystem<?> sys) {
        super(sys);
        if (this.getCDMASettings().getDownLinkSettings() == null) {
            this.getCDMASettings().setDownLinkSettings(new CDMADownLink());
        }
        this.getCDMASettings().setUpLinkSettings(null);
    }

    public double getMaxTrafficChannelPowerIndBm() {
        return Mathematics.fromWatt2dBm(this.getMaxTrafficChannelPowerInWatt());
    }

    public double getMaxTrafficChannelPowerInWatt() {
        double maxBroadcastPower = this.getCDMASettings().getDownLinkSettings().getMaximumBroadcastChannel();
        double maxPowerChannelFraction = this.getCDMASettings().getDownLinkSettings().getMaximumTrafficChannelFraction();
        return Mathematics.fromdBm2Watt(maxBroadcastPower) * maxPowerChannelFraction;
    }

    @Override
    public void balanceInterferedSystem() {
        this.internalPowerBalance();
    }

    @Override
    public void balancePower() {
        this.calculateProcessingGain();
        int cellsPerSite = this.cellsPerSite();
        int bStop = this.cells.length;
        for (int j = 0; j < bStop; ++j) {
            for (int k = 0; k < cellsPerSite; ++k) {
                ((CdmaBaseStation)this.cells[j][k]).initializeTransmitPowerLevels();
            }
        }
        try {
            this.internalPowerBalance();
        }
        catch (Exception ex) {
            LOG.error("Error scaling power", ex);
        }
    }

    @Override
    protected NonInterferedCapacitySearch findNonInterferedCapacityInternal(Results results, MultiValueDef def, NonInterferedCapacitySearch search, Object context) {
        int pointsAdded = 0;
        int usersPerCell = search.getCapacity();
        int deltaN = search.getDeltaUsers();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Finding non interfered capacity. [N = " + usersPerCell + ", deltaN = " + deltaN + "]");
        }
        int numberOfTrials = this.getCDMASettings().getNumberOfTrials();
        EventBusFactory.getEventBus().publish(new CapacityStartingTest(context, usersPerCell, numberOfTrials));
        int trialThreshold = (int)Math.ceil((double)(usersPerCell * this.getNumberOfBaseStations()) * this.getCDMASettings().getToleranceOfInitialOutage() / 100.0);
        try {
            this.calculateProcessingGain();
            int[] dropped = new int[numberOfTrials];
            int smartStopIndex = 0;
            for (int i = 0; i < dropped.length; ++i) {
                int j;
                int currentSuccess = 0;
                for (int j2 = 0; j2 < i; ++j2) {
                    if (dropped[j2] > trialThreshold) continue;
                    ++currentSuccess;
                }
                if ((double)currentSuccess > (double)numberOfTrials * this.succesCriteria) {
                    smartStopIndex = i;
                    while (i < dropped.length) {
                        dropped[i] = -1;
                        ++i;
                    }
                    continue;
                }
                if ((double)(currentSuccess + dropped.length - i) < (double)numberOfTrials * this.succesCriteria) {
                    smartStopIndex = i;
                    while (i < dropped.length) {
                        dropped[i] = trialThreshold + 1;
                        ++i;
                    }
                    continue;
                }
                this.resetSystem();
                int cellsPerSite = this.cellsPerSite();
                int bStop = this.cells.length;
                for (int j3 = 0; j3 < bStop; ++j3) {
                    for (int k = 0; k < cellsPerSite; ++k) {
                        ((CdmaBaseStation)this.cells[j3][k]).initializeTransmitPowerLevels();
                    }
                }
                int stop = usersPerCell * this.getNumberOfBaseStations();
                for (j = 0; j < stop; ++j) {
                    CdmaUserTerminal user = (CdmaUserTerminal)this.generateInitializedMobile();
                    if (user == null) continue;
                    if (user.connectToBaseStationsDownlink()) {
                        user.setAllowedToConnect(true);
                        this.activeUsers.add(user);
                        for (AbstractDmaLink l : user.getActiveList()) {
                            CDMADownlink link = (CDMADownlink)l;
                            CdmaBaseStation cell = link.getBaseStation();
                            if (cell.getCurrentTransmitPower_dBm() > cell.getMaximumTransmitPower()) {
                                cell.scaleChannelPower();
                            }
                            cell.calculateCurrentChannelPower_dBm();
                        }
                        continue;
                    }
                    this.dropActiveUser(user, "Unable to connect");
                }
                int bStop2 = this.cells.length;
                for (j = 0; j < bStop2; ++j) {
                    for (int k = 0; k < this.cells[j].length; ++k) {
                        CdmaBaseStation cell = (CdmaBaseStation)this.cells[j][k];
                        cell.calculateCurrentChannelPower_dBm();
                    }
                }
                this.internalPowerBalance();
                dropped[i] = this.getDroppedUsers().size();
                EventBusFactory.getEventBus().publish(new CapacityEndingTrial(context, dropped[i], dropped[i] <= trialThreshold, i));
            }
            int succes = 0;
            int stop = dropped.length;
            if (smartStopIndex > 0) {
                stop = smartStopIndex;
            }
            for (int i = 0; i < stop; ++i) {
                if (dropped[i] > trialThreshold) continue;
                ++succes;
            }
            this.addPoint(++pointsAdded, results, def, usersPerCell, succes);
            EventBusFactory.getEventBus().publish(new CapacityEndingTest(context, usersPerCell, succes));
            if (LOG.isDebugEnabled()) {
                LOG.debug("Number of succesfull trials was: " + succes + " out of " + numberOfTrials);
            }
            if ((double)succes > (double)numberOfTrials * this.succesCriteria) {
                if (this.fineTuning) {
                    if (deltaN == 1 && this.finalFineTuning) {
                        return new NonInterferedCapacitySearch(usersPerCell);
                    }
                    deltaN = (int)Math.ceil((double)deltaN / 2.0);
                }
                return new NonInterferedCapacitySearch(usersPerCell += deltaN, deltaN);
            }
            if ((double)succes < (double)numberOfTrials * this.succesCriteria) {
                this.fineTuning = true;
                if (deltaN == 1) {
                    this.finalFineTuning = true;
                } else {
                    deltaN = (int)Math.ceil((double)deltaN / 2.0);
                }
                return new NonInterferedCapacitySearch(usersPerCell -= deltaN, deltaN);
            }
            return new NonInterferedCapacitySearch(usersPerCell);
        }
        catch (Exception ex) {
            if (ex.getCause() instanceof InterruptedException) {
                throw new SimulationInvalidException("Interrupted", ex.getCause());
            }
            LOG.error("An Error occured", ex);
            ex.printStackTrace();
            return new NonInterferedCapacitySearch(-1);
        }
    }

    @Override
    protected int internalPowerBalance() {
        try {
            boolean powerConverged = false;
            double maxPower = Mathematics.fromWatt2dBm(((CdmaBaseStation)this.cells[0][0]).getMaximumChannelPower_Watt());
            while (!powerConverged) {
                powerConverged = true;
                for (CdmaUserTerminal user : this.activeUsers) {
                    user.calculateReceivedPower();
                    user.calculateGeometry(this.getCDMASettings().getLld().getInitialMinimumGeometry(), this.getCDMASettings().getLld().getInitialMaximumGeometry());
                    user.findLinkLevelDataPoint(this.getLinkLevelData());
                }
                AbstractDmaBaseStation[][] abstractDmaBaseStationArray = this.cells;
                int user = abstractDmaBaseStationArray.length;
                for (int i = 0; i < user; ++i) {
                    AbstractDmaBaseStation[] cell1;
                    for (AbstractDmaBaseStation cell : cell1 = abstractDmaBaseStationArray[i]) {
                        double curPower;
                        if (cell.countServedUsers() <= 0 || !((curPower = ((CdmaBaseStation)cell).calculateCurrentChannelPower_dBm()) > maxPower) || !(curPower - maxPower > 1.0E-4)) continue;
                        ((CdmaBaseStation)cell).scaleChannelPower();
                        powerConverged = false;
                    }
                }
                if (!powerConverged) continue;
                for (int i = 0; i < this.activeUsers.size(); ++i) {
                    CdmaUserTerminal user2 = (CdmaUserTerminal)this.activeUsers.get(i);
                    user2.calculateAchievedEcIor();
                    int freePassCount = user2.getLinkQualityExceptions();
                    if (!user2.meetsEcIorRequirement(this.getCDMASettings().getDownLinkSettings().getSuccessThreshold(), true)) {
                        if (user2.getPowerScaledUpCount() > 2) {
                            this.dropActiveUser(user2, "Power scaled up too many times");
                            powerConverged = false;
                            continue;
                        }
                        user2.calculateReceivedTrafficChannelPowerInWatt();
                        user2.increasePowerScaledUpCount();
                        powerConverged = false;
                    }
                    user2.setLinkQualityExceptions(freePassCount);
                }
            }
            for (int i = 0; i < this.activeUsers.size(); ++i) {
                CdmaUserTerminal user = (CdmaUserTerminal)this.activeUsers.get(i);
                user.calculateReceivedPower();
                user.calculateGeometry(this.getCDMASettings().getLld().getInitialMinimumGeometry(), this.getCDMASettings().getLld().getInitialMaximumGeometry());
                user.findLinkLevelDataPoint(this.getLinkLevelData());
                user.calculateAchievedEcIor();
                if (user.meetsEcIorRequirement(this.getCDMASettings().getDownLinkSettings().getSuccessThreshold(), true)) continue;
                this.dropActiveUser(user, "due to success threshold");
                --i;
            }
        }
        catch (ScalingException ex) {
            LOG.error("Error scaling power", ex);
        }
        return 0;
    }

    @Override
    protected void performSystemSpecificInitialization(CdmaUserTerminal user) throws UserShouldBeIgnoredException {
        boolean voice = this.trialVoiceActivity();
        if (!voice) {
            for (AbstractDmaLink link : user.getActiveList()) {
                CDMADownlink l = (CDMADownlink)link;
                l.getBaseStation().addVoiceInActiveUser(l);
            }
            this.inactiveUsers.add(user);
            throw new UserShouldBeIgnoredException();
        }
        try {
            user.calculateInitialReceivedPower(this.getCDMASettings().getDownLinkSettings().getMaximumBroadcastChannel());
            user.calculateGeometry(this.getCDMASettings().getLld().getInitialMinimumGeometry(), this.getCDMASettings().getLld().getInitialMaximumGeometry());
            user.findLinkLevelDataPoint(this.getLinkLevelData());
            user.calculateReceivedTrafficChannelPowerInWatt();
        }
        catch (Exception e) {
            if (!user.linkLevelDataPointFound()) {
                this.noLinkLevelFoundUsers.add(user);
                --this.useridcount;
                throw new UserShouldBeIgnoredException();
            }
            throw new IllegalStateException("Unable to calculate PTraf", e);
        }
    }
}

