/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.cdma;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.log4j.Logger;
import org.seamcat.cdma.CDMASystem;
import org.seamcat.cdma.CDMAUplink;
import org.seamcat.cdma.CdmaBaseStation;
import org.seamcat.cdma.CdmaUserTerminal;
import org.seamcat.cdma.NonInterferedCapacitySearch;
import org.seamcat.dmasystems.AbstractDmaBaseStation;
import org.seamcat.dmasystems.AbstractDmaLink;
import org.seamcat.dmasystems.AbstractDmaMobile;
import org.seamcat.dmasystems.AbstractDmaSystem;
import org.seamcat.dmasystems.UserShouldBeIgnoredException;
import org.seamcat.eventbus.EventBusFactory;
import org.seamcat.events.CapacityEndingTest;
import org.seamcat.events.CapacityEndingTrial;
import org.seamcat.events.CapacityStartingTest;
import org.seamcat.exception.SimulationInvalidException;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.simulation.result.MultiValueDef;
import org.seamcat.model.simulation.result.VectorDef;
import org.seamcat.model.types.result.Results;
import org.seamcat.simulation.IgnoreSnapshot;
import org.seamcat.simulation.cellular.CellularVictimSystemSimulation;
import org.seamcat.simulation.cellular.cdma.CDMAUpLink;
import org.seamcat.simulation.result.VectorDefImpl;

public class CDMAUplinkSystem
extends CDMASystem {
    private static final Logger LOG = Logger.getLogger(CDMAUplinkSystem.class);
    private final int maximumPeakCount = 150;
    private static Comparator<AbstractDmaMobile> lowestTransmittingUser = new Comparator<AbstractDmaMobile>(){

        @Override
        public int compare(AbstractDmaMobile u1, AbstractDmaMobile u2) {
            if (u1.getCurrentTransmitPower() < u2.getCurrentTransmitPower()) {
                return -1;
            }
            if (u1.getCurrentTransmitPower() > u2.getCurrentTransmitPower()) {
                return 1;
            }
            return 0;
        }
    };
    private static Comparator<AbstractDmaBaseStation> highestNoiseRise = new Comparator<AbstractDmaBaseStation>(){

        @Override
        public int compare(AbstractDmaBaseStation u1, AbstractDmaBaseStation u2) {
            if (u1.getRelativeCellNoiseRise() > u2.getRelativeCellNoiseRise()) {
                return -1;
            }
            if (u1.getRelativeCellNoiseRise() < u2.getRelativeCellNoiseRise()) {
                return 1;
            }
            return 0;
        }
    };
    private double[][] initialVictimCapacityActiveAndInactiveUsersWorstCell;

    public CDMAUplinkSystem(AbstractDmaSystem<?> sys) {
        super(sys);
        if (this.getCDMASettings().getUpLinkSettings() == null) {
            this.getCDMASettings().setUpLinkSettings(new CDMAUpLink());
        }
        this.getCDMASettings().setDownLinkSettings(null);
    }

    private void addAllUsersToSystem(int usersPerCell) {
        int stop = usersPerCell * this.getNumberOfBaseStations();
        for (int i = 0; i < stop; ++i) {
            CdmaUserTerminal user = (CdmaUserTerminal)this.generateInitializedMobile();
            if (user == null) continue;
            user.connectToBaseStationsUplink();
            this.activeUsers.add(user);
        }
    }

    @Override
    public void balanceInterferedSystem() {
        boolean cellOptimization = this.getCDMASettings().getUpLinkSettings().cellOptimization();
        double initialAverageNetworkNoiseRiseWithoutExternalInterference = this.calculateAverageNoiseRiseWithoutExternalInterference_dB();
        this.getCollector().add((VectorDef)new VectorDefImpl("Average network noise rise, (initial - no Ext. interference)", "dB", false), initialAverageNetworkNoiseRiseWithoutExternalInterference);
        double initial = this.calculateAverageNoiseRise_dB();
        this.getCollector().add((VectorDef)new VectorDefImpl("Average network noise rise, (initial)", "dB", false), initial);
        this.getCollector().add((VectorDef)new VectorDefImpl("Average network rise, (resulting)", "dB", false), initial);
        if (!cellOptimization) {
            boolean noiseRiseAboveLimit = true;
            while (noiseRiseAboveLimit) {
                int loopCount = this.internalPowerBalance();
                double currentAverageNoiseRise = this.calculateAverageNoiseRise_dB();
                boolean bl = noiseRiseAboveLimit = currentAverageNoiseRise > initialAverageNetworkNoiseRiseWithoutExternalInterference;
                if (loopCount >= 150) {
                    noiseRiseAboveLimit = true;
                }
                if (!noiseRiseAboveLimit) continue;
                int absRiseAboveLimit = (int)Math.max(1.0, Math.ceil(currentAverageNoiseRise - initialAverageNetworkNoiseRiseWithoutExternalInterference));
                for (int i = 0; i < absRiseAboveLimit && this.activeUsers.size() > 0; ++i) {
                    CdmaUserTerminal user = (CdmaUserTerminal)this.activeUsers.get(this.activeUsers.size() - 1);
                    this.dropActiveUser(user, "Highest Transmitting UE from the network");
                }
                if (this.activeUsers.size() != 0) continue;
                noiseRiseAboveLimit = false;
                this.getCollector().add((VectorDef)new VectorDefImpl("Average network rise, (resulting)", "dB", false), this.calculateAverageNoiseRise_dB());
            }
        } else {
            Map<CdmaBaseStation, LinkedList<CdmaUserTerminal>> bsUsersMap = this.createUsersBsMap();
            LinkedList<CdmaBaseStation> relevantBs = new LinkedList<CdmaBaseStation>(bsUsersMap.keySet());
            for (CdmaBaseStation bs : relevantBs) {
                this.calculateRelativeCellNoiseRise(bs);
            }
            ((CdmaBaseStation)relevantBs.get(0)).setWorstCell(true);
            int loopCount = this.internalPowerBalance();
            boolean noiseRiseAboveLimit = this.noiseRiseAboveLimit(initialAverageNetworkNoiseRiseWithoutExternalInterference);
            if (loopCount >= 150) {
                noiseRiseAboveLimit = true;
            }
            while (noiseRiseAboveLimit && !relevantBs.isEmpty()) {
                Collections.sort(relevantBs, highestNoiseRise);
                CdmaBaseStation highestNoiseRiseBS = (CdmaBaseStation)relevantBs.get(0);
                LinkedList<CdmaUserTerminal> users = bsUsersMap.get(highestNoiseRiseBS);
                Collections.sort(users, lowestTransmittingUser);
                CdmaUserTerminal highestTxUser = users.removeLast();
                this.dropActiveUser(highestTxUser, "Highest Transmitting UE from a single cell");
                this.internalPowerBalance();
                if (users.isEmpty()) {
                    relevantBs.remove(highestNoiseRiseBS);
                } else {
                    this.calculateRelativeCellNoiseRise(highestNoiseRiseBS);
                }
                noiseRiseAboveLimit = this.noiseRiseAboveLimit(initialAverageNetworkNoiseRiseWithoutExternalInterference);
            }
            this.getCollector().add((VectorDef)new VectorDefImpl("Average network rise, (resulting)", "dB", false), this.calculateAverageNoiseRise_dB());
        }
        for (int i = 0; i < this.activeUsers.size(); ++i) {
            CdmaUserTerminal user = (CdmaUserTerminal)this.activeUsers.get(i);
            double ci = user.calculateAchievedCI();
            double reqci = user.getLinkLevelData().getEbNo();
            double difference = reqci - ci;
            if (!(difference > this.getCDMASettings().getCallDropThreshold())) continue;
            this.dropActiveUser(user, "Ec/IoR requirement deos not meet - after External balancing");
            --i;
        }
    }

    private boolean noiseRiseAboveLimit(double initialAverageNetworkNoiseRiseWithoutExternalInterference) {
        double currentAverageNoiseRise = this.calculateAverageNoiseRise_dB();
        if (Double.isNaN(currentAverageNoiseRise)) {
            return true;
        }
        return currentAverageNoiseRise > initialAverageNetworkNoiseRiseWithoutExternalInterference;
    }

    public void setInitialVictimCapacityActiveAndInactiveUsersWorstCell(double[][] initial) {
        this.initialVictimCapacityActiveAndInactiveUsersWorstCell = initial;
    }

    public double[][] getInitialVictimCapacityActiveAndInactiveUsersWorstCell() {
        return this.initialVictimCapacityActiveAndInactiveUsersWorstCell;
    }

    public int getNumberOfServedMobilesInCell(int CellID, int triSectorCellSelection) {
        return this.cells[CellID][triSectorCellSelection].countServedUsers();
    }

    public boolean getWorstCell(int j, int k) {
        return ((CdmaBaseStation)this.cells[j][k]).isWorstCell();
    }

    public void resetWorstCell(int j, int k) {
        ((CdmaBaseStation)this.cells[j][k]).setWorstCell(false);
    }

    public int getNumberOfServedMobilesInWorstCell() {
        int result = 0;
        boolean isNoWorthCell = false;
        AbstractDmaBaseStation[][] abstractDmaBaseStationArray = this.cells;
        int n = abstractDmaBaseStationArray.length;
        for (int i = 0; i < n; ++i) {
            AbstractDmaBaseStation[] cell;
            for (AbstractDmaBaseStation aCell : cell = abstractDmaBaseStationArray[i]) {
                if (!((CdmaBaseStation)aCell).isWorstCell()) continue;
                result = aCell.countServedUsers();
                isNoWorthCell = true;
            }
        }
        if (!isNoWorthCell) {
            result = -1;
        }
        return result;
    }

    @Override
    public void balancePower() {
        this.calculateProcessingGain();
        int blockNumberUsers = this.getAllBaseStations().size() == 57 ? 10 : 1;
        int loopCount = this.internalPowerBalance();
        boolean ignoreSnapshot = loopCount >= 150;
        this.checkLoop(loopCount);
        boolean initialNoiseRiseAboveLimit = true;
        boolean tempInitialNoiseRiseAboveLimit = true;
        double currentInitialAverageNetworkNoiseRiseWithoutExternalInterference = this.calculateAverageNoiseRiseWithoutExternalInterference_dB();
        while (initialNoiseRiseAboveLimit) {
            CdmaUserTerminal user;
            int i;
            if (currentInitialAverageNetworkNoiseRiseWithoutExternalInterference > this.getCDMASettings().getUpLinkSettings().getTargetNetworkNoiseRise()) {
                for (i = 0; i < blockNumberUsers; ++i) {
                    user = (CdmaUserTerminal)this.activeUsers.get(this.activeUsers.size() - 1);
                    this.dropActiveUser(user, "Target noise rise too high while initially balancing the power");
                }
                loopCount = this.internalPowerBalance();
                ignoreSnapshot = loopCount >= 150;
                this.checkLoop(loopCount);
                currentInitialAverageNetworkNoiseRiseWithoutExternalInterference = this.calculateAverageNoiseRiseWithoutExternalInterference_dB();
                initialNoiseRiseAboveLimit = currentInitialAverageNetworkNoiseRiseWithoutExternalInterference >= this.getCDMASettings().getUpLinkSettings().getTargetNetworkNoiseRise();
                continue;
            }
            for (i = 0; i < blockNumberUsers; ++i) {
                user = (CdmaUserTerminal)this.generateInitializedMobile();
                if (user == null) continue;
                if (user.connect()) {
                    user.setAllowedToConnect(true);
                    this.activeUsers.add(user);
                    continue;
                }
                this.dropActiveUser(user, "Unable to connect when adding a UE while initially balancing the power");
            }
            loopCount = this.internalPowerBalance();
            ignoreSnapshot = loopCount >= 150;
            this.checkLoop(loopCount);
            currentInitialAverageNetworkNoiseRiseWithoutExternalInterference = this.calculateAverageNoiseRiseWithoutExternalInterference_dB();
            boolean bl = tempInitialNoiseRiseAboveLimit = currentInitialAverageNetworkNoiseRiseWithoutExternalInterference <= this.getCDMASettings().getUpLinkSettings().getTargetNetworkNoiseRise();
            while (!tempInitialNoiseRiseAboveLimit) {
                user = (CdmaUserTerminal)this.activeUsers.get(this.activeUsers.size() - 1);
                this.dropActiveUser(user, "Target noise rise too high while initially balancing the power");
                loopCount = this.internalPowerBalance();
                ignoreSnapshot = loopCount >= 150;
                this.checkLoop(loopCount);
                currentInitialAverageNetworkNoiseRiseWithoutExternalInterference = this.calculateAverageNoiseRiseWithoutExternalInterference_dB();
                tempInitialNoiseRiseAboveLimit = currentInitialAverageNetworkNoiseRiseWithoutExternalInterference <= this.getCDMASettings().getUpLinkSettings().getTargetNetworkNoiseRise();
                if (!tempInitialNoiseRiseAboveLimit) continue;
                initialNoiseRiseAboveLimit = false;
            }
        }
        if (ignoreSnapshot) {
            throw new IgnoreSnapshot();
        }
        this.calculateAverageNoiseRise_Linear();
    }

    private double calculateAverageNoiseRise_dB() {
        return Mathematics.linear2dB(this.calculateAverageNoiseRise_Linear());
    }

    private double calculateAverageNoiseRise_Linear() {
        int cellCounter = 0;
        double noiseRise = 0.0;
        int cellsPerSite = this.cellsPerSite();
        int bStop = this.cells.length;
        for (int j = 0; j < bStop; ++j) {
            for (int k = 0; k < cellsPerSite; ++k) {
                CdmaBaseStation cell = (CdmaBaseStation)this.cells[j][k];
                noiseRise += cell.calculateNoiseRiseOverThermalNoise_LinearyFactor();
                ++cellCounter;
            }
        }
        return noiseRise / (double)cellCounter;
    }

    public double calculateAverageNoiseRiseWithoutExternalInterference_dB() {
        return Mathematics.linear2dB(this.calculateAverageNoiseRiseWithoutExternalInterference_Linear());
    }

    public double calculateAverageNoiseRiseWithoutExternalInterference_Linear() {
        int cellCounter = 0;
        double noiseRise = 0.0;
        int cellsPerSite = this.cellsPerSite();
        int bStop = this.cells.length;
        for (int j = 0; j < bStop; ++j) {
            for (int k = 0; k < cellsPerSite; ++k) {
                CdmaBaseStation cell = (CdmaBaseStation)this.cells[j][k];
                noiseRise += cell.calculateNoiseRiseOverThermalNoiseWithoutExternal_LinearyFactor();
                ++cellCounter;
            }
        }
        return noiseRise / (double)cellCounter;
    }

    public double calculateNoiseRiseForSingleCell_dB(int cellSelectedToHaveTheHighestNoiseRise) {
        double maxNoiseRise = 0.0;
        int cellsPerSite = this.cellsPerSite();
        int bStop = this.cells.length;
        for (int j = 0; j < bStop; ++j) {
            for (int k = 0; k < cellsPerSite; ++k) {
                if (this.cells[j][k].getCellid() != cellSelectedToHaveTheHighestNoiseRise) continue;
                maxNoiseRise = this.cells[j][k].calculateNoiseRiseOverThermalNoise_dB();
            }
        }
        return maxNoiseRise;
    }

    @Override
    protected NonInterferedCapacitySearch findNonInterferedCapacityInternal(Results results, MultiValueDef def, NonInterferedCapacitySearch search, Object context) {
        int numberOfPoints = 0;
        int usersPerCell = search.getCapacity();
        int deltaN = search.getDeltaUsers();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Testing non interfered capacity. [N = " + usersPerCell + ", deltaN = " + deltaN + "]");
        }
        int numberOfTrials = this.getCDMASettings().getNumberOfTrials();
        EventBusFactory.getEventBus().publish(new CapacityStartingTest(context, usersPerCell, numberOfTrials));
        try {
            this.calculateProcessingGain();
            double networkNoiseRiseSum = 0.0;
            for (int i = 0; i < numberOfTrials; ++i) {
                double currentEndResult = 10.0 * Math.log10(networkNoiseRiseSum / (double)numberOfTrials);
                if (currentEndResult > this.maxTargetNoiseRise) {
                    double linearyAverage = networkNoiseRiseSum / (double)i;
                    while (i < numberOfTrials) {
                        networkNoiseRiseSum += linearyAverage;
                        ++i;
                    }
                    continue;
                }
                this.resetSystem();
                this.addAllUsersToSystem(usersPerCell);
                this.checkLoop(this.internalPowerBalance());
                double nr = this.calculateAverageNoiseRise_Linear();
                double temp_meanNoiseRise = Mathematics.linear2dB((networkNoiseRiseSum += nr) / (double)(i + 1));
                EventBusFactory.getEventBus().publish(new CapacityEndingTrial(context, temp_meanNoiseRise, nr <= this.getCDMASettings().getUpLinkSettings().getTargetNetworkNoiseRise(), i));
            }
            this.meanNoiseRiseOverTrials = 10.0 * Math.log10(networkNoiseRiseSum / (double)numberOfTrials);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Mean noise rise was: " + this.meanNoiseRiseOverTrials + " dB");
            }
            this.addPoint(++numberOfPoints, results, def, usersPerCell, this.meanNoiseRiseOverTrials);
            EventBusFactory.getEventBus().publish(new CapacityEndingTest(context, usersPerCell, this.meanNoiseRiseOverTrials));
            if (this.meanNoiseRiseOverTrials < this.minTargetNoiseRise) {
                if (this.fineTuning) {
                    if (deltaN == 1 && this.finalFineTuning) {
                        return new NonInterferedCapacitySearch(usersPerCell);
                    }
                    deltaN = (int)Math.ceil((double)deltaN / 2.0);
                }
                return new NonInterferedCapacitySearch(usersPerCell += deltaN, deltaN);
            }
            if (this.meanNoiseRiseOverTrials > this.maxTargetNoiseRise) {
                this.fineTuning = true;
                if (deltaN == 1) {
                    this.finalFineTuning = true;
                } else {
                    deltaN = (int)Math.ceil((double)deltaN / 2.0);
                }
                if ((usersPerCell -= deltaN) > 0) {
                    return new NonInterferedCapacitySearch(usersPerCell, deltaN);
                }
                return new NonInterferedCapacitySearch(0);
            }
            return new NonInterferedCapacitySearch(usersPerCell);
        }
        catch (Exception ex) {
            if (ex.getCause() instanceof InterruptedException) {
                throw new SimulationInvalidException("Interrupted", ex.getCause());
            }
            LOG.error("An Error occured", ex);
            return new NonInterferedCapacitySearch(-1);
        }
    }

    private void checkLoop(int loopCount) {
        if (this.getCollector() == null) {
            return;
        }
        Double value = this.getCollector().get(CellularVictimSystemSimulation.highestPCLoopCount);
        if (value == null) {
            value = 0.0;
        }
        if ((double)loopCount > value) {
            this.getCollector().add(CellularVictimSystemSimulation.highestPCLoopCount, (double)loopCount);
        }
    }

    private void calculateRelativeCellNoiseRise(CdmaBaseStation bs) {
        bs.setCellNoiseRiseInitial(bs.calculateNoiseRiseOverThermalNoiseWithoutExternal_dB());
        double cellNoiseRiseInterferer = bs.calculateNoiseRiseOverThermalNoise_dB();
        bs.setRelativeCellNoiseRise(cellNoiseRiseInterferer - bs.getCellNoiseRiseInitial());
    }

    private Map<CdmaBaseStation, LinkedList<CdmaUserTerminal>> createUsersBsMap() {
        HashMap<CdmaBaseStation, LinkedList<CdmaUserTerminal>> cellUserMap = new HashMap<CdmaBaseStation, LinkedList<CdmaUserTerminal>>();
        for (CdmaUserTerminal activeUser : this.activeUsers) {
            CdmaBaseStation bs = (CdmaBaseStation)activeUser.getActiveList().get(0).getBaseStation();
            LinkedList<CdmaUserTerminal> users = (LinkedList<CdmaUserTerminal>)cellUserMap.get(bs);
            if (users == null) {
                users = new LinkedList<CdmaUserTerminal>();
                cellUserMap.put(bs, users);
            }
            users.add(activeUser);
        }
        return cellUserMap;
    }

    @Override
    protected int internalPowerBalance() {
        boolean powerConverged = false;
        int peakCount = 0;
        while (!powerConverged) {
            powerConverged = true;
            ++peakCount;
            for (CdmaUserTerminal u : this.activeUsers) {
                u.calculateAchievedCI();
            }
            for (CdmaUserTerminal u : this.activeUsers) {
                double cToI_last_loop = u.getOldAchievedCI();
                double cToI_loop = u.getAchievedCI();
                double Sir_target = u.getLinkLevelData().getEbNo();
                double tx_required_last_loop = Mathematics.fromWatt2dBm(u.getCurrentTransmitPower());
                double tx_required_loop = tx_required_last_loop + Sir_target - cToI_loop;
                double maxTxPower = this.getCDMASettings().getUpLinkSettings().getMSMaximumTransmitPower();
                double minTxPower = maxTxPower - this.getCDMASettings().getUpLinkSettings().getMSPowerControlRange();
                double power = Math.min(Math.max(tx_required_loop, minTxPower), maxTxPower);
                u.setCurrentTransmitPower_dBm(power);
                u.resetSummationAffectedBaseStations();
                if (!(Math.abs(cToI_loop - cToI_last_loop) > this.getCDMASettings().getUpLinkSettings().getMSConvergencePrecision())) continue;
                powerConverged = false;
            }
            if (peakCount <= 150) continue;
            powerConverged = true;
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Terminating CDMA Power Control loop after 150 cycles");
        }
        AbstractDmaBaseStation[][] abstractDmaBaseStationArray = this.cells;
        int n = abstractDmaBaseStationArray.length;
        for (int i = 0; i < n; ++i) {
            Object cell;
            for (Object aCell : cell = abstractDmaBaseStationArray[i]) {
                ((AbstractDmaBaseStation)aCell).calculateTotalInterference_dBm(null);
            }
        }
        return peakCount;
    }

    @Override
    protected void performSystemSpecificInitialization(CdmaUserTerminal user) throws UserShouldBeIgnoredException {
        boolean voice = this.trialVoiceActivity();
        if (!voice) {
            this.inactiveUsers.add(user);
            for (AbstractDmaLink link : user.getActiveList()) {
                CDMAUplink l = (CDMAUplink)link;
                l.getBaseStation().addVoiceInActiveUser(l);
            }
            throw new UserShouldBeIgnoredException();
        }
        user.setMultiPathChannel(1 + (int)Math.round(this.random.trial()));
        user.findLinkLevelDataPoint(this.getLinkLevelData());
        if (!user.linkLevelDataPointFound()) {
            this.noLinkLevelFoundUsers.add(user);
            --this.useridcount;
            throw new UserShouldBeIgnoredException();
        }
    }
}

