/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.cdma;

import org.seamcat.cdma.CDMADownlink;
import org.seamcat.cdma.CDMALinkLevelData;
import org.seamcat.cdma.CDMALinkLevelDataPoint;
import org.seamcat.cdma.CDMASystem;
import org.seamcat.cdma.CDMAUplink;
import org.seamcat.cdma.CdmaBaseStation;
import org.seamcat.dmasystems.AbstractDmaBaseStation;
import org.seamcat.dmasystems.AbstractDmaLink;
import org.seamcat.dmasystems.AbstractDmaMobile;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.simulation.cdma.CDMADownLinkSimulation;

public class CdmaUserTerminal
extends AbstractDmaMobile {
    private CDMALinkLevelDataPoint linkLevelData = null;

    public CdmaUserTerminal(Point2D point, CDMASystem _system, int _userid, double antGain, double antHeight) {
        super(point, _system, _userid, antGain, antHeight);
    }

    public void resetSummationAffectedBaseStations() {
        if (this.servingLink != null) {
            CdmaBaseStation station = (CdmaBaseStation)this.servingLink.getBaseStation();
            station.resetSummedInterference();
        }
        for (AbstractDmaLink link : this.activeList) {
            CdmaBaseStation s = (CdmaBaseStation)link.getBaseStation();
            s.resetSummedInterference();
        }
    }

    public double calculateAchievedCI() {
        this.setOldAchievedCI(this.getAchievedCI());
        CDMAUplink link = (CDMAUplink)this.servingLink;
        this.setAchievedCI(link.calculateAchivedCI());
        if (this.isInSoftHandover()) {
            for (AbstractDmaLink l : this.activeList) {
                if (l == link) continue;
                double achievedCI_inactiveLink = ((CDMAUplink)l).calculateAchivedCI();
                if (l.getBaseStation().getCellLocationId() == link.getBaseStation().getCellLocationId()) {
                    this.setAchievedCI(Mathematics.powerSummation(this.getAchievedCI(), achievedCI_inactiveLink));
                    continue;
                }
                if (!(achievedCI_inactiveLink > this.getAchievedCI())) continue;
                this.setAchievedCI(achievedCI_inactiveLink);
                this.servingLink.deinitilizeConnection();
                this.servingLink = l;
                this.servingLink.initializeConnection();
            }
        }
        return this.getAchievedCI();
    }

    public void calculateAchievedEcIor() {
        double pTraf_W = this.calculateReceivedTrafficChannelPowerWatt();
        double pTot_W = this.getTotalPowerReceivedFromBaseStationsActiveSetInWatt();
        double pTraf = Mathematics.fromWatt2dBm(pTraf_W);
        double pTot = Mathematics.fromWatt2dBm(pTot_W);
        this.setAchievedEcIor(pTraf - pTot);
        this.setRequiredEcIor(this.linkLevelData.getEcIor());
    }

    public double calculateGeometry(double minGeometry, double maxGeometry) {
        double extInt = Mathematics.fromdBm2Watt(this.getExternalInterference());
        double interference = this.getTotalPowerReceivedFromBaseStationsNotInActiveSet() + extInt;
        double thermalNoise = Mathematics.fromdBm2Watt(this.getSystem().getPreSimulation().findDoubleValue(CDMADownLinkSimulation.THERMAL_NOISE));
        if (this.isInSoftHandover() && this.getMobilitySpeed() == 0.0) {
            double c1 = Mathematics.fromdBm2Watt(((AbstractDmaLink)this.activeList.get(0)).getReceivePower_dB());
            double c2 = Mathematics.fromdBm2Watt(((AbstractDmaLink)this.activeList.get(1)).getReceivePower_dB());
            double absGeometry = c1 / (c2 + thermalNoise + interference) + c2 / (c1 + thermalNoise + interference);
            this.setGeometry(Mathematics.linear2dB(absGeometry));
        } else {
            double absGeometry = this.getTotalPowerReceivedFromBaseStationsInActiveSet() / (thermalNoise + interference);
            this.setGeometry(Mathematics.linear2dB(absGeometry));
        }
        this.setGeometry(Math.max(this.getGeometry(), minGeometry));
        this.setGeometry(Math.min(this.getGeometry(), maxGeometry));
        return this.getGeometry();
    }

    public void calculateInitialReceivedPower(double maximumBroadcastChannel) {
        double resultActive_W = 0.0;
        double resultInActive_W = 0.0;
        double initialTransmitPower_dbm = Mathematics.fromWatt2dBm(Mathematics.fromdBm2Watt(maximumBroadcastChannel) * 0.7);
        for (int x = 0; x < this.links.length; ++x) {
            if (this.activeList.contains(this.links[x])) {
                resultActive_W += Mathematics.fromdBm2Watt(initialTransmitPower_dbm - this.links[x].getEffectivePathloss());
                continue;
            }
            resultInActive_W += Mathematics.fromdBm2Watt(initialTransmitPower_dbm - this.links[x].getEffectivePathloss());
        }
        this.setTotalPowerReceivedFromBaseStationsInActiveSet(resultActive_W);
        this.setTotalPowerReceivedFromBaseStationsNotInActiveSet(resultInActive_W);
    }

    public void calculateReceivedPower() {
        double resultActive_W = 0.0;
        double resultInActive_W = 0.0;
        for (int x = 0; x < this.links.length; ++x) {
            CDMADownlink link = (CDMADownlink)this.links[x];
            if (this.activeList.contains(link)) {
                resultActive_W += Mathematics.fromdBm2Watt(link.calculateCurrentReceivePower_dBm());
                continue;
            }
            resultInActive_W += Mathematics.fromdBm2Watt(link.calculateCurrentReceivePower_dBm());
        }
        this.setTotalPowerReceivedFromBaseStationsInActiveSet(resultActive_W);
        this.setTotalPowerReceivedFromBaseStationsNotInActiveSet(resultInActive_W);
    }

    public double calculateReceivedTrafficChannelPowerInWatt() {
        double EcIor = Mathematics.dB2Linear(this.linkLevelData.getEcIor());
        this.setReceivedTrafficChannelPowerWatt(this.getTotalPowerReceivedFromBaseStationsInActiveSet() * EcIor);
        double receivedPerLink = this.getReceivedTrafficChannelPowerWatt();
        if (this.isInSoftHandover()) {
            receivedPerLink /= 2.0;
        }
        this.resetSummationAffectedBaseStations();
        for (AbstractDmaLink l : this.activeList) {
            CDMADownlink link = (CDMADownlink)l;
            link.setReceivedTrafficChannelPowerdBm(Mathematics.fromWatt2dBm(receivedPerLink));
            link.calculateTransmittedTrafficChannelPowerIndBm();
        }
        return this.calculateReceivedTrafficChannelPowerWatt();
    }

    public boolean connect() {
        if (this.isUpLinkMode()) {
            return this.connectToBaseStationsUplink();
        }
        return this.connectToBaseStationsDownlink();
    }

    public boolean connectToBaseStationsDownlink() {
        this.links[0].initializeConnection();
        boolean powerScaledDown = this.links[0].isPowerScaledDownToMax();
        int i = 1;
        if (this.isInSoftHandover()) {
            this.links[1].initializeConnection();
            powerScaledDown = powerScaledDown || this.links[1].isPowerScaledDownToMax();
            ++i;
        }
        int stop = this.links.length;
        while (i < stop) {
            this.links[i].connectToInActiveBaseStation();
            ++i;
        }
        if (powerScaledDown) {
            this.setConnected(this.meetsEcIorRequirement(((CDMASystem)this.getSystem()).getCDMASettings().getCallDropThreshold()));
        } else {
            this.setConnected(true);
        }
        return this.isConnected();
    }

    public boolean connectToBaseStationsUplink() {
        AbstractDmaLink secondLink;
        double achievedCI_secondLink;
        AbstractDmaLink firstLink;
        this.servingLink = firstLink = this.links[0];
        double achievedCI_firstLink = ((CDMAUplink)firstLink).initializePowerLevels();
        this.setAchievedCI(achievedCI_firstLink);
        if (this.isInSoftHandover() && (achievedCI_secondLink = ((CDMAUplink)(secondLink = this.links[1])).initializePowerLevels()) > achievedCI_firstLink) {
            this.servingLink = secondLink;
            this.setAchievedCI(achievedCI_secondLink);
        }
        this.servingLink.initializeConnection();
        int stop = this.links.length;
        for (int i = 0; i < stop; ++i) {
            if (this.servingLink == this.links[i]) continue;
            this.links[i].connectToInActiveBaseStation();
        }
        this.setConnected(true);
        return this.isConnected();
    }

    public void dropCall() {
        for (AbstractDmaLink link : this.links) {
            link.disconnect();
        }
        this.setConnected(false);
        this.setDropped(true);
    }

    public CDMALinkLevelDataPoint findLinkLevelDataPoint(CDMALinkLevelData data) {
        if (data == null) {
            throw new IllegalArgumentException("Supplied CDMALinkLevelData is null");
        }
        try {
            this.linkLevelData = this.isUpLinkMode() ? data.getLinkLevelDataPoint(new CDMALinkLevelDataPoint(this.getSystem().getFrequency(), this.getMultiPathChannel(), 0.0, this.getMobilitySpeed(), 0.0)) : data.getLinkLevelDataPoint(new CDMALinkLevelDataPoint(this.getSystem().getFrequency(), this.activeList.size(), this.getGeometry(), this.getMobilitySpeed(), 0.0));
            this.setLinkLevelDataPointFound(true);
        }
        catch (IllegalStateException ex) {
            this.setLinkLevelDataPointFound(false);
        }
        if (this.linkLevelData == null) {
            this.setLinkLevelDataPointFound(false);
        }
        return this.linkLevelData;
    }

    @Override
    protected AbstractDmaLink[] generateLinksArray() {
        if (this.getSystem().isUplink()) {
            return new CDMAUplink[this.getSystem().getNumberOfBaseStations()];
        }
        return new CDMADownlink[this.getSystem().getNumberOfBaseStations()];
    }

    @Override
    public void generateLinksToBaseStations() {
        AbstractDmaBaseStation[][] cells = this.getSystem().getBaseStationArray();
        int linkid = 0;
        for (int i = 0; i < cells.length; ++i) {
            double pathloss = 0.0;
            int j = 0;
            while (j < cells[i].length) {
                this.links[linkid] = this.isUpLinkMode() ? new CDMAUplink((CdmaBaseStation)cells[i][j], this, (CDMASystem)this.getSystem()) : new CDMADownlink((CdmaBaseStation)cells[i][j], this, (CDMASystem)this.getSystem());
                this.links[linkid].determinePathLoss(this.getSystem().getRadioSystem().getPropagationModel());
                ++j;
                ++linkid;
            }
        }
    }

    public CDMALinkLevelDataPoint getLinkLevelData() {
        if (this.linkLevelData == null) {
            this.findLinkLevelDataPoint(((CDMASystem)this.getSystem()).getLinkLevelData());
        }
        return this.linkLevelData;
    }

    public double calculateReceivedTrafficChannelPowerWatt() {
        double received = 0.0;
        for (AbstractDmaLink l : this.activeList) {
            CDMADownlink link = (CDMADownlink)l;
            received += Mathematics.fromdBm2Watt(link.getReceivedTrafficChannelPowerdBm());
        }
        this.setReceivedTrafficChannelPowerWatt(received);
        return received;
    }

    public double getTotalPowerReceivedFromBaseStationsActiveSetInWatt() {
        return this.getTotalPowerReceivedFromBaseStationsInActiveSet();
    }

    public double getTotalPowerReceivedFromBaseStationsNotInActiveSetdBm() {
        return Mathematics.fromWatt2dBm(this.getTotalPowerReceivedFromBaseStationsNotInActiveSet());
    }

    public void increasePowerScaledUpCount() {
        this.setPowerScaledUpCount(this.getPowerScaledUpCount() + 1);
    }

    public boolean linkLevelDataPointFound() {
        return this.isLinkLevelDataPointFound();
    }

    public boolean meetsEcIorRequirement(double callDropThreshold) {
        return this.meetsEcIorRequirement(callDropThreshold, false);
    }

    public boolean meetsEcIorRequirement(double callDropThreshold, boolean finalLoop) {
        boolean value;
        boolean bl = value = this.getAchievedEcIor() >= this.getRequiredEcIor() - callDropThreshold;
        if (finalLoop || value) {
            this.setLinkQualityExceptions(0);
        } else if (this.getLinkQualityExceptions() < 5) {
            this.setLinkQualityExceptions(this.getLinkQualityExceptions() + 1);
            value = true;
        }
        return value;
    }

    @Override
    public void selectActiveList(double softHandoverMargin) {
        this.addToActiveList(this.links[0]);
        if (this.links.length > 1) {
            if (Math.abs(this.links[0].getTxRxPathLoss() - this.links[0].gainSum() - (this.links[1].getTxRxPathLoss() - this.links[1].gainSum())) < softHandoverMargin) {
                this.addToActiveList(this.links[1]);
                this.setInSoftHandover(true);
            }
        } else {
            this.setInSoftHandover(false);
        }
    }

    public String toString() {
        Point2D point = this.getPosition();
        return "MS #" + this.getUserId() + " at (" + Mathematics.round(point.getX()) + ", " + Mathematics.round(point.getY()) + ") [Geo = " + this.getGeometry() + " dB]";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CdmaUserTerminal)) {
            return false;
        }
        CdmaUserTerminal term = (CdmaUserTerminal)obj;
        if (term.getUserId() != this.getUserId()) {
            return false;
        }
        Point2D other = term.getPosition();
        Point2D point = this.getPosition();
        return other.getX() == point.getX() && other.getY() == point.getY();
    }

    public int hashCode() {
        return this.getUserId();
    }
}

