/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.dmasystems;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.seamcat.dmasystems.AbstractDmaLink;
import org.seamcat.dmasystems.AbstractDmaSystem;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.simulation.result.Victim;
import org.seamcat.simulation.cdma.CDMADownLinkSimulation;
import org.seamcat.simulation.result.MutableBaseStationResult;

public abstract class AbstractDmaBaseStation
extends MutableBaseStationResult {
    protected static final Logger LOG = Logger.getLogger(AbstractDmaBaseStation.class);
    private Victim victim;
    protected List<AbstractDmaLink> droppedUsers;
    protected List<AbstractDmaLink> activeConnections;
    protected List<AbstractDmaLink> inActiveConnections;
    protected List<AbstractDmaLink> inactiveUsers;
    private AbstractDmaSystem system;

    public AbstractDmaSystem getSystem() {
        return this.system;
    }

    @Override
    public double getFrequency() {
        return this.system.getFrequency();
    }

    public boolean isReferenceCell() {
        return this.system.getReferenceCell() == this;
    }

    @Override
    public double getReferenceBandwidth() {
        return this.system.getPlugin().getBandwidth();
    }

    public AbstractDmaBaseStation(Point2D position, AbstractDmaSystem _system, int _cellid, double antHeight, double antennaTilt, int sectorId) {
        super(_system.antennas);
        this.system = _system;
        this.setPosition(position);
        this.setAntennaHeight(antHeight);
        this.setAntennaTilt(antennaTilt);
        this.setSectorId(sectorId);
        this.setCellId(_cellid);
        this.activeConnections = new ArrayList<AbstractDmaLink>();
        this.inActiveConnections = new ArrayList<AbstractDmaLink>();
        this.inactiveUsers = new ArrayList<AbstractDmaLink>();
        this.droppedUsers = new ArrayList<AbstractDmaLink>();
    }

    public void addInActiveConnection(AbstractDmaLink link) {
        this.inActiveConnections.add(link);
    }

    public void addVoiceInActiveUser(AbstractDmaLink user) {
        this.inactiveUsers.add(user);
    }

    public double calculateNoiseRiseOverThermalNoise_dB() {
        double Nt = this.system.getPreSimulation().findDoubleValue(CDMADownLinkSimulation.THERMAL_NOISE);
        double Itotal = this.calculateTotalInterference_dBm(null);
        this.setNoiseRise(Itotal - Nt);
        return this.getNoiseRise();
    }

    public double calculateNoiseRiseOverThermalNoise_LinearyFactor() {
        this.setNoiseRiseLinearFactor(Math.pow(10.0, this.calculateNoiseRiseOverThermalNoise_dB() / 10.0));
        return this.getNoiseRiseLinearFactor();
    }

    public double calculateNoiseRiseOverThermalNoiseWithoutExternal_dB() {
        double Nt = this.system.getPreSimulation().findDoubleValue(CDMADownLinkSimulation.THERMAL_NOISE);
        double Itotal = this.calculateInterferenceWithoutExternal_dBm(null);
        return Itotal - Nt;
    }

    public double calculateNoiseRiseOverThermalNoiseWithoutExternal_LinearyFactor() {
        this.setNoiseRiseLinearFactor(Math.pow(10.0, this.calculateNoiseRiseOverThermalNoiseWithoutExternal_dB() / 10.0));
        return this.getNoiseRiseLinearFactor();
    }

    public double calculateOutage() {
        double connected = this.countActiveUsers();
        if (connected < 1.0) {
            return 1.0;
        }
        double dropped = this.countDroppedUsers();
        double outage = 0.0;
        outage = connected + dropped == 0.0 || dropped == 0.0 ? dropped : dropped / (connected + dropped);
        return outage;
    }

    public abstract double calculateTotalInterference_dBm(AbstractDmaLink var1);

    public abstract double calculateInterferenceWithoutExternal_dBm(AbstractDmaLink var1);

    public int countActiveUsers() {
        int capacity = 0;
        for (AbstractDmaLink link : this.activeConnections) {
            if (link.getUserTerminal().getActiveList().get(0).getBaseStation() != this && link.getUserTerminal().getActiveList().get(1).getBaseStation() != this) continue;
            ++capacity;
        }
        return capacity;
    }

    public int countDroppedUsers() {
        int capacity = 0;
        for (AbstractDmaLink link : this.droppedUsers) {
            if (link.getUserTerminal().getActiveList().get(0).getBaseStation() != this && link.getUserTerminal().getActiveList().get(1).getBaseStation() != this) continue;
            ++capacity;
        }
        return capacity;
    }

    public int countInActiveUsers() {
        int capacity = 0;
        for (AbstractDmaLink link : this.inactiveUsers) {
            if (link.getUserTerminal().getActiveList().get(0).getBaseStation() != this) continue;
            ++capacity;
        }
        return capacity;
    }

    public int countServedUsers() {
        return this.countActiveUsers() + this.countInActiveUsers();
    }

    public void deinitializeConnection(AbstractDmaLink link) {
        this.activeConnections.remove(link);
        this.inActiveConnections.add(link);
    }

    public void intializeConnection(AbstractDmaLink link) {
        this.activeConnections.add(link);
        this.inActiveConnections.remove(link);
    }

    public void disconnectUser(AbstractDmaLink linkToMobile) {
        if (this.activeConnections.contains(linkToMobile)) {
            this.removeActive(linkToMobile);
        }
        if (this.inActiveConnections.contains(linkToMobile)) {
            this.removeInActive(linkToMobile);
        }
    }

    public void removeActive(AbstractDmaLink linkToMobile) {
        this.droppedUsers.add(linkToMobile);
        this.activeConnections.remove(linkToMobile);
    }

    public void removeInActive(AbstractDmaLink linkToMobile) {
        this.inActiveConnections.remove(linkToMobile);
    }

    public List<AbstractDmaLink> getOldTypeActiveConnections() {
        return this.activeConnections;
    }

    public int getCellid() {
        return this.getCellId();
    }

    public abstract double getCurrentTransmitPower_dBm();

    public List<AbstractDmaLink> getDroppedUsers() {
        return this.droppedUsers;
    }

    public double getMaximumTransmitPower_Watt() {
        return Mathematics.fromdBm2Watt(this.getMaximumTransmitPower());
    }

    public double getOutagePercentage() {
        return this.calculateOutage() * 100.0;
    }

    public abstract void resetBaseStation();

    public void setMaximumTransmitPower_dBm(double maximumTransmitPower) {
        this.setMaximumTransmitPower(maximumTransmitPower);
    }

    public void translateLocation(Point2D factor) {
        this.setPosition(this.getPosition().add(factor));
    }

    public void setCellNoiseRiseInitial(double initialCellNoiseRise) {
        this.setInitialCellNoiseRise(initialCellNoiseRise);
    }

    public double getCellNoiseRiseInitial() {
        return this.getInitialCellNoiseRise();
    }

    public Victim getVictim() {
        return this.victim;
    }

    public void setVictim(Victim victim) {
        this.victim = victim;
    }

    public abstract String getName();
}

