/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.dmasystems;

import java.util.Comparator;
import java.util.List;
import org.apache.log4j.Logger;
import org.seamcat.dmasystems.AbstractDmaBaseStation;
import org.seamcat.dmasystems.AbstractDmaMobile;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.simulation.result.AntennaResult;
import org.seamcat.model.simulation.result.Direction;
import org.seamcat.model.simulation.result.LinkResult;
import org.seamcat.model.types.LocalEnvironment;
import org.seamcat.model.types.PropagationModel;
import org.seamcat.simulation.cellular.CellularCalculations;

public abstract class AbstractDmaLink {
    protected static final Logger LOG = Logger.getLogger(AbstractDmaLink.class);
    public static Comparator<AbstractDmaLink> CDMALinkPathlossComparator = new Comparator<AbstractDmaLink>(){

        @Override
        public int compare(AbstractDmaLink l1, AbstractDmaLink l2) {
            double l2Result;
            if (l1 == null && l2 == null) {
                return 0;
            }
            if (l1 == null) {
                return -1;
            }
            if (l2 == null) {
                return 1;
            }
            double l1Result = l1.txRxPathLoss - l1.gainSum();
            if (l1Result > (l2Result = l2.txRxPathLoss - l2.gainSum())) {
                return 1;
            }
            if (l1Result < l2Result) {
                return -1;
            }
            return 0;
        }

        @Override
        public boolean equals(Object obj) {
            return false;
        }
    };
    private final Point2D baseStationNewCoordinate;
    private AbstractDmaBaseStation basestation;
    private AbstractDmaMobile user;
    protected boolean powerScaledDownToMax = false;
    protected double totalReceivedPower;
    protected double transmittedTrafficChannelPowerdBm;
    private double distance;
    private double txRxPathLoss;
    protected double effectivePathLoss;
    private boolean upLink;
    private LinkResult linkResult;

    public boolean isUpLink() {
        return this.upLink;
    }

    public AbstractDmaLink(boolean upLink, AbstractDmaBaseStation _cell, AbstractDmaMobile _user, double frequency) {
        this.upLink = upLink;
        this.linkResult = Factory.results().linkResult(_cell.getSystem().getRadioSystem(), frequency);
        this.user = _user;
        this.basestation = _cell;
        AntennaResult tx = this.linkResult.txAntenna();
        AntennaResult rx = this.linkResult.rxAntenna();
        this.baseStationNewCoordinate = CellularCalculations.findNewCoordinate(this.user.getPosition(), this.basestation.getPosition(), this.user.getSystem().getInterCellDistance(), this.user.getSystem().getPlugin().generateWrapAround(), this.user.getSystem().getPlugin().getSectorSetup());
        this.distance = Mathematics.distance(this.user.getPosition(), this.baseStationNewCoordinate);
        if (upLink) {
            tx.setHeight(this.user.getAntennaHeight());
            tx.setTilt(this.user.getAntennaTilt());
            tx.setPosition(this.user.getPosition());
            rx.setHeight(this.basestation.getAntennaHeight());
            rx.setTilt(this.basestation.getAntennaTilt());
            rx.setPosition(this.baseStationNewCoordinate);
        } else {
            tx.setHeight(this.basestation.getAntennaHeight());
            tx.setTilt(this.basestation.getAntennaTilt());
            tx.setPosition(this.baseStationNewCoordinate);
            rx.setHeight(this.user.getAntennaHeight());
            rx.setTilt(this.user.getAntennaTilt());
            rx.setPosition(this.user.getPosition());
        }
        this.linkResult.setTxRxDistance(this.distance);
        rx.setElevationCompensation(0.0);
        tx.setElevationCompensation(0.0);
        double txRxAzi = Mathematics.convertAngleToConfineToHorizontalDefinedRange(Mathematics.calculateKartesianAngle(rx.getPosition(), tx.getPosition()));
        double rxTxAzi = Mathematics.convertAngleToConfineToHorizontalDefinedRange(Mathematics.calculateKartesianAngle(tx.getPosition(), rx.getPosition()));
        this.linkResult.setTxRxAngle(txRxAzi);
        double txRxEle = Mathematics.calculateElevation(tx, rx);
        rx.setAzimuth(rxTxAzi);
        rx.setElevation(-txRxEle);
        tx.setAzimuth(txRxAzi);
        tx.setElevation(txRxEle);
        if (upLink) {
            tx.setGain(this.user.getAntennaGain());
            rx.setGain(this.basestation.getAntennaGain().evaluate(this.linkResult, rx));
            List<LocalEnvironment> environments = this.user.getSystem().getRadioSystem().getTransmitter().getLocalEnvironments();
            this.linkResult.assignLocalEnvironment(environments, Direction.To_TX);
            environments = this.basestation.getSystem().getRadioSystem().getReceiver().getLocalEnvironments();
            this.linkResult.assignLocalEnvironment(environments, Direction.To_RX);
        } else {
            tx.setGain(this.basestation.getAntennaGain().evaluate(this.linkResult, tx));
            rx.setGain(this.user.getAntennaGain());
            List<LocalEnvironment> environments = this.user.getSystem().getRadioSystem().getReceiver().getLocalEnvironments();
            this.linkResult.assignLocalEnvironment(environments, Direction.To_RX);
            environments = this.basestation.getSystem().getRadioSystem().getTransmitter().getLocalEnvironments();
            this.linkResult.assignLocalEnvironment(environments, Direction.To_TX);
        }
        this.linkResult.trialTxRxInSameBuilding();
    }

    public double gainSum() {
        return this.linkResult.txAntenna().getGain() + this.linkResult.rxAntenna().getGain();
    }

    public abstract double calculateCurrentReceivePower_dBm();

    public double calculateCurrentReceivePower_Watt() {
        return Mathematics.fromdBm2Watt(this.calculateCurrentReceivePower_dBm());
    }

    public abstract void activateLink();

    public void connectToInActiveBaseStation() {
        this.basestation.addInActiveConnection(this);
    }

    public void deinitilizeConnection() {
        this.basestation.deinitializeConnection(this);
    }

    public void determinePathLoss(PropagationModel propagationModel) {
        this.txRxPathLoss = propagationModel.evaluate(this.linkResult);
        this.effectivePathLoss = Math.max(this.txRxPathLoss - this.gainSum(), this.user.getSystem().getPlugin().getMinimumCouplingLoss());
    }

    public void disconnect() {
        this.basestation.disconnectUser(this);
    }

    public AbstractDmaBaseStation getBaseStation() {
        return this.basestation;
    }

    public double getEffectivePathloss() {
        return this.effectivePathLoss;
    }

    public double getReceivePower_dB() {
        return this.totalReceivedPower;
    }

    public double getTransmittedTrafficChannelPowerWatt() {
        return Mathematics.fromdBm2Watt(this.transmittedTrafficChannelPowerdBm);
    }

    public AbstractDmaMobile getUserTerminal() {
        return this.user;
    }

    public void initializeConnection() {
        this.basestation.intializeConnection(this);
    }

    public boolean isPowerScaledDownToMax() {
        return this.powerScaledDownToMax;
    }

    public boolean isUsingWrapAround() {
        return this.user.getSystem().getPlugin().generateWrapAround();
    }

    public double getTotalReceivedPower() {
        return this.totalReceivedPower;
    }

    public double getTxRxPathLoss() {
        return this.txRxPathLoss;
    }

    public void setTxRxPathLoss(double txRxPathLoss) {
        this.txRxPathLoss = txRxPathLoss;
        this.effectivePathLoss = Math.max(txRxPathLoss - this.gainSum(), this.user.getSystem().getPlugin().getMinimumCouplingLoss());
    }

    public double getDistance() {
        return this.distance;
    }

    public LinkResult asLinkResult() {
        this.linkResult.setTxRxPathLoss(this.txRxPathLoss);
        this.linkResult.setEffectiveTxRxPathLoss(this.effectivePathLoss);
        return this.linkResult;
    }
}

