/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.dmasystems;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.seamcat.dmasystems.AbstractDmaLink;
import org.seamcat.dmasystems.AbstractDmaSystem;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.simulation.result.Victim;
import org.seamcat.simulation.cdma.CDMADownLinkSimulation;
import org.seamcat.simulation.result.MutableMobileStationResult;

public abstract class AbstractDmaMobile
extends MutableMobileStationResult {
    protected static final Logger LOG = Logger.getLogger(AbstractDmaMobile.class);
    private Victim victim;
    protected List<AbstractDmaLink> activeList;
    protected AbstractDmaLink[] links;
    protected AbstractDmaLink servingLink;
    private AbstractDmaSystem system;

    public AbstractDmaSystem getSystem() {
        return this.system;
    }

    @Override
    public double getFrequency() {
        return this.system.getFrequency();
    }

    @Override
    public double getReferenceBandwidth() {
        return this.system.getPlugin().getBandwidth();
    }

    public AbstractDmaMobile(Point2D point, AbstractDmaSystem _system, int _userid, double antGain, double antHeight) {
        this.setPosition(point);
        this.setAntennaHeight(antHeight);
        this.setAntennaTilt(0.0);
        this.setUserId(_userid);
        this.setAntennaGain(antGain);
        this.system = _system;
        this.links = this.generateLinksArray();
        this.activeList = new ArrayList<AbstractDmaLink>(2);
    }

    public void addToActiveList(AbstractDmaLink link) {
        this.activeList.add(link);
    }

    public double calculateTotalInterference_dBm() {
        double thermalNoise = this.system.getPreSimulation().findDoubleValue(CDMADownLinkSimulation.THERMAL_NOISE);
        this.setTotalInterference(Mathematics.fromWatt2dBm(Mathematics.fromdBm2Watt(this.getExternalInterference()) + Mathematics.fromdBm2Watt(thermalNoise)));
        return this.getTotalInterference();
    }

    protected abstract AbstractDmaLink[] generateLinksArray();

    public abstract void generateLinksToBaseStations();

    public List<AbstractDmaLink> getActiveList() {
        return this.activeList;
    }

    public AbstractDmaLink[] getAllLinks() {
        return this.links;
    }

    public AbstractDmaLink getServingLink() {
        return this.servingLink;
    }

    public boolean isInSofterHandover() {
        return this.isInSoftHandover() && this.activeList.get(0).getBaseStation().getCellLocationId() == this.activeList.get(1).getBaseStation().getCellLocationId();
    }

    @Override
    public boolean isInSoftHandover() {
        return this.activeList.size() > 1;
    }

    public abstract void selectActiveList(double var1);

    public void setCurrentTransmitPower_dBm(double currentTransmitPower) {
        this.setCurrentTransmitPowerIndBm(currentTransmitPower);
        this.setCurrentTransmitPower(Mathematics.fromdBm2Watt(currentTransmitPower));
    }

    public void setServingLink(AbstractDmaLink servingLink) {
        this.servingLink = servingLink;
    }

    public void sortLinks() {
        Arrays.sort(this.links, AbstractDmaLink.CDMALinkPathlossComparator);
    }

    public Victim getVictim() {
        return this.victim;
    }

    public void setVictim(Victim victim) {
        this.victim = victim;
    }
}

