/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.dmasystems;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;
import org.seamcat.cdma.CDMASystem;
import org.seamcat.cdma.CDMAUplinkSystem;
import org.seamcat.dmasystems.AbstractDmaBaseStation;
import org.seamcat.dmasystems.AbstractDmaMobile;
import org.seamcat.dmasystems.UserShouldBeIgnoredException;
import org.seamcat.function.DiscreteFunction;
import org.seamcat.model.RadioSystem;
import org.seamcat.model.distributions.AbstractDistribution;
import org.seamcat.model.distributions.ConstantDistributionImpl;
import org.seamcat.model.distributions.StairDistributionImpl;
import org.seamcat.model.distributions.UniformDistributionImpl;
import org.seamcat.model.distributions.UniformPolarAngleDistributionImpl;
import org.seamcat.model.distributions.UniformPolarDistanceDistributionImpl;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.plugin.antenna.HorizontalVerticalInput;
import org.seamcat.model.simulation.result.Collector;
import org.seamcat.model.simulation.result.UniqueValueDef;
import org.seamcat.model.types.result.DescriptionImpl;
import org.seamcat.model.types.result.DoubleResultType;
import org.seamcat.model.types.result.Results;
import org.seamcat.model.types.result.SingleValueTypes;
import org.seamcat.ofdma.OfdmaSystem;
import org.seamcat.ofdma.UplinkOfdmaSystem;
import org.seamcat.plugin.AntennaGainConfiguration;
import org.seamcat.simulation.cdma.CDMADownLinkSimulation;
import org.seamcat.simulation.cellular.BaseStation;
import org.seamcat.simulation.cellular.CellularCalculations;
import org.seamcat.simulation.cellular.GridPositionCalculator;
import org.seamcat.simulation.cellular.MobileStation;
import org.seamcat.simulation.hybrid.HybridSystemPlugin;
import org.seamcat.simulation.result.MutableMobileStationResult;
import org.seamcat.simulation.result.MutableSimulationElement;

public abstract class AbstractDmaSystem<GenericMobileType extends AbstractDmaMobile> {
    public static final UniqueValueDef TRIAL_FREQUENCY = Factory.results().single("Trial Frequency", "MHz");
    protected static Logger LOG = Logger.getLogger(AbstractDmaSystem.class);
    protected static final ResourceBundle STRINGLIST = ResourceBundle.getBundle("stringlist", Locale.ENGLISH);
    private RadioSystem radioSystem;
    private HybridSystemPlugin plugin;
    private Results pre;
    private Collector collector;
    protected AntennaGainConfiguration[] antennas;
    public AbstractDmaBaseStation[][] cells;
    public List<GenericMobileType> activeUsers = new ArrayList<GenericMobileType>();
    public List<GenericMobileType> noLinkLevelFoundUsers = new ArrayList<GenericMobileType>();
    protected double processingGain;
    protected double frequency = 0.0;
    protected double locationX;
    protected double locationY;
    public AbstractDmaBaseStation referenceCell;
    protected int useridcount = 1;
    protected boolean victimSystem = false;
    private static final double SQRT3 = Math.sqrt(3.0);
    protected final AbstractDistribution random = new UniformDistributionImpl(0.0, 1.0);
    private AbstractDistribution userAngle = new UniformPolarAngleDistributionImpl(360.0);
    private AbstractDistribution userLocation = new UniformPolarDistanceDistributionImpl(1.0);

    public RadioSystem getRadioSystem() {
        return this.radioSystem;
    }

    public void setRadioSystem(RadioSystem radioSystem) {
        this.radioSystem = radioSystem;
    }

    public HybridSystemPlugin getPlugin() {
        return this.plugin;
    }

    public void initialize(Results pre, Collector collector) {
        this.collector = collector;
        this.pre = pre;
        if (this.antennas == null) {
            this.antennas = CellularCalculations.createSectorAntennas(this.plugin.getSectorSetup(), this.plugin.getBs().getAntennaGain());
            this.generateSystemCells();
            this.calculateThermalNoise();
            if (!pre.hasSingleValue(TRIAL_FREQUENCY)) {
                pre.getSingleValueTypes().add(new DoubleResultType(TRIAL_FREQUENCY, 900.0));
            }
        }
    }

    public Collector getCollector() {
        return this.collector;
    }

    public Results getPreSimulation() {
        return this.pre;
    }

    public AbstractDmaSystem() {
        this.radioSystem = new RadioSystem(null, null, Factory.propagationModelFactory().getHataSE21());
    }

    public AbstractDmaSystem(AbstractDmaSystem<?> system) {
        this();
        if (system.getPlugin().getBs() == null) {
            system.getPlugin().setBs(new BaseStation(new ConstantDistributionImpl(30.0), new ConstantDistributionImpl(0.0), AbstractDmaSystem.createDefaultTriSectorAntenna()));
        }
        if (system.getPlugin().getMs() == null) {
            system.getPlugin().setMs(new MobileStation(new ConstantDistributionImpl(1.5), new ConstantDistributionImpl(0.0), new StairDistributionImpl(new DiscreteFunction(Arrays.asList(new Point2D(0.0, 0.25), new Point2D(3.0, 0.5), new Point2D(30.0, 0.75), new Point2D(100.0, 1.0))))));
        }
        this.antennas = system.antennas;
        this.plugin = system.getPlugin();
        this.plugin.setGenerateWrapAround(this.plugin.generateWrapAround());
        this.victimSystem = system.victimSystem;
        BaseStation bs = this.plugin.getBs();
        bs.setHeight(system.getPlugin().getBs().getHeight());
        bs.setTilt(system.getPlugin().getBs().getTilt());
        bs.setAntennaGain(system.getPlugin().getBs().getAntennaGain());
        this.plugin.setCellRadius(system.getPlugin().getCellRadius());
        this.plugin.setUsersPerCell(system.getPlugin().getUsersPerCell());
        this.frequency = system.frequency;
        this.plugin.setHandoverMargin(system.getPlugin().getHandoverMargin());
        this.locationX = system.locationX;
        this.locationY = system.locationY;
        this.plugin.setMeasureInterferenceFromEntireCluster(this.plugin.measureInterferenceFromEntireCluster());
        MobileStation ms = this.plugin.getMs();
        ms.setAntennaGain(system.getPlugin().getMs().getAntennaGain());
        ms.setAntennaHeight(system.getPlugin().getMs().getAntennaHeight());
        ms.setMobility(system.getPlugin().getMs().getMobility());
        this.plugin.setSystemLayout(system.getPlugin().getSystemLayout());
        this.plugin.setMinimumCouplingLoss(system.getPlugin().getMinimumCouplingLoss());
        this.plugin.setTierSetup(system.getPlugin().getTierSetup().getTiers());
        this.processingGain = system.processingGain;
        this.plugin.setIndexOfReferenceCell(system.getPlugin().getIndexOfReferenceCell());
        this.plugin.setReferenceSector(system.getPlugin().getReferenceSector());
        this.plugin.setReceiverNoiseFigure(system.getPlugin().getReceiverNoiseFigure());
        this.plugin.setBandwidth(system.getPlugin().getBandwidth());
        this.plugin.setSectorSetup(system.getPlugin().getSectorSetup());
        this.radioSystem = new RadioSystem(system.getRadioSystem().getReceiver(), system.getRadioSystem().getTransmitter(), system.getRadioSystem().getPropagationModel());
    }

    public String toString() {
        if (this.plugin == null) {
            return "Cellular system";
        }
        return this.plugin.getUI().description().name();
    }

    public boolean isCdma() {
        return this instanceof CDMASystem;
    }

    public boolean isOfdma() {
        return this instanceof OfdmaSystem;
    }

    public void calculateThermalNoise() {
        if (!this.getPreSimulation().hasSingleValue(CDMADownLinkSimulation.THERMAL_NOISE)) {
            double noise = CellularCalculations.calculateThermalNoise(this.plugin.getBandwidth(), this.plugin.getReceiverNoiseFigure());
            this.getPreSimulation().getSingleValueTypes().add(new DoubleResultType(CDMADownLinkSimulation.THERMAL_NOISE, noise));
            if (LOG.isDebugEnabled()) {
                LOG.debug(" Thermal noise (dBm)" + noise);
            }
        }
    }

    protected abstract void configureBaseStation(AbstractDmaBaseStation var1);

    public static AntennaGainConfiguration createDefaultTriSectorAntenna() {
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        points.add(new Point2D(0.0, 0.0));
        points.add(new Point2D(10.0, 0.0));
        points.add(new Point2D(20.0, -0.182));
        points.add(new Point2D(30.0, -0.364));
        points.add(new Point2D(40.0, -1.37));
        points.add(new Point2D(50.0, -2.73));
        points.add(new Point2D(60.0, -3.82));
        points.add(new Point2D(70.0, -5.27));
        points.add(new Point2D(80.0, -7.18));
        points.add(new Point2D(90.0, -9.36));
        points.add(new Point2D(100.0, -11.36));
        points.add(new Point2D(110.0, -13.73));
        points.add(new Point2D(120.0, -15.55));
        points.add(new Point2D(130.0, -17.36));
        points.add(new Point2D(140.0, -18.64));
        points.add(new Point2D(150.0, -20.364));
        points.add(new Point2D(160.0, -23.0));
        points.add(new Point2D(170.0, -24.27));
        points.add(new Point2D(180.0, -23.18));
        points.add(new Point2D(190.0, -24.27));
        points.add(new Point2D(200.0, -23.0));
        points.add(new Point2D(210.0, -20.364));
        points.add(new Point2D(220.0, -18.64));
        points.add(new Point2D(230.0, -17.36));
        points.add(new Point2D(240.0, -15.55));
        points.add(new Point2D(250.0, -13.73));
        points.add(new Point2D(260.0, -11.36));
        points.add(new Point2D(270.0, -9.36));
        points.add(new Point2D(280.0, -7.18));
        points.add(new Point2D(290.0, -5.27));
        points.add(new Point2D(300.0, -3.82));
        points.add(new Point2D(310.0, -2.73));
        points.add(new Point2D(320.0, -1.37));
        points.add(new Point2D(330.0, -0.364));
        points.add(new Point2D(340.0, -0.182));
        points.add(new Point2D(350.0, 0.0));
        points.add(new Point2D(360.0, 0.0));
        DiscreteFunction function = new DiscreteFunction(points);
        DiscreteFunction verticalFun = new DiscreteFunction(Arrays.asList(new Point2D(-90.0, 0.0), new Point2D(90.0, 0.0)));
        HorizontalVerticalInput prototype = Factory.prototype(HorizontalVerticalInput.class);
        Factory.when(prototype.horizontal()).thenReturn(Factory.results().optional(true, function));
        Factory.when(prototype.vertical()).thenReturn(Factory.results().optional(false, verticalFun));
        AntennaGainConfiguration defaultAG = (AntennaGainConfiguration)Factory.antennaGainFactory().getHorizontalVerticalAntenna(Factory.build(prototype), 15.0);
        defaultAG.setDescription(new DescriptionImpl("Default Tri-Sector Antenna", "3GPP 3-sector"));
        return defaultAG;
    }

    public int countActiveUsers() {
        return this.activeUsers.size();
    }

    protected abstract void generateAndPositionMobiles();

    protected abstract AbstractDmaBaseStation generateBaseStation(Point2D var1, int var2, double var3, double var5, int var7, boolean var8);

    protected abstract AbstractDmaBaseStation[][] generateBaseStationArray();

    protected void generateCells(AbstractDmaBaseStation[] _cells, int _cellid, boolean triSector) {
        int cellid = 0;
        for (int i = 0; i < _cells.length; ++i) {
            if (_cells[i] != null) continue;
            cellid = triSector ? (_cellid == 0 ? i : _cellid * this.cellsPerSite() + i) : _cellid;
            BaseStation bs = this.plugin.getBs();
            _cells[i] = this.generateBaseStation(Point2D.ORIGIN, cellid, bs.getHeight().trial(), bs.getTilt().trial(), i + 1, triSector);
            _cells[i].setUpLinkMode(this.isUplink());
            _cells[i].setCellLocationId(_cellid);
            this.configureBaseStation(_cells[i]);
        }
    }

    public int cellsPerSite() {
        return this.plugin.getSectorSetup().getSectors();
    }

    public int getNumberOfCellSitesInPowerControlCluster() {
        return this.plugin.getTierSetup().getCellSites();
    }

    public int getNumberOfBaseStations() {
        return this.cellsPerSite() * this.getNumberOfCellSitesInPowerControlCluster();
    }

    protected GenericMobileType generateInitializedMobile() {
        GenericMobileType user = this.generateUserTerminal();
        this.positionUser(user);
        this.initializeUser(user);
        try {
            this.performSystemSpecificInitialization(user);
        }
        catch (UserShouldBeIgnoredException ex) {
            return null;
        }
        return user;
    }

    public void generateSystemCells() {
        this.cells = this.generateBaseStationArray();
        boolean triSectorCells = this.plugin.getSectorSetup() != HybridSystemPlugin.SectorSetup.SingleSector;
        for (int i = 0; i < this.cells.length; ++i) {
            this.generateCells(this.cells[i], i, triSectorCells);
        }
        this.setReferenceCell(this.cells[this.plugin.getIndexOfReferenceCell()][this.plugin.getReferenceSector()]);
        this.repositionSystem(this.getLocation());
    }

    public abstract GenericMobileType generateUserTerminal();

    public List<GenericMobileType> getActiveUsers() {
        return this.activeUsers;
    }

    public List<AbstractDmaBaseStation> getAllBaseStations() {
        ArrayList<AbstractDmaBaseStation> list = new ArrayList<AbstractDmaBaseStation>();
        if (this.cells != null) {
            for (AbstractDmaBaseStation[] bases : this.cells) {
                list.addAll(Arrays.asList(bases));
            }
        }
        return list;
    }

    public List<GenericMobileType> getAllActiveUsers() {
        ArrayList<GenericMobileType> list = new ArrayList<GenericMobileType>();
        list.addAll(this.getActiveUsers());
        return list;
    }

    public AbstractDmaBaseStation[][] getBaseStationArray() {
        return this.cells;
    }

    public double getCellRadius() {
        return this.plugin.getCellRadius();
    }

    public int getCellStructure() {
        return 6;
    }

    public double getFrequency() {
        return this.frequency;
    }

    public final double getInterCellDistance() {
        double interCellDistance = 0.0;
        interCellDistance = this.plugin.getSectorSetup() != HybridSystemPlugin.SectorSetup.TriSector3GPP ? this.plugin.getCellRadius() * SQRT3 : this.plugin.getCellRadius() * 3.0;
        return interCellDistance;
    }

    public double getLocationX() {
        return this.locationX;
    }

    public double getLocationY() {
        return this.locationY;
    }

    public int getNumberOfTiers() {
        return this.plugin.getTierSetup().getTiers();
    }

    public double getProcessingGain() {
        return this.processingGain;
    }

    public AbstractDmaBaseStation getReferenceCell() {
        if (this.referenceCell == null) {
            if (this.cells == null) {
                this.generateSystemCells();
            }
            this.setReferenceCell(this.cells[0][this.plugin.getReferenceSector()]);
        }
        return this.referenceCell;
    }

    public void setReferenceCell(AbstractDmaBaseStation referenceCell) {
        this.referenceCell = referenceCell;
    }

    public double getReferenceCellMeasurement() {
        return this.referenceCell.getOutagePercentage();
    }

    public double getSystemMeasurement() {
        int connectedInSystem = 0;
        int droppedInSystem = 0;
        double outage = 0.0;
        AbstractDmaBaseStation[][] abstractDmaBaseStationArray = this.cells;
        int n = abstractDmaBaseStationArray.length;
        for (int i = 0; i < n; ++i) {
            AbstractDmaBaseStation[] cell;
            for (AbstractDmaBaseStation aCell : cell = abstractDmaBaseStationArray[i]) {
                if (aCell == null) continue;
                connectedInSystem += aCell.countActiveUsers();
                droppedInSystem += aCell.countDroppedUsers();
            }
        }
        outage = (double)(connectedInSystem + droppedInSystem) == 0.0 || (double)droppedInSystem == 0.0 ? (double)droppedInSystem : (double)(droppedInSystem / (connectedInSystem + droppedInSystem) * 100);
        return outage;
    }

    protected void initializeUser(GenericMobileType user) {
        if (this.getPlugin().getMs().getMobility() != null) {
            ((MutableMobileStationResult)user).setMobilitySpeed(this.getPlugin().getMs().getMobility().trial());
        }
        ((AbstractDmaMobile)user).generateLinksToBaseStations();
        ((AbstractDmaMobile)user).sortLinks();
        ((AbstractDmaMobile)user).selectActiveList(this.getPlugin().getHandoverMargin());
    }

    public boolean isUplink() {
        return this instanceof CDMAUplinkSystem || this instanceof UplinkOfdmaSystem;
    }

    public boolean isVictimSystem() {
        return this.victimSystem;
    }

    public void performPreSimulationTasks(double frequency) {
        this.setFrequency(frequency);
        if (this.pre.hasSingleValue(TRIAL_FREQUENCY)) {
            SingleValueTypes<?> remove = null;
            for (SingleValueTypes<?> value : this.pre.getSingleValueTypes()) {
                if (value.def() != TRIAL_FREQUENCY) continue;
                remove = value;
            }
            this.pre.getSingleValueTypes().remove(remove);
        }
        this.pre.getSingleValueTypes().add(new DoubleResultType(TRIAL_FREQUENCY, frequency));
        this.antennas = CellularCalculations.createSectorAntennas(this.plugin.getSectorSetup(), this.getPlugin().getBs().getAntennaGain());
        this.generateSystemCells();
        this.calculateThermalNoise();
    }

    protected abstract void performSystemSpecificInitialization(GenericMobileType var1) throws UserShouldBeIgnoredException;

    protected void positionUser(GenericMobileType user) {
        double userAng = this.userAngle.trial();
        double userDist = 0.0;
        if (this.plugin.getSectorSetup() != HybridSystemPlugin.SectorSetup.TriSector3GPP) {
            double r = this.getCellRadius() + this.getInterCellDistance() * (double)this.getNumberOfTiers();
            userDist = r * this.userLocation.trial();
        } else {
            userDist = (double)(this.getNumberOfTiers() + 1) * this.getInterCellDistance() * this.userLocation.trial();
        }
        double x = userDist * Mathematics.cosD(userAng);
        double y = userDist * Mathematics.sinD(userAng);
        ((MutableSimulationElement)user).setPosition(new Point2D(this.locationX + x, this.locationY + y));
        for (AbstractDmaBaseStation[] cell : this.cells) {
            Point2D position = ((MutableSimulationElement)user).getPosition();
            if (!(this.plugin.getSectorSetup() != HybridSystemPlugin.SectorSetup.TriSector3GPP ? cell[0].isInside(position) : cell[0].isInside(position) || cell[1].isInside(position) || cell[2].isInside(position))) continue;
            return;
        }
        this.positionUser(user);
    }

    public void repositionSystem(Point2D systemCenter) {
        double d = this.getInterCellDistance();
        for (int j = 0; j < this.cells.length; ++j) {
            for (int i = 0; i < this.cells[0].length; ++i) {
                if (this.plugin.getSectorSetup() != HybridSystemPlugin.SectorSetup.TriSector3GPP) {
                    this.setPosition(this.cells[j][i], GridPositionCalculator.ppg2(j, systemCenter, d));
                    continue;
                }
                Point2D center = i == 0 ? new Point2D(this.getCellRadius(), 0.0) : (i == 1 ? new Point2D(Mathematics.cosD(120.0) * this.getCellRadius(), Mathematics.sinD(120.0) * this.getCellRadius()) : new Point2D(Mathematics.cosD(240.0) * this.getCellRadius(), Mathematics.sinD(240.0) * this.getCellRadius()));
                Point2D bsPosition = GridPositionCalculator.standard(j, systemCenter, d);
                this.setPosition(this.cells[j][i], center.add(GridPositionCalculator.standard(j, systemCenter, d)));
                this.cells[j][i].setPosition(bsPosition);
            }
        }
    }

    private void setPosition(AbstractDmaBaseStation bs, Point2D p) {
        bs.setPosition(p);
        bs.calculateHexagon(this.getCellRadius());
    }

    public void resetSystem() {
        this.activeUsers.clear();
        this.noLinkLevelFoundUsers.clear();
        this.useridcount = 0;
        for (AbstractDmaBaseStation base : this.getAllBaseStations()) {
            base.resetBaseStation();
            base.setUpLinkMode(this.isUplink());
        }
    }

    public void setFrequency(double frequency) {
        this.frequency = frequency;
    }

    public Point2D getLocation() {
        return new Point2D(this.locationX, this.locationY);
    }

    public void setLocation(Point2D p) {
        this.locationX = p.getX();
        this.locationY = p.getY();
    }

    public void setLocation(double x, double y) {
        this.setLocationX(x);
        this.setLocationY(y);
    }

    public void setLocationX(double locationX) {
        this.locationX = locationX;
    }

    public void setLocationY(double locationY) {
        this.locationY = locationY;
    }

    public void setVictimSystem(boolean victimSystem) {
        this.victimSystem = victimSystem;
    }

    public abstract void simulate();

    public int getNumberOfServedMobilesInReferenceCell() {
        return this.referenceCell.countServedUsers();
    }

    public int getNumberOfActiveServedMobilesInReferenceCell() {
        return this.referenceCell.countActiveUsers();
    }

    public int getNumberOfServedMobilesInSystem() {
        int result = 0;
        AbstractDmaBaseStation[][] abstractDmaBaseStationArray = this.cells;
        int n = abstractDmaBaseStationArray.length;
        for (int i = 0; i < n; ++i) {
            AbstractDmaBaseStation[] cell;
            for (AbstractDmaBaseStation aCell : cell = abstractDmaBaseStationArray[i]) {
                if (aCell == null) continue;
                result += aCell.countServedUsers();
            }
        }
        return result;
    }

    public int getNumberOfActiveServedMobilesInSystem() {
        int result = 0;
        AbstractDmaBaseStation[][] abstractDmaBaseStationArray = this.cells;
        int n = abstractDmaBaseStationArray.length;
        for (int i = 0; i < n; ++i) {
            AbstractDmaBaseStation[] cell;
            for (AbstractDmaBaseStation aCell : cell = abstractDmaBaseStationArray[i]) {
                if (aCell == null) continue;
                result += aCell.countActiveUsers();
            }
        }
        return result;
    }

    public boolean isDownlink() {
        return !this.isUplink();
    }

    public void setPlugin(HybridSystemPlugin plugin) {
        this.plugin = plugin;
    }
}

